function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2013, Tridium, Inc. All Rights Reserved.
 * @author Gareth Johnson
 */

/* eslint-env browser */

define(["baja!", "lex!dashboard", 'log!nmodule.dashboard.rc.dashboard', "bajaux/events", "bajaux/commands/Command", "bajaux/container/util", "bajaux/util/SaveCommand", "dialogs", "jquery", "Promise"], function (baja, lexicons, log, events, Command, containerUtil, SaveCommand, dialogs, $, Promise) {
  "use strict";

  var DASHBOARD_ID_ADDED = 'bajaux:dashboardid';
  var _lexicons = _slicedToArray(lexicons, 1),
    dashboardLex = _lexicons[0];
  var logSevere = log.severe.bind(log);
  var encodeToWebPropertyDefinition = containerUtil.encodeToWebPropertyDefinition;
  var promise;
  var registered = false;

  /**
   * API Status: **Private**
   *
   * Dashboards for bajaux Widgets. This works by serializing non-transient bajaux Widget
   * Properties away to the DashboardService running on the Station. This also injects
   * Commands for saving and clearing dashboard related data away into the Widget.
   *
   * @exports nmodule/dashboard/rc/dashboard
   */
  var exports = {};

  /**
   * Return a promise that resolves to the Station Dashboard Service.
   *
   * @private
   * @inner
   *
   * @returns {Promise} A promise that resolves to the Dashboard Service.
   */
  function getDashboardService() {
    return promise || (promise = baja.Ord.make("service:dashboard:DashboardService").get({
      lease: true
    }));
  }

  /**
   * The save event handler. This handler is plugged in at the very
   * root of the DOM to listen for bajaux save events.
   * When a save event occurs, this handler will test to see if the Widget has a
   * Dashboard Id, if so then the Widget's non-transient Properties will
   * be saved via the Dashboard Service.
   *
   * @private
   * @inner
   *
   * @param [widget] The bajaux Widget.
   * @returns {Promise}
   */
  function saveDashboardableProperties(widget) {
    var jq = widget && widget.jq();
    var id = jq && jq.data("dashboardId");
    if (!id) {
      return Promise.resolve();
    }

    // Find non-transient, dashboardable properties.
    var propsToSave = widget.properties().get().filter(shouldSaveToDashboard);
    var dashboardData = {};
    propsToSave.forEach(function (prop) {
      var _encodeToWebPropertyD = encodeToWebPropertyDefinition(prop),
        name = _encodeToWebPropertyD.name,
        value = _encodeToWebPropertyD.value,
        typeSpec = _encodeToWebPropertyD.typeSpec;
      dashboardData[name] = {
        value: value,
        typeSpec: typeSpec
      };
    });

    // Write the dashboard data away.
    return getDashboardService().then(function (service) {
      return service.writeDashboard(JSON.stringify({
        id: id,
        data: dashboardData
      }));
    }).then(function () {
      // If there was data saved then enable the clear
      // dashboard command.
      if (propsToSave.length) {
        widget.getCommandGroup().visit(function (cmd) {
          if (cmd && cmd.$clearDashboardCmd) {
            cmd.setEnabled(true);
          }
        });
      }
    });
  }

  /**
   * @param {module:bajaux/Properties~PropertyDefinition} prop
   * @returns {boolean}
   */
  function shouldSaveToDashboard(prop) {
    return !(prop["transient"] || prop.trans) && prop.dashboard;
  }

  /**
   * @private
   * @returns {boolean}
   */
  exports.$hasPendingTasks = function () {
    return typeof window.onbeforeunload === "function" && window.onbeforeunload();
  };

  /**
   * Make a command that enables a user to clear the dashboard data from
   * a widget.
   *
   * @param  widget The widget to make the clear command for.
   * @return The newly created Clear Command.
   */
  exports.makeClearCmd = function (widget) {
    var cmd = new Command({
      module: "dashboard",
      lex: "clearCmd",
      enabled: false,
      func: function func() {
        // Make sure changes are saved before attempting to clear.
        if (exports.$hasPendingTasks()) {
          return dialogs.showOk(dashboardLex.get("clearCmd.saveChangesFirst")).promise();
        } else {
          return dialogs.showYesNo(dashboardLex.get("clearCmd.question")).yes(function () {
            return getDashboardService().then(function (service) {
              // When clearing the dashboard, save a empty object back to the server.
              return service.writeDashboard(JSON.stringify({
                id: widget.jq().data("dashboardId"),
                data: {}
              }));
            }).then(function () {
              if (window.niagara.env.type !== "wb") {
                // This clears the Hx page from the internal Station cache. HxPxCache looks
                // for the 'no-cache' and removes the page accordingly.
                return $.ajax(window.location.href, {
                  headers: {
                    "Cache-Control": "no-cache"
                  }
                });
              }
            }).then(function () {
              return window.niagara.env.reload();
            }); // Reload the page.
          }).promise();
        }
      }
    });
    cmd.$clearDashboardCmd = true;
    return cmd;
  };

  /**
   * The initialize/dashboard id added event handler.
   * This handler is plugged in at the very root
   * of the DOM to listen for bajaux initialization/dashboard id added events.
   * When a widget on a Dashboard is initialized (or the id is added),
   * this handler will ensure the widget is appropriately configured to be
   * used on a Dashboard.
   *
   * @private
   * @inner
   *
   * @param ev The DOM event. Please note, this variable is not used.
   * @param [widget] The bajaux Widget.
   */
  function initializeWidget(ev, widget) {
    var jq = widget && widget.jq(),
      id = jq && jq.data("dashboardId"),
      cg,
      foundSaveCmd = false,
      clearCmd;
    if (id && jq) {
      cg = widget.getCommandGroup();
      cg.visit(function (cmd) {
        if (cmd.$clearDashboardCmd) {
          clearCmd = cmd;
        }
        if (cmd.$saveCmd) {
          foundSaveCmd = true;
        }
      });
      if (!clearCmd) {
        cg.add(clearCmd = exports.makeClearCmd(widget));
      }
      clearCmd.setEnabled(jq.data("dashboardPropsSet") || false);
      if (!foundSaveCmd) {
        cg.add(new SaveCommand());
      }
      if (!jq.data("dashboardInit")) {
        widget.properties().on(events.PROPERTY_CHANGED, function (names, values, option) {
          if (option !== "ext") {
            // Mark the widget as modified if there are any non-external
            // widget property changes. For instance, the widget instance
            // itself changes a property as a result of user interaction.
            widget.setModified(true);
            names.forEach(function (name) {
              var prop = widget.properties().get(name);
              prop.userModified = true;
              widget.properties().add(prop);
            });
          }
        });
        // Propagation for dashboardable properties is prevented so that they
        // are not saved automatically by hxContainer.
        var stopPropagation = function stopPropagation(event, prop) {
          if (prop && prop.dashboard) {
            event.stopImmediatePropagation();
          }
        };
        jq.on(events.PROPERTY_REMOVED, function (event, widget, propName, prop) {
          stopPropagation(event, prop);
        });
        jq.on(events.PROPERTY_CHANGED + ' ' +
        // propName = property name
        events.PROPERTY_ADDED,
        // propName = property name array
        function (event, widget, propName) {
          propName = [].concat(propName);
          propName.forEach(function (propName) {
            var prop = widget.properties().get(propName);
            stopPropagation(event, prop);
          });
        });
        jq.data("dashboardInit", true);
      }
    }
  }

  /**
   * Called to initialize the Dashboard.
   *
   * @param {JQuery} jq The jQuery wrapped DOM for the Dasboard Widget.
   * @param {String} id The unique id for the Dashboard.
   * @param {Boolean} dashboardPropsSet Indicates some properties on the Dashboard have been
   * initially set.
   * @returns {String} id The dashboardId.
   */
  exports.initialize = function (jq, id, dashboardPropsSet) {
    jq.data('dashboardId', id);
    jq.data('dashboardPropsSet', dashboardPropsSet);
    jq.trigger(DASHBOARD_ID_ADDED, jq.data('widget'));
  };

  // Detect window save events and make an AJAX call to save them
  // to the Dashboard Service.
  var onSave = function onSave(e, ed) {
    return saveDashboardableProperties(ed)["catch"](logSevere);
  };

  /**
   * Arm any Dashboard handling events.
   *
   * This method is exported so unit tests can register/unregister
   * the event handlers.
   *
   *
   * @return {Promise} A promise that's resolved once the dashboard
   * framework has finished registration.
   */
  exports.register = function () {
    // Register for events for any other dashboard widgets that are created.
    if (!registered) {
      $(window).on(events.SAVE_EVENT, onSave);
      $(window).on(events.INITIALIZE_EVENT, initializeWidget);
      $(window).on(DASHBOARD_ID_ADDED, initializeWidget);
      registered = true;
    }

    // Find all of the widgets on the page that are already initialized or are
    // in the processing of initializing.
    var widgets = [];
    $(".bajaux-widget").each(function () {
      var widget = $(this).data("widget");
      if (widget && (widget.isInitialized() || widget.$initializing)) {
        widgets.push(widget);
      }
    });

    // Wait for all the detected widgets to initialize.
    return Promise.all(widgets.map(function (widget) {
      return widget.$initialized();
    })).then(function () {
      widgets.forEach(function (w) {
        initializeWidget($.Event(), w);
      });
    }, baja.error);
  };

  /**
   * Disarm any Dashboard handling events.
   *
   * This method is exported so unit tests can register/unregister
   * the event handlers.
   */
  exports.unregister = function () {
    if (registered) {
      $(window).off(events.SAVE_EVENT, onSave);
      $(window).off(events.INITIALIZE_EVENT, initializeWidget);
      $(window).off(DASHBOARD_ID_ADDED, initializeWidget);
      registered = false;
      promise = null;
    }
  };
  exports.DASHBOARD_ID_ADDED = DASHBOARD_ID_ADDED;

  // Automatically register when defined.
  exports.register();
  return exports;
});
