/*
 * Copyright 2016 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.tagdictionary;

import static com.tridium.tagdictionary.util.ImportExportConst.JSON_NAME;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_TYPE;
import static com.tridium.tagdictionary.util.ImportUtil.decodeType;

import java.util.Iterator;

import javax.baja.collection.SlotCursorIterator;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.util.ExportUtil;

/**
 * BTagRuleScopeList defines a scope in which a {@code BScopedTagRule} applies.
 * Its {@code TagRuleScope} children specify what is in scope and
 * what is out of scope.
 *
 * @author Scott Newton
 * @creation 20 Oct 16
 * @since Niagara 4.3
 */
@NiagaraType
public class BTagRuleScopeList
  extends BInfoList
  implements Iterable<TagRuleScope>
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.tagdictionary.BTagRuleScopeList(2979906276)1.0$ @*/
/* Generated Tue Jan 25 17:26:55 CST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BTagRuleScopeList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Allow only TagRuleScope children.
   */
  @Override
  public boolean isChildLegal(BComponent child)
  {
    return child instanceof TagRuleScope;
  }

  /**
   * Determine if a supplied entity is in this scope.
   *
   * @param entity the entity to test against this scope
   * @return {@code true} if the entity is in scope, otherwise {@code false}.
   */
  public boolean isInScope(Entity entity)
  {
    Iterator<TagRuleScope> it = iterator();
    while (it.hasNext())
    {
      TagRuleScope scope = it.next();
      if (scope.includes(entity))
      {
        return true;
      }
    }

    return false;
  }

  /**
   * Get an iterator of TagRuleScopes.
   *
   * @return An Iterator of TagRuleScope children.
   */
  public Iterator<TagRuleScope> iterator()
  {
    return SlotCursorIterator.iterator(getProperties(), TagRuleScope.class);
  }

  /**
   * Encode to a JSON representation
   * @since Niagara 4.14
   */
  public void encodeToJson(JSONWriter writer)
  {
    writer.array();
    for (TagRuleScope ruleScope : this)
    {
      BTagRuleScope tagRuleScope = (BTagRuleScope) ruleScope;
      writer.object();
      ExportUtil.encodeName(tagRuleScope.getName(), writer);
      writer.key(JSON_TYPE).value(tagRuleScope.getType());
      tagRuleScope.encodeToJson(writer);
      writer.endObject();
    }
    writer.endArray();
  }

  /**
   * Decode a Tag Rule Scope List from a JSON representation
   *
   * @param tagRuleScopeListJson the JSON for the tag rule scope list
   * @since Niagara 4.14
   */
  public void decodeFromJson(JSONArray tagRuleScopeListJson)
  {
    for (Object o : tagRuleScopeListJson)
    {
      JSONObject tagRuleScopeJson = (JSONObject) o;
      TypeInfo type = BTagRuleScope.TYPE.getTypeInfo();
      if (tagRuleScopeJson.has(JSON_TYPE))
      {
        type = decodeType(tagRuleScopeJson.getString(JSON_TYPE), BTagRuleScope.TYPE);
      }
      BTagRuleScope tagRuleScope = (BTagRuleScope)type.getInstance();
      tagRuleScope.decodeFromJson(tagRuleScopeJson);
      add(SlotPath.escape(tagRuleScopeJson.getString(JSON_NAME)), tagRuleScope);
    }
  }
}
