/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.tagdictionary;

import static com.tridium.tagdictionary.util.ImportExportConst.JSON_NAME;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_NAMESPACE;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_TYPE;
import static com.tridium.tagdictionary.util.ImportUtil.decodeType;
import static com.tridium.tagdictionary.util.TagDictionaryUtil.handleIllegalChild;

import java.util.Iterator;
import java.util.Optional;

import javax.baja.collection.SlotCursorIterator;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.tagdictionary.util.ExportUtil;

/**
 * BRelationInfoList is a list of {@code RelationInfo}s.
 *
 * @author John Sublett
 * @creation 2/28/14
 * @since Niagara 4.0
 */
@NiagaraType
public class BRelationInfoList
  extends BInfoList
  implements Iterable<RelationInfo>
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.tagdictionary.BRelationInfoList(2979906276)1.0$ @*/
/* Generated Tue Jan 25 17:26:55 CST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BRelationInfoList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Only components that implement {@link RelationInfo} may be added to a BRelationInfoList.
   * @since Niagara 4.4
   */
  @Override
  public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context)
  {
    // Only allow RelationInfos to be added to a BRelationInfoList
    if (!(value instanceof RelationInfo))
      handleIllegalChild(this, value, context);

    super.checkAdd(name, value, flags, facets, context);
  }

  /**
   * Get the dictionary that this list is defined in, if one exists.
   *
   * @return an {@code Optional} that contains the {@code TagDictionary}
   * for this list if the list is part of a {@code TagDictionary};
   * otherwise, an empty {@code Optional}
   */
  public Optional<TagDictionary> getDictionary()
  {
    return BTagDictionary.getParentDictionary(this);
  }

  /**
   * Test whether this list includes a relation with the specified id.
   *
   * @param id relation id to search for
   * @return {@code true} if the list contains a relation with the specified id;
   * {@code false} otherwise.
   */
  @SuppressWarnings("unused")
  public boolean containsRelationId(Id id)
  {
    return getRelation(id).isPresent();
  }

  /**
   * Gets the relation with the specified id.
   *
   * @param id id of the relation
   * @return an {@code Optional} that contains the {@code RelationInfo} with the
   * specified id, if contained in the list; otherwise, an empty
   * {@code Optional}
   */
  public Optional<RelationInfo> getRelation(Id id)
  {
    for (BRelationInfo relationInfo: getChildren(BRelationInfo.class))
    {
      if (relationInfo.getRelationId().equals(id))
      {
        return Optional.of(relationInfo);
      }
    }
    return Optional.empty();
  }

  /**
   * If the property is a {@link BRelationInfo}, call {@link BRelationInfo#relationRenamed()} on it.
   *
   * @param property property being renamed
   * @param oldName old name
   * @param context execution context
   */
  @Override
  public void renamed(Property property, String oldName, Context context)
  {
    BValue value = get(property);
    if (value instanceof BRelationInfo)
    {
      ((BRelationInfo)value).relationRenamed();
    }
  }

  /**
   * Encode to a JSON representation
   * @since Niagara 4.14
   */
  public void encodeToJson(JSONWriter writer)
  {
    writer.array();
    for (RelationInfo relation : this)
    {
      BRelationInfo relationInfo = (BRelationInfo) relation;
      writer.object();
      ExportUtil.encodeName(relationInfo.getName(), writer);
      if (!relationInfo.getType().equals(BRelationInfo.TYPE))
      {
        writer.key(JSON_TYPE).value(relationInfo.getType());
      }
      relationInfo.encodeToJson(writer);
      writer.endObject();
    }
    writer.endArray();
  }

  /**
   * Decode a Relation Info List from a JSON representation
   *
   * @param relationsJson the JSON for the relation info list
   * @since Niagara 4.14
   */
  public void decodeFromJson(JSONArray relationsJson)
  {
    for (Object o : relationsJson)
    {
      JSONObject relationJson = (JSONObject) o;
      TypeInfo type = BRelationInfo.TYPE.getTypeInfo();
      if (relationJson.has(JSON_TYPE))
      {
        type = decodeType(relationJson.getString(JSON_TYPE), BRelationInfo.TYPE);
      }
      BRelationInfo relationInfo = (BRelationInfo)type.getInstance();
      relationInfo.decodeFromJson(relationJson);
      // NAME is unescaped when generating RelationInfo json
      String namespace = relationJson.optString(JSON_NAMESPACE, "");
      if (!namespace.isEmpty())
      {
        add(SlotPath.escape(namespace + ':' + relationJson.getString(JSON_NAME)), relationInfo);
      }
      else
      {
        add(SlotPath.escape(relationJson.getString(JSON_NAME)), relationInfo);
      }
    }
  }

////////////////////////////////////////////////////////////////
// Iterable
////////////////////////////////////////////////////////////////

  /**
   * Get an iterator of the relations in this list.
   *
   * @return an iterator of {@code RelationInfo}s.
   */
  @Override
  public Iterator<RelationInfo> iterator()
  {
    return SlotCursorIterator.iterator(getProperties(), RelationInfo.class);
  }
}
