/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.rdb;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

import javax.baja.driver.BDevice;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.rdb.point.BRdbmsPointDeviceExt;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.LexiconText;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BRdbSecuritySettings;
import com.tridium.rdb.jdbc.RdbmsDialect;

/**
 * BRdbms models a relational database.
 *
 * @author Mike Jarmy on 24 Jul 2003
 * @since Baja 1.0
 */
@NiagaraType
/*
 The address of the computer that hosts the database.
 */
@NiagaraProperty(
  name = "hostAddress",
  type = "BOrd",
  defaultValue = "BOrd.NULL",
  facets = {
    @Facet(name = "BFacets.ORD_RELATIVIZE", value = "BBoolean.FALSE"),
    @Facet(name = "BFacets.FIELD_EDITOR", value = "BString.make(\"workbench:HostOrdFE\")"),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "BString.make(\"webEditors:HostOrdEditor\")")
  }
)
/*
 deprecated
 */
@NiagaraProperty(
  name = "ownerName",
  type = "String",
  defaultValue = "",
  flags = Flags.HIDDEN
)
/*
 indicate whether the connection should use SSL/TLS
 */
@NiagaraProperty(
  name = "useEncryptedConnection",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")
)
/*
 The username of the privileged user account that is used to log in to the database to perform
 necessary DDL operations (and DML operations too if an additional, non-privileged user account is
 not also specified/enabled).
 */
@NiagaraProperty(
  name = "userName",
  type = "String",
  defaultValue = ""
)
/*
 The password of the privileged user account that is used to log in to the database to perform
 necessary DDL operations (and DML operations too if an additional, non-privileged user account is
 not also specified/enabled).
 */
@NiagaraProperty(
  name = "password",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT"
)
@NiagaraProperty(
  name = "worker",
  type = "BRdbmsWorker",
  defaultValue = "new BRdbmsWorker()"
)
/*
 Whether histories will be exported into this database as
 one table per History Id, or one table per BHistoryRecord type.
 The default is 'byHistoryId', but choosing 'byHistoryType' will
 make the data much easier to query once it has been exported.
 */
@NiagaraProperty(
  name = "exportMode",
  type = "BRdbmsHistoryExportMode",
  defaultValue = "BRdbmsHistoryExportMode.byHistoryId"
)
@NiagaraProperty(
  name = "useUnicodeEncodingScheme",
  type = "boolean",
  defaultValue = "false",
  flags = Flags.USER_DEFINED_1
)
/*
 How to store the BAbsTimes:
 dialectDefault is the default assignment prefered by the dialect
 LocalTimestamp is convenient for Time that never changes TimeZones as long as it has millis precision
 UtcTimestamp   is convenient for TimeZone if it changes as long as it has millis precision
 utcMillis  is the most convenient for orion and other Rdbms that require import and export, but dates are hard to read within sql
 */
@NiagaraProperty(
  name = "timestampStorage",
  type = "BRdbmsTimestampStorage",
  defaultValue = "BRdbmsTimestampStorage.dialectDefault",
  flags = Flags.USER_DEFINED_1
)
/*
 Proxy point mappings
 */
@NiagaraProperty(
  name = "points",
  type = "BRdbmsPointDeviceExt",
  defaultValue = "new BRdbmsPointDeviceExt()"
)
@NiagaraProperty(
  name = "sqlSchemeEnabled",
  type = "boolean",
  defaultValue = "false"
)
@NiagaraProperty(
  name = "rdbSecuritySettings",
  type = "BRdbSecuritySettings",
  defaultValue = "new BRdbSecuritySettings()"
)
@NiagaraAction(
  name = "allowDialectModifications",
  flags = Flags.CONFIRM_REQUIRED
)
public abstract class BRdbms
  extends BDevice
  implements BILicensed
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.rdb.BRdbms(3392354574)1.0$ @*/
/* Generated Thu Sep 19 13:55:32 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "hostAddress"

  /**
   * Slot for the {@code hostAddress} property.
   * The address of the computer that hosts the database.
   * @see #getHostAddress
   * @see #setHostAddress
   */
  @Generated
  public static final Property hostAddress = newProperty(0, BOrd.NULL, BFacets.make(BFacets.make(BFacets.make(BFacets.ORD_RELATIVIZE, BBoolean.FALSE), BFacets.make(BFacets.FIELD_EDITOR, BString.make("workbench:HostOrdFE"))), BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make("webEditors:HostOrdEditor"))));

  /**
   * Get the {@code hostAddress} property.
   * The address of the computer that hosts the database.
   * @see #hostAddress
   */
  @Generated
  public BOrd getHostAddress() { return (BOrd)get(hostAddress); }

  /**
   * Set the {@code hostAddress} property.
   * The address of the computer that hosts the database.
   * @see #hostAddress
   */
  @Generated
  public void setHostAddress(BOrd v) { set(hostAddress, v, null); }

  //endregion Property "hostAddress"

  //region Property "ownerName"

  /**
   * Slot for the {@code ownerName} property.
   * deprecated
   * @see #getOwnerName
   * @see #setOwnerName
   */
  @Generated
  public static final Property ownerName = newProperty(Flags.HIDDEN, "", null);

  /**
   * Get the {@code ownerName} property.
   * deprecated
   * @see #ownerName
   */
  @Generated
  public String getOwnerName() { return getString(ownerName); }

  /**
   * Set the {@code ownerName} property.
   * deprecated
   * @see #ownerName
   */
  @Generated
  public void setOwnerName(String v) { setString(ownerName, v, null); }

  //endregion Property "ownerName"

  //region Property "useEncryptedConnection"

  /**
   * Slot for the {@code useEncryptedConnection} property.
   * indicate whether the connection should use SSL/TLS
   * @see #getUseEncryptedConnection
   * @see #setUseEncryptedConnection
   */
  @Generated
  public static final Property useEncryptedConnection = newProperty(0, false, BFacets.make(BFacets.SECURITY, BBoolean.TRUE));

  /**
   * Get the {@code useEncryptedConnection} property.
   * indicate whether the connection should use SSL/TLS
   * @see #useEncryptedConnection
   */
  @Generated
  public boolean getUseEncryptedConnection() { return getBoolean(useEncryptedConnection); }

  /**
   * Set the {@code useEncryptedConnection} property.
   * indicate whether the connection should use SSL/TLS
   * @see #useEncryptedConnection
   */
  @Generated
  public void setUseEncryptedConnection(boolean v) { setBoolean(useEncryptedConnection, v, null); }

  //endregion Property "useEncryptedConnection"

  //region Property "userName"

  /**
   * Slot for the {@code userName} property.
   * The username of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #getUserName
   * @see #setUserName
   */
  @Generated
  public static final Property userName = newProperty(0, "", null);

  /**
   * Get the {@code userName} property.
   * The username of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #userName
   */
  @Generated
  public String getUserName() { return getString(userName); }

  /**
   * Set the {@code userName} property.
   * The username of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #userName
   */
  @Generated
  public void setUserName(String v) { setString(userName, v, null); }

  //endregion Property "userName"

  //region Property "password"

  /**
   * Slot for the {@code password} property.
   * The password of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #getPassword
   * @see #setPassword
   */
  @Generated
  public static final Property password = newProperty(0, BPassword.DEFAULT, null);

  /**
   * Get the {@code password} property.
   * The password of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #password
   */
  @Generated
  public BPassword getPassword() { return (BPassword)get(password); }

  /**
   * Set the {@code password} property.
   * The password of the privileged user account that is used to log in to the database to perform
   * necessary DDL operations (and DML operations too if an additional, non-privileged user account is
   * not also specified/enabled).
   * @see #password
   */
  @Generated
  public void setPassword(BPassword v) { set(password, v, null); }

  //endregion Property "password"

  //region Property "worker"

  /**
   * Slot for the {@code worker} property.
   * @see #getWorker
   * @see #setWorker
   */
  @Generated
  public static final Property worker = newProperty(0, new BRdbmsWorker(), null);

  /**
   * Get the {@code worker} property.
   * @see #worker
   */
  @Generated
  public BRdbmsWorker getWorker() { return (BRdbmsWorker)get(worker); }

  /**
   * Set the {@code worker} property.
   * @see #worker
   */
  @Generated
  public void setWorker(BRdbmsWorker v) { set(worker, v, null); }

  //endregion Property "worker"

  //region Property "exportMode"

  /**
   * Slot for the {@code exportMode} property.
   * Whether histories will be exported into this database as
   * one table per History Id, or one table per BHistoryRecord type.
   * The default is 'byHistoryId', but choosing 'byHistoryType' will
   * make the data much easier to query once it has been exported.
   * @see #getExportMode
   * @see #setExportMode
   */
  @Generated
  public static final Property exportMode = newProperty(0, BRdbmsHistoryExportMode.byHistoryId, null);

  /**
   * Get the {@code exportMode} property.
   * Whether histories will be exported into this database as
   * one table per History Id, or one table per BHistoryRecord type.
   * The default is 'byHistoryId', but choosing 'byHistoryType' will
   * make the data much easier to query once it has been exported.
   * @see #exportMode
   */
  @Generated
  public BRdbmsHistoryExportMode getExportMode() { return (BRdbmsHistoryExportMode)get(exportMode); }

  /**
   * Set the {@code exportMode} property.
   * Whether histories will be exported into this database as
   * one table per History Id, or one table per BHistoryRecord type.
   * The default is 'byHistoryId', but choosing 'byHistoryType' will
   * make the data much easier to query once it has been exported.
   * @see #exportMode
   */
  @Generated
  public void setExportMode(BRdbmsHistoryExportMode v) { set(exportMode, v, null); }

  //endregion Property "exportMode"

  //region Property "useUnicodeEncodingScheme"

  /**
   * Slot for the {@code useUnicodeEncodingScheme} property.
   * @see #getUseUnicodeEncodingScheme
   * @see #setUseUnicodeEncodingScheme
   */
  @Generated
  public static final Property useUnicodeEncodingScheme = newProperty(Flags.USER_DEFINED_1, false, null);

  /**
   * Get the {@code useUnicodeEncodingScheme} property.
   * @see #useUnicodeEncodingScheme
   */
  @Generated
  public boolean getUseUnicodeEncodingScheme() { return getBoolean(useUnicodeEncodingScheme); }

  /**
   * Set the {@code useUnicodeEncodingScheme} property.
   * @see #useUnicodeEncodingScheme
   */
  @Generated
  public void setUseUnicodeEncodingScheme(boolean v) { setBoolean(useUnicodeEncodingScheme, v, null); }

  //endregion Property "useUnicodeEncodingScheme"

  //region Property "timestampStorage"

  /**
   * Slot for the {@code timestampStorage} property.
   * How to store the BAbsTimes:
   * dialectDefault is the default assignment prefered by the dialect
   * LocalTimestamp is convenient for Time that never changes TimeZones as long as it has millis precision
   * UtcTimestamp   is convenient for TimeZone if it changes as long as it has millis precision
   * utcMillis  is the most convenient for orion and other Rdbms that require import and export, but dates are hard to read within sql
   * @see #getTimestampStorage
   * @see #setTimestampStorage
   */
  @Generated
  public static final Property timestampStorage = newProperty(Flags.USER_DEFINED_1, BRdbmsTimestampStorage.dialectDefault, null);

  /**
   * Get the {@code timestampStorage} property.
   * How to store the BAbsTimes:
   * dialectDefault is the default assignment prefered by the dialect
   * LocalTimestamp is convenient for Time that never changes TimeZones as long as it has millis precision
   * UtcTimestamp   is convenient for TimeZone if it changes as long as it has millis precision
   * utcMillis  is the most convenient for orion and other Rdbms that require import and export, but dates are hard to read within sql
   * @see #timestampStorage
   */
  @Generated
  public BRdbmsTimestampStorage getTimestampStorage() { return (BRdbmsTimestampStorage)get(timestampStorage); }

  /**
   * Set the {@code timestampStorage} property.
   * How to store the BAbsTimes:
   * dialectDefault is the default assignment prefered by the dialect
   * LocalTimestamp is convenient for Time that never changes TimeZones as long as it has millis precision
   * UtcTimestamp   is convenient for TimeZone if it changes as long as it has millis precision
   * utcMillis  is the most convenient for orion and other Rdbms that require import and export, but dates are hard to read within sql
   * @see #timestampStorage
   */
  @Generated
  public void setTimestampStorage(BRdbmsTimestampStorage v) { set(timestampStorage, v, null); }

  //endregion Property "timestampStorage"

  //region Property "points"

  /**
   * Slot for the {@code points} property.
   * Proxy point mappings
   * @see #getPoints
   * @see #setPoints
   */
  @Generated
  public static final Property points = newProperty(0, new BRdbmsPointDeviceExt(), null);

  /**
   * Get the {@code points} property.
   * Proxy point mappings
   * @see #points
   */
  @Generated
  public BRdbmsPointDeviceExt getPoints() { return (BRdbmsPointDeviceExt)get(points); }

  /**
   * Set the {@code points} property.
   * Proxy point mappings
   * @see #points
   */
  @Generated
  public void setPoints(BRdbmsPointDeviceExt v) { set(points, v, null); }

  //endregion Property "points"

  //region Property "sqlSchemeEnabled"

  /**
   * Slot for the {@code sqlSchemeEnabled} property.
   * @see #getSqlSchemeEnabled
   * @see #setSqlSchemeEnabled
   */
  @Generated
  public static final Property sqlSchemeEnabled = newProperty(0, false, null);

  /**
   * Get the {@code sqlSchemeEnabled} property.
   * @see #sqlSchemeEnabled
   */
  @Generated
  public boolean getSqlSchemeEnabled() { return getBoolean(sqlSchemeEnabled); }

  /**
   * Set the {@code sqlSchemeEnabled} property.
   * @see #sqlSchemeEnabled
   */
  @Generated
  public void setSqlSchemeEnabled(boolean v) { setBoolean(sqlSchemeEnabled, v, null); }

  //endregion Property "sqlSchemeEnabled"

  //region Property "rdbSecuritySettings"

  /**
   * Slot for the {@code rdbSecuritySettings} property.
   * @see #getRdbSecuritySettings
   * @see #setRdbSecuritySettings
   */
  @Generated
  public static final Property rdbSecuritySettings = newProperty(0, new BRdbSecuritySettings(), null);

  /**
   * Get the {@code rdbSecuritySettings} property.
   * @see #rdbSecuritySettings
   */
  @Generated
  public BRdbSecuritySettings getRdbSecuritySettings() { return (BRdbSecuritySettings)get(rdbSecuritySettings); }

  /**
   * Set the {@code rdbSecuritySettings} property.
   * @see #rdbSecuritySettings
   */
  @Generated
  public void setRdbSecuritySettings(BRdbSecuritySettings v) { set(rdbSecuritySettings, v, null); }

  //endregion Property "rdbSecuritySettings"

  //region Action "allowDialectModifications"

  /**
   * Slot for the {@code allowDialectModifications} action.
   * @see #allowDialectModifications()
   */
  @Generated
  public static final Action allowDialectModifications = newAction(Flags.CONFIRM_REQUIRED, null);

  /**
   * Invoke the {@code allowDialectModifications} action.
   * @see #allowDialectModifications
   */
  @Generated
  public void allowDialectModifications() { invoke(allowDialectModifications, null, null); }

  //endregion Action "allowDialectModifications"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BRdbms.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// BDevice
////////////////////////////////////////////////////////////////

  @Override
  public Type getNetworkType()  { return BRdbmsNetwork.TYPE; }

  @Override
  protected IFuture postPing()
  {
    return getWorker().postAsync(new Invocation(this, ping, null, null));
  }

  @Override
  public void doPing()
  {
    try (Connection conn = AccessController.doPrivileged((PrivilegedExceptionAction<Connection>) () -> getPrivilegedConnection(null));
         Statement statement = conn.createStatement())
    {
      // Issue a validation query.  This ensures that the connection
      // which we obtained from the pool can actually talk to the database.
      RdbmsDialect dialect = (RdbmsDialect)getRdbmsContext();

      statement.execute(dialect.getValidationQuery());
      setStatus(BStatus.makeDown(getStatus(), false));
      pingOk();
    }
    catch (Throwable e)
    {
      Throwable cause = e;
      if (e instanceof PrivilegedActionException && e.getCause() != null)
      {
        cause = e.getCause();
      }

      setStatus(BStatus.makeDown(getStatus(), true));
      pingFail(cause.getMessage());
      getLogger().log(Level.WARNING, "Ping failed for " + getName(), getLogger().isLoggable(Level.FINE) ? cause : null);
    }
  }
  /**
   * Descendant classes are not allowed to override this method directly.
   * However, this method calls {@link #rdbmsStarted()}, which may
   * be overridden.
   */
  @Override
  public final void started()
    throws Exception
  {
    super.started();
    checkLicense();
    checkSlotDisplayNames();
    rdbmsStarted();
  }

  /**
   * Convenience method to check if the default display names of the {@link #userName} and
   * {@link #password} properties need to be updated.
   *
   * @since Niagara 4.15
   */
  private void checkSlotDisplayNames()
  {
    // Since bajaScript can't detect the override of the getDisplayName() method below, the
    // following startup code will check to see if an updated display name for the privileged
    // username and password properties should be set directly in the BNameMap so that bajaScript
    // can pick it up, but only do this once (use the USER_DEFINED_3 flag to indicate that).
    BValue displayNames = get("displayNames");
    if (!Flags.isUserDefined3(this, userName))
    {
      if (!(displayNames instanceof BNameMap) || ((BNameMap)displayNames).get(userName.getName()) == null)
      {
        setDisplayName(userName, BFormat.make("%lexicon(rdb:rdbms.privileged.username)%"), null);
      }
      setFlags(userName, getFlags(userName) | Flags.USER_DEFINED_3);
    }

    if (!Flags.isUserDefined3(this, password))
    {
      if (!(displayNames instanceof BNameMap) || ((BNameMap)displayNames).get(password.getName()) == null)
      {
        setDisplayName(password, BFormat.make("%lexicon(rdb:rdbms.privileged.password)%"), null);
      }
      setFlags(password, getFlags(password) | Flags.USER_DEFINED_3);
    }
  }

  /**
   * a method for initialization code that needs to be run on child rdbms devices
   * @since 4.4_u4, 4.7_u2, 4.8_u1, 4.9
   */
  public void rdbmsStarted()
  throws Exception
  {
  }
  
  public void pingOk()
  {
    super.pingOk();
    preventDialectModifications();
  }
  
  public void preventDialectModifications()
  {
    Property[] props = getPropertiesArray();
    for(int i=0; i<props.length; i++)
    {
      if(Flags.isUserDefined1(this, props[i]) && !Flags.isReadonly(this, props[i]))
        setFlags(props[i], getFlags(props[i]) | Flags.READONLY); 
    }  
  }
  
  /**
   * Confirm Allowance for Dialect Modification.
   */
  public void doAllowDialectModifications(Context cx)
  {
    Property[] props = getPropertiesArray();
    for(int i=0; i<props.length; i++)
    {
      if(Flags.isUserDefined1(this, props[i]) && Flags.isReadonly(this, props[i]))
        setFlags(props[i], getFlags(props[i]) &~ Flags.READONLY); 
    }  
  }

  /**
   * Overridden in Niagara 4.15 to provide an alternate default display name for the
   * {@link #userName} and {@link #password} properties.
   */
  @Override
  public String getDisplayName(Slot slot, Context cx)
  {
    // NOTE: bajaScript can't detect the override of this getDisplayName() method (see corresponding
    // comment in the checkSlotDisplayNames() method above), but this code is still helpful when
    // viewing the AX Property Sheet of the BRdbms device offline in Workbench. We could have
    // addressed this default display name change with a "userName" and "password" key in the
    // lexicon, but that seemed too generic for a lexicon key since it might be picked up
    // accidentally by other unrelated properties with the same name, so this approach was used
    // instead.
    boolean isUserNameProperty = userName.equals(slot);
    if (isUserNameProperty || password.equals(slot))
    {
      // If the user has not configured a custom display name for the userName or password frozen
      // property, then lookup the display name using a custom lexicon key
      BValue displayNames = get("displayNames");
      if (!(displayNames instanceof BNameMap) || ((BNameMap)displayNames).get(slot.getName()) == null)
      {
        return isUserNameProperty ? PRIVILEGED_USER_NAME.getText(cx) : PRIVILEGED_PASSWORD.getText(cx);
      }
    }

    return super.getDisplayName(slot, cx);
  }

/////////////////////////////////////////////////////////////////
// licensing
/////////////////////////////////////////////////////////////////

  /**
   * get the feature code used to license this database type.
   */
  @Override
  public abstract Feature getLicenseFeature();

  private void checkLicense()
  {
    try
    {
      Feature feature = getLicenseFeature();
      if (feature != null) feature.check();
    }
    catch(Exception e)
    {
      getLogger().log(Level.SEVERE, "Unlicensed: " + toPathString(), e);
      configFatal("Unlicensed: " + e);
    }
  }

////////////////////////////////////////////////////////////////
// public
////////////////////////////////////////////////////////////////

  /**
   * Get a SQL database connection for the privileged user account (specified in the
   * {@link #userName} and {@link #password} properties configured on this instance).
   * The returned connection should be allowed to perform certain DDL operations, but may
   * also be used for DML operations (see {@link #getNonPrivilegedConnection(Context)}).
   * <p>
   * Overrides of this method by subclasses should protect access to the returned Connection by
   * making a check with the security manager to ensure any module calling this method has the
   * required permission. Such a check would look like the following:
   * <p>
   * <pre>{@code
   * SecurityManager sm = System.getSecurityManager();
   * if (sm != null)
   * {
   *   sm.checkPermission(BRdbms.RDB_CONNECTION_PERMISSION);
   * }
   * }</pre>
   * <p>
   * Callers of this method that use the Connection internally may want to wrap the call in a
   * doPrivileged() block (and add the entry below), otherwise any calling module in the call stack
   * will need an entry like the following in the module's module-permissions.xml file:
   * <p>
   * <pre>{@code
   * <req-permission>
   *   <name>RDB</name>
   *   <purposeKey>This module needs to access JDBC Connections from RDB drivers</purposeKey>
   * </req-permission>
   * }</pre>
   * <p>
   *
   * @return An active {@link Connection} to use for privileged (DDL) operations, and under some
   * configurations, also non-privileged (DML) operations. This method may also return null if
   * there is a misconfiguration of the connection settings.
   * @throws SQLException if an exception occurs while attempting to establish a Connection to the database.
   *
   * @deprecated since Niagara 4.15 - use {@link #getConnection(String, BPassword)},
   * {@link #getPrivilegedConnection(Context)}, or {@link #getNonPrivilegedConnection(Context)}
   * instead.
   */
  @Deprecated
  public Connection getConnection()
    throws SQLException
  {
    return getConnection(getUserName(), getPassword());
  }

  /**
   * Get a SQL database connection instance to communicate with the database using the account
   * specified by the given username and password.
   * <p>
   * Overrides of this method by subclasses should protect access to the returned Connection by
   * making a check with the security manager to ensure any module calling this method has the
   * required permission. Such a check would look like the following:
   * <p>
   * <pre>{@code
   * SecurityManager sm = System.getSecurityManager();
   * if (sm != null)
   * {
   *   sm.checkPermission(BRdbms.RDB_CONNECTION_PERMISSION);
   * }
   * }</pre>
   * <p>
   * Callers of this method that use the Connection internally may want to wrap the call in a
   * doPrivileged() block (and add the entry below), otherwise any calling module in the call stack
   * will need an entry like the following in the module's module-permissions.xml file:
   * <p>
   * <pre>{@code
   * <req-permission>
   *   <name>RDB</name>
   *   <purposeKey>This module needs to access JDBC Connections from RDB drivers</purposeKey>
   * </req-permission>
   * }</pre>
   * <p>
   *
   * @param userName The username of the account to use for making the connection to the database.
   * @param password The password of the account to use for making the connection to the database.
   * @return An active {@link Connection} to the database, or null if there is a misconfiguration
   * of the connection settings.
   * @throws SQLException if an exception occurs while attempting to establish a Connection to the database.
   */
  public abstract Connection getConnection(String userName, BPassword password)
    throws SQLException;

  /**
   * Get a SQL database connection for the privileged user account (specified in the
   * {@link #userName} and {@link #password} properties configured on this instance).
   * The returned connection should be allowed to perform certain DDL operations, but may
   * also be used for DML operations (see {@link #getNonPrivilegedConnection(Context)}).
   * <p>
   * Overrides of this method by subclasses should protect access to the returned Connection by
   * making a check with the security manager to ensure any module calling this method has the
   * required permission. Such a check would look like the following:
   * <p>
   * <pre>{@code
   * SecurityManager sm = System.getSecurityManager();
   * if (sm != null)
   * {
   *   sm.checkPermission(BRdbms.RDB_CONNECTION_PERMISSION);
   * }
   * }</pre>
   * <p>
   * Callers of this method that use the Connection internally may want to wrap the call in a
   * doPrivileged() block (and add the entry below), otherwise any calling module in the call stack
   * will need an entry like the following in the module's module-permissions.xml file:
   * <p>
   * <pre>{@code
   * <req-permission>
   *   <name>RDB</name>
   *   <purposeKey>This module needs to access JDBC Connections from RDB drivers</purposeKey>
   * </req-permission>
   * }</pre>
   * <p>
   *
   * @param cx The Context associated with this connection request.
   * @return An active {@link Connection} to use for privileged (DDL) operations, and under some
   * configurations, also non-privileged (DML) operations. This method may also return null if
   * there is a misconfiguration of the connection settings.
   * @throws SQLException if an exception occurs while attempting to establish a Connection to the database.
   *
   * @since Niagara 4.15
   */
  public Connection getPrivilegedConnection(Context cx)
    throws SQLException
  {
    return getConnection(getUserName(), getPassword());
  }

  /**
   * Tests whether the given {@link Connection} was authenticated with the privileged user
   * account credentials. The default implementation of this method will return {@code true},
   * but subclasses should override this behavior as necessary. If a determination cannot
   * be made (such as in the event of an Exception occurring when evaluating the privilege level
   * of the connection), the connection will be assumed to be non-privileged.
   *
   * @param connection The connection to evaluate
   * @return {@code true} if the given connection is privileged, {@code false} otherwise
   * @since Niagara 4.15
   */
  public boolean isPrivilegedConnection(Connection connection)
  {
    return true;
  }

  /**
   * Checks the configuration for this BRdbms device to determine whether privilege separation support
   * is provided and enabled. Subclasses should override this method based on whether privilege separation is
   * supported and enabled. The default implementation assumes this support is not present, and returns
   * {@code false}.
   *
   * @param cx the {@link Context} in which this call is made
   * @return whether privilege separation support is provided and enabled for this BRdbms device
   * @since Niagara 4.15
   */
  public boolean isPrivilegeSeparationEnabled(Context cx)
  {
    return false;
  }

  /**
   * Get a SQL database connection for a non-privileged user account. The returned connection
   * should be allowed to perform certain DML operations against the database. The default
   * implementation return a privileged connection via {@link #getPrivilegedConnection(Context)}.
   * Subclasses can override this method to return a different non-privileged database connection
   * when necessary.
   * <p>
   * Overrides of this method by subclasses should protect access to the returned Connection by
   * making a check with the security manager to ensure any module calling this method has the
   * required permission. Such a check would look like the following:
   * <p>
   * <pre>{@code
   * SecurityManager sm = System.getSecurityManager();
   * if (sm != null)
   * {
   *   sm.checkPermission(BRdbms.RDB_CONNECTION_PERMISSION);
   * }
   * }</pre>
   * <p>
   * Callers of this method that use the Connection internally may want to wrap the call in a
   * doPrivileged() block (and add the entry below), otherwise any calling module in the call stack
   * will need an entry like the following in the module's module-permissions.xml file:
   * <p>
   * <pre>{@code
   * <req-permission>
   *   <name>RDB</name>
   *   <purposeKey>This module needs to access JDBC Connections from RDB drivers</purposeKey>
   * </req-permission>
   * }</pre>
   * <p>
   *
   * @param cx The Context associated with this connection request.
   * @return An active {@link Connection} to use for non-privileged (DML) operations, or null if
   * there is a misconfiguration of the connection settings.
   * @throws SQLException if an exception occurs while attempting to establish a Connection to the database.
   *
   * @since Niagara 4.15
   */
  public Connection getNonPrivilegedConnection(Context cx)
    throws SQLException
  {
    return getPrivilegedConnection(cx);
  }

  /**
   * This method is deprecated as of Niagara 4.5. RDBMS now uses the default SSLContext and
   * calling this method is no longer necessary. This method is a no-op.
   */
  @Deprecated
  public void initSSLContext()
  {
  }

  /**
   * get the hostname from the hostAddress
   */
  public final String getHostname()
  {
    if (getHostAddress().isNull()) return "";

    try
    {
      return ((BHost) getHostAddress().get()).getHostname();
    }
    // This can be thrown by BHost.mount(BHost host) if there is
    // more than one thread running.
    catch (IllegalArgumentException e)
    {
      return "";
    }
  }

  /**
   * get the RdbmsContext for the database.
   */
  public abstract RdbmsContext getRdbmsContext();
  private static boolean sslCtxInitialized;
  /**
   * Abstract method to implement aes sys key encoder.
   * @return
   */
  public AesSysKeyEncoder getEncoder() {
    return getRdbSecuritySettings().getEncoder();
  }

  /**
   * Returns the fetch size to use on ResultSets from queries made to this
   * Rdbms.  The default value returned is zero, which means the JDBC driver
   * ignores the value and is free to make its own best guess as to what
   * the fetch size should be. Subclasses can optionally override this method
   * to return a non-negative fetch size value to optimize query performance.
   * Subclass implementations of this method should never throw a runtime
   * exception for any reason, and they should avoid any expensive operations
   * to lookup the result.
   *
   * @see java.sql.ResultSet#setFetchSize(int)
   *
   * @since Niagara 4.11
   */
  public int getResultSetFetchSize()
  {
    return 0;
  }

  /**
   * The Permission checked by any methods that return a {@link Connection} to the relational
   * database.
   * 
   * @see #getConnection()
   * @see #getConnection(String, BPassword) 
   * @see #getPrivilegedConnection(Context)
   * @see #getNonPrivilegedConnection(Context) 
   * @since Niagara 4.15
   */  
  public static final Permission RDB_CONNECTION_PERMISSION = new NiagaraBasicPermission("RDB_CONNECTION_PERMISSION");

  private static final LexiconText PRIVILEGED_USER_NAME = LexiconText.make("rdb", "rdbms.privileged.username");
  private static final LexiconText PRIVILEGED_PASSWORD = LexiconText.make("rdb", "rdbms.privileged.password");
}
