/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * The BLonScptType class provides an enumeration for
 * all standard SCPT types
 *
 * @author Robert Adams on 31 Oct 03
 * @since Niagara 3.0
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("ScptXxx"),
    @Range("ScptActFbDly"),
    @Range("ScptAlrmClrT1"),
    @Range("ScptAlrmClrT2"),
    @Range("ScptAlrmIhbT"),
    @Range("ScptAlrmSetT1"),
    @Range("ScptAlrmSetT2"),
    @Range("ScptDefOutput"),
    @Range("ScptDriveT"),
    @Range("ScptHighLimit1"),
    @Range("ScptHighLimit2"),
    @Range("ScptHystHigh1"),
    @Range("ScptHystHigh2"),
    @Range("ScptHystLow1"),
    @Range("ScptHystLow2"),
    @Range("ScptInFbDly"),
    @Range("ScptInvrtOut"),
    @Range("ScptLocation"),
    @Range("ScptLowLimit1"),
    @Range("ScptLowLimit2"),
    @Range("ScptMaxRnge"),
    @Range("ScptMaxRcvT"),
    @Range("ScptMaxSndT"),
    @Range("ScptMinRnge"),
    @Range("ScptMinSndT"),
    @Range("ScptNwrkCnfg"),
    @Range("ScptOffset"),
    @Range("ScptSndDelta"),
    @Range("ScptTrnsTblX"),
    @Range("ScptTrnsTblY"),
    @Range("ScptOffDely"),
    @Range("ScptGain"),
    @Range("ScptOvrBehave"),
    @Range("ScptOvrValue"),
    @Range("ScptBypassTime"),
    @Range("ScptManOvrTime"),
    @Range("ScptHumSetpt"),
    @Range("ScptMaxFlowHeat"),
    @Range("ScptFireInitType"),
    @Range("ScptSmokeNomSens"),
    @Range("ScptSmokeDayAlrmLim"),
    @Range("ScptActuatorType"),
    @Range("ScptLimitCO2"),
    @Range("ScptMinDeltaAngl"),
    @Range("ScptDirection"),
    @Range("ScptDriveTime"),
    @Range("ScptDuctArea"),
    @Range("ScptMinDeltaFlow"),
    @Range("ScptMaxRcvTime"),
    @Range("ScptMaxSendTime"),
    @Range("ScptMaxSetpoint"),
    @Range("ScptMaxFlow"),
    @Range("ScptMinSendTime"),
    @Range("ScptMinSetpoint"),
    @Range("ScptMinFlow"),
    @Range("ScptMinFlowHeat"),
    @Range("ScptMinFlowStby"),
    @Range("ScptNomAirFlow"),
    @Range("ScptNomAngle"),
    @Range("ScptNumValves"),
    @Range("ScptSetPnts"),
    @Range("ScptOemType"),
    @Range("ScptMinDeltaRH"),
    @Range("ScptMinDeltaCO2"),
    @Range("ScptMinDeltaTemp"),
    @Range("ScptSensConstTmp"),
    @Range("ScptGainVAV"),
    @Range("ScptSensConstVAV"),
    @Range("ScptOffsetCO2"),
    @Range("ScptOffsetRH"),
    @Range("ScptOffsetTemp"),
    @Range("ScptDefltBehave"),
    @Range("ScptPwrUpDelay"),
    @Range("ScptPwrUpState"),
    @Range("ScptHvacMode"),
    @Range("ScptCoolSetpt"),
    @Range("ScptCoolLowerSP"),
    @Range("ScptCoolUpperSP"),
    @Range("ScptHeatSetpt"),
    @Range("ScptHeatLowerSP"),
    @Range("ScptHeatUpperSP"),
    @Range("ScptLimitChlrCap"),
    @Range("ScptLuxSetpoint"),
    @Range("ScptStep"),
    @Range("ScptOnOffHysteresis"),
    @Range("ScptClOffDelay"),
    @Range("ScptClOnDelay"),
    @Range("ScptPowerupState"),
    @Range("ScptMinDeltaLevel"),
    @Range("ScptReflection"),
    @Range("ScptFieldCalib"),
    @Range("ScptHoldTime"),
    @Range("ScptStepValue"),
    @Range("ScptMaxOut"),
    @Range("ScptSceneNmbr"),
    @Range("ScptFadeTime"),
    @Range("ScptDelayTime"),
    @Range("ScptMasterSlave"),
    @Range("ScptUpdateRate"),
    @Range("ScptSummerTime"),
    @Range("ScptWinterTime"),
    @Range("ScptManualAllowed"),
    @Range("ScptDefWeekMask"),
    @Range("ScptDayDateIndex"),
    @Range("ScptTimeEvent"),
    @Range("ScptModeHrtBt"),
    @Range("ScptDefrostMode"),
    @Range("ScptMaxDefrstTime"),
    @Range("ScptDrainDelay"),
    @Range("ScptInjDelay"),
    @Range("ScptMaxDefrstTemp"),
    @Range("ScptStrtupDelay"),
    @Range("ScptTermTimeTemp"),
    @Range("ScptPumpDownDelay"),
    @Range("ScptSuperHtRefInit"),
    @Range("ScptStrtupOpen"),
    @Range("ScptSuperHtRefMin"),
    @Range("ScptRefrigGlide"),
    @Range("ScptSuperHtRefMax"),
    @Range("ScptRefrigType"),
    @Range("ScptThermMode"),
    @Range("ScptDayNightCntrl"),
    @Range("ScptDiffNight"),
    @Range("ScptHighLimTemp"),
    @Range("ScptHighLimDly"),
    @Range("ScptCutOutValue"),
    @Range("ScptAirTemp1Day"),
    @Range("ScptSmokeNightAlrmLim"),
    @Range("ScptLowLimTemp"),
    @Range("ScptLowLimDly"),
    @Range("ScptDiffValue"),
    @Range("ScptAirTemp1Night"),
    @Range("ScptAirTemp1Alrm"),
    @Range("ScptHighLimDefrDly"),
    @Range("ScptDeltaNight"),
    @Range("ScptRunHrInit"),
    @Range("ScptRunHrAlarm"),
    @Range("ScptEnergyCntInit"),
    @Range("ScptSmokeDayPreAlrmLim"),
    @Range("ScptDebounce"),
    @Range("ScptSmokeNightPreAlrmLim"),
    @Range("ScptZoneNum"),
    @Range("ScptThermAlrmROR"),
    @Range("ScptVisOutput"),
    @Range("ScptAudOutput"),
    @Range("ScptFlashFreq"),
    @Range("ScptInstallDate"),
    @Range("ScptMaintDate"),
    @Range("ScptManfDate"),
    @Range("ScptFireTxt1"),
    @Range("ScptFireTxt2"),
    @Range("ScptFireTxt3"),
    @Range("ScptThermThreshold"),
    @Range("ScptFireIndicate"),
    @Range("ScptTimeZone"),
    @Range("ScptPrimeVal"),
    @Range("ScptSecondVal"),
    @Range("ScptSceneOffset"),
    @Range("ScptNomRPM"),
    @Range("ScptNomFreq"),
    @Range("ScptRampUpTm"),
    @Range("ScptRampDownTm"),
    @Range("ScptDefScale"),
    @Range("ScptRegName"),
    @Range("ScptBaseValue"),
    @Range("ScptDevMajVer"),
    @Range("ScptDevMinVer"),
    @Range("ScptObjMajVer"),
    @Range("ScptObjMinVer"),
    @Range("ScptHvacType"),
    @Range("ScptTimeout"),
    @Range("ScptControlPriority"),
    @Range("ScptDeviceGroupID"),
    @Range("ScptMaxPrivacyZones"),
    @Range("ScptMaxCameraPrepositions"),
    @Range("ScptDefaultPanTiltZoomSpeeds"),
    @Range("ScptDefaultAutoPanSpeed"),
    @Range("ScptAutoAnswer"),
    @Range("ScptDialString"),
    @Range("ScptSerialNumber"),
    @Range("ScptNormalRotationalSpeed"),
    @Range("ScptStandbyRotationalSpeed"),
    @Range("ScptPartNumber"),
    @Range("ScptDischargeAirCoolingSetpoint"),
    @Range("ScptDischargeAirHeatingSetpoint"),
    @Range("ScptMaxSupplyFanCapacity"),
    @Range("ScptMinSupplyFanCapacity"),
    @Range("ScptMaxReturnExhaustFanCapacity"),
    @Range("ScptMinReturnExhaustFanCapacity"),
    @Range("ScptDuctStaticPressureSetpoint"),
    @Range("ScptMaxDuctStaticPressureSetpoint"),
    @Range("ScptMinDuctStaticPressureSetpoint"),
    @Range("ScptDuctStaticPressureLimit"),
    @Range("ScptBuildingStaticPressureSetpoint"),
    @Range("ScptReturnFanStaticPressureSetpoint"),
    @Range("ScptFanDifferentialSetpoint"),
    @Range("ScptMixedAirLowLimitSetpoint"),
    @Range("ScptMixedAirTempSetpoint"),
    @Range("ScptMinOutdoorAirFlowSetpoint"),
    @Range("ScptOutdoorAirTempSetpoint"),
    @Range("ScptOutdoorAirEnthalpySetpoint"),
    @Range("ScptDiffTempSetpoint"),
    @Range("ScptExhaustEnablePosition"),
    @Range("ScptSpaceHumSetpoint"),
    @Range("ScptDischargeAirDewpointSetpoint"),
    @Range("ScptMaxDischargeAirCoolingSetpoint"),
    @Range("ScptMinDischargeAirCoolingSetpoint"),
    @Range("ScptMaxDischargeAirHeatingSetpoint"),
    @Range("ScptMinDischargeAirHeatingSetpoint"),
    @Range("ScptCoolingLockout"),
    @Range("ScptHeatingLockout"),
    @Range("ScptCoolingResetEnable"),
    @Range("ScptHeatingResetEnable"),
    @Range("ScptSetpoint"),
    @Range("ScptTemperatureHysteresis"),
    @Range("ScptControlTemperatureWeighting"),
    @Range("ScptPwmPeriod"),
    @Range("ScptDefrostInternalSchedule"),
    @Range("ScptDefrostStart"),
    @Range("ScptDefrostCycles"),
    @Range("ScptMinDefrostTime"),
    @Range("ScptMaxDefrostTime"),
    @Range("ScptDefrostFanDelay"),
    @Range("ScptDefrostRecoveryTime"),
    @Range("ScptDefrostHold"),
    @Range("ScptDefrostDetect"),
    @Range("ScptScheduleInternal"),
    @Range("ScptTempOffset"),
    @Range("ScptAudibleLevel"),
    @Range("ScptScrollSpeed"),
    @Range("ScptBrightness"),
    @Range("ScptOrientation"),
    @Range("ScptInstalledLevel"),
    @Range("ScptPumpCharacteristic"),
    @Range("ScptMinPressureSetpoint"),
    @Range("ScptMaxPressureSetpoint"),
    @Range("ScptMinFlowSetpoint"),
    @Range("ScptMaxFlowSetpoint"),
    @Range("ScptDeviceControlMode"),
    @Range("ScptMinRemotePressureSetpoint"),
    @Range("ScptMaxRemotePressureSetpoint"),
    @Range("ScptMinRemoteFlowSetpoint"),
    @Range("ScptMaxRemoteFlowSetpoint"),
    @Range("ScptMinRemoteTempSetpoint"),
    @Range("ScptMaxRemoteTempSetpoint"),
    @Range("ScptControlSignal"),
    @Range("ScptNightPurgePosition"),
    @Range("ScptFreeCoolPosition"),
    @Range("ScptValveFlowCharacteristic"),
    @Range("ScptValveOperatingMode"),
    @Range("ScptEmergencyPosition"),
    @Range("ScptBlockProtectionTime"),
    @Range("ScptMinStroke"),
    @Range("ScptMaxStroke"),
    @Range("ScptNvType"),
    @Range("ScptMaxNVLength"),
    @Range("ScptNvDynamicAssignment"),
    @Range("ScptSafExtCnfg"),
    @Range("ScptEmergCnfg"),
    @Range("ScptSluiceCnfg"),
    @Range("ScptFanOperation"),
    @Range("ScptMinFlowUnit"),
    @Range("ScptMaxFlowUnit"),
    @Range("ScptMinFlowHeatStby"),
    @Range("ScptMinFlowUnitStby"),
    @Range("ScptOffsetFlow"),
    @Range("ScptAreaDuctHeat"),
    @Range("ScptNomAirFlowHeat"),
    @Range("ScptGainVAVHeat"),
    @Range("ScptNumDampers"),
    @Range("ScptMinFlowUnitHeat"),
    @Range("ScptSaturationDelay"),
    @Range("ScptEffectivePeriod"),
    @Range("ScptScheduleDates"),
    @Range("ScptSchedule"),
    @Range("ScptScheduleTimeValue"),
    @Range("ScptValueDefinition"),
    @Range("ScptValueName"),
    @Range("ScptWeeklySchedule"),
    @Range("ScptScheduleName"),
    @Range("ScptValveStroke"),
    @Range("ScptValveNominalSize"),
    @Range("ScptValveKvs"),
    @Range("ScptValveType"),
    @Range("ScptActuatorCharacteristic"),
    @Range("ScptTrnsTblX2"),
    @Range("ScptTrnsTblY2"),
    @Range("ScptCombFlowCharacteristic"),
    @Range("ScptTrnsTblX3"),
    @Range("ScptTrnsTblY3"),
    @Range("ScptRunTimeAlarm"),
    @Range("ScptTimePeriod"),
    @Range("ScptPulseValue"),
    @Range("ScptNumDigits"),
    @Range("ScptIdentity"),
    @Range("ScptDefaultState"),
    @Range("ScptNvPriority"),
    @Range("ScptDefaultSetting"),
    @Range("ScptLowLimit1Enable"),
    @Range("ScptLowLimit2Enable"),
    @Range("ScptClockCalibration"),
    @Range("ScptNeuronId"),
    @Range("ScptHighLimit1Enable"),
    @Range("ScptHighLimit2Enable"),
    @Range("ScptAhamApplianceModel"),
    @Range("ScptDefInput"),
    @Range("ScptName1"),
    @Range("ScptScene"),
    @Range("ScptSceneTiming"),
    @Range("ScptName2"),
    @Range("ScptName3"),
    @Range("ScptButtonPressAction"),
    @Range("ScptButtonColor"),
    @Range("ScptButtonRepeatInterval"),
    @Range("ScptButtonHoldAction"),
    @Range("ScptPwrSendOnDelta"),
    @Range("ScptSceneName"),
    @Range("ScptMaxPower"),
    @Range("ScptIfaceDesc"),
    @Range("ScptMonInterval"),
    @Range("ScptLinkPowerDetectEnable"),
    @Range("ScptScanTime"),
    @Range("ScptDevListDesc"),
    @Range("ScptDevListEntry"),
    @Range("ScptLogCapacity"),
    @Range("ScptLogNotificationThreshold"),
    @Range("ScptLogSize"),
    @Range("ScptLogType"),
    @Range("ScptFanInEnable"),
    @Range("ScptLogTimestampEnable"),
    @Range("ScptLogHighLimit"),
    @Range("ScptLogLowLimit"),
    @Range("ScptMaxFanIn"),
    @Range("ScptLogMinDeltaTime"),
    @Range("ScptLogMinDeltaValue"),
    @Range("ScptPollRate"),
    @Range("ScptSourceAddress"),
    @Range("ScptLogRecord"),
    @Range("ScptLogFileHeader"),
    @Range("ScptLogAlarmThreshold"),
    @Range("ScptLogRequest"),
    @Range("ScptLogResponse"),
    @Range("ScptLightingGroupEnable"),
    @Range("ScptSceneColor"),
    @Range("ScptBkupSchedule"),
    @Range("ScptOLCLimits"),
    @Range("ScptLampPower"),
    @Range("ScptDeviceOutSelection"),
    @Range("ScptEnableStatusMsg"),
    @Range("ScptMaxLevelVolt"),
    @Range("ScptGeoLocation"),
    @Range("ScptProgName"),
    @Range("ScptProgRevision"),
    @Range("ScptProgSelect"),
    @Range("ScptProgSourceLocation"),
    @Range("ScptProgFileIndexes"),
    @Range("ScptProgCmdHistory"),
    @Range("ScptProgStateHistory"),
    @Range("ScptNsdsFbIndex"),
    @Range("ScptCurrentSenseEnable"),
    @Range("ScptMeasurementInterval"),
    @Range("ScptLightingGroupMembership"),
    @Range("ScptLoadControlOffset"),
    @Range("ScptProgErrorHistory"),
    @Range("ScptNvUsage"),
    @Range("ScptScheduleSunday"),
    @Range("ScptScheduleMonday"),
    @Range("ScptScheduleTuesday"),
    @Range("ScptScheduleWednesday"),
    @Range("ScptScheduleThursday"),
    @Range("ScptScheduleFriday"),
    @Range("ScptScheduleSaturday"),
    @Range("ScptOccupancyBehavior"),
    @Range("ScptTimeSource"),
    @Range("ScptScheduleException"),
    @Range("ScptScheduleHoliday"),
    @Range("ScptRandomizationInterval"),
    @Range("ScptSunriseTime"),
    @Range("ScptSunsetTime"),
    @Range("ScptSchedulerOptions"),
    @Range("ScptOccupancyThresholds")
  }
)
public final class BLonScptType
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.lonworks.enums.BLonScptType(565254039)1.0$ @*/
/* Generated Tue Jun 06 14:04:02 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for ScptXxx. */
  @Generated
  public static final int SCPT_XXX = 0;
  /** Ordinal value for ScptActFbDly. */
  @Generated
  public static final int SCPT_ACT_FB_DLY = 1;
  /** Ordinal value for ScptAlrmClrT1. */
  @Generated
  public static final int SCPT_ALRM_CLR_T1 = 2;
  /** Ordinal value for ScptAlrmClrT2. */
  @Generated
  public static final int SCPT_ALRM_CLR_T2 = 3;
  /** Ordinal value for ScptAlrmIhbT. */
  @Generated
  public static final int SCPT_ALRM_IHB_T = 4;
  /** Ordinal value for ScptAlrmSetT1. */
  @Generated
  public static final int SCPT_ALRM_SET_T1 = 5;
  /** Ordinal value for ScptAlrmSetT2. */
  @Generated
  public static final int SCPT_ALRM_SET_T2 = 6;
  /** Ordinal value for ScptDefOutput. */
  @Generated
  public static final int SCPT_DEF_OUTPUT = 7;
  /** Ordinal value for ScptDriveT. */
  @Generated
  public static final int SCPT_DRIVE_T = 8;
  /** Ordinal value for ScptHighLimit1. */
  @Generated
  public static final int SCPT_HIGH_LIMIT_1 = 9;
  /** Ordinal value for ScptHighLimit2. */
  @Generated
  public static final int SCPT_HIGH_LIMIT_2 = 10;
  /** Ordinal value for ScptHystHigh1. */
  @Generated
  public static final int SCPT_HYST_HIGH_1 = 11;
  /** Ordinal value for ScptHystHigh2. */
  @Generated
  public static final int SCPT_HYST_HIGH_2 = 12;
  /** Ordinal value for ScptHystLow1. */
  @Generated
  public static final int SCPT_HYST_LOW_1 = 13;
  /** Ordinal value for ScptHystLow2. */
  @Generated
  public static final int SCPT_HYST_LOW_2 = 14;
  /** Ordinal value for ScptInFbDly. */
  @Generated
  public static final int SCPT_IN_FB_DLY = 15;
  /** Ordinal value for ScptInvrtOut. */
  @Generated
  public static final int SCPT_INVRT_OUT = 16;
  /** Ordinal value for ScptLocation. */
  @Generated
  public static final int SCPT_LOCATION = 17;
  /** Ordinal value for ScptLowLimit1. */
  @Generated
  public static final int SCPT_LOW_LIMIT_1 = 18;
  /** Ordinal value for ScptLowLimit2. */
  @Generated
  public static final int SCPT_LOW_LIMIT_2 = 19;
  /** Ordinal value for ScptMaxRnge. */
  @Generated
  public static final int SCPT_MAX_RNGE = 20;
  /** Ordinal value for ScptMaxRcvT. */
  @Generated
  public static final int SCPT_MAX_RCV_T = 21;
  /** Ordinal value for ScptMaxSndT. */
  @Generated
  public static final int SCPT_MAX_SND_T = 22;
  /** Ordinal value for ScptMinRnge. */
  @Generated
  public static final int SCPT_MIN_RNGE = 23;
  /** Ordinal value for ScptMinSndT. */
  @Generated
  public static final int SCPT_MIN_SND_T = 24;
  /** Ordinal value for ScptNwrkCnfg. */
  @Generated
  public static final int SCPT_NWRK_CNFG = 25;
  /** Ordinal value for ScptOffset. */
  @Generated
  public static final int SCPT_OFFSET = 26;
  /** Ordinal value for ScptSndDelta. */
  @Generated
  public static final int SCPT_SND_DELTA = 27;
  /** Ordinal value for ScptTrnsTblX. */
  @Generated
  public static final int SCPT_TRNS_TBL_X = 28;
  /** Ordinal value for ScptTrnsTblY. */
  @Generated
  public static final int SCPT_TRNS_TBL_Y = 29;
  /** Ordinal value for ScptOffDely. */
  @Generated
  public static final int SCPT_OFF_DELY = 30;
  /** Ordinal value for ScptGain. */
  @Generated
  public static final int SCPT_GAIN = 31;
  /** Ordinal value for ScptOvrBehave. */
  @Generated
  public static final int SCPT_OVR_BEHAVE = 32;
  /** Ordinal value for ScptOvrValue. */
  @Generated
  public static final int SCPT_OVR_VALUE = 33;
  /** Ordinal value for ScptBypassTime. */
  @Generated
  public static final int SCPT_BYPASS_TIME = 34;
  /** Ordinal value for ScptManOvrTime. */
  @Generated
  public static final int SCPT_MAN_OVR_TIME = 35;
  /** Ordinal value for ScptHumSetpt. */
  @Generated
  public static final int SCPT_HUM_SETPT = 36;
  /** Ordinal value for ScptMaxFlowHeat. */
  @Generated
  public static final int SCPT_MAX_FLOW_HEAT = 37;
  /** Ordinal value for ScptFireInitType. */
  @Generated
  public static final int SCPT_FIRE_INIT_TYPE = 38;
  /** Ordinal value for ScptSmokeNomSens. */
  @Generated
  public static final int SCPT_SMOKE_NOM_SENS = 39;
  /** Ordinal value for ScptSmokeDayAlrmLim. */
  @Generated
  public static final int SCPT_SMOKE_DAY_ALRM_LIM = 40;
  /** Ordinal value for ScptActuatorType. */
  @Generated
  public static final int SCPT_ACTUATOR_TYPE = 41;
  /** Ordinal value for ScptLimitCO2. */
  @Generated
  public static final int SCPT_LIMIT_CO2 = 42;
  /** Ordinal value for ScptMinDeltaAngl. */
  @Generated
  public static final int SCPT_MIN_DELTA_ANGL = 43;
  /** Ordinal value for ScptDirection. */
  @Generated
  public static final int SCPT_DIRECTION = 44;
  /** Ordinal value for ScptDriveTime. */
  @Generated
  public static final int SCPT_DRIVE_TIME = 45;
  /** Ordinal value for ScptDuctArea. */
  @Generated
  public static final int SCPT_DUCT_AREA = 46;
  /** Ordinal value for ScptMinDeltaFlow. */
  @Generated
  public static final int SCPT_MIN_DELTA_FLOW = 47;
  /** Ordinal value for ScptMaxRcvTime. */
  @Generated
  public static final int SCPT_MAX_RCV_TIME = 48;
  /** Ordinal value for ScptMaxSendTime. */
  @Generated
  public static final int SCPT_MAX_SEND_TIME = 49;
  /** Ordinal value for ScptMaxSetpoint. */
  @Generated
  public static final int SCPT_MAX_SETPOINT = 50;
  /** Ordinal value for ScptMaxFlow. */
  @Generated
  public static final int SCPT_MAX_FLOW = 51;
  /** Ordinal value for ScptMinSendTime. */
  @Generated
  public static final int SCPT_MIN_SEND_TIME = 52;
  /** Ordinal value for ScptMinSetpoint. */
  @Generated
  public static final int SCPT_MIN_SETPOINT = 53;
  /** Ordinal value for ScptMinFlow. */
  @Generated
  public static final int SCPT_MIN_FLOW = 54;
  /** Ordinal value for ScptMinFlowHeat. */
  @Generated
  public static final int SCPT_MIN_FLOW_HEAT = 55;
  /** Ordinal value for ScptMinFlowStby. */
  @Generated
  public static final int SCPT_MIN_FLOW_STBY = 56;
  /** Ordinal value for ScptNomAirFlow. */
  @Generated
  public static final int SCPT_NOM_AIR_FLOW = 57;
  /** Ordinal value for ScptNomAngle. */
  @Generated
  public static final int SCPT_NOM_ANGLE = 58;
  /** Ordinal value for ScptNumValves. */
  @Generated
  public static final int SCPT_NUM_VALVES = 59;
  /** Ordinal value for ScptSetPnts. */
  @Generated
  public static final int SCPT_SET_PNTS = 60;
  /** Ordinal value for ScptOemType. */
  @Generated
  public static final int SCPT_OEM_TYPE = 61;
  /** Ordinal value for ScptMinDeltaRH. */
  @Generated
  public static final int SCPT_MIN_DELTA_RH = 62;
  /** Ordinal value for ScptMinDeltaCO2. */
  @Generated
  public static final int SCPT_MIN_DELTA_CO2 = 63;
  /** Ordinal value for ScptMinDeltaTemp. */
  @Generated
  public static final int SCPT_MIN_DELTA_TEMP = 64;
  /** Ordinal value for ScptSensConstTmp. */
  @Generated
  public static final int SCPT_SENS_CONST_TMP = 65;
  /** Ordinal value for ScptGainVAV. */
  @Generated
  public static final int SCPT_GAIN_VAV = 66;
  /** Ordinal value for ScptSensConstVAV. */
  @Generated
  public static final int SCPT_SENS_CONST_VAV = 67;
  /** Ordinal value for ScptOffsetCO2. */
  @Generated
  public static final int SCPT_OFFSET_CO2 = 68;
  /** Ordinal value for ScptOffsetRH. */
  @Generated
  public static final int SCPT_OFFSET_RH = 69;
  /** Ordinal value for ScptOffsetTemp. */
  @Generated
  public static final int SCPT_OFFSET_TEMP = 70;
  /** Ordinal value for ScptDefltBehave. */
  @Generated
  public static final int SCPT_DEFLT_BEHAVE = 71;
  /** Ordinal value for ScptPwrUpDelay. */
  @Generated
  public static final int SCPT_PWR_UP_DELAY = 72;
  /** Ordinal value for ScptPwrUpState. */
  @Generated
  public static final int SCPT_PWR_UP_STATE = 73;
  /** Ordinal value for ScptHvacMode. */
  @Generated
  public static final int SCPT_HVAC_MODE = 74;
  /** Ordinal value for ScptCoolSetpt. */
  @Generated
  public static final int SCPT_COOL_SETPT = 75;
  /** Ordinal value for ScptCoolLowerSP. */
  @Generated
  public static final int SCPT_COOL_LOWER_SP = 76;
  /** Ordinal value for ScptCoolUpperSP. */
  @Generated
  public static final int SCPT_COOL_UPPER_SP = 77;
  /** Ordinal value for ScptHeatSetpt. */
  @Generated
  public static final int SCPT_HEAT_SETPT = 78;
  /** Ordinal value for ScptHeatLowerSP. */
  @Generated
  public static final int SCPT_HEAT_LOWER_SP = 79;
  /** Ordinal value for ScptHeatUpperSP. */
  @Generated
  public static final int SCPT_HEAT_UPPER_SP = 80;
  /** Ordinal value for ScptLimitChlrCap. */
  @Generated
  public static final int SCPT_LIMIT_CHLR_CAP = 81;
  /** Ordinal value for ScptLuxSetpoint. */
  @Generated
  public static final int SCPT_LUX_SETPOINT = 82;
  /** Ordinal value for ScptStep. */
  @Generated
  public static final int SCPT_STEP = 83;
  /** Ordinal value for ScptOnOffHysteresis. */
  @Generated
  public static final int SCPT_ON_OFF_HYSTERESIS = 84;
  /** Ordinal value for ScptClOffDelay. */
  @Generated
  public static final int SCPT_CL_OFF_DELAY = 85;
  /** Ordinal value for ScptClOnDelay. */
  @Generated
  public static final int SCPT_CL_ON_DELAY = 86;
  /** Ordinal value for ScptPowerupState. */
  @Generated
  public static final int SCPT_POWERUP_STATE = 87;
  /** Ordinal value for ScptMinDeltaLevel. */
  @Generated
  public static final int SCPT_MIN_DELTA_LEVEL = 88;
  /** Ordinal value for ScptReflection. */
  @Generated
  public static final int SCPT_REFLECTION = 89;
  /** Ordinal value for ScptFieldCalib. */
  @Generated
  public static final int SCPT_FIELD_CALIB = 90;
  /** Ordinal value for ScptHoldTime. */
  @Generated
  public static final int SCPT_HOLD_TIME = 91;
  /** Ordinal value for ScptStepValue. */
  @Generated
  public static final int SCPT_STEP_VALUE = 92;
  /** Ordinal value for ScptMaxOut. */
  @Generated
  public static final int SCPT_MAX_OUT = 93;
  /** Ordinal value for ScptSceneNmbr. */
  @Generated
  public static final int SCPT_SCENE_NMBR = 94;
  /** Ordinal value for ScptFadeTime. */
  @Generated
  public static final int SCPT_FADE_TIME = 95;
  /** Ordinal value for ScptDelayTime. */
  @Generated
  public static final int SCPT_DELAY_TIME = 96;
  /** Ordinal value for ScptMasterSlave. */
  @Generated
  public static final int SCPT_MASTER_SLAVE = 97;
  /** Ordinal value for ScptUpdateRate. */
  @Generated
  public static final int SCPT_UPDATE_RATE = 98;
  /** Ordinal value for ScptSummerTime. */
  @Generated
  public static final int SCPT_SUMMER_TIME = 99;
  /** Ordinal value for ScptWinterTime. */
  @Generated
  public static final int SCPT_WINTER_TIME = 100;
  /** Ordinal value for ScptManualAllowed. */
  @Generated
  public static final int SCPT_MANUAL_ALLOWED = 101;
  /** Ordinal value for ScptDefWeekMask. */
  @Generated
  public static final int SCPT_DEF_WEEK_MASK = 102;
  /** Ordinal value for ScptDayDateIndex. */
  @Generated
  public static final int SCPT_DAY_DATE_INDEX = 103;
  /** Ordinal value for ScptTimeEvent. */
  @Generated
  public static final int SCPT_TIME_EVENT = 104;
  /** Ordinal value for ScptModeHrtBt. */
  @Generated
  public static final int SCPT_MODE_HRT_BT = 105;
  /** Ordinal value for ScptDefrostMode. */
  @Generated
  public static final int SCPT_DEFROST_MODE = 106;
  /** Ordinal value for ScptMaxDefrstTime. */
  @Generated
  public static final int SCPT_MAX_DEFRST_TIME = 107;
  /** Ordinal value for ScptDrainDelay. */
  @Generated
  public static final int SCPT_DRAIN_DELAY = 108;
  /** Ordinal value for ScptInjDelay. */
  @Generated
  public static final int SCPT_INJ_DELAY = 109;
  /** Ordinal value for ScptMaxDefrstTemp. */
  @Generated
  public static final int SCPT_MAX_DEFRST_TEMP = 110;
  /** Ordinal value for ScptStrtupDelay. */
  @Generated
  public static final int SCPT_STRTUP_DELAY = 111;
  /** Ordinal value for ScptTermTimeTemp. */
  @Generated
  public static final int SCPT_TERM_TIME_TEMP = 112;
  /** Ordinal value for ScptPumpDownDelay. */
  @Generated
  public static final int SCPT_PUMP_DOWN_DELAY = 113;
  /** Ordinal value for ScptSuperHtRefInit. */
  @Generated
  public static final int SCPT_SUPER_HT_REF_INIT = 114;
  /** Ordinal value for ScptStrtupOpen. */
  @Generated
  public static final int SCPT_STRTUP_OPEN = 115;
  /** Ordinal value for ScptSuperHtRefMin. */
  @Generated
  public static final int SCPT_SUPER_HT_REF_MIN = 116;
  /** Ordinal value for ScptRefrigGlide. */
  @Generated
  public static final int SCPT_REFRIG_GLIDE = 117;
  /** Ordinal value for ScptSuperHtRefMax. */
  @Generated
  public static final int SCPT_SUPER_HT_REF_MAX = 118;
  /** Ordinal value for ScptRefrigType. */
  @Generated
  public static final int SCPT_REFRIG_TYPE = 119;
  /** Ordinal value for ScptThermMode. */
  @Generated
  public static final int SCPT_THERM_MODE = 120;
  /** Ordinal value for ScptDayNightCntrl. */
  @Generated
  public static final int SCPT_DAY_NIGHT_CNTRL = 121;
  /** Ordinal value for ScptDiffNight. */
  @Generated
  public static final int SCPT_DIFF_NIGHT = 122;
  /** Ordinal value for ScptHighLimTemp. */
  @Generated
  public static final int SCPT_HIGH_LIM_TEMP = 123;
  /** Ordinal value for ScptHighLimDly. */
  @Generated
  public static final int SCPT_HIGH_LIM_DLY = 124;
  /** Ordinal value for ScptCutOutValue. */
  @Generated
  public static final int SCPT_CUT_OUT_VALUE = 125;
  /** Ordinal value for ScptAirTemp1Day. */
  @Generated
  public static final int SCPT_AIR_TEMP_1DAY = 126;
  /** Ordinal value for ScptSmokeNightAlrmLim. */
  @Generated
  public static final int SCPT_SMOKE_NIGHT_ALRM_LIM = 127;
  /** Ordinal value for ScptLowLimTemp. */
  @Generated
  public static final int SCPT_LOW_LIM_TEMP = 128;
  /** Ordinal value for ScptLowLimDly. */
  @Generated
  public static final int SCPT_LOW_LIM_DLY = 129;
  /** Ordinal value for ScptDiffValue. */
  @Generated
  public static final int SCPT_DIFF_VALUE = 130;
  /** Ordinal value for ScptAirTemp1Night. */
  @Generated
  public static final int SCPT_AIR_TEMP_1NIGHT = 131;
  /** Ordinal value for ScptAirTemp1Alrm. */
  @Generated
  public static final int SCPT_AIR_TEMP_1ALRM = 132;
  /** Ordinal value for ScptHighLimDefrDly. */
  @Generated
  public static final int SCPT_HIGH_LIM_DEFR_DLY = 133;
  /** Ordinal value for ScptDeltaNight. */
  @Generated
  public static final int SCPT_DELTA_NIGHT = 134;
  /** Ordinal value for ScptRunHrInit. */
  @Generated
  public static final int SCPT_RUN_HR_INIT = 135;
  /** Ordinal value for ScptRunHrAlarm. */
  @Generated
  public static final int SCPT_RUN_HR_ALARM = 136;
  /** Ordinal value for ScptEnergyCntInit. */
  @Generated
  public static final int SCPT_ENERGY_CNT_INIT = 137;
  /** Ordinal value for ScptSmokeDayPreAlrmLim. */
  @Generated
  public static final int SCPT_SMOKE_DAY_PRE_ALRM_LIM = 138;
  /** Ordinal value for ScptDebounce. */
  @Generated
  public static final int SCPT_DEBOUNCE = 139;
  /** Ordinal value for ScptSmokeNightPreAlrmLim. */
  @Generated
  public static final int SCPT_SMOKE_NIGHT_PRE_ALRM_LIM = 140;
  /** Ordinal value for ScptZoneNum. */
  @Generated
  public static final int SCPT_ZONE_NUM = 141;
  /** Ordinal value for ScptThermAlrmROR. */
  @Generated
  public static final int SCPT_THERM_ALRM_ROR = 142;
  /** Ordinal value for ScptVisOutput. */
  @Generated
  public static final int SCPT_VIS_OUTPUT = 143;
  /** Ordinal value for ScptAudOutput. */
  @Generated
  public static final int SCPT_AUD_OUTPUT = 144;
  /** Ordinal value for ScptFlashFreq. */
  @Generated
  public static final int SCPT_FLASH_FREQ = 145;
  /** Ordinal value for ScptInstallDate. */
  @Generated
  public static final int SCPT_INSTALL_DATE = 146;
  /** Ordinal value for ScptMaintDate. */
  @Generated
  public static final int SCPT_MAINT_DATE = 147;
  /** Ordinal value for ScptManfDate. */
  @Generated
  public static final int SCPT_MANF_DATE = 148;
  /** Ordinal value for ScptFireTxt1. */
  @Generated
  public static final int SCPT_FIRE_TXT_1 = 149;
  /** Ordinal value for ScptFireTxt2. */
  @Generated
  public static final int SCPT_FIRE_TXT_2 = 150;
  /** Ordinal value for ScptFireTxt3. */
  @Generated
  public static final int SCPT_FIRE_TXT_3 = 151;
  /** Ordinal value for ScptThermThreshold. */
  @Generated
  public static final int SCPT_THERM_THRESHOLD = 152;
  /** Ordinal value for ScptFireIndicate. */
  @Generated
  public static final int SCPT_FIRE_INDICATE = 153;
  /** Ordinal value for ScptTimeZone. */
  @Generated
  public static final int SCPT_TIME_ZONE = 154;
  /** Ordinal value for ScptPrimeVal. */
  @Generated
  public static final int SCPT_PRIME_VAL = 155;
  /** Ordinal value for ScptSecondVal. */
  @Generated
  public static final int SCPT_SECOND_VAL = 156;
  /** Ordinal value for ScptSceneOffset. */
  @Generated
  public static final int SCPT_SCENE_OFFSET = 157;
  /** Ordinal value for ScptNomRPM. */
  @Generated
  public static final int SCPT_NOM_RPM = 158;
  /** Ordinal value for ScptNomFreq. */
  @Generated
  public static final int SCPT_NOM_FREQ = 159;
  /** Ordinal value for ScptRampUpTm. */
  @Generated
  public static final int SCPT_RAMP_UP_TM = 160;
  /** Ordinal value for ScptRampDownTm. */
  @Generated
  public static final int SCPT_RAMP_DOWN_TM = 161;
  /** Ordinal value for ScptDefScale. */
  @Generated
  public static final int SCPT_DEF_SCALE = 162;
  /** Ordinal value for ScptRegName. */
  @Generated
  public static final int SCPT_REG_NAME = 163;
  /** Ordinal value for ScptBaseValue. */
  @Generated
  public static final int SCPT_BASE_VALUE = 164;
  /** Ordinal value for ScptDevMajVer. */
  @Generated
  public static final int SCPT_DEV_MAJ_VER = 165;
  /** Ordinal value for ScptDevMinVer. */
  @Generated
  public static final int SCPT_DEV_MIN_VER = 166;
  /** Ordinal value for ScptObjMajVer. */
  @Generated
  public static final int SCPT_OBJ_MAJ_VER = 167;
  /** Ordinal value for ScptObjMinVer. */
  @Generated
  public static final int SCPT_OBJ_MIN_VER = 168;
  /** Ordinal value for ScptHvacType. */
  @Generated
  public static final int SCPT_HVAC_TYPE = 169;
  /** Ordinal value for ScptTimeout. */
  @Generated
  public static final int SCPT_TIMEOUT = 170;
  /** Ordinal value for ScptControlPriority. */
  @Generated
  public static final int SCPT_CONTROL_PRIORITY = 171;
  /** Ordinal value for ScptDeviceGroupID. */
  @Generated
  public static final int SCPT_DEVICE_GROUP_ID = 172;
  /** Ordinal value for ScptMaxPrivacyZones. */
  @Generated
  public static final int SCPT_MAX_PRIVACY_ZONES = 173;
  /** Ordinal value for ScptMaxCameraPrepositions. */
  @Generated
  public static final int SCPT_MAX_CAMERA_PREPOSITIONS = 174;
  /** Ordinal value for ScptDefaultPanTiltZoomSpeeds. */
  @Generated
  public static final int SCPT_DEFAULT_PAN_TILT_ZOOM_SPEEDS = 175;
  /** Ordinal value for ScptDefaultAutoPanSpeed. */
  @Generated
  public static final int SCPT_DEFAULT_AUTO_PAN_SPEED = 176;
  /** Ordinal value for ScptAutoAnswer. */
  @Generated
  public static final int SCPT_AUTO_ANSWER = 177;
  /** Ordinal value for ScptDialString. */
  @Generated
  public static final int SCPT_DIAL_STRING = 178;
  /** Ordinal value for ScptSerialNumber. */
  @Generated
  public static final int SCPT_SERIAL_NUMBER = 179;
  /** Ordinal value for ScptNormalRotationalSpeed. */
  @Generated
  public static final int SCPT_NORMAL_ROTATIONAL_SPEED = 180;
  /** Ordinal value for ScptStandbyRotationalSpeed. */
  @Generated
  public static final int SCPT_STANDBY_ROTATIONAL_SPEED = 181;
  /** Ordinal value for ScptPartNumber. */
  @Generated
  public static final int SCPT_PART_NUMBER = 182;
  /** Ordinal value for ScptDischargeAirCoolingSetpoint. */
  @Generated
  public static final int SCPT_DISCHARGE_AIR_COOLING_SETPOINT = 183;
  /** Ordinal value for ScptDischargeAirHeatingSetpoint. */
  @Generated
  public static final int SCPT_DISCHARGE_AIR_HEATING_SETPOINT = 184;
  /** Ordinal value for ScptMaxSupplyFanCapacity. */
  @Generated
  public static final int SCPT_MAX_SUPPLY_FAN_CAPACITY = 185;
  /** Ordinal value for ScptMinSupplyFanCapacity. */
  @Generated
  public static final int SCPT_MIN_SUPPLY_FAN_CAPACITY = 186;
  /** Ordinal value for ScptMaxReturnExhaustFanCapacity. */
  @Generated
  public static final int SCPT_MAX_RETURN_EXHAUST_FAN_CAPACITY = 187;
  /** Ordinal value for ScptMinReturnExhaustFanCapacity. */
  @Generated
  public static final int SCPT_MIN_RETURN_EXHAUST_FAN_CAPACITY = 188;
  /** Ordinal value for ScptDuctStaticPressureSetpoint. */
  @Generated
  public static final int SCPT_DUCT_STATIC_PRESSURE_SETPOINT = 189;
  /** Ordinal value for ScptMaxDuctStaticPressureSetpoint. */
  @Generated
  public static final int SCPT_MAX_DUCT_STATIC_PRESSURE_SETPOINT = 190;
  /** Ordinal value for ScptMinDuctStaticPressureSetpoint. */
  @Generated
  public static final int SCPT_MIN_DUCT_STATIC_PRESSURE_SETPOINT = 191;
  /** Ordinal value for ScptDuctStaticPressureLimit. */
  @Generated
  public static final int SCPT_DUCT_STATIC_PRESSURE_LIMIT = 192;
  /** Ordinal value for ScptBuildingStaticPressureSetpoint. */
  @Generated
  public static final int SCPT_BUILDING_STATIC_PRESSURE_SETPOINT = 193;
  /** Ordinal value for ScptReturnFanStaticPressureSetpoint. */
  @Generated
  public static final int SCPT_RETURN_FAN_STATIC_PRESSURE_SETPOINT = 194;
  /** Ordinal value for ScptFanDifferentialSetpoint. */
  @Generated
  public static final int SCPT_FAN_DIFFERENTIAL_SETPOINT = 195;
  /** Ordinal value for ScptMixedAirLowLimitSetpoint. */
  @Generated
  public static final int SCPT_MIXED_AIR_LOW_LIMIT_SETPOINT = 196;
  /** Ordinal value for ScptMixedAirTempSetpoint. */
  @Generated
  public static final int SCPT_MIXED_AIR_TEMP_SETPOINT = 197;
  /** Ordinal value for ScptMinOutdoorAirFlowSetpoint. */
  @Generated
  public static final int SCPT_MIN_OUTDOOR_AIR_FLOW_SETPOINT = 198;
  /** Ordinal value for ScptOutdoorAirTempSetpoint. */
  @Generated
  public static final int SCPT_OUTDOOR_AIR_TEMP_SETPOINT = 199;
  /** Ordinal value for ScptOutdoorAirEnthalpySetpoint. */
  @Generated
  public static final int SCPT_OUTDOOR_AIR_ENTHALPY_SETPOINT = 200;
  /** Ordinal value for ScptDiffTempSetpoint. */
  @Generated
  public static final int SCPT_DIFF_TEMP_SETPOINT = 201;
  /** Ordinal value for ScptExhaustEnablePosition. */
  @Generated
  public static final int SCPT_EXHAUST_ENABLE_POSITION = 202;
  /** Ordinal value for ScptSpaceHumSetpoint. */
  @Generated
  public static final int SCPT_SPACE_HUM_SETPOINT = 203;
  /** Ordinal value for ScptDischargeAirDewpointSetpoint. */
  @Generated
  public static final int SCPT_DISCHARGE_AIR_DEWPOINT_SETPOINT = 204;
  /** Ordinal value for ScptMaxDischargeAirCoolingSetpoint. */
  @Generated
  public static final int SCPT_MAX_DISCHARGE_AIR_COOLING_SETPOINT = 205;
  /** Ordinal value for ScptMinDischargeAirCoolingSetpoint. */
  @Generated
  public static final int SCPT_MIN_DISCHARGE_AIR_COOLING_SETPOINT = 206;
  /** Ordinal value for ScptMaxDischargeAirHeatingSetpoint. */
  @Generated
  public static final int SCPT_MAX_DISCHARGE_AIR_HEATING_SETPOINT = 207;
  /** Ordinal value for ScptMinDischargeAirHeatingSetpoint. */
  @Generated
  public static final int SCPT_MIN_DISCHARGE_AIR_HEATING_SETPOINT = 208;
  /** Ordinal value for ScptCoolingLockout. */
  @Generated
  public static final int SCPT_COOLING_LOCKOUT = 209;
  /** Ordinal value for ScptHeatingLockout. */
  @Generated
  public static final int SCPT_HEATING_LOCKOUT = 210;
  /** Ordinal value for ScptCoolingResetEnable. */
  @Generated
  public static final int SCPT_COOLING_RESET_ENABLE = 211;
  /** Ordinal value for ScptHeatingResetEnable. */
  @Generated
  public static final int SCPT_HEATING_RESET_ENABLE = 212;
  /** Ordinal value for ScptSetpoint. */
  @Generated
  public static final int SCPT_SETPOINT = 213;
  /** Ordinal value for ScptTemperatureHysteresis. */
  @Generated
  public static final int SCPT_TEMPERATURE_HYSTERESIS = 214;
  /** Ordinal value for ScptControlTemperatureWeighting. */
  @Generated
  public static final int SCPT_CONTROL_TEMPERATURE_WEIGHTING = 215;
  /** Ordinal value for ScptPwmPeriod. */
  @Generated
  public static final int SCPT_PWM_PERIOD = 216;
  /** Ordinal value for ScptDefrostInternalSchedule. */
  @Generated
  public static final int SCPT_DEFROST_INTERNAL_SCHEDULE = 217;
  /** Ordinal value for ScptDefrostStart. */
  @Generated
  public static final int SCPT_DEFROST_START = 218;
  /** Ordinal value for ScptDefrostCycles. */
  @Generated
  public static final int SCPT_DEFROST_CYCLES = 219;
  /** Ordinal value for ScptMinDefrostTime. */
  @Generated
  public static final int SCPT_MIN_DEFROST_TIME = 220;
  /** Ordinal value for ScptMaxDefrostTime. */
  @Generated
  public static final int SCPT_MAX_DEFROST_TIME = 221;
  /** Ordinal value for ScptDefrostFanDelay. */
  @Generated
  public static final int SCPT_DEFROST_FAN_DELAY = 222;
  /** Ordinal value for ScptDefrostRecoveryTime. */
  @Generated
  public static final int SCPT_DEFROST_RECOVERY_TIME = 223;
  /** Ordinal value for ScptDefrostHold. */
  @Generated
  public static final int SCPT_DEFROST_HOLD = 224;
  /** Ordinal value for ScptDefrostDetect. */
  @Generated
  public static final int SCPT_DEFROST_DETECT = 225;
  /** Ordinal value for ScptScheduleInternal. */
  @Generated
  public static final int SCPT_SCHEDULE_INTERNAL = 226;
  /** Ordinal value for ScptTempOffset. */
  @Generated
  public static final int SCPT_TEMP_OFFSET = 227;
  /** Ordinal value for ScptAudibleLevel. */
  @Generated
  public static final int SCPT_AUDIBLE_LEVEL = 228;
  /** Ordinal value for ScptScrollSpeed. */
  @Generated
  public static final int SCPT_SCROLL_SPEED = 229;
  /** Ordinal value for ScptBrightness. */
  @Generated
  public static final int SCPT_BRIGHTNESS = 230;
  /** Ordinal value for ScptOrientation. */
  @Generated
  public static final int SCPT_ORIENTATION = 231;
  /** Ordinal value for ScptInstalledLevel. */
  @Generated
  public static final int SCPT_INSTALLED_LEVEL = 232;
  /** Ordinal value for ScptPumpCharacteristic. */
  @Generated
  public static final int SCPT_PUMP_CHARACTERISTIC = 233;
  /** Ordinal value for ScptMinPressureSetpoint. */
  @Generated
  public static final int SCPT_MIN_PRESSURE_SETPOINT = 234;
  /** Ordinal value for ScptMaxPressureSetpoint. */
  @Generated
  public static final int SCPT_MAX_PRESSURE_SETPOINT = 235;
  /** Ordinal value for ScptMinFlowSetpoint. */
  @Generated
  public static final int SCPT_MIN_FLOW_SETPOINT = 236;
  /** Ordinal value for ScptMaxFlowSetpoint. */
  @Generated
  public static final int SCPT_MAX_FLOW_SETPOINT = 237;
  /** Ordinal value for ScptDeviceControlMode. */
  @Generated
  public static final int SCPT_DEVICE_CONTROL_MODE = 238;
  /** Ordinal value for ScptMinRemotePressureSetpoint. */
  @Generated
  public static final int SCPT_MIN_REMOTE_PRESSURE_SETPOINT = 239;
  /** Ordinal value for ScptMaxRemotePressureSetpoint. */
  @Generated
  public static final int SCPT_MAX_REMOTE_PRESSURE_SETPOINT = 240;
  /** Ordinal value for ScptMinRemoteFlowSetpoint. */
  @Generated
  public static final int SCPT_MIN_REMOTE_FLOW_SETPOINT = 241;
  /** Ordinal value for ScptMaxRemoteFlowSetpoint. */
  @Generated
  public static final int SCPT_MAX_REMOTE_FLOW_SETPOINT = 242;
  /** Ordinal value for ScptMinRemoteTempSetpoint. */
  @Generated
  public static final int SCPT_MIN_REMOTE_TEMP_SETPOINT = 243;
  /** Ordinal value for ScptMaxRemoteTempSetpoint. */
  @Generated
  public static final int SCPT_MAX_REMOTE_TEMP_SETPOINT = 244;
  /** Ordinal value for ScptControlSignal. */
  @Generated
  public static final int SCPT_CONTROL_SIGNAL = 245;
  /** Ordinal value for ScptNightPurgePosition. */
  @Generated
  public static final int SCPT_NIGHT_PURGE_POSITION = 246;
  /** Ordinal value for ScptFreeCoolPosition. */
  @Generated
  public static final int SCPT_FREE_COOL_POSITION = 247;
  /** Ordinal value for ScptValveFlowCharacteristic. */
  @Generated
  public static final int SCPT_VALVE_FLOW_CHARACTERISTIC = 248;
  /** Ordinal value for ScptValveOperatingMode. */
  @Generated
  public static final int SCPT_VALVE_OPERATING_MODE = 249;
  /** Ordinal value for ScptEmergencyPosition. */
  @Generated
  public static final int SCPT_EMERGENCY_POSITION = 250;
  /** Ordinal value for ScptBlockProtectionTime. */
  @Generated
  public static final int SCPT_BLOCK_PROTECTION_TIME = 251;
  /** Ordinal value for ScptMinStroke. */
  @Generated
  public static final int SCPT_MIN_STROKE = 252;
  /** Ordinal value for ScptMaxStroke. */
  @Generated
  public static final int SCPT_MAX_STROKE = 253;
  /** Ordinal value for ScptNvType. */
  @Generated
  public static final int SCPT_NV_TYPE = 254;
  /** Ordinal value for ScptMaxNVLength. */
  @Generated
  public static final int SCPT_MAX_NVLENGTH = 255;
  /** Ordinal value for ScptNvDynamicAssignment. */
  @Generated
  public static final int SCPT_NV_DYNAMIC_ASSIGNMENT = 256;
  /** Ordinal value for ScptSafExtCnfg. */
  @Generated
  public static final int SCPT_SAF_EXT_CNFG = 257;
  /** Ordinal value for ScptEmergCnfg. */
  @Generated
  public static final int SCPT_EMERG_CNFG = 258;
  /** Ordinal value for ScptSluiceCnfg. */
  @Generated
  public static final int SCPT_SLUICE_CNFG = 259;
  /** Ordinal value for ScptFanOperation. */
  @Generated
  public static final int SCPT_FAN_OPERATION = 260;
  /** Ordinal value for ScptMinFlowUnit. */
  @Generated
  public static final int SCPT_MIN_FLOW_UNIT = 261;
  /** Ordinal value for ScptMaxFlowUnit. */
  @Generated
  public static final int SCPT_MAX_FLOW_UNIT = 262;
  /** Ordinal value for ScptMinFlowHeatStby. */
  @Generated
  public static final int SCPT_MIN_FLOW_HEAT_STBY = 263;
  /** Ordinal value for ScptMinFlowUnitStby. */
  @Generated
  public static final int SCPT_MIN_FLOW_UNIT_STBY = 264;
  /** Ordinal value for ScptOffsetFlow. */
  @Generated
  public static final int SCPT_OFFSET_FLOW = 265;
  /** Ordinal value for ScptAreaDuctHeat. */
  @Generated
  public static final int SCPT_AREA_DUCT_HEAT = 266;
  /** Ordinal value for ScptNomAirFlowHeat. */
  @Generated
  public static final int SCPT_NOM_AIR_FLOW_HEAT = 267;
  /** Ordinal value for ScptGainVAVHeat. */
  @Generated
  public static final int SCPT_GAIN_VAVHEAT = 268;
  /** Ordinal value for ScptNumDampers. */
  @Generated
  public static final int SCPT_NUM_DAMPERS = 269;
  /** Ordinal value for ScptMinFlowUnitHeat. */
  @Generated
  public static final int SCPT_MIN_FLOW_UNIT_HEAT = 270;
  /** Ordinal value for ScptSaturationDelay. */
  @Generated
  public static final int SCPT_SATURATION_DELAY = 271;
  /** Ordinal value for ScptEffectivePeriod. */
  @Generated
  public static final int SCPT_EFFECTIVE_PERIOD = 272;
  /** Ordinal value for ScptScheduleDates. */
  @Generated
  public static final int SCPT_SCHEDULE_DATES = 273;
  /** Ordinal value for ScptSchedule. */
  @Generated
  public static final int SCPT_SCHEDULE = 274;
  /** Ordinal value for ScptScheduleTimeValue. */
  @Generated
  public static final int SCPT_SCHEDULE_TIME_VALUE = 275;
  /** Ordinal value for ScptValueDefinition. */
  @Generated
  public static final int SCPT_VALUE_DEFINITION = 276;
  /** Ordinal value for ScptValueName. */
  @Generated
  public static final int SCPT_VALUE_NAME = 277;
  /** Ordinal value for ScptWeeklySchedule. */
  @Generated
  public static final int SCPT_WEEKLY_SCHEDULE = 278;
  /** Ordinal value for ScptScheduleName. */
  @Generated
  public static final int SCPT_SCHEDULE_NAME = 279;
  /** Ordinal value for ScptValveStroke. */
  @Generated
  public static final int SCPT_VALVE_STROKE = 280;
  /** Ordinal value for ScptValveNominalSize. */
  @Generated
  public static final int SCPT_VALVE_NOMINAL_SIZE = 281;
  /** Ordinal value for ScptValveKvs. */
  @Generated
  public static final int SCPT_VALVE_KVS = 282;
  /** Ordinal value for ScptValveType. */
  @Generated
  public static final int SCPT_VALVE_TYPE = 283;
  /** Ordinal value for ScptActuatorCharacteristic. */
  @Generated
  public static final int SCPT_ACTUATOR_CHARACTERISTIC = 284;
  /** Ordinal value for ScptTrnsTblX2. */
  @Generated
  public static final int SCPT_TRNS_TBL_X2 = 285;
  /** Ordinal value for ScptTrnsTblY2. */
  @Generated
  public static final int SCPT_TRNS_TBL_Y2 = 286;
  /** Ordinal value for ScptCombFlowCharacteristic. */
  @Generated
  public static final int SCPT_COMB_FLOW_CHARACTERISTIC = 287;
  /** Ordinal value for ScptTrnsTblX3. */
  @Generated
  public static final int SCPT_TRNS_TBL_X3 = 288;
  /** Ordinal value for ScptTrnsTblY3. */
  @Generated
  public static final int SCPT_TRNS_TBL_Y3 = 289;
  /** Ordinal value for ScptRunTimeAlarm. */
  @Generated
  public static final int SCPT_RUN_TIME_ALARM = 290;
  /** Ordinal value for ScptTimePeriod. */
  @Generated
  public static final int SCPT_TIME_PERIOD = 291;
  /** Ordinal value for ScptPulseValue. */
  @Generated
  public static final int SCPT_PULSE_VALUE = 292;
  /** Ordinal value for ScptNumDigits. */
  @Generated
  public static final int SCPT_NUM_DIGITS = 293;
  /** Ordinal value for ScptIdentity. */
  @Generated
  public static final int SCPT_IDENTITY = 294;
  /** Ordinal value for ScptDefaultState. */
  @Generated
  public static final int SCPT_DEFAULT_STATE = 295;
  /** Ordinal value for ScptNvPriority. */
  @Generated
  public static final int SCPT_NV_PRIORITY = 296;
  /** Ordinal value for ScptDefaultSetting. */
  @Generated
  public static final int SCPT_DEFAULT_SETTING = 297;
  /** Ordinal value for ScptLowLimit1Enable. */
  @Generated
  public static final int SCPT_LOW_LIMIT_1ENABLE = 298;
  /** Ordinal value for ScptLowLimit2Enable. */
  @Generated
  public static final int SCPT_LOW_LIMIT_2ENABLE = 299;
  /** Ordinal value for ScptClockCalibration. */
  @Generated
  public static final int SCPT_CLOCK_CALIBRATION = 300;
  /** Ordinal value for ScptNeuronId. */
  @Generated
  public static final int SCPT_NEURON_ID = 301;
  /** Ordinal value for ScptHighLimit1Enable. */
  @Generated
  public static final int SCPT_HIGH_LIMIT_1ENABLE = 302;
  /** Ordinal value for ScptHighLimit2Enable. */
  @Generated
  public static final int SCPT_HIGH_LIMIT_2ENABLE = 303;
  /** Ordinal value for ScptAhamApplianceModel. */
  @Generated
  public static final int SCPT_AHAM_APPLIANCE_MODEL = 304;
  /** Ordinal value for ScptDefInput. */
  @Generated
  public static final int SCPT_DEF_INPUT = 305;
  /** Ordinal value for ScptName1. */
  @Generated
  public static final int SCPT_NAME_1 = 306;
  /** Ordinal value for ScptScene. */
  @Generated
  public static final int SCPT_SCENE = 307;
  /** Ordinal value for ScptSceneTiming. */
  @Generated
  public static final int SCPT_SCENE_TIMING = 308;
  /** Ordinal value for ScptName2. */
  @Generated
  public static final int SCPT_NAME_2 = 309;
  /** Ordinal value for ScptName3. */
  @Generated
  public static final int SCPT_NAME_3 = 310;
  /** Ordinal value for ScptButtonPressAction. */
  @Generated
  public static final int SCPT_BUTTON_PRESS_ACTION = 311;
  /** Ordinal value for ScptButtonColor. */
  @Generated
  public static final int SCPT_BUTTON_COLOR = 312;
  /** Ordinal value for ScptButtonRepeatInterval. */
  @Generated
  public static final int SCPT_BUTTON_REPEAT_INTERVAL = 313;
  /** Ordinal value for ScptButtonHoldAction. */
  @Generated
  public static final int SCPT_BUTTON_HOLD_ACTION = 314;
  /** Ordinal value for ScptPwrSendOnDelta. */
  @Generated
  public static final int SCPT_PWR_SEND_ON_DELTA = 315;
  /** Ordinal value for ScptSceneName. */
  @Generated
  public static final int SCPT_SCENE_NAME = 316;
  /** Ordinal value for ScptMaxPower. */
  @Generated
  public static final int SCPT_MAX_POWER = 317;
  /** Ordinal value for ScptIfaceDesc. */
  @Generated
  public static final int SCPT_IFACE_DESC = 318;
  /** Ordinal value for ScptMonInterval. */
  @Generated
  public static final int SCPT_MON_INTERVAL = 319;
  /** Ordinal value for ScptLinkPowerDetectEnable. */
  @Generated
  public static final int SCPT_LINK_POWER_DETECT_ENABLE = 320;
  /** Ordinal value for ScptScanTime. */
  @Generated
  public static final int SCPT_SCAN_TIME = 321;
  /** Ordinal value for ScptDevListDesc. */
  @Generated
  public static final int SCPT_DEV_LIST_DESC = 322;
  /** Ordinal value for ScptDevListEntry. */
  @Generated
  public static final int SCPT_DEV_LIST_ENTRY = 323;
  /** Ordinal value for ScptLogCapacity. */
  @Generated
  public static final int SCPT_LOG_CAPACITY = 324;
  /** Ordinal value for ScptLogNotificationThreshold. */
  @Generated
  public static final int SCPT_LOG_NOTIFICATION_THRESHOLD = 325;
  /** Ordinal value for ScptLogSize. */
  @Generated
  public static final int SCPT_LOG_SIZE = 326;
  /** Ordinal value for ScptLogType. */
  @Generated
  public static final int SCPT_LOG_TYPE = 327;
  /** Ordinal value for ScptFanInEnable. */
  @Generated
  public static final int SCPT_FAN_IN_ENABLE = 328;
  /** Ordinal value for ScptLogTimestampEnable. */
  @Generated
  public static final int SCPT_LOG_TIMESTAMP_ENABLE = 329;
  /** Ordinal value for ScptLogHighLimit. */
  @Generated
  public static final int SCPT_LOG_HIGH_LIMIT = 330;
  /** Ordinal value for ScptLogLowLimit. */
  @Generated
  public static final int SCPT_LOG_LOW_LIMIT = 331;
  /** Ordinal value for ScptMaxFanIn. */
  @Generated
  public static final int SCPT_MAX_FAN_IN = 332;
  /** Ordinal value for ScptLogMinDeltaTime. */
  @Generated
  public static final int SCPT_LOG_MIN_DELTA_TIME = 333;
  /** Ordinal value for ScptLogMinDeltaValue. */
  @Generated
  public static final int SCPT_LOG_MIN_DELTA_VALUE = 334;
  /** Ordinal value for ScptPollRate. */
  @Generated
  public static final int SCPT_POLL_RATE = 335;
  /** Ordinal value for ScptSourceAddress. */
  @Generated
  public static final int SCPT_SOURCE_ADDRESS = 336;
  /** Ordinal value for ScptLogRecord. */
  @Generated
  public static final int SCPT_LOG_RECORD = 337;
  /** Ordinal value for ScptLogFileHeader. */
  @Generated
  public static final int SCPT_LOG_FILE_HEADER = 338;
  /** Ordinal value for ScptLogAlarmThreshold. */
  @Generated
  public static final int SCPT_LOG_ALARM_THRESHOLD = 339;
  /** Ordinal value for ScptLogRequest. */
  @Generated
  public static final int SCPT_LOG_REQUEST = 340;
  /** Ordinal value for ScptLogResponse. */
  @Generated
  public static final int SCPT_LOG_RESPONSE = 341;
  /** Ordinal value for ScptLightingGroupEnable. */
  @Generated
  public static final int SCPT_LIGHTING_GROUP_ENABLE = 342;
  /** Ordinal value for ScptSceneColor. */
  @Generated
  public static final int SCPT_SCENE_COLOR = 343;
  /** Ordinal value for ScptBkupSchedule. */
  @Generated
  public static final int SCPT_BKUP_SCHEDULE = 344;
  /** Ordinal value for ScptOLCLimits. */
  @Generated
  public static final int SCPT_OLCLIMITS = 345;
  /** Ordinal value for ScptLampPower. */
  @Generated
  public static final int SCPT_LAMP_POWER = 346;
  /** Ordinal value for ScptDeviceOutSelection. */
  @Generated
  public static final int SCPT_DEVICE_OUT_SELECTION = 347;
  /** Ordinal value for ScptEnableStatusMsg. */
  @Generated
  public static final int SCPT_ENABLE_STATUS_MSG = 348;
  /** Ordinal value for ScptMaxLevelVolt. */
  @Generated
  public static final int SCPT_MAX_LEVEL_VOLT = 349;
  /** Ordinal value for ScptGeoLocation. */
  @Generated
  public static final int SCPT_GEO_LOCATION = 350;
  /** Ordinal value for ScptProgName. */
  @Generated
  public static final int SCPT_PROG_NAME = 351;
  /** Ordinal value for ScptProgRevision. */
  @Generated
  public static final int SCPT_PROG_REVISION = 352;
  /** Ordinal value for ScptProgSelect. */
  @Generated
  public static final int SCPT_PROG_SELECT = 353;
  /** Ordinal value for ScptProgSourceLocation. */
  @Generated
  public static final int SCPT_PROG_SOURCE_LOCATION = 354;
  /** Ordinal value for ScptProgFileIndexes. */
  @Generated
  public static final int SCPT_PROG_FILE_INDEXES = 355;
  /** Ordinal value for ScptProgCmdHistory. */
  @Generated
  public static final int SCPT_PROG_CMD_HISTORY = 356;
  /** Ordinal value for ScptProgStateHistory. */
  @Generated
  public static final int SCPT_PROG_STATE_HISTORY = 357;
  /** Ordinal value for ScptNsdsFbIndex. */
  @Generated
  public static final int SCPT_NSDS_FB_INDEX = 358;
  /** Ordinal value for ScptCurrentSenseEnable. */
  @Generated
  public static final int SCPT_CURRENT_SENSE_ENABLE = 359;
  /** Ordinal value for ScptMeasurementInterval. */
  @Generated
  public static final int SCPT_MEASUREMENT_INTERVAL = 360;
  /** Ordinal value for ScptLightingGroupMembership. */
  @Generated
  public static final int SCPT_LIGHTING_GROUP_MEMBERSHIP = 361;
  /** Ordinal value for ScptLoadControlOffset. */
  @Generated
  public static final int SCPT_LOAD_CONTROL_OFFSET = 362;
  /** Ordinal value for ScptProgErrorHistory. */
  @Generated
  public static final int SCPT_PROG_ERROR_HISTORY = 363;
  /** Ordinal value for ScptNvUsage. */
  @Generated
  public static final int SCPT_NV_USAGE = 364;
  /** Ordinal value for ScptScheduleSunday. */
  @Generated
  public static final int SCPT_SCHEDULE_SUNDAY = 365;
  /** Ordinal value for ScptScheduleMonday. */
  @Generated
  public static final int SCPT_SCHEDULE_MONDAY = 366;
  /** Ordinal value for ScptScheduleTuesday. */
  @Generated
  public static final int SCPT_SCHEDULE_TUESDAY = 367;
  /** Ordinal value for ScptScheduleWednesday. */
  @Generated
  public static final int SCPT_SCHEDULE_WEDNESDAY = 368;
  /** Ordinal value for ScptScheduleThursday. */
  @Generated
  public static final int SCPT_SCHEDULE_THURSDAY = 369;
  /** Ordinal value for ScptScheduleFriday. */
  @Generated
  public static final int SCPT_SCHEDULE_FRIDAY = 370;
  /** Ordinal value for ScptScheduleSaturday. */
  @Generated
  public static final int SCPT_SCHEDULE_SATURDAY = 371;
  /** Ordinal value for ScptOccupancyBehavior. */
  @Generated
  public static final int SCPT_OCCUPANCY_BEHAVIOR = 372;
  /** Ordinal value for ScptTimeSource. */
  @Generated
  public static final int SCPT_TIME_SOURCE = 373;
  /** Ordinal value for ScptScheduleException. */
  @Generated
  public static final int SCPT_SCHEDULE_EXCEPTION = 374;
  /** Ordinal value for ScptScheduleHoliday. */
  @Generated
  public static final int SCPT_SCHEDULE_HOLIDAY = 375;
  /** Ordinal value for ScptRandomizationInterval. */
  @Generated
  public static final int SCPT_RANDOMIZATION_INTERVAL = 376;
  /** Ordinal value for ScptSunriseTime. */
  @Generated
  public static final int SCPT_SUNRISE_TIME = 377;
  /** Ordinal value for ScptSunsetTime. */
  @Generated
  public static final int SCPT_SUNSET_TIME = 378;
  /** Ordinal value for ScptSchedulerOptions. */
  @Generated
  public static final int SCPT_SCHEDULER_OPTIONS = 379;
  /** Ordinal value for ScptOccupancyThresholds. */
  @Generated
  public static final int SCPT_OCCUPANCY_THRESHOLDS = 380;

  /** BLonScptType constant for ScptXxx. */
  @Generated
  public static final BLonScptType ScptXxx = new BLonScptType(SCPT_XXX);
  /** BLonScptType constant for ScptActFbDly. */
  @Generated
  public static final BLonScptType ScptActFbDly = new BLonScptType(SCPT_ACT_FB_DLY);
  /** BLonScptType constant for ScptAlrmClrT1. */
  @Generated
  public static final BLonScptType ScptAlrmClrT1 = new BLonScptType(SCPT_ALRM_CLR_T1);
  /** BLonScptType constant for ScptAlrmClrT2. */
  @Generated
  public static final BLonScptType ScptAlrmClrT2 = new BLonScptType(SCPT_ALRM_CLR_T2);
  /** BLonScptType constant for ScptAlrmIhbT. */
  @Generated
  public static final BLonScptType ScptAlrmIhbT = new BLonScptType(SCPT_ALRM_IHB_T);
  /** BLonScptType constant for ScptAlrmSetT1. */
  @Generated
  public static final BLonScptType ScptAlrmSetT1 = new BLonScptType(SCPT_ALRM_SET_T1);
  /** BLonScptType constant for ScptAlrmSetT2. */
  @Generated
  public static final BLonScptType ScptAlrmSetT2 = new BLonScptType(SCPT_ALRM_SET_T2);
  /** BLonScptType constant for ScptDefOutput. */
  @Generated
  public static final BLonScptType ScptDefOutput = new BLonScptType(SCPT_DEF_OUTPUT);
  /** BLonScptType constant for ScptDriveT. */
  @Generated
  public static final BLonScptType ScptDriveT = new BLonScptType(SCPT_DRIVE_T);
  /** BLonScptType constant for ScptHighLimit1. */
  @Generated
  public static final BLonScptType ScptHighLimit1 = new BLonScptType(SCPT_HIGH_LIMIT_1);
  /** BLonScptType constant for ScptHighLimit2. */
  @Generated
  public static final BLonScptType ScptHighLimit2 = new BLonScptType(SCPT_HIGH_LIMIT_2);
  /** BLonScptType constant for ScptHystHigh1. */
  @Generated
  public static final BLonScptType ScptHystHigh1 = new BLonScptType(SCPT_HYST_HIGH_1);
  /** BLonScptType constant for ScptHystHigh2. */
  @Generated
  public static final BLonScptType ScptHystHigh2 = new BLonScptType(SCPT_HYST_HIGH_2);
  /** BLonScptType constant for ScptHystLow1. */
  @Generated
  public static final BLonScptType ScptHystLow1 = new BLonScptType(SCPT_HYST_LOW_1);
  /** BLonScptType constant for ScptHystLow2. */
  @Generated
  public static final BLonScptType ScptHystLow2 = new BLonScptType(SCPT_HYST_LOW_2);
  /** BLonScptType constant for ScptInFbDly. */
  @Generated
  public static final BLonScptType ScptInFbDly = new BLonScptType(SCPT_IN_FB_DLY);
  /** BLonScptType constant for ScptInvrtOut. */
  @Generated
  public static final BLonScptType ScptInvrtOut = new BLonScptType(SCPT_INVRT_OUT);
  /** BLonScptType constant for ScptLocation. */
  @Generated
  public static final BLonScptType ScptLocation = new BLonScptType(SCPT_LOCATION);
  /** BLonScptType constant for ScptLowLimit1. */
  @Generated
  public static final BLonScptType ScptLowLimit1 = new BLonScptType(SCPT_LOW_LIMIT_1);
  /** BLonScptType constant for ScptLowLimit2. */
  @Generated
  public static final BLonScptType ScptLowLimit2 = new BLonScptType(SCPT_LOW_LIMIT_2);
  /** BLonScptType constant for ScptMaxRnge. */
  @Generated
  public static final BLonScptType ScptMaxRnge = new BLonScptType(SCPT_MAX_RNGE);
  /** BLonScptType constant for ScptMaxRcvT. */
  @Generated
  public static final BLonScptType ScptMaxRcvT = new BLonScptType(SCPT_MAX_RCV_T);
  /** BLonScptType constant for ScptMaxSndT. */
  @Generated
  public static final BLonScptType ScptMaxSndT = new BLonScptType(SCPT_MAX_SND_T);
  /** BLonScptType constant for ScptMinRnge. */
  @Generated
  public static final BLonScptType ScptMinRnge = new BLonScptType(SCPT_MIN_RNGE);
  /** BLonScptType constant for ScptMinSndT. */
  @Generated
  public static final BLonScptType ScptMinSndT = new BLonScptType(SCPT_MIN_SND_T);
  /** BLonScptType constant for ScptNwrkCnfg. */
  @Generated
  public static final BLonScptType ScptNwrkCnfg = new BLonScptType(SCPT_NWRK_CNFG);
  /** BLonScptType constant for ScptOffset. */
  @Generated
  public static final BLonScptType ScptOffset = new BLonScptType(SCPT_OFFSET);
  /** BLonScptType constant for ScptSndDelta. */
  @Generated
  public static final BLonScptType ScptSndDelta = new BLonScptType(SCPT_SND_DELTA);
  /** BLonScptType constant for ScptTrnsTblX. */
  @Generated
  public static final BLonScptType ScptTrnsTblX = new BLonScptType(SCPT_TRNS_TBL_X);
  /** BLonScptType constant for ScptTrnsTblY. */
  @Generated
  public static final BLonScptType ScptTrnsTblY = new BLonScptType(SCPT_TRNS_TBL_Y);
  /** BLonScptType constant for ScptOffDely. */
  @Generated
  public static final BLonScptType ScptOffDely = new BLonScptType(SCPT_OFF_DELY);
  /** BLonScptType constant for ScptGain. */
  @Generated
  public static final BLonScptType ScptGain = new BLonScptType(SCPT_GAIN);
  /** BLonScptType constant for ScptOvrBehave. */
  @Generated
  public static final BLonScptType ScptOvrBehave = new BLonScptType(SCPT_OVR_BEHAVE);
  /** BLonScptType constant for ScptOvrValue. */
  @Generated
  public static final BLonScptType ScptOvrValue = new BLonScptType(SCPT_OVR_VALUE);
  /** BLonScptType constant for ScptBypassTime. */
  @Generated
  public static final BLonScptType ScptBypassTime = new BLonScptType(SCPT_BYPASS_TIME);
  /** BLonScptType constant for ScptManOvrTime. */
  @Generated
  public static final BLonScptType ScptManOvrTime = new BLonScptType(SCPT_MAN_OVR_TIME);
  /** BLonScptType constant for ScptHumSetpt. */
  @Generated
  public static final BLonScptType ScptHumSetpt = new BLonScptType(SCPT_HUM_SETPT);
  /** BLonScptType constant for ScptMaxFlowHeat. */
  @Generated
  public static final BLonScptType ScptMaxFlowHeat = new BLonScptType(SCPT_MAX_FLOW_HEAT);
  /** BLonScptType constant for ScptFireInitType. */
  @Generated
  public static final BLonScptType ScptFireInitType = new BLonScptType(SCPT_FIRE_INIT_TYPE);
  /** BLonScptType constant for ScptSmokeNomSens. */
  @Generated
  public static final BLonScptType ScptSmokeNomSens = new BLonScptType(SCPT_SMOKE_NOM_SENS);
  /** BLonScptType constant for ScptSmokeDayAlrmLim. */
  @Generated
  public static final BLonScptType ScptSmokeDayAlrmLim = new BLonScptType(SCPT_SMOKE_DAY_ALRM_LIM);
  /** BLonScptType constant for ScptActuatorType. */
  @Generated
  public static final BLonScptType ScptActuatorType = new BLonScptType(SCPT_ACTUATOR_TYPE);
  /** BLonScptType constant for ScptLimitCO2. */
  @Generated
  public static final BLonScptType ScptLimitCO2 = new BLonScptType(SCPT_LIMIT_CO2);
  /** BLonScptType constant for ScptMinDeltaAngl. */
  @Generated
  public static final BLonScptType ScptMinDeltaAngl = new BLonScptType(SCPT_MIN_DELTA_ANGL);
  /** BLonScptType constant for ScptDirection. */
  @Generated
  public static final BLonScptType ScptDirection = new BLonScptType(SCPT_DIRECTION);
  /** BLonScptType constant for ScptDriveTime. */
  @Generated
  public static final BLonScptType ScptDriveTime = new BLonScptType(SCPT_DRIVE_TIME);
  /** BLonScptType constant for ScptDuctArea. */
  @Generated
  public static final BLonScptType ScptDuctArea = new BLonScptType(SCPT_DUCT_AREA);
  /** BLonScptType constant for ScptMinDeltaFlow. */
  @Generated
  public static final BLonScptType ScptMinDeltaFlow = new BLonScptType(SCPT_MIN_DELTA_FLOW);
  /** BLonScptType constant for ScptMaxRcvTime. */
  @Generated
  public static final BLonScptType ScptMaxRcvTime = new BLonScptType(SCPT_MAX_RCV_TIME);
  /** BLonScptType constant for ScptMaxSendTime. */
  @Generated
  public static final BLonScptType ScptMaxSendTime = new BLonScptType(SCPT_MAX_SEND_TIME);
  /** BLonScptType constant for ScptMaxSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxSetpoint = new BLonScptType(SCPT_MAX_SETPOINT);
  /** BLonScptType constant for ScptMaxFlow. */
  @Generated
  public static final BLonScptType ScptMaxFlow = new BLonScptType(SCPT_MAX_FLOW);
  /** BLonScptType constant for ScptMinSendTime. */
  @Generated
  public static final BLonScptType ScptMinSendTime = new BLonScptType(SCPT_MIN_SEND_TIME);
  /** BLonScptType constant for ScptMinSetpoint. */
  @Generated
  public static final BLonScptType ScptMinSetpoint = new BLonScptType(SCPT_MIN_SETPOINT);
  /** BLonScptType constant for ScptMinFlow. */
  @Generated
  public static final BLonScptType ScptMinFlow = new BLonScptType(SCPT_MIN_FLOW);
  /** BLonScptType constant for ScptMinFlowHeat. */
  @Generated
  public static final BLonScptType ScptMinFlowHeat = new BLonScptType(SCPT_MIN_FLOW_HEAT);
  /** BLonScptType constant for ScptMinFlowStby. */
  @Generated
  public static final BLonScptType ScptMinFlowStby = new BLonScptType(SCPT_MIN_FLOW_STBY);
  /** BLonScptType constant for ScptNomAirFlow. */
  @Generated
  public static final BLonScptType ScptNomAirFlow = new BLonScptType(SCPT_NOM_AIR_FLOW);
  /** BLonScptType constant for ScptNomAngle. */
  @Generated
  public static final BLonScptType ScptNomAngle = new BLonScptType(SCPT_NOM_ANGLE);
  /** BLonScptType constant for ScptNumValves. */
  @Generated
  public static final BLonScptType ScptNumValves = new BLonScptType(SCPT_NUM_VALVES);
  /** BLonScptType constant for ScptSetPnts. */
  @Generated
  public static final BLonScptType ScptSetPnts = new BLonScptType(SCPT_SET_PNTS);
  /** BLonScptType constant for ScptOemType. */
  @Generated
  public static final BLonScptType ScptOemType = new BLonScptType(SCPT_OEM_TYPE);
  /** BLonScptType constant for ScptMinDeltaRH. */
  @Generated
  public static final BLonScptType ScptMinDeltaRH = new BLonScptType(SCPT_MIN_DELTA_RH);
  /** BLonScptType constant for ScptMinDeltaCO2. */
  @Generated
  public static final BLonScptType ScptMinDeltaCO2 = new BLonScptType(SCPT_MIN_DELTA_CO2);
  /** BLonScptType constant for ScptMinDeltaTemp. */
  @Generated
  public static final BLonScptType ScptMinDeltaTemp = new BLonScptType(SCPT_MIN_DELTA_TEMP);
  /** BLonScptType constant for ScptSensConstTmp. */
  @Generated
  public static final BLonScptType ScptSensConstTmp = new BLonScptType(SCPT_SENS_CONST_TMP);
  /** BLonScptType constant for ScptGainVAV. */
  @Generated
  public static final BLonScptType ScptGainVAV = new BLonScptType(SCPT_GAIN_VAV);
  /** BLonScptType constant for ScptSensConstVAV. */
  @Generated
  public static final BLonScptType ScptSensConstVAV = new BLonScptType(SCPT_SENS_CONST_VAV);
  /** BLonScptType constant for ScptOffsetCO2. */
  @Generated
  public static final BLonScptType ScptOffsetCO2 = new BLonScptType(SCPT_OFFSET_CO2);
  /** BLonScptType constant for ScptOffsetRH. */
  @Generated
  public static final BLonScptType ScptOffsetRH = new BLonScptType(SCPT_OFFSET_RH);
  /** BLonScptType constant for ScptOffsetTemp. */
  @Generated
  public static final BLonScptType ScptOffsetTemp = new BLonScptType(SCPT_OFFSET_TEMP);
  /** BLonScptType constant for ScptDefltBehave. */
  @Generated
  public static final BLonScptType ScptDefltBehave = new BLonScptType(SCPT_DEFLT_BEHAVE);
  /** BLonScptType constant for ScptPwrUpDelay. */
  @Generated
  public static final BLonScptType ScptPwrUpDelay = new BLonScptType(SCPT_PWR_UP_DELAY);
  /** BLonScptType constant for ScptPwrUpState. */
  @Generated
  public static final BLonScptType ScptPwrUpState = new BLonScptType(SCPT_PWR_UP_STATE);
  /** BLonScptType constant for ScptHvacMode. */
  @Generated
  public static final BLonScptType ScptHvacMode = new BLonScptType(SCPT_HVAC_MODE);
  /** BLonScptType constant for ScptCoolSetpt. */
  @Generated
  public static final BLonScptType ScptCoolSetpt = new BLonScptType(SCPT_COOL_SETPT);
  /** BLonScptType constant for ScptCoolLowerSP. */
  @Generated
  public static final BLonScptType ScptCoolLowerSP = new BLonScptType(SCPT_COOL_LOWER_SP);
  /** BLonScptType constant for ScptCoolUpperSP. */
  @Generated
  public static final BLonScptType ScptCoolUpperSP = new BLonScptType(SCPT_COOL_UPPER_SP);
  /** BLonScptType constant for ScptHeatSetpt. */
  @Generated
  public static final BLonScptType ScptHeatSetpt = new BLonScptType(SCPT_HEAT_SETPT);
  /** BLonScptType constant for ScptHeatLowerSP. */
  @Generated
  public static final BLonScptType ScptHeatLowerSP = new BLonScptType(SCPT_HEAT_LOWER_SP);
  /** BLonScptType constant for ScptHeatUpperSP. */
  @Generated
  public static final BLonScptType ScptHeatUpperSP = new BLonScptType(SCPT_HEAT_UPPER_SP);
  /** BLonScptType constant for ScptLimitChlrCap. */
  @Generated
  public static final BLonScptType ScptLimitChlrCap = new BLonScptType(SCPT_LIMIT_CHLR_CAP);
  /** BLonScptType constant for ScptLuxSetpoint. */
  @Generated
  public static final BLonScptType ScptLuxSetpoint = new BLonScptType(SCPT_LUX_SETPOINT);
  /** BLonScptType constant for ScptStep. */
  @Generated
  public static final BLonScptType ScptStep = new BLonScptType(SCPT_STEP);
  /** BLonScptType constant for ScptOnOffHysteresis. */
  @Generated
  public static final BLonScptType ScptOnOffHysteresis = new BLonScptType(SCPT_ON_OFF_HYSTERESIS);
  /** BLonScptType constant for ScptClOffDelay. */
  @Generated
  public static final BLonScptType ScptClOffDelay = new BLonScptType(SCPT_CL_OFF_DELAY);
  /** BLonScptType constant for ScptClOnDelay. */
  @Generated
  public static final BLonScptType ScptClOnDelay = new BLonScptType(SCPT_CL_ON_DELAY);
  /** BLonScptType constant for ScptPowerupState. */
  @Generated
  public static final BLonScptType ScptPowerupState = new BLonScptType(SCPT_POWERUP_STATE);
  /** BLonScptType constant for ScptMinDeltaLevel. */
  @Generated
  public static final BLonScptType ScptMinDeltaLevel = new BLonScptType(SCPT_MIN_DELTA_LEVEL);
  /** BLonScptType constant for ScptReflection. */
  @Generated
  public static final BLonScptType ScptReflection = new BLonScptType(SCPT_REFLECTION);
  /** BLonScptType constant for ScptFieldCalib. */
  @Generated
  public static final BLonScptType ScptFieldCalib = new BLonScptType(SCPT_FIELD_CALIB);
  /** BLonScptType constant for ScptHoldTime. */
  @Generated
  public static final BLonScptType ScptHoldTime = new BLonScptType(SCPT_HOLD_TIME);
  /** BLonScptType constant for ScptStepValue. */
  @Generated
  public static final BLonScptType ScptStepValue = new BLonScptType(SCPT_STEP_VALUE);
  /** BLonScptType constant for ScptMaxOut. */
  @Generated
  public static final BLonScptType ScptMaxOut = new BLonScptType(SCPT_MAX_OUT);
  /** BLonScptType constant for ScptSceneNmbr. */
  @Generated
  public static final BLonScptType ScptSceneNmbr = new BLonScptType(SCPT_SCENE_NMBR);
  /** BLonScptType constant for ScptFadeTime. */
  @Generated
  public static final BLonScptType ScptFadeTime = new BLonScptType(SCPT_FADE_TIME);
  /** BLonScptType constant for ScptDelayTime. */
  @Generated
  public static final BLonScptType ScptDelayTime = new BLonScptType(SCPT_DELAY_TIME);
  /** BLonScptType constant for ScptMasterSlave. */
  @Generated
  public static final BLonScptType ScptMasterSlave = new BLonScptType(SCPT_MASTER_SLAVE);
  /** BLonScptType constant for ScptUpdateRate. */
  @Generated
  public static final BLonScptType ScptUpdateRate = new BLonScptType(SCPT_UPDATE_RATE);
  /** BLonScptType constant for ScptSummerTime. */
  @Generated
  public static final BLonScptType ScptSummerTime = new BLonScptType(SCPT_SUMMER_TIME);
  /** BLonScptType constant for ScptWinterTime. */
  @Generated
  public static final BLonScptType ScptWinterTime = new BLonScptType(SCPT_WINTER_TIME);
  /** BLonScptType constant for ScptManualAllowed. */
  @Generated
  public static final BLonScptType ScptManualAllowed = new BLonScptType(SCPT_MANUAL_ALLOWED);
  /** BLonScptType constant for ScptDefWeekMask. */
  @Generated
  public static final BLonScptType ScptDefWeekMask = new BLonScptType(SCPT_DEF_WEEK_MASK);
  /** BLonScptType constant for ScptDayDateIndex. */
  @Generated
  public static final BLonScptType ScptDayDateIndex = new BLonScptType(SCPT_DAY_DATE_INDEX);
  /** BLonScptType constant for ScptTimeEvent. */
  @Generated
  public static final BLonScptType ScptTimeEvent = new BLonScptType(SCPT_TIME_EVENT);
  /** BLonScptType constant for ScptModeHrtBt. */
  @Generated
  public static final BLonScptType ScptModeHrtBt = new BLonScptType(SCPT_MODE_HRT_BT);
  /** BLonScptType constant for ScptDefrostMode. */
  @Generated
  public static final BLonScptType ScptDefrostMode = new BLonScptType(SCPT_DEFROST_MODE);
  /** BLonScptType constant for ScptMaxDefrstTime. */
  @Generated
  public static final BLonScptType ScptMaxDefrstTime = new BLonScptType(SCPT_MAX_DEFRST_TIME);
  /** BLonScptType constant for ScptDrainDelay. */
  @Generated
  public static final BLonScptType ScptDrainDelay = new BLonScptType(SCPT_DRAIN_DELAY);
  /** BLonScptType constant for ScptInjDelay. */
  @Generated
  public static final BLonScptType ScptInjDelay = new BLonScptType(SCPT_INJ_DELAY);
  /** BLonScptType constant for ScptMaxDefrstTemp. */
  @Generated
  public static final BLonScptType ScptMaxDefrstTemp = new BLonScptType(SCPT_MAX_DEFRST_TEMP);
  /** BLonScptType constant for ScptStrtupDelay. */
  @Generated
  public static final BLonScptType ScptStrtupDelay = new BLonScptType(SCPT_STRTUP_DELAY);
  /** BLonScptType constant for ScptTermTimeTemp. */
  @Generated
  public static final BLonScptType ScptTermTimeTemp = new BLonScptType(SCPT_TERM_TIME_TEMP);
  /** BLonScptType constant for ScptPumpDownDelay. */
  @Generated
  public static final BLonScptType ScptPumpDownDelay = new BLonScptType(SCPT_PUMP_DOWN_DELAY);
  /** BLonScptType constant for ScptSuperHtRefInit. */
  @Generated
  public static final BLonScptType ScptSuperHtRefInit = new BLonScptType(SCPT_SUPER_HT_REF_INIT);
  /** BLonScptType constant for ScptStrtupOpen. */
  @Generated
  public static final BLonScptType ScptStrtupOpen = new BLonScptType(SCPT_STRTUP_OPEN);
  /** BLonScptType constant for ScptSuperHtRefMin. */
  @Generated
  public static final BLonScptType ScptSuperHtRefMin = new BLonScptType(SCPT_SUPER_HT_REF_MIN);
  /** BLonScptType constant for ScptRefrigGlide. */
  @Generated
  public static final BLonScptType ScptRefrigGlide = new BLonScptType(SCPT_REFRIG_GLIDE);
  /** BLonScptType constant for ScptSuperHtRefMax. */
  @Generated
  public static final BLonScptType ScptSuperHtRefMax = new BLonScptType(SCPT_SUPER_HT_REF_MAX);
  /** BLonScptType constant for ScptRefrigType. */
  @Generated
  public static final BLonScptType ScptRefrigType = new BLonScptType(SCPT_REFRIG_TYPE);
  /** BLonScptType constant for ScptThermMode. */
  @Generated
  public static final BLonScptType ScptThermMode = new BLonScptType(SCPT_THERM_MODE);
  /** BLonScptType constant for ScptDayNightCntrl. */
  @Generated
  public static final BLonScptType ScptDayNightCntrl = new BLonScptType(SCPT_DAY_NIGHT_CNTRL);
  /** BLonScptType constant for ScptDiffNight. */
  @Generated
  public static final BLonScptType ScptDiffNight = new BLonScptType(SCPT_DIFF_NIGHT);
  /** BLonScptType constant for ScptHighLimTemp. */
  @Generated
  public static final BLonScptType ScptHighLimTemp = new BLonScptType(SCPT_HIGH_LIM_TEMP);
  /** BLonScptType constant for ScptHighLimDly. */
  @Generated
  public static final BLonScptType ScptHighLimDly = new BLonScptType(SCPT_HIGH_LIM_DLY);
  /** BLonScptType constant for ScptCutOutValue. */
  @Generated
  public static final BLonScptType ScptCutOutValue = new BLonScptType(SCPT_CUT_OUT_VALUE);
  /** BLonScptType constant for ScptAirTemp1Day. */
  @Generated
  public static final BLonScptType ScptAirTemp1Day = new BLonScptType(SCPT_AIR_TEMP_1DAY);
  /** BLonScptType constant for ScptSmokeNightAlrmLim. */
  @Generated
  public static final BLonScptType ScptSmokeNightAlrmLim = new BLonScptType(SCPT_SMOKE_NIGHT_ALRM_LIM);
  /** BLonScptType constant for ScptLowLimTemp. */
  @Generated
  public static final BLonScptType ScptLowLimTemp = new BLonScptType(SCPT_LOW_LIM_TEMP);
  /** BLonScptType constant for ScptLowLimDly. */
  @Generated
  public static final BLonScptType ScptLowLimDly = new BLonScptType(SCPT_LOW_LIM_DLY);
  /** BLonScptType constant for ScptDiffValue. */
  @Generated
  public static final BLonScptType ScptDiffValue = new BLonScptType(SCPT_DIFF_VALUE);
  /** BLonScptType constant for ScptAirTemp1Night. */
  @Generated
  public static final BLonScptType ScptAirTemp1Night = new BLonScptType(SCPT_AIR_TEMP_1NIGHT);
  /** BLonScptType constant for ScptAirTemp1Alrm. */
  @Generated
  public static final BLonScptType ScptAirTemp1Alrm = new BLonScptType(SCPT_AIR_TEMP_1ALRM);
  /** BLonScptType constant for ScptHighLimDefrDly. */
  @Generated
  public static final BLonScptType ScptHighLimDefrDly = new BLonScptType(SCPT_HIGH_LIM_DEFR_DLY);
  /** BLonScptType constant for ScptDeltaNight. */
  @Generated
  public static final BLonScptType ScptDeltaNight = new BLonScptType(SCPT_DELTA_NIGHT);
  /** BLonScptType constant for ScptRunHrInit. */
  @Generated
  public static final BLonScptType ScptRunHrInit = new BLonScptType(SCPT_RUN_HR_INIT);
  /** BLonScptType constant for ScptRunHrAlarm. */
  @Generated
  public static final BLonScptType ScptRunHrAlarm = new BLonScptType(SCPT_RUN_HR_ALARM);
  /** BLonScptType constant for ScptEnergyCntInit. */
  @Generated
  public static final BLonScptType ScptEnergyCntInit = new BLonScptType(SCPT_ENERGY_CNT_INIT);
  /** BLonScptType constant for ScptSmokeDayPreAlrmLim. */
  @Generated
  public static final BLonScptType ScptSmokeDayPreAlrmLim = new BLonScptType(SCPT_SMOKE_DAY_PRE_ALRM_LIM);
  /** BLonScptType constant for ScptDebounce. */
  @Generated
  public static final BLonScptType ScptDebounce = new BLonScptType(SCPT_DEBOUNCE);
  /** BLonScptType constant for ScptSmokeNightPreAlrmLim. */
  @Generated
  public static final BLonScptType ScptSmokeNightPreAlrmLim = new BLonScptType(SCPT_SMOKE_NIGHT_PRE_ALRM_LIM);
  /** BLonScptType constant for ScptZoneNum. */
  @Generated
  public static final BLonScptType ScptZoneNum = new BLonScptType(SCPT_ZONE_NUM);
  /** BLonScptType constant for ScptThermAlrmROR. */
  @Generated
  public static final BLonScptType ScptThermAlrmROR = new BLonScptType(SCPT_THERM_ALRM_ROR);
  /** BLonScptType constant for ScptVisOutput. */
  @Generated
  public static final BLonScptType ScptVisOutput = new BLonScptType(SCPT_VIS_OUTPUT);
  /** BLonScptType constant for ScptAudOutput. */
  @Generated
  public static final BLonScptType ScptAudOutput = new BLonScptType(SCPT_AUD_OUTPUT);
  /** BLonScptType constant for ScptFlashFreq. */
  @Generated
  public static final BLonScptType ScptFlashFreq = new BLonScptType(SCPT_FLASH_FREQ);
  /** BLonScptType constant for ScptInstallDate. */
  @Generated
  public static final BLonScptType ScptInstallDate = new BLonScptType(SCPT_INSTALL_DATE);
  /** BLonScptType constant for ScptMaintDate. */
  @Generated
  public static final BLonScptType ScptMaintDate = new BLonScptType(SCPT_MAINT_DATE);
  /** BLonScptType constant for ScptManfDate. */
  @Generated
  public static final BLonScptType ScptManfDate = new BLonScptType(SCPT_MANF_DATE);
  /** BLonScptType constant for ScptFireTxt1. */
  @Generated
  public static final BLonScptType ScptFireTxt1 = new BLonScptType(SCPT_FIRE_TXT_1);
  /** BLonScptType constant for ScptFireTxt2. */
  @Generated
  public static final BLonScptType ScptFireTxt2 = new BLonScptType(SCPT_FIRE_TXT_2);
  /** BLonScptType constant for ScptFireTxt3. */
  @Generated
  public static final BLonScptType ScptFireTxt3 = new BLonScptType(SCPT_FIRE_TXT_3);
  /** BLonScptType constant for ScptThermThreshold. */
  @Generated
  public static final BLonScptType ScptThermThreshold = new BLonScptType(SCPT_THERM_THRESHOLD);
  /** BLonScptType constant for ScptFireIndicate. */
  @Generated
  public static final BLonScptType ScptFireIndicate = new BLonScptType(SCPT_FIRE_INDICATE);
  /** BLonScptType constant for ScptTimeZone. */
  @Generated
  public static final BLonScptType ScptTimeZone = new BLonScptType(SCPT_TIME_ZONE);
  /** BLonScptType constant for ScptPrimeVal. */
  @Generated
  public static final BLonScptType ScptPrimeVal = new BLonScptType(SCPT_PRIME_VAL);
  /** BLonScptType constant for ScptSecondVal. */
  @Generated
  public static final BLonScptType ScptSecondVal = new BLonScptType(SCPT_SECOND_VAL);
  /** BLonScptType constant for ScptSceneOffset. */
  @Generated
  public static final BLonScptType ScptSceneOffset = new BLonScptType(SCPT_SCENE_OFFSET);
  /** BLonScptType constant for ScptNomRPM. */
  @Generated
  public static final BLonScptType ScptNomRPM = new BLonScptType(SCPT_NOM_RPM);
  /** BLonScptType constant for ScptNomFreq. */
  @Generated
  public static final BLonScptType ScptNomFreq = new BLonScptType(SCPT_NOM_FREQ);
  /** BLonScptType constant for ScptRampUpTm. */
  @Generated
  public static final BLonScptType ScptRampUpTm = new BLonScptType(SCPT_RAMP_UP_TM);
  /** BLonScptType constant for ScptRampDownTm. */
  @Generated
  public static final BLonScptType ScptRampDownTm = new BLonScptType(SCPT_RAMP_DOWN_TM);
  /** BLonScptType constant for ScptDefScale. */
  @Generated
  public static final BLonScptType ScptDefScale = new BLonScptType(SCPT_DEF_SCALE);
  /** BLonScptType constant for ScptRegName. */
  @Generated
  public static final BLonScptType ScptRegName = new BLonScptType(SCPT_REG_NAME);
  /** BLonScptType constant for ScptBaseValue. */
  @Generated
  public static final BLonScptType ScptBaseValue = new BLonScptType(SCPT_BASE_VALUE);
  /** BLonScptType constant for ScptDevMajVer. */
  @Generated
  public static final BLonScptType ScptDevMajVer = new BLonScptType(SCPT_DEV_MAJ_VER);
  /** BLonScptType constant for ScptDevMinVer. */
  @Generated
  public static final BLonScptType ScptDevMinVer = new BLonScptType(SCPT_DEV_MIN_VER);
  /** BLonScptType constant for ScptObjMajVer. */
  @Generated
  public static final BLonScptType ScptObjMajVer = new BLonScptType(SCPT_OBJ_MAJ_VER);
  /** BLonScptType constant for ScptObjMinVer. */
  @Generated
  public static final BLonScptType ScptObjMinVer = new BLonScptType(SCPT_OBJ_MIN_VER);
  /** BLonScptType constant for ScptHvacType. */
  @Generated
  public static final BLonScptType ScptHvacType = new BLonScptType(SCPT_HVAC_TYPE);
  /** BLonScptType constant for ScptTimeout. */
  @Generated
  public static final BLonScptType ScptTimeout = new BLonScptType(SCPT_TIMEOUT);
  /** BLonScptType constant for ScptControlPriority. */
  @Generated
  public static final BLonScptType ScptControlPriority = new BLonScptType(SCPT_CONTROL_PRIORITY);
  /** BLonScptType constant for ScptDeviceGroupID. */
  @Generated
  public static final BLonScptType ScptDeviceGroupID = new BLonScptType(SCPT_DEVICE_GROUP_ID);
  /** BLonScptType constant for ScptMaxPrivacyZones. */
  @Generated
  public static final BLonScptType ScptMaxPrivacyZones = new BLonScptType(SCPT_MAX_PRIVACY_ZONES);
  /** BLonScptType constant for ScptMaxCameraPrepositions. */
  @Generated
  public static final BLonScptType ScptMaxCameraPrepositions = new BLonScptType(SCPT_MAX_CAMERA_PREPOSITIONS);
  /** BLonScptType constant for ScptDefaultPanTiltZoomSpeeds. */
  @Generated
  public static final BLonScptType ScptDefaultPanTiltZoomSpeeds = new BLonScptType(SCPT_DEFAULT_PAN_TILT_ZOOM_SPEEDS);
  /** BLonScptType constant for ScptDefaultAutoPanSpeed. */
  @Generated
  public static final BLonScptType ScptDefaultAutoPanSpeed = new BLonScptType(SCPT_DEFAULT_AUTO_PAN_SPEED);
  /** BLonScptType constant for ScptAutoAnswer. */
  @Generated
  public static final BLonScptType ScptAutoAnswer = new BLonScptType(SCPT_AUTO_ANSWER);
  /** BLonScptType constant for ScptDialString. */
  @Generated
  public static final BLonScptType ScptDialString = new BLonScptType(SCPT_DIAL_STRING);
  /** BLonScptType constant for ScptSerialNumber. */
  @Generated
  public static final BLonScptType ScptSerialNumber = new BLonScptType(SCPT_SERIAL_NUMBER);
  /** BLonScptType constant for ScptNormalRotationalSpeed. */
  @Generated
  public static final BLonScptType ScptNormalRotationalSpeed = new BLonScptType(SCPT_NORMAL_ROTATIONAL_SPEED);
  /** BLonScptType constant for ScptStandbyRotationalSpeed. */
  @Generated
  public static final BLonScptType ScptStandbyRotationalSpeed = new BLonScptType(SCPT_STANDBY_ROTATIONAL_SPEED);
  /** BLonScptType constant for ScptPartNumber. */
  @Generated
  public static final BLonScptType ScptPartNumber = new BLonScptType(SCPT_PART_NUMBER);
  /** BLonScptType constant for ScptDischargeAirCoolingSetpoint. */
  @Generated
  public static final BLonScptType ScptDischargeAirCoolingSetpoint = new BLonScptType(SCPT_DISCHARGE_AIR_COOLING_SETPOINT);
  /** BLonScptType constant for ScptDischargeAirHeatingSetpoint. */
  @Generated
  public static final BLonScptType ScptDischargeAirHeatingSetpoint = new BLonScptType(SCPT_DISCHARGE_AIR_HEATING_SETPOINT);
  /** BLonScptType constant for ScptMaxSupplyFanCapacity. */
  @Generated
  public static final BLonScptType ScptMaxSupplyFanCapacity = new BLonScptType(SCPT_MAX_SUPPLY_FAN_CAPACITY);
  /** BLonScptType constant for ScptMinSupplyFanCapacity. */
  @Generated
  public static final BLonScptType ScptMinSupplyFanCapacity = new BLonScptType(SCPT_MIN_SUPPLY_FAN_CAPACITY);
  /** BLonScptType constant for ScptMaxReturnExhaustFanCapacity. */
  @Generated
  public static final BLonScptType ScptMaxReturnExhaustFanCapacity = new BLonScptType(SCPT_MAX_RETURN_EXHAUST_FAN_CAPACITY);
  /** BLonScptType constant for ScptMinReturnExhaustFanCapacity. */
  @Generated
  public static final BLonScptType ScptMinReturnExhaustFanCapacity = new BLonScptType(SCPT_MIN_RETURN_EXHAUST_FAN_CAPACITY);
  /** BLonScptType constant for ScptDuctStaticPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptDuctStaticPressureSetpoint = new BLonScptType(SCPT_DUCT_STATIC_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMaxDuctStaticPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxDuctStaticPressureSetpoint = new BLonScptType(SCPT_MAX_DUCT_STATIC_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMinDuctStaticPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMinDuctStaticPressureSetpoint = new BLonScptType(SCPT_MIN_DUCT_STATIC_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptDuctStaticPressureLimit. */
  @Generated
  public static final BLonScptType ScptDuctStaticPressureLimit = new BLonScptType(SCPT_DUCT_STATIC_PRESSURE_LIMIT);
  /** BLonScptType constant for ScptBuildingStaticPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptBuildingStaticPressureSetpoint = new BLonScptType(SCPT_BUILDING_STATIC_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptReturnFanStaticPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptReturnFanStaticPressureSetpoint = new BLonScptType(SCPT_RETURN_FAN_STATIC_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptFanDifferentialSetpoint. */
  @Generated
  public static final BLonScptType ScptFanDifferentialSetpoint = new BLonScptType(SCPT_FAN_DIFFERENTIAL_SETPOINT);
  /** BLonScptType constant for ScptMixedAirLowLimitSetpoint. */
  @Generated
  public static final BLonScptType ScptMixedAirLowLimitSetpoint = new BLonScptType(SCPT_MIXED_AIR_LOW_LIMIT_SETPOINT);
  /** BLonScptType constant for ScptMixedAirTempSetpoint. */
  @Generated
  public static final BLonScptType ScptMixedAirTempSetpoint = new BLonScptType(SCPT_MIXED_AIR_TEMP_SETPOINT);
  /** BLonScptType constant for ScptMinOutdoorAirFlowSetpoint. */
  @Generated
  public static final BLonScptType ScptMinOutdoorAirFlowSetpoint = new BLonScptType(SCPT_MIN_OUTDOOR_AIR_FLOW_SETPOINT);
  /** BLonScptType constant for ScptOutdoorAirTempSetpoint. */
  @Generated
  public static final BLonScptType ScptOutdoorAirTempSetpoint = new BLonScptType(SCPT_OUTDOOR_AIR_TEMP_SETPOINT);
  /** BLonScptType constant for ScptOutdoorAirEnthalpySetpoint. */
  @Generated
  public static final BLonScptType ScptOutdoorAirEnthalpySetpoint = new BLonScptType(SCPT_OUTDOOR_AIR_ENTHALPY_SETPOINT);
  /** BLonScptType constant for ScptDiffTempSetpoint. */
  @Generated
  public static final BLonScptType ScptDiffTempSetpoint = new BLonScptType(SCPT_DIFF_TEMP_SETPOINT);
  /** BLonScptType constant for ScptExhaustEnablePosition. */
  @Generated
  public static final BLonScptType ScptExhaustEnablePosition = new BLonScptType(SCPT_EXHAUST_ENABLE_POSITION);
  /** BLonScptType constant for ScptSpaceHumSetpoint. */
  @Generated
  public static final BLonScptType ScptSpaceHumSetpoint = new BLonScptType(SCPT_SPACE_HUM_SETPOINT);
  /** BLonScptType constant for ScptDischargeAirDewpointSetpoint. */
  @Generated
  public static final BLonScptType ScptDischargeAirDewpointSetpoint = new BLonScptType(SCPT_DISCHARGE_AIR_DEWPOINT_SETPOINT);
  /** BLonScptType constant for ScptMaxDischargeAirCoolingSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxDischargeAirCoolingSetpoint = new BLonScptType(SCPT_MAX_DISCHARGE_AIR_COOLING_SETPOINT);
  /** BLonScptType constant for ScptMinDischargeAirCoolingSetpoint. */
  @Generated
  public static final BLonScptType ScptMinDischargeAirCoolingSetpoint = new BLonScptType(SCPT_MIN_DISCHARGE_AIR_COOLING_SETPOINT);
  /** BLonScptType constant for ScptMaxDischargeAirHeatingSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxDischargeAirHeatingSetpoint = new BLonScptType(SCPT_MAX_DISCHARGE_AIR_HEATING_SETPOINT);
  /** BLonScptType constant for ScptMinDischargeAirHeatingSetpoint. */
  @Generated
  public static final BLonScptType ScptMinDischargeAirHeatingSetpoint = new BLonScptType(SCPT_MIN_DISCHARGE_AIR_HEATING_SETPOINT);
  /** BLonScptType constant for ScptCoolingLockout. */
  @Generated
  public static final BLonScptType ScptCoolingLockout = new BLonScptType(SCPT_COOLING_LOCKOUT);
  /** BLonScptType constant for ScptHeatingLockout. */
  @Generated
  public static final BLonScptType ScptHeatingLockout = new BLonScptType(SCPT_HEATING_LOCKOUT);
  /** BLonScptType constant for ScptCoolingResetEnable. */
  @Generated
  public static final BLonScptType ScptCoolingResetEnable = new BLonScptType(SCPT_COOLING_RESET_ENABLE);
  /** BLonScptType constant for ScptHeatingResetEnable. */
  @Generated
  public static final BLonScptType ScptHeatingResetEnable = new BLonScptType(SCPT_HEATING_RESET_ENABLE);
  /** BLonScptType constant for ScptSetpoint. */
  @Generated
  public static final BLonScptType ScptSetpoint = new BLonScptType(SCPT_SETPOINT);
  /** BLonScptType constant for ScptTemperatureHysteresis. */
  @Generated
  public static final BLonScptType ScptTemperatureHysteresis = new BLonScptType(SCPT_TEMPERATURE_HYSTERESIS);
  /** BLonScptType constant for ScptControlTemperatureWeighting. */
  @Generated
  public static final BLonScptType ScptControlTemperatureWeighting = new BLonScptType(SCPT_CONTROL_TEMPERATURE_WEIGHTING);
  /** BLonScptType constant for ScptPwmPeriod. */
  @Generated
  public static final BLonScptType ScptPwmPeriod = new BLonScptType(SCPT_PWM_PERIOD);
  /** BLonScptType constant for ScptDefrostInternalSchedule. */
  @Generated
  public static final BLonScptType ScptDefrostInternalSchedule = new BLonScptType(SCPT_DEFROST_INTERNAL_SCHEDULE);
  /** BLonScptType constant for ScptDefrostStart. */
  @Generated
  public static final BLonScptType ScptDefrostStart = new BLonScptType(SCPT_DEFROST_START);
  /** BLonScptType constant for ScptDefrostCycles. */
  @Generated
  public static final BLonScptType ScptDefrostCycles = new BLonScptType(SCPT_DEFROST_CYCLES);
  /** BLonScptType constant for ScptMinDefrostTime. */
  @Generated
  public static final BLonScptType ScptMinDefrostTime = new BLonScptType(SCPT_MIN_DEFROST_TIME);
  /** BLonScptType constant for ScptMaxDefrostTime. */
  @Generated
  public static final BLonScptType ScptMaxDefrostTime = new BLonScptType(SCPT_MAX_DEFROST_TIME);
  /** BLonScptType constant for ScptDefrostFanDelay. */
  @Generated
  public static final BLonScptType ScptDefrostFanDelay = new BLonScptType(SCPT_DEFROST_FAN_DELAY);
  /** BLonScptType constant for ScptDefrostRecoveryTime. */
  @Generated
  public static final BLonScptType ScptDefrostRecoveryTime = new BLonScptType(SCPT_DEFROST_RECOVERY_TIME);
  /** BLonScptType constant for ScptDefrostHold. */
  @Generated
  public static final BLonScptType ScptDefrostHold = new BLonScptType(SCPT_DEFROST_HOLD);
  /** BLonScptType constant for ScptDefrostDetect. */
  @Generated
  public static final BLonScptType ScptDefrostDetect = new BLonScptType(SCPT_DEFROST_DETECT);
  /** BLonScptType constant for ScptScheduleInternal. */
  @Generated
  public static final BLonScptType ScptScheduleInternal = new BLonScptType(SCPT_SCHEDULE_INTERNAL);
  /** BLonScptType constant for ScptTempOffset. */
  @Generated
  public static final BLonScptType ScptTempOffset = new BLonScptType(SCPT_TEMP_OFFSET);
  /** BLonScptType constant for ScptAudibleLevel. */
  @Generated
  public static final BLonScptType ScptAudibleLevel = new BLonScptType(SCPT_AUDIBLE_LEVEL);
  /** BLonScptType constant for ScptScrollSpeed. */
  @Generated
  public static final BLonScptType ScptScrollSpeed = new BLonScptType(SCPT_SCROLL_SPEED);
  /** BLonScptType constant for ScptBrightness. */
  @Generated
  public static final BLonScptType ScptBrightness = new BLonScptType(SCPT_BRIGHTNESS);
  /** BLonScptType constant for ScptOrientation. */
  @Generated
  public static final BLonScptType ScptOrientation = new BLonScptType(SCPT_ORIENTATION);
  /** BLonScptType constant for ScptInstalledLevel. */
  @Generated
  public static final BLonScptType ScptInstalledLevel = new BLonScptType(SCPT_INSTALLED_LEVEL);
  /** BLonScptType constant for ScptPumpCharacteristic. */
  @Generated
  public static final BLonScptType ScptPumpCharacteristic = new BLonScptType(SCPT_PUMP_CHARACTERISTIC);
  /** BLonScptType constant for ScptMinPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMinPressureSetpoint = new BLonScptType(SCPT_MIN_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMaxPressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxPressureSetpoint = new BLonScptType(SCPT_MAX_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMinFlowSetpoint. */
  @Generated
  public static final BLonScptType ScptMinFlowSetpoint = new BLonScptType(SCPT_MIN_FLOW_SETPOINT);
  /** BLonScptType constant for ScptMaxFlowSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxFlowSetpoint = new BLonScptType(SCPT_MAX_FLOW_SETPOINT);
  /** BLonScptType constant for ScptDeviceControlMode. */
  @Generated
  public static final BLonScptType ScptDeviceControlMode = new BLonScptType(SCPT_DEVICE_CONTROL_MODE);
  /** BLonScptType constant for ScptMinRemotePressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMinRemotePressureSetpoint = new BLonScptType(SCPT_MIN_REMOTE_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMaxRemotePressureSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxRemotePressureSetpoint = new BLonScptType(SCPT_MAX_REMOTE_PRESSURE_SETPOINT);
  /** BLonScptType constant for ScptMinRemoteFlowSetpoint. */
  @Generated
  public static final BLonScptType ScptMinRemoteFlowSetpoint = new BLonScptType(SCPT_MIN_REMOTE_FLOW_SETPOINT);
  /** BLonScptType constant for ScptMaxRemoteFlowSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxRemoteFlowSetpoint = new BLonScptType(SCPT_MAX_REMOTE_FLOW_SETPOINT);
  /** BLonScptType constant for ScptMinRemoteTempSetpoint. */
  @Generated
  public static final BLonScptType ScptMinRemoteTempSetpoint = new BLonScptType(SCPT_MIN_REMOTE_TEMP_SETPOINT);
  /** BLonScptType constant for ScptMaxRemoteTempSetpoint. */
  @Generated
  public static final BLonScptType ScptMaxRemoteTempSetpoint = new BLonScptType(SCPT_MAX_REMOTE_TEMP_SETPOINT);
  /** BLonScptType constant for ScptControlSignal. */
  @Generated
  public static final BLonScptType ScptControlSignal = new BLonScptType(SCPT_CONTROL_SIGNAL);
  /** BLonScptType constant for ScptNightPurgePosition. */
  @Generated
  public static final BLonScptType ScptNightPurgePosition = new BLonScptType(SCPT_NIGHT_PURGE_POSITION);
  /** BLonScptType constant for ScptFreeCoolPosition. */
  @Generated
  public static final BLonScptType ScptFreeCoolPosition = new BLonScptType(SCPT_FREE_COOL_POSITION);
  /** BLonScptType constant for ScptValveFlowCharacteristic. */
  @Generated
  public static final BLonScptType ScptValveFlowCharacteristic = new BLonScptType(SCPT_VALVE_FLOW_CHARACTERISTIC);
  /** BLonScptType constant for ScptValveOperatingMode. */
  @Generated
  public static final BLonScptType ScptValveOperatingMode = new BLonScptType(SCPT_VALVE_OPERATING_MODE);
  /** BLonScptType constant for ScptEmergencyPosition. */
  @Generated
  public static final BLonScptType ScptEmergencyPosition = new BLonScptType(SCPT_EMERGENCY_POSITION);
  /** BLonScptType constant for ScptBlockProtectionTime. */
  @Generated
  public static final BLonScptType ScptBlockProtectionTime = new BLonScptType(SCPT_BLOCK_PROTECTION_TIME);
  /** BLonScptType constant for ScptMinStroke. */
  @Generated
  public static final BLonScptType ScptMinStroke = new BLonScptType(SCPT_MIN_STROKE);
  /** BLonScptType constant for ScptMaxStroke. */
  @Generated
  public static final BLonScptType ScptMaxStroke = new BLonScptType(SCPT_MAX_STROKE);
  /** BLonScptType constant for ScptNvType. */
  @Generated
  public static final BLonScptType ScptNvType = new BLonScptType(SCPT_NV_TYPE);
  /** BLonScptType constant for ScptMaxNVLength. */
  @Generated
  public static final BLonScptType ScptMaxNVLength = new BLonScptType(SCPT_MAX_NVLENGTH);
  /** BLonScptType constant for ScptNvDynamicAssignment. */
  @Generated
  public static final BLonScptType ScptNvDynamicAssignment = new BLonScptType(SCPT_NV_DYNAMIC_ASSIGNMENT);
  /** BLonScptType constant for ScptSafExtCnfg. */
  @Generated
  public static final BLonScptType ScptSafExtCnfg = new BLonScptType(SCPT_SAF_EXT_CNFG);
  /** BLonScptType constant for ScptEmergCnfg. */
  @Generated
  public static final BLonScptType ScptEmergCnfg = new BLonScptType(SCPT_EMERG_CNFG);
  /** BLonScptType constant for ScptSluiceCnfg. */
  @Generated
  public static final BLonScptType ScptSluiceCnfg = new BLonScptType(SCPT_SLUICE_CNFG);
  /** BLonScptType constant for ScptFanOperation. */
  @Generated
  public static final BLonScptType ScptFanOperation = new BLonScptType(SCPT_FAN_OPERATION);
  /** BLonScptType constant for ScptMinFlowUnit. */
  @Generated
  public static final BLonScptType ScptMinFlowUnit = new BLonScptType(SCPT_MIN_FLOW_UNIT);
  /** BLonScptType constant for ScptMaxFlowUnit. */
  @Generated
  public static final BLonScptType ScptMaxFlowUnit = new BLonScptType(SCPT_MAX_FLOW_UNIT);
  /** BLonScptType constant for ScptMinFlowHeatStby. */
  @Generated
  public static final BLonScptType ScptMinFlowHeatStby = new BLonScptType(SCPT_MIN_FLOW_HEAT_STBY);
  /** BLonScptType constant for ScptMinFlowUnitStby. */
  @Generated
  public static final BLonScptType ScptMinFlowUnitStby = new BLonScptType(SCPT_MIN_FLOW_UNIT_STBY);
  /** BLonScptType constant for ScptOffsetFlow. */
  @Generated
  public static final BLonScptType ScptOffsetFlow = new BLonScptType(SCPT_OFFSET_FLOW);
  /** BLonScptType constant for ScptAreaDuctHeat. */
  @Generated
  public static final BLonScptType ScptAreaDuctHeat = new BLonScptType(SCPT_AREA_DUCT_HEAT);
  /** BLonScptType constant for ScptNomAirFlowHeat. */
  @Generated
  public static final BLonScptType ScptNomAirFlowHeat = new BLonScptType(SCPT_NOM_AIR_FLOW_HEAT);
  /** BLonScptType constant for ScptGainVAVHeat. */
  @Generated
  public static final BLonScptType ScptGainVAVHeat = new BLonScptType(SCPT_GAIN_VAVHEAT);
  /** BLonScptType constant for ScptNumDampers. */
  @Generated
  public static final BLonScptType ScptNumDampers = new BLonScptType(SCPT_NUM_DAMPERS);
  /** BLonScptType constant for ScptMinFlowUnitHeat. */
  @Generated
  public static final BLonScptType ScptMinFlowUnitHeat = new BLonScptType(SCPT_MIN_FLOW_UNIT_HEAT);
  /** BLonScptType constant for ScptSaturationDelay. */
  @Generated
  public static final BLonScptType ScptSaturationDelay = new BLonScptType(SCPT_SATURATION_DELAY);
  /** BLonScptType constant for ScptEffectivePeriod. */
  @Generated
  public static final BLonScptType ScptEffectivePeriod = new BLonScptType(SCPT_EFFECTIVE_PERIOD);
  /** BLonScptType constant for ScptScheduleDates. */
  @Generated
  public static final BLonScptType ScptScheduleDates = new BLonScptType(SCPT_SCHEDULE_DATES);
  /** BLonScptType constant for ScptSchedule. */
  @Generated
  public static final BLonScptType ScptSchedule = new BLonScptType(SCPT_SCHEDULE);
  /** BLonScptType constant for ScptScheduleTimeValue. */
  @Generated
  public static final BLonScptType ScptScheduleTimeValue = new BLonScptType(SCPT_SCHEDULE_TIME_VALUE);
  /** BLonScptType constant for ScptValueDefinition. */
  @Generated
  public static final BLonScptType ScptValueDefinition = new BLonScptType(SCPT_VALUE_DEFINITION);
  /** BLonScptType constant for ScptValueName. */
  @Generated
  public static final BLonScptType ScptValueName = new BLonScptType(SCPT_VALUE_NAME);
  /** BLonScptType constant for ScptWeeklySchedule. */
  @Generated
  public static final BLonScptType ScptWeeklySchedule = new BLonScptType(SCPT_WEEKLY_SCHEDULE);
  /** BLonScptType constant for ScptScheduleName. */
  @Generated
  public static final BLonScptType ScptScheduleName = new BLonScptType(SCPT_SCHEDULE_NAME);
  /** BLonScptType constant for ScptValveStroke. */
  @Generated
  public static final BLonScptType ScptValveStroke = new BLonScptType(SCPT_VALVE_STROKE);
  /** BLonScptType constant for ScptValveNominalSize. */
  @Generated
  public static final BLonScptType ScptValveNominalSize = new BLonScptType(SCPT_VALVE_NOMINAL_SIZE);
  /** BLonScptType constant for ScptValveKvs. */
  @Generated
  public static final BLonScptType ScptValveKvs = new BLonScptType(SCPT_VALVE_KVS);
  /** BLonScptType constant for ScptValveType. */
  @Generated
  public static final BLonScptType ScptValveType = new BLonScptType(SCPT_VALVE_TYPE);
  /** BLonScptType constant for ScptActuatorCharacteristic. */
  @Generated
  public static final BLonScptType ScptActuatorCharacteristic = new BLonScptType(SCPT_ACTUATOR_CHARACTERISTIC);
  /** BLonScptType constant for ScptTrnsTblX2. */
  @Generated
  public static final BLonScptType ScptTrnsTblX2 = new BLonScptType(SCPT_TRNS_TBL_X2);
  /** BLonScptType constant for ScptTrnsTblY2. */
  @Generated
  public static final BLonScptType ScptTrnsTblY2 = new BLonScptType(SCPT_TRNS_TBL_Y2);
  /** BLonScptType constant for ScptCombFlowCharacteristic. */
  @Generated
  public static final BLonScptType ScptCombFlowCharacteristic = new BLonScptType(SCPT_COMB_FLOW_CHARACTERISTIC);
  /** BLonScptType constant for ScptTrnsTblX3. */
  @Generated
  public static final BLonScptType ScptTrnsTblX3 = new BLonScptType(SCPT_TRNS_TBL_X3);
  /** BLonScptType constant for ScptTrnsTblY3. */
  @Generated
  public static final BLonScptType ScptTrnsTblY3 = new BLonScptType(SCPT_TRNS_TBL_Y3);
  /** BLonScptType constant for ScptRunTimeAlarm. */
  @Generated
  public static final BLonScptType ScptRunTimeAlarm = new BLonScptType(SCPT_RUN_TIME_ALARM);
  /** BLonScptType constant for ScptTimePeriod. */
  @Generated
  public static final BLonScptType ScptTimePeriod = new BLonScptType(SCPT_TIME_PERIOD);
  /** BLonScptType constant for ScptPulseValue. */
  @Generated
  public static final BLonScptType ScptPulseValue = new BLonScptType(SCPT_PULSE_VALUE);
  /** BLonScptType constant for ScptNumDigits. */
  @Generated
  public static final BLonScptType ScptNumDigits = new BLonScptType(SCPT_NUM_DIGITS);
  /** BLonScptType constant for ScptIdentity. */
  @Generated
  public static final BLonScptType ScptIdentity = new BLonScptType(SCPT_IDENTITY);
  /** BLonScptType constant for ScptDefaultState. */
  @Generated
  public static final BLonScptType ScptDefaultState = new BLonScptType(SCPT_DEFAULT_STATE);
  /** BLonScptType constant for ScptNvPriority. */
  @Generated
  public static final BLonScptType ScptNvPriority = new BLonScptType(SCPT_NV_PRIORITY);
  /** BLonScptType constant for ScptDefaultSetting. */
  @Generated
  public static final BLonScptType ScptDefaultSetting = new BLonScptType(SCPT_DEFAULT_SETTING);
  /** BLonScptType constant for ScptLowLimit1Enable. */
  @Generated
  public static final BLonScptType ScptLowLimit1Enable = new BLonScptType(SCPT_LOW_LIMIT_1ENABLE);
  /** BLonScptType constant for ScptLowLimit2Enable. */
  @Generated
  public static final BLonScptType ScptLowLimit2Enable = new BLonScptType(SCPT_LOW_LIMIT_2ENABLE);
  /** BLonScptType constant for ScptClockCalibration. */
  @Generated
  public static final BLonScptType ScptClockCalibration = new BLonScptType(SCPT_CLOCK_CALIBRATION);
  /** BLonScptType constant for ScptNeuronId. */
  @Generated
  public static final BLonScptType ScptNeuronId = new BLonScptType(SCPT_NEURON_ID);
  /** BLonScptType constant for ScptHighLimit1Enable. */
  @Generated
  public static final BLonScptType ScptHighLimit1Enable = new BLonScptType(SCPT_HIGH_LIMIT_1ENABLE);
  /** BLonScptType constant for ScptHighLimit2Enable. */
  @Generated
  public static final BLonScptType ScptHighLimit2Enable = new BLonScptType(SCPT_HIGH_LIMIT_2ENABLE);
  /** BLonScptType constant for ScptAhamApplianceModel. */
  @Generated
  public static final BLonScptType ScptAhamApplianceModel = new BLonScptType(SCPT_AHAM_APPLIANCE_MODEL);
  /** BLonScptType constant for ScptDefInput. */
  @Generated
  public static final BLonScptType ScptDefInput = new BLonScptType(SCPT_DEF_INPUT);
  /** BLonScptType constant for ScptName1. */
  @Generated
  public static final BLonScptType ScptName1 = new BLonScptType(SCPT_NAME_1);
  /** BLonScptType constant for ScptScene. */
  @Generated
  public static final BLonScptType ScptScene = new BLonScptType(SCPT_SCENE);
  /** BLonScptType constant for ScptSceneTiming. */
  @Generated
  public static final BLonScptType ScptSceneTiming = new BLonScptType(SCPT_SCENE_TIMING);
  /** BLonScptType constant for ScptName2. */
  @Generated
  public static final BLonScptType ScptName2 = new BLonScptType(SCPT_NAME_2);
  /** BLonScptType constant for ScptName3. */
  @Generated
  public static final BLonScptType ScptName3 = new BLonScptType(SCPT_NAME_3);
  /** BLonScptType constant for ScptButtonPressAction. */
  @Generated
  public static final BLonScptType ScptButtonPressAction = new BLonScptType(SCPT_BUTTON_PRESS_ACTION);
  /** BLonScptType constant for ScptButtonColor. */
  @Generated
  public static final BLonScptType ScptButtonColor = new BLonScptType(SCPT_BUTTON_COLOR);
  /** BLonScptType constant for ScptButtonRepeatInterval. */
  @Generated
  public static final BLonScptType ScptButtonRepeatInterval = new BLonScptType(SCPT_BUTTON_REPEAT_INTERVAL);
  /** BLonScptType constant for ScptButtonHoldAction. */
  @Generated
  public static final BLonScptType ScptButtonHoldAction = new BLonScptType(SCPT_BUTTON_HOLD_ACTION);
  /** BLonScptType constant for ScptPwrSendOnDelta. */
  @Generated
  public static final BLonScptType ScptPwrSendOnDelta = new BLonScptType(SCPT_PWR_SEND_ON_DELTA);
  /** BLonScptType constant for ScptSceneName. */
  @Generated
  public static final BLonScptType ScptSceneName = new BLonScptType(SCPT_SCENE_NAME);
  /** BLonScptType constant for ScptMaxPower. */
  @Generated
  public static final BLonScptType ScptMaxPower = new BLonScptType(SCPT_MAX_POWER);
  /** BLonScptType constant for ScptIfaceDesc. */
  @Generated
  public static final BLonScptType ScptIfaceDesc = new BLonScptType(SCPT_IFACE_DESC);
  /** BLonScptType constant for ScptMonInterval. */
  @Generated
  public static final BLonScptType ScptMonInterval = new BLonScptType(SCPT_MON_INTERVAL);
  /** BLonScptType constant for ScptLinkPowerDetectEnable. */
  @Generated
  public static final BLonScptType ScptLinkPowerDetectEnable = new BLonScptType(SCPT_LINK_POWER_DETECT_ENABLE);
  /** BLonScptType constant for ScptScanTime. */
  @Generated
  public static final BLonScptType ScptScanTime = new BLonScptType(SCPT_SCAN_TIME);
  /** BLonScptType constant for ScptDevListDesc. */
  @Generated
  public static final BLonScptType ScptDevListDesc = new BLonScptType(SCPT_DEV_LIST_DESC);
  /** BLonScptType constant for ScptDevListEntry. */
  @Generated
  public static final BLonScptType ScptDevListEntry = new BLonScptType(SCPT_DEV_LIST_ENTRY);
  /** BLonScptType constant for ScptLogCapacity. */
  @Generated
  public static final BLonScptType ScptLogCapacity = new BLonScptType(SCPT_LOG_CAPACITY);
  /** BLonScptType constant for ScptLogNotificationThreshold. */
  @Generated
  public static final BLonScptType ScptLogNotificationThreshold = new BLonScptType(SCPT_LOG_NOTIFICATION_THRESHOLD);
  /** BLonScptType constant for ScptLogSize. */
  @Generated
  public static final BLonScptType ScptLogSize = new BLonScptType(SCPT_LOG_SIZE);
  /** BLonScptType constant for ScptLogType. */
  @Generated
  public static final BLonScptType ScptLogType = new BLonScptType(SCPT_LOG_TYPE);
  /** BLonScptType constant for ScptFanInEnable. */
  @Generated
  public static final BLonScptType ScptFanInEnable = new BLonScptType(SCPT_FAN_IN_ENABLE);
  /** BLonScptType constant for ScptLogTimestampEnable. */
  @Generated
  public static final BLonScptType ScptLogTimestampEnable = new BLonScptType(SCPT_LOG_TIMESTAMP_ENABLE);
  /** BLonScptType constant for ScptLogHighLimit. */
  @Generated
  public static final BLonScptType ScptLogHighLimit = new BLonScptType(SCPT_LOG_HIGH_LIMIT);
  /** BLonScptType constant for ScptLogLowLimit. */
  @Generated
  public static final BLonScptType ScptLogLowLimit = new BLonScptType(SCPT_LOG_LOW_LIMIT);
  /** BLonScptType constant for ScptMaxFanIn. */
  @Generated
  public static final BLonScptType ScptMaxFanIn = new BLonScptType(SCPT_MAX_FAN_IN);
  /** BLonScptType constant for ScptLogMinDeltaTime. */
  @Generated
  public static final BLonScptType ScptLogMinDeltaTime = new BLonScptType(SCPT_LOG_MIN_DELTA_TIME);
  /** BLonScptType constant for ScptLogMinDeltaValue. */
  @Generated
  public static final BLonScptType ScptLogMinDeltaValue = new BLonScptType(SCPT_LOG_MIN_DELTA_VALUE);
  /** BLonScptType constant for ScptPollRate. */
  @Generated
  public static final BLonScptType ScptPollRate = new BLonScptType(SCPT_POLL_RATE);
  /** BLonScptType constant for ScptSourceAddress. */
  @Generated
  public static final BLonScptType ScptSourceAddress = new BLonScptType(SCPT_SOURCE_ADDRESS);
  /** BLonScptType constant for ScptLogRecord. */
  @Generated
  public static final BLonScptType ScptLogRecord = new BLonScptType(SCPT_LOG_RECORD);
  /** BLonScptType constant for ScptLogFileHeader. */
  @Generated
  public static final BLonScptType ScptLogFileHeader = new BLonScptType(SCPT_LOG_FILE_HEADER);
  /** BLonScptType constant for ScptLogAlarmThreshold. */
  @Generated
  public static final BLonScptType ScptLogAlarmThreshold = new BLonScptType(SCPT_LOG_ALARM_THRESHOLD);
  /** BLonScptType constant for ScptLogRequest. */
  @Generated
  public static final BLonScptType ScptLogRequest = new BLonScptType(SCPT_LOG_REQUEST);
  /** BLonScptType constant for ScptLogResponse. */
  @Generated
  public static final BLonScptType ScptLogResponse = new BLonScptType(SCPT_LOG_RESPONSE);
  /** BLonScptType constant for ScptLightingGroupEnable. */
  @Generated
  public static final BLonScptType ScptLightingGroupEnable = new BLonScptType(SCPT_LIGHTING_GROUP_ENABLE);
  /** BLonScptType constant for ScptSceneColor. */
  @Generated
  public static final BLonScptType ScptSceneColor = new BLonScptType(SCPT_SCENE_COLOR);
  /** BLonScptType constant for ScptBkupSchedule. */
  @Generated
  public static final BLonScptType ScptBkupSchedule = new BLonScptType(SCPT_BKUP_SCHEDULE);
  /** BLonScptType constant for ScptOLCLimits. */
  @Generated
  public static final BLonScptType ScptOLCLimits = new BLonScptType(SCPT_OLCLIMITS);
  /** BLonScptType constant for ScptLampPower. */
  @Generated
  public static final BLonScptType ScptLampPower = new BLonScptType(SCPT_LAMP_POWER);
  /** BLonScptType constant for ScptDeviceOutSelection. */
  @Generated
  public static final BLonScptType ScptDeviceOutSelection = new BLonScptType(SCPT_DEVICE_OUT_SELECTION);
  /** BLonScptType constant for ScptEnableStatusMsg. */
  @Generated
  public static final BLonScptType ScptEnableStatusMsg = new BLonScptType(SCPT_ENABLE_STATUS_MSG);
  /** BLonScptType constant for ScptMaxLevelVolt. */
  @Generated
  public static final BLonScptType ScptMaxLevelVolt = new BLonScptType(SCPT_MAX_LEVEL_VOLT);
  /** BLonScptType constant for ScptGeoLocation. */
  @Generated
  public static final BLonScptType ScptGeoLocation = new BLonScptType(SCPT_GEO_LOCATION);
  /** BLonScptType constant for ScptProgName. */
  @Generated
  public static final BLonScptType ScptProgName = new BLonScptType(SCPT_PROG_NAME);
  /** BLonScptType constant for ScptProgRevision. */
  @Generated
  public static final BLonScptType ScptProgRevision = new BLonScptType(SCPT_PROG_REVISION);
  /** BLonScptType constant for ScptProgSelect. */
  @Generated
  public static final BLonScptType ScptProgSelect = new BLonScptType(SCPT_PROG_SELECT);
  /** BLonScptType constant for ScptProgSourceLocation. */
  @Generated
  public static final BLonScptType ScptProgSourceLocation = new BLonScptType(SCPT_PROG_SOURCE_LOCATION);
  /** BLonScptType constant for ScptProgFileIndexes. */
  @Generated
  public static final BLonScptType ScptProgFileIndexes = new BLonScptType(SCPT_PROG_FILE_INDEXES);
  /** BLonScptType constant for ScptProgCmdHistory. */
  @Generated
  public static final BLonScptType ScptProgCmdHistory = new BLonScptType(SCPT_PROG_CMD_HISTORY);
  /** BLonScptType constant for ScptProgStateHistory. */
  @Generated
  public static final BLonScptType ScptProgStateHistory = new BLonScptType(SCPT_PROG_STATE_HISTORY);
  /** BLonScptType constant for ScptNsdsFbIndex. */
  @Generated
  public static final BLonScptType ScptNsdsFbIndex = new BLonScptType(SCPT_NSDS_FB_INDEX);
  /** BLonScptType constant for ScptCurrentSenseEnable. */
  @Generated
  public static final BLonScptType ScptCurrentSenseEnable = new BLonScptType(SCPT_CURRENT_SENSE_ENABLE);
  /** BLonScptType constant for ScptMeasurementInterval. */
  @Generated
  public static final BLonScptType ScptMeasurementInterval = new BLonScptType(SCPT_MEASUREMENT_INTERVAL);
  /** BLonScptType constant for ScptLightingGroupMembership. */
  @Generated
  public static final BLonScptType ScptLightingGroupMembership = new BLonScptType(SCPT_LIGHTING_GROUP_MEMBERSHIP);
  /** BLonScptType constant for ScptLoadControlOffset. */
  @Generated
  public static final BLonScptType ScptLoadControlOffset = new BLonScptType(SCPT_LOAD_CONTROL_OFFSET);
  /** BLonScptType constant for ScptProgErrorHistory. */
  @Generated
  public static final BLonScptType ScptProgErrorHistory = new BLonScptType(SCPT_PROG_ERROR_HISTORY);
  /** BLonScptType constant for ScptNvUsage. */
  @Generated
  public static final BLonScptType ScptNvUsage = new BLonScptType(SCPT_NV_USAGE);
  /** BLonScptType constant for ScptScheduleSunday. */
  @Generated
  public static final BLonScptType ScptScheduleSunday = new BLonScptType(SCPT_SCHEDULE_SUNDAY);
  /** BLonScptType constant for ScptScheduleMonday. */
  @Generated
  public static final BLonScptType ScptScheduleMonday = new BLonScptType(SCPT_SCHEDULE_MONDAY);
  /** BLonScptType constant for ScptScheduleTuesday. */
  @Generated
  public static final BLonScptType ScptScheduleTuesday = new BLonScptType(SCPT_SCHEDULE_TUESDAY);
  /** BLonScptType constant for ScptScheduleWednesday. */
  @Generated
  public static final BLonScptType ScptScheduleWednesday = new BLonScptType(SCPT_SCHEDULE_WEDNESDAY);
  /** BLonScptType constant for ScptScheduleThursday. */
  @Generated
  public static final BLonScptType ScptScheduleThursday = new BLonScptType(SCPT_SCHEDULE_THURSDAY);
  /** BLonScptType constant for ScptScheduleFriday. */
  @Generated
  public static final BLonScptType ScptScheduleFriday = new BLonScptType(SCPT_SCHEDULE_FRIDAY);
  /** BLonScptType constant for ScptScheduleSaturday. */
  @Generated
  public static final BLonScptType ScptScheduleSaturday = new BLonScptType(SCPT_SCHEDULE_SATURDAY);
  /** BLonScptType constant for ScptOccupancyBehavior. */
  @Generated
  public static final BLonScptType ScptOccupancyBehavior = new BLonScptType(SCPT_OCCUPANCY_BEHAVIOR);
  /** BLonScptType constant for ScptTimeSource. */
  @Generated
  public static final BLonScptType ScptTimeSource = new BLonScptType(SCPT_TIME_SOURCE);
  /** BLonScptType constant for ScptScheduleException. */
  @Generated
  public static final BLonScptType ScptScheduleException = new BLonScptType(SCPT_SCHEDULE_EXCEPTION);
  /** BLonScptType constant for ScptScheduleHoliday. */
  @Generated
  public static final BLonScptType ScptScheduleHoliday = new BLonScptType(SCPT_SCHEDULE_HOLIDAY);
  /** BLonScptType constant for ScptRandomizationInterval. */
  @Generated
  public static final BLonScptType ScptRandomizationInterval = new BLonScptType(SCPT_RANDOMIZATION_INTERVAL);
  /** BLonScptType constant for ScptSunriseTime. */
  @Generated
  public static final BLonScptType ScptSunriseTime = new BLonScptType(SCPT_SUNRISE_TIME);
  /** BLonScptType constant for ScptSunsetTime. */
  @Generated
  public static final BLonScptType ScptSunsetTime = new BLonScptType(SCPT_SUNSET_TIME);
  /** BLonScptType constant for ScptSchedulerOptions. */
  @Generated
  public static final BLonScptType ScptSchedulerOptions = new BLonScptType(SCPT_SCHEDULER_OPTIONS);
  /** BLonScptType constant for ScptOccupancyThresholds. */
  @Generated
  public static final BLonScptType ScptOccupancyThresholds = new BLonScptType(SCPT_OCCUPANCY_THRESHOLDS);

  /** Factory method with ordinal. */
  @Generated
  public static BLonScptType make(int ordinal)
  {
    return (BLonScptType)ScptXxx.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BLonScptType make(String tag)
  {
    return (BLonScptType)ScptXxx.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BLonScptType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BLonScptType DEFAULT = ScptXxx;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLonScptType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static final int LAST_SCPT_ID = 380;

  //DEVELOPER SLOT NOTE: Update Annotation version of Slot-o-matic uses a slightly different name derivation
  //                     function such that ScptAlrmClrT1 becomes SCPT_ALRM_CLR_T1, not SCPT_ALRM_CLR_T_1.
  //                     Provide backwards compatible ordinal values that allow old code to continue to function
  //                     without having to update to new variable names.

  /** Backwards compatible ordinal value for ScptAlrmClrT1. */
  public static final int SCPT_ALRM_CLR_T_1 = SCPT_ALRM_CLR_T1;
  /** Backwards compatible ordinal value for ScptAlrmClrT2. */
  public static final int SCPT_ALRM_CLR_T_2 = SCPT_ALRM_CLR_T2;
  /** Backwards compatible ordinal value for ScptAlrmSetT1. */
  public static final int SCPT_ALRM_SET_T_1 = SCPT_ALRM_SET_T1;
  /** Backwards compatible ordinal value for ScptAlrmSetT2. */
  public static final int SCPT_ALRM_SET_T_2 = SCPT_ALRM_SET_T2;
  /** Backwards compatible ordinal value for ScptLimitCO2. */
  public static final int SCPT_LIMIT_CO_2 = SCPT_LIMIT_CO2;
  /** Backwards compatible ordinal value for ScptMinDeltaCO2. */
  public static final int SCPT_MIN_DELTA_CO_2 = SCPT_MIN_DELTA_CO2;
  /** Backwards compatible ordinal value for ScptOffsetCO2. */
  public static final int SCPT_OFFSET_CO_2 = SCPT_OFFSET_CO2;
  /** Backwards compatible ordinal value for ScptAirTemp1Day. */
  public static final int SCPT_AIR_TEMP_1_DAY = SCPT_AIR_TEMP_1DAY;
  /** Backwards compatible ordinal value for ScptAirTemp1Night. */
  public static final int SCPT_AIR_TEMP_1_NIGHT = SCPT_AIR_TEMP_1NIGHT;
  /** Backwards compatible ordinal value for ScptAirTemp1Alrm. */
  public static final int SCPT_AIR_TEMP_1_ALRM = SCPT_AIR_TEMP_1ALRM;
  /** Backwards compatible ordinal value for ScptMaxNVLength. */
  public static final int SCPT_MAX_NV_LENGTH = SCPT_MAX_NVLENGTH;
  /** Backwards compatible ordinal value for ScptLowLimit1Enable. */
  public static final int SCPT_LOW_LIMIT1_ENABLE = SCPT_LOW_LIMIT_1ENABLE;
  /** Backwards compatible ordinal value for ScptLowLimit2Enable. */
  public static final int SCPT_LOW_LIMIT2_ENABLE = SCPT_LOW_LIMIT_2ENABLE;
  /** Backwards compatible ordinal value for ScptHighLimit1Enable. */
  public static final int SCPT_HIGH_LIMIT1_ENABLE = SCPT_HIGH_LIMIT_1ENABLE;
  /** Backwards compatible ordinal value for ScptHighLimit2Enable. */
  public static final int SCPT_HIGH_LIMIT2_ENABLE = SCPT_HIGH_LIMIT_2ENABLE;
  /** Backwards compatible ordinal value for ScptName1. */
  public static final int SCPT_NAME1 = SCPT_NAME_1;
  /** Backwards compatible ordinal value for ScptName2. */
  public static final int SCPT_NAME2 = SCPT_NAME_2;
  /** Backwards compatible ordinal value for ScptName3. */
  public static final int SCPT_NAME3 = SCPT_NAME_3;

//  // Create a list of SCPT types for this class file
//  // to run >>nre lonworks:javax.baja.lonworks.enums.BLonScptType
//  public static void main(String[] args)
//  {
//      XLonInterfaceFile std = XUtil.getStandard();
//      Vector types = std.types;
//      String[] a = new String[types.size()];
//      String[] c = new String[types.size()];
//int[] la = new int [types.size()];
//      int maxNv = 0;
//      int maxLen = 0;
//      int maxCLen = 0;
//      for(int i=0 ; i<types.size() ; i++)
//      {
//        XTypeDef t = ((XTypeDef)types.elementAt(i));
//        if(t.isCpType())
//        {
//          int ndx = t.getTypeIndex();
//          if(ndx < 0) continue;
//          String name = t.getName().substring(2);
//          a[ndx] = NameUtil.toJavaName(name,true);
//          c[ndx] = NameUtil.toConstantName(name);
//          if(ndx>maxNv) maxNv = ndx;
//
//          if(a[ndx].length() > maxLen) maxLen = a[ndx].length();
//          if(c[ndx].length() > maxCLen) maxCLen = c[ndx].length();
//try { la[ndx] = t.getLonData(std).getByteLength(); } catch(Exception e) { System.out.println("error:" + a[ndx]);}
//        }
//      }
//
//      String pad = "                                                        ";
//      System.out.println("  public static final int SCPT_XXX          = 0  ;");
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final int SCPT_" +
//               conName + pad.substring(0,maxCLen - conName.length()) + " = " + i + "  ;");
//      }
//
//      System.out.println("\n\n");
//      System.out.println("  public static final int LAST_SCPT_ID  = " + maxNv + " ;\n");
//      System.out.println("  public static final BLonScptType SCPTXxx         = new BLonScptType(SCPT_XXX         );\n");
//
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final BLonScptType Scpt"
//                     + a[i] + pad.substring(0,maxLen - a[i].length()) +
//                      " = new BLonScptType(SCPT_" + conName + pad.substring(0,maxCLen-conName.length()) + ");");
//      }
//
//      System.out.println("\n\n/* matches name format in SCPT Master list\n");
//      for(int i=1; i<=maxNv ; i++)
//      {
//        String conName = c[i];
//        System.out.println("  public static final BLonScptType SCPT_"
//                     + TextUtil.toLowerCase(conName) + pad.substring(0,maxCLen - conName.length()) +
//                      " = new BLonScptType(SCPT_" + conName + pad.substring(0,maxCLen - conName.length()) +
// ");  " + la[i]);
//      }
//      System.out.println("* //");
//  }
}
