/*
 * Copyright 2007 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.lonworks.datatypes;

import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *   This class file specifies parameters needed for 
 * importing xml data to local device.
 * <p>
 *  
 * @author    Robert Adams
 * @creation  14 Aug 07
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
@NiagaraType
@NiagaraProperty(
  name = "file",
  type = "BOrd",
  defaultValue = "BOrd.NULL",
  facets = @Facet("BFacets.make(\"allowLocalAccess\", BBoolean.TRUE)")
)
public class BLocalImportXmlParameter
  extends BStruct
{  
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.lonworks.datatypes.BLocalImportXmlParameter(3875786145)1.0$ @*/
/* Generated Tue Aug 15 09:32:08 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "file"

  /**
   * Slot for the {@code file} property.
   * @see #getFile
   * @see #setFile
   */
  @Generated
  public static final Property file = newProperty(0, BOrd.NULL, BFacets.make("allowLocalAccess", BBoolean.TRUE));

  /**
   * Get the {@code file} property.
   * @see #file
   */
  @Generated
  public BOrd getFile() { return (BOrd)get(file); }

  /**
   * Set the {@code file} property.
   * @see #file
   */
  @Generated
  public void setFile(BOrd v) { set(file, v, null); }

  //endregion Property "file"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BLocalImportXmlParameter.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  
}
