/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package com.tridium.kitControl.math;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/**
 * BArcTangent2 performs the operation out = atan2(inB,inA)
 *
 * @author Rayan Bouhal on 4 June 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "facets",
  type = "BFacets",
  defaultValue = "makeOutputFacets()",
  override = true
)
public class BArcTangent2
  extends BBinaryMath
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.kitControl.math.BArcTangent2(338157149)1.0$ @*/
/* Generated Wed Jun 05 11:29:29 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "facets"

  /**
   * Slot for the {@code facets} property.
   * @see #getFacets
   * @see #setFacets
   */
  @Generated
  public static final Property facets = newProperty(0, makeOutputFacets(), null);

  //endregion Property "facets"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BArcTangent2.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  protected double calculate(double y, double x)
  {
    return Math.atan2(y, x);
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon()
  {
    return icon;
  }

  private static final BIcon icon = BIcon.std("control/util/sine.png");

  /**
   * Default the facets to radians
   */
  private static BFacets makeOutputFacets()
  {
    return BFacets.make(BFacets.makeNumeric(), BFacets.UNITS, BUnit.getUnit("radian"));
  }
}
