/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNor performs a logical NOR on all inputs and writes
 * the result to the out property.
 *
 * @author Rayan Bouhal on 07 Jun 2024
 * @since Niagara 4.15
 */
@NiagaraType
public class BNor
  extends BQuadLogic
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.kitControl.logic.BNor(2979906276)1.0$ @*/
/* Generated Fri Jun 07 11:47:20 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BNor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  protected boolean calculate(BStatusBoolean a, BStatusBoolean b, BStatusBoolean c, BStatusBoolean d)
  {
    boolean aa,bb,cc,dd;

    //  Use only valid values.  If an input is invalid, use
    //  false (identity operation for NOR)
    aa = bb = cc = dd = false;
    if (a.getStatus().isValid()) { aa = a.getValue(); }
    if (b.getStatus().isValid()) { bb = b.getValue(); }
    if (c.getStatus().isValid()) { cc = c.getValue(); }
    if (d.getStatus().isValid()) { dd = d.getValue(); }

    return !(aa || bb || cc || dd);
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 2 for an BNor object.
   */
  public int minInputs()
  {
    return 2;
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon()
  {
    return ICON;
  }

  private static final BIcon ICON = BIcon.std("control/logic/nor.png");
}
