/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package com.tridium.kitControl.logic;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BNand performs a logical NAND on all inputs and writes
 * the result to the out property.
 *
 * @author Rayan Bouhal on 11 Jun 2024
 * @since Niagara 4.15
 */
@NiagaraType
public class BNand
  extends BQuadLogic
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $com.tridium.kitControl.logic.BNand(2979906276)1.0$ @*/
/* Generated Tue Jun 11 11:26:42 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BNand.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  @Override
  protected boolean calculate(BStatusBoolean a, BStatusBoolean b, BStatusBoolean c, BStatusBoolean d)
  {
    boolean result = true;
    boolean allInvalid = true;

    //  Use only valid values
    if (a.getStatus().isValid()) { result &= a.getValue(); allInvalid = false; }
    if (b.getStatus().isValid()) { result &= b.getValue(); allInvalid = false; }
    if (c.getStatus().isValid()) { result &= c.getValue(); allInvalid = false; }
    if (d.getStatus().isValid()) { result &= d.getValue(); allInvalid = false; }
    return allInvalid ? false : !result;
  }

  /**
   * Return the minimum number of valid inputs needed to
   * generate a valid output, which is 2 for an BNand object.
   */
  @Override
  public int minInputs()
  {
    return 2;
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon()
  {
    return ICON;
  }

  private static final BIcon ICON = BIcon.std("control/logic/nand.png");
}
