/*
 * Copyright 2004, Tridium, Inc. All Rights Reserved.
 */

package javax.baja.control.trigger;

import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A BTriggerMode determines when a BTimeTrigger will fire its trigger.
 *
 * @author    John Sublett
 * @creation  07 Jan 2004
 * @version   $Revision: 4$ $Date: 7/24/08 9:45:10 AM EDT$
 * @since     Baja 1.0
 */
@NiagaraType
public abstract class BTriggerMode
  extends BSimple
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.control.trigger.BTriggerMode(2979906276)1.0$ @*/
/* Generated Tue Jun 06 11:55:29 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BTriggerMode.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the display name for this trigger mode.
   */
  public String getDisplayName(Context cx)
  {
    return getType().getDisplayName(cx);
  }

  /**
   * Make a scheduler for this trigger mode.  This method must
   * create a new instance each time it is called.
   */
  public abstract TriggerScheduler makeScheduler(BTimeTrigger trigger);

////////////////////////////////////////////////////////////////
// Agents
////////////////////////////////////////////////////////////////

  /**
   * Override so that BTriggerModeFE is always the default.
   */
  public AgentList getAgents(Context cx)
  {
    AgentList agents = super.getAgents(cx);
    agents.toTop("control:TriggerModeFE");
    return agents;
  }
}
