/*
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import java.security.Key;
import java.security.cert.X509Certificate;

/**
 * IKeyStore is the type of object returned from 
 * a call to getTrustStore or getUserTrustStore from an
 * ICryptoManager.
 * 
 * @see java.security.KeyStore
 *
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public interface IKeyStore extends ITrustStore
{
  /**
   * Get the key stored for the specified alias
   *
   * @param alias the alias to retrieve
   * @param password the entry's password
   * @return The key stored for the alias, or null if the alias does not exist
   *         or is not a key entry
   * @throws Exception if an error occurs retrieving the certificate
   * @throws java.security.AccessControlException if the calling module does
   *         not have the necessary KeyStorePermission.
   */
  Key getKey(String alias, char[] password) throws Exception;

  /**
   * Store a key and certificate with the specified alias
   *
   * @param alias the alias for the entry
   * @param key the key to set
   * @param chain the certificate chain to set
   * @throws Exception if an error occurs setting the key
   * @throws java.security.AccessControlException if the calling module does
   *         not have the necessary KeyStorePermission.
   */
  void setKeyEntry(String alias, byte[] key, X509Certificate[] chain) throws Exception;

  /**
   * Store a key and certificate with the specified alias
   *
   * @param alias the alias for the entry
   * @param key the key to set
   * @param password the password to protect the entry with
   * @param chain the certificate chain to set
   * @throws Exception if an error occurs setting the key
   * @throws java.security.AccessControlException if the calling module does
   *         not have the necessary KeyStorePermission.
   */
  void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws Exception;
}
