/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

/**
 * This interface indicates that the implementing {@link
 * javax.baja.security.AuthenticationException AuthenticationException}
 * is meant to report its cause back to the user.
 *
 * <p>This should only be used when reporting the cause will not introduce
 * a security risk.</p>
 *
 * @author Melanie Coggan
 * @creation 2015-05-22
 * @since Niagara 4.0
 */
public interface ReportCauseAuthenticationException
{
  String getCauseMessage();
}
