/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

/**
 * DigestFactory provides the standard interface used
 * to convert credentials into a digest.
 *
 * @author    Brian Frank
 * @creation  8 Jun 04
 * @version   $Revision: 3$ $Date: 11/12/10 4:06:49 PM EST$
 * @since     Baja 1.0
 */
public interface DigestFactory
{
  
  /**
   * Given the specified username and password, build an
   * application specific digest.  Typically this is an MD5
   * message digest of a string composed of the username
   * password, and an application specific nonce.
   */
  public byte[] makeDigest(String username, String password);
    
  public byte[] getNonce();
}
