/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.security.SecureRandom;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.nre.security.NullAlgorithmBundle;
import com.tridium.nre.security.SecretChars;

/**
 * Password encoder for BPassword.DEFAULT, whose validate() method always returns false.
 *
 * @author Matt Boon
 * @creation February 18, 2015
 * @since Niagara 4.0
 */
@NiagaraType(
  agent = @AgentOn(
    types = "baja:Password"
  )
)
public final class BNullPasswordEncoder
  extends BAbstractPasswordEncoder
  implements BIAgent
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BNullPasswordEncoder(2040504243)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BNullPasswordEncoder.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BNullPasswordEncoder()
  {
  super();
  }

////////////////////////////////////////////////////////////////
// Utility
////////////////////////////////////////////////////////////////

  /**
   * Convenience for getting the encoded value of BPassword.DEFAULT
   */
  public static String getEncodedDefaultPassword()
  {
    return ALGORITHM_BUNDLE.encode(null);
  }

////////////////////////////////////////////////////////////////
// BAbstractPasswordEncoder
////////////////////////////////////////////////////////////////

  @Override
  public boolean isReversible()
  {
    return false;
  }

  /**
   * Takes a password and encodes it. The encoding will depend on the
   * particular subclass of BAbstractPasswordEncoder.
   *
   * @throws Exception
   */
  @Override
  public void encode(SecretChars password) throws Exception
  {
    if (password.get().length > 0)
    {
      throw new IllegalArgumentException("Null password encoder should not be used with nonempty passwords");
    }
  }

  /**
   * Takes an encoded string and parses it to instantiate the encoder.
   * The string should be in the format returned by getEncodedValue().
   *
   * @throws IllegalArgumentException
   * @throws Exception
   */
  @Override
  public void parse(String key) throws Exception
  {
  }

  /**
   * Returns random nonsense.
   *
   * @throws Exception
   */
  @Override
  public String getValue() throws Exception
  {
    try (SecretChars secretChars = getSecretChars())
    {
      return new String(secretChars.get());
    }
  }

  @Override
  public SecretChars getSecretChars() throws Exception
  {
    byte[] val = new byte[16];
    new SecureRandom().nextBytes(val);
    return SecretChars.fromString(ByteArrayUtil.toHexString(val));
  }

  /**
   * Returns a String describing the encoding type.
   */
  @Override
  public String getEncodingType()
  {
    return ENCODING_TYPE;
  }

  /**
   * Validates that the provided String "password" corresponds to the
   * encoded password.
   *
   * @throws Exception
   */
  @Override
  public boolean validate(SecretChars password) throws Exception
  {
    return false;
  }

  /**
   * Returns an encoded string describing the password. This should included
   * the encrypted/hashed password and any public data associated with it
   * (e.g. the salt, or initialization vector).
   */
  @Override
  public String getEncodedValue()
  {
    return "";
  }

////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final NullAlgorithmBundle ALGORITHM_BUNDLE = NullAlgorithmBundle.getInstance();
  public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
}
