/*
 * Copyright 2018 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A SeedInfo file for ClientCert Authentication. Contains Session information
 * along with UsernameCredentials.
 *
 * @author Ashutosh Chaturvedi
 * @creation 11 July 2018
 * @since Niagara 4.7
 */
@NiagaraType(
  agent = @AgentOn(
    types = "baja:ClientCredentials"
  )
)
@NiagaraProperty(
  name = "certificateAlias",
  type = "BString",
  defaultValue = "BString.DEFAULT",
  flags = Flags.READONLY
)
/*
 The server certificate password for the servlet to use for signing.
 @since Niagara 4.14
 */
@NiagaraProperty(
  name = "certificatePassword",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT",
  facets = {
    @Facet(name = "BFacets.FIELD_EDITOR", value = "BString.make(\"workbench:DefaultPasswordFE\")"),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "BString.make(\"webEditors:DefaultPasswordEditor\")"),
    @Facet(name = "BPassword.PLACEHOLDER_TEXT", value = "\"%lexicon(workbench:default.password.placeholder.label)%\""),
    @Facet("BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")
  }
)
@NiagaraProperty(
  name = "username",
  type = "BString",
  defaultValue = "BString.DEFAULT",
  flags = Flags.READONLY
)
public class BCertificateAliasCredential
  extends BStruct
  implements BIPreconnectCredentials, BIAgent, BIDeferOwnership
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BCertificateAliasCredential(1183797733)1.0$ @*/
/* Generated Mon Jan 22 16:29:04 EST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "certificateAlias"

  /**
   * Slot for the {@code certificateAlias} property.
   * @see #getCertificateAlias
   * @see #setCertificateAlias
   */
  @Generated
  public static final Property certificateAlias = newProperty(Flags.READONLY, BString.DEFAULT, null);

  /**
   * Get the {@code certificateAlias} property.
   * @see #certificateAlias
   */
  @Generated
  public String getCertificateAlias() { return getString(certificateAlias); }

  /**
   * Set the {@code certificateAlias} property.
   * @see #certificateAlias
   */
  @Generated
  public void setCertificateAlias(String v) { setString(certificateAlias, v, null); }

  //endregion Property "certificateAlias"

  //region Property "certificatePassword"

  /**
   * Slot for the {@code certificatePassword} property.
   * The server certificate password for the servlet to use for signing.
   * @since Niagara 4.14
   * @see #getCertificatePassword
   * @see #setCertificatePassword
   */
  @Generated
  public static final Property certificatePassword = newProperty(0, BPassword.DEFAULT, BFacets.make(BFacets.make(BFacets.make(BFacets.make(BFacets.FIELD_EDITOR, BString.make("workbench:DefaultPasswordFE")), BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make("webEditors:DefaultPasswordEditor"))), BFacets.make(BPassword.PLACEHOLDER_TEXT, "%lexicon(workbench:default.password.placeholder.label)%")), BFacets.make(BFacets.SECURITY, BBoolean.TRUE)));

  /**
   * Get the {@code certificatePassword} property.
   * The server certificate password for the servlet to use for signing.
   * @since Niagara 4.14
   * @see #certificatePassword
   */
  @Generated
  public BPassword getCertificatePassword() { return (BPassword)get(certificatePassword); }

  /**
   * Set the {@code certificatePassword} property.
   * The server certificate password for the servlet to use for signing.
   * @since Niagara 4.14
   * @see #certificatePassword
   */
  @Generated
  public void setCertificatePassword(BPassword v) { set(certificatePassword, v, null); }

  //endregion Property "certificatePassword"

  //region Property "username"

  /**
   * Slot for the {@code username} property.
   * @see #getUsername
   * @see #setUsername
   */
  @Generated
  public static final Property username = newProperty(Flags.READONLY, BString.DEFAULT, null);

  /**
   * Get the {@code username} property.
   * @see #username
   */
  @Generated
  public String getUsername() { return getString(username); }

  /**
   * Set the {@code username} property.
   * @see #username
   */
  @Generated
  public void setUsername(String v) { setString(username, v, null); }

  //endregion Property "username"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BCertificateAliasCredential.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Encode the credentials into a byte array which
   * may stored in a credential database.
   *
   * @param context
   */
  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    BString.make(getCertificateAlias()).encode(out);
    getCertificatePassword().encode(out, context);
    out.flush();
    return bout.toByteArray();
  }

  /**
   * Decode into a new instance of BICredentials from a
   * byte array generated using encode().
   *
   * @param encoding
   * @param context
   */
  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BCertificateAliasCredential x = new BCertificateAliasCredential();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    x.set(certificateAlias, (BValue)BString.DEFAULT.decode(in));
    try
    {
      x.set(certificatePassword, (BValue)BPassword.DEFAULT.decode(in, context));
    }
    /**
     * When decoding credentials from an older version (4.13 and earlier), the encoded credentials will not contain
     * a password and will throw an EOF exception. In this case, use BPassword.DEFAULT to use the global default password.
     */
    catch (EOFException e)
    {
      x.set(certificatePassword, BPassword.DEFAULT);
    }
    return x;
  }

}
