/*
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.nre.security.AesAlgorithmBundle;
import com.tridium.nre.security.EncryptionAlgorithmBundle;

/**
 * AES-CBC password encoder to be used for legacy support.
 * New passwords should use BAes256PasswordEncoder
 *
 * @author Patrick Sager on 1/13/2020
 * @since Niagara 4.9
 */
@NiagaraType(
  agent = @AgentOn(
    types = "baja:Password"
  )
)
public class BAes256CbcPasswordEncoder
  extends BAes256PasswordEncoder
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BAes256CbcPasswordEncoder(2040504243)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BAes256CbcPasswordEncoder.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public String getEncodingType()
  {
    return ENCODING_TYPE;
  }

  @Override
  protected EncryptionAlgorithmBundle getAlgorithmBundle()
  {
    return ALGORITHM_BUNDLE;
  }

////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////
  public static final AesAlgorithmBundle ALGORITHM_BUNDLE = AesAlgorithmBundle.make(256, "1");
  public static final String ENCODING_TYPE = ALGORITHM_BUNDLE.getAlgorithmName();
}
