/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.virtual;

import java.util.logging.Logger;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetDate;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetOptionalBinaryLightingPv;
import javax.baja.bacnet.datatypes.BBacnetOptionalBinaryPv;
import javax.baja.bacnet.datatypes.BBacnetOptionalBitString;
import javax.baja.bacnet.datatypes.BBacnetOptionalCharacterString;
import javax.baja.bacnet.datatypes.BBacnetOptionalDate;
import javax.baja.bacnet.datatypes.BBacnetOptionalDatePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalDateTime;
import javax.baja.bacnet.datatypes.BBacnetOptionalDateTimePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalDoorValue;
import javax.baja.bacnet.datatypes.BBacnetOptionalDouble;
import javax.baja.bacnet.datatypes.BBacnetOptionalInteger;
import javax.baja.bacnet.datatypes.BBacnetOptionalOctetString;
import javax.baja.bacnet.datatypes.BBacnetOptionalReal;
import javax.baja.bacnet.datatypes.BBacnetOptionalTime;
import javax.baja.bacnet.datatypes.BBacnetOptionalTimePattern;
import javax.baja.bacnet.datatypes.BBacnetOptionalUnsigned;
import javax.baja.bacnet.datatypes.BBacnetTime;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnUtil;

@NiagaraType
public class BVirtualPropertyWrite
  extends BAction
  implements BacnetConst
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.virtual.BVirtualPropertyWrite(2979906276)1.0$ @*/
/* Generated Thu Dec 16 19:44:32 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BVirtualPropertyWrite.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BVirtualPropertyWrite()
  {
  }

  /**
   * Get the default parameter to use for the
   * action, or null if the action takes no
   * arguments.
   */
  public BValue getParameterDefault()
  {
    BBacnetVirtualProperty property = (BBacnetVirtualProperty)getParent();
    BBacnetVirtualObject object = property.object();
    BValue value = property.getValue();
    if (object.getPrioritizedPoint() && property.getPropertyId() == BBacnetPropertyIdentifier.PRESENT_VALUE)
    {
      int objectType = object.getObjectId().getObjectType();
      return makePriorityValue(objectType, value);
    }
    else
    {
      return property.getValue().newCopy();
    }
  }

  private static BValue makePriorityValue(int objectType, BValue presentValue)
  {
    switch (objectType)
    {
      case BBacnetObjectType.ANALOG_OUTPUT:
      case BBacnetObjectType.ANALOG_VALUE:
      case BBacnetObjectType.LIGHTING_OUTPUT:
        return new BBacnetOptionalReal(((BFloat)presentValue).getFloat());

      case BBacnetObjectType.BINARY_OUTPUT:
      case BBacnetObjectType.BINARY_VALUE:
        return new BBacnetOptionalBinaryPv((BBacnetBinaryPv)presentValue);

      case BBacnetObjectType.MULTI_STATE_OUTPUT:
      case BBacnetObjectType.MULTI_STATE_VALUE:
      case BBacnetObjectType.POSITIVE_INTEGER_VALUE:
        return new BBacnetOptionalUnsigned((BBacnetUnsigned)presentValue);

      case BBacnetObjectType.CHARACTER_STRING_VALUE:
        return new BBacnetOptionalCharacterString(((BString)presentValue).getString());

      case BBacnetObjectType.BITSTRING_VALUE:
        return new BBacnetOptionalBitString((BBacnetBitString)presentValue);

      case BBacnetObjectType.OCTET_STRING_VALUE:
        return new BBacnetOptionalOctetString((BBacnetOctetString)presentValue);

      case BBacnetObjectType.LARGE_ANALOG_VALUE:
        return new BBacnetOptionalDouble(((BDouble)presentValue).getDouble());

      case BBacnetObjectType.INTEGER_VALUE:
        return new BBacnetOptionalInteger(((BInteger)presentValue).getInt());

      case BBacnetObjectType.DATE_VALUE:
        return new BBacnetOptionalDate(((BBacnetDate)presentValue).toBDate());

      case BBacnetObjectType.DATE_PATTERN_VALUE:
        return new BBacnetOptionalDatePattern((BBacnetDate)presentValue);

      case BBacnetObjectType.TIME_VALUE:
        return new BBacnetOptionalTime(((BBacnetTime)presentValue).toBTime());

      case BBacnetObjectType.TIME_PATTERN_VALUE:
        return new BBacnetOptionalTimePattern((BBacnetTime)presentValue);

      case BBacnetObjectType.DATE_TIME_VALUE:
        return new BBacnetOptionalDateTime(((BBacnetDateTime)presentValue).toBAbsTime());

      case BBacnetObjectType.DATE_TIME_PATTERN_VALUE:
        return new BBacnetOptionalDateTimePattern(((BBacnetDateTime)presentValue.newCopy()));

      case BBacnetObjectType.ACCESS_DOOR:
        return new BBacnetOptionalDoorValue((BBacnetDoorValue)presentValue);

      case BBacnetObjectType.BINARY_LIGHTING_OUTPUT:
        return new BBacnetOptionalBinaryLightingPv((BBacnetBinaryLightingPv)presentValue);
    }

    throw new IllegalArgumentException(
      "Object type not supported when making priority value for present value property: " + BBacnetObjectType.tag(objectType));
  }

  /**
   * Get the parameter type for the action, or
   * if the action takes no arguments return null.
   */
  public Type getParameterType()
  {
    BBacnetVirtualProperty bvp = (BBacnetVirtualProperty)getParent();
    return bvp.getValue().getType();
  }

  /**
   * Get the return type for the action, or
   * null if the action doesn't return a value.
   */
  public Type getReturnType()
  {
    return null;
  }

  /**
   * Invoke the action on the specified target with
   * given argument array.
   */
  public BValue invoke(BComponent target, BValue arg)
    throws Exception
  {
    BBacnetVirtualProperty bvp = (BBacnetVirtualProperty)target;
    BValue currentValue = bvp.getValue();
    boolean audit = bvp.auditWrites();

    // Determine which type of write this is.
    if (bvp.object().getPrioritizedPoint() &&
        (bvp.getPropertyId() == BBacnetPropertyIdentifier.PRESENT_VALUE ||
         bvp.getPropertyId() == BBacnetPropertyIdentifier.VALUE_SOURCE))
    {
      // Prioritized write to a commandable point.
      byte[] encodedValue = AsnUtil.toAsn(arg);
      bvp.write(NOT_USED, encodedValue, bvp.object().getWritePriority());
    }
    else
    {
      // Non-command write.
      if (!currentValue.equals(arg))
      {
        // First we need to check if the value is an array.  These writes need
        // to be handled differently depending on whether the argument is the
        // full array or just one element.
        if (bvp.getValue() instanceof BBacnetArray)
        {
          if (arg instanceof BBacnetArray)
          {
            // Compare the current array and the argument array and manually
            // issue writes for the differences.
            BBacnetArray cur = (BBacnetArray)currentValue;
            BBacnetArray nue = (BBacnetArray)arg;

            // Start with the last element and work towards the first.  This
            // is so that in the case of a priority array, the highest priority
            // command will take effect and prevent the lower-priority commands
            // from causing rapid changes in the output as each higher priority
            // command takes effect.
            int len = nue.getSize();
            for (int i = 1; i <= len; i++)
            {
              if (!cur.getElement(i).equivalent(nue.getElement(i)))
              {
                // write this element
                bvp.write(i, AsnUtil.toAsn(nue.getElement(i)), NOT_USED);
              }
            }

            // Now set the virtual property value with the noWrite context
            // since we've already performed the BACnet write.
            bvp.setValue(nue, noWrite);
          }
          else
          {
            // This is a write of one element of an array, so the individual
            // array index configured on the virtual property needs to be 
            // used in the write request.
            int index = bvp.getArrayIndex();
            bvp.write(index, AsnUtil.toAsn(arg), NOT_USED);
          }
        }
        else
        {
          // Regular non-array case.  The property change will generate its
          // own audit event, so we do not need to generate one.
          bvp.setValue(arg);
          audit = false;
        }
      }
      else
      {
        // Re-write the same value.
        byte[] encodedValue = AsnUtil.toAsn(arg);
        bvp.write(NOT_USED, encodedValue, NOT_USED);
      }
    }

    // Now create an audit log entry if needed.
    if (audit)
    {
      AuditEvent event = new AuditEvent(AuditEvent.CHANGED,
        bvp.getAuditName(), "value",
        currentValue.toString(),
        arg.toString(),
        "");
      try
      {
        Auditor a = Sys.getAuditor();
        a.audit(event);
      }
      catch (ServiceNotFoundException e)
      {
        logger.info("Could not find AuditHistoryService to log audit event:" + event);
      }
    }
    return null;
  }

  private static final Logger logger = Logger.getLogger("bacnet.virtual");
}
