/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.ErrorType;

import com.tridium.bacnet.asn.NErrorType;

/**
 * Thrown when validating BBacnetNetworkPortDescriptor pending changes and used to populate the
 * Command_Validation_Result property of that descriptor.
 *
 * @author Eric Anderson on 12 Jan 2024
 * @since Niagara 4.15
 */
public class ValidateChangesException
  extends BacnetException
{
  public ValidateChangesException(
    BBacnetErrorClass errorClass,
    BBacnetErrorCode errorCode,
    BBacnetPropertyIdentifier property,
    String details)
  {
    super(details);
    this.error = new NErrorType(errorClass, errorCode);
    this.property = property;
    this.details = details;
  }

  public ValidateChangesException(
    BBacnetErrorClass errorClass,
    BBacnetErrorCode errorCode,
    BBacnetPropertyIdentifier property,
    String details,
    Throwable cause)
  {
    super(details, cause);
    this.error = new NErrorType(errorClass, errorCode);
    this.property = property;
    this.details = details;
  }

  public ErrorType getError()
  {
    return error;
  }

  public BBacnetPropertyIdentifier getProperty()
  {
    return property;
  }

  public String getDetails()
  {
    return details;
  }

  private final ErrorType error;
  private final BBacnetPropertyIdentifier property;
  private final String details;
}
