/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;

@NiagaraType
public class BBacnetNetworkPortPendingChanges
  extends BComponent
  implements IPropertyValidator
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.export.BBacnetNetworkPortPendingChanges(2979906276)1.0$ @*/
/* Generated Fri Nov 01 13:17:34 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNetworkPortPendingChanges.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context)
  {
    super.checkAdd(name, value, flags, facets, context);

    if (isRunning())
    {
      validateSetPendingChange(name, value, context);
    }
  }

  @Override
  public void checkRename(Property property, String newName, Context context)
  {
    super.checkRename(property, newName, context);

    if (isRunning())
    {
      validateSetPendingChange(newName, get(property), context);
    }
  }

  @Override
  public IPropertyValidator getPropertyValidator(Property[] properties, Context context)
  {
    return isRunning() ? this : null;
  }

  @Override
  public IPropertyValidator getPropertyValidator(Property property, Context context)
  {
    return isRunning() ? this : null;
  }

  @Override
  public void validateSet(Validatable validatable, Context context)
  {
    for (Property property : validatable.getModifiedProperties())
    {
      validateSetPendingChange(property.getName(), validatable.getProposedValue(property), context);
    }
  }

  @Override
  public void validateSet(BComplex instance, Property property, BValue newValue, Context context)
  {
    validateSetPendingChange(property.getName(), newValue, context);
  }

  private void validateSetPendingChange(String name, BValue value, Context context)
  {
    ((BBacnetNetworkPortDescriptor)getParent()).validateSetPendingChange(name, value, context);
  }
}
