/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import java.util.Vector;

import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;

/**
 * BBacnetLargeAnalogValueDescriptor exposes a ControlPoint as a writable (non-commandable) Bacnet
 * Analog Value Object.
 *
 * @author Craig Gemmill on 19 Feb 02
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType(
  agent = @AgentOn(
    types = "control:NumericWritable"
  )
)
/*
 objectId is the identifier by which this point is known
 to the Bacnet world.
 */
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.LARGE_ANALOG_VALUE)",
  flags = Flags.DEFAULT_ON_CLONE,
  override = true
)
public class BBacnetLargeAnalogValuePrioritizedDescriptor
  extends BBacnetAnalogWritableDescriptor
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.export.BBacnetLargeAnalogValuePrioritizedDescriptor(3691200386)1.0$ @*/
/* Generated Thu Jun 02 14:30:02 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * objectId is the identifier by which this point is known
   * to the Bacnet world.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.DEFAULT_ON_CLONE, BBacnetObjectIdentifier.make(BBacnetObjectType.LARGE_ANALOG_VALUE), null);

  //endregion Property "objectId"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetLargeAnalogValuePrioritizedDescriptor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  @Override
  public int asnType()
  {
    return ASN_DOUBLE;
  }

  @Override
  public byte[] convertToAsn(double value)
  {
    return AsnUtil.toAsnDouble(value);
  }

  @Override
  public byte[] convertToAsn(BValue value)
  {
    return AsnUtil.toAsnDouble(((BNumber) value).getDouble());
  }

  @Override
  public double convertFromAsn(byte[] value)
    throws AsnException
  {
    return AsnUtil.fromAsnDouble(value);
  }

  /**
   * @param out   asn.1 byte stream to append the numeric value
   * @param value asn.1 byte array containing a number
   */
  @Override
  public void appendToAsn(AsnOutputStream out, double value)
  {
    out.writeDouble(value);
  }

  @Override
  public void writeAsnPriorityValue(AsnOutput out, BValue value)
  {
    out.writeDouble(((BNumber) value).getDouble());
  }

  /**
   * @param in   asn.1 byte stream to read the numeric value from
   * @throws AsnException if an unexpected ASN_TYPE is encountered
   */
  @Override
  public double readFromAsn(AsnInputStream in)
    throws AsnException
  {
    return in.readDouble();
  }

  @Override
  protected BValue readAsnPriorityValue(AsnInput in, BControlPoint point)
    throws AsnException
  {
    return BDouble.make(in.readDouble());
  }

  /**
   * Subclass override method to add required properties.
   * outOfService property is required for AnalogPointDescriptor but not for LargeAnalogValue commendable
   * Remove those optional properties from required
   *
   * @param v Vector containing required propertyIds.
   */
  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  protected void addRequiredProps(Vector v)
  {
    v.add(BBacnetPropertyIdentifier.presentValue);
    v.add(BBacnetPropertyIdentifier.statusFlags);
    v.add(BBacnetPropertyIdentifier.units);
  }

  /**
   * Subclass override method to add optional properties.
   * NOTE: You MUST call super.addOptionalProps(v) first!
   * @param v Vector containing optional propertyIds.
   */
  @Override
  @SuppressWarnings("rawtypes")
  protected void addOptionalProps(Vector v)
  {
    addPrioritizedValueObjectOptionalProps(v);
  }

 /**
   * @param s
   * @return the appropriate slot facets.
   */
  @Override
  public final BFacets getSlotFacets(Slot s)
  {
    if (s == objectId)
    {
      return BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.LARGE_ANALOG_VALUE);
    }

    return super.getSlotFacets(s);
  }

  /**
   * Read the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @return a PropertyValue containing either the encoded value or the error.
   */
  @Override
  protected PropertyValue readOptionalProperty(int pId, int ndx)
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getHighLimit()));
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getLowLimit()));
        }
        break;
      }
    }
    return super.readOptionalProperty(pId, ndx);
  }

  /**
   * Set the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  @Override
  protected ErrorType writeOptionalProperty(
    int pId,
    int ndx,
    byte[] val,
    int pri)
      throws BacnetException
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.highLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.lowLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }
    }
    return super.writeOptionalProperty(pId, ndx, val, pri);
  }
}
