/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import static javax.baja.bacnet.enums.BBacnetErrorClass.property;
import static javax.baja.bacnet.enums.BBacnetErrorCode.writeAccessDenied;
import static javax.baja.bacnet.export.BacnetDescriptorUtil.makeConstructedReadResult;
import static javax.baja.bacnet.export.BacnetDescriptorUtil.readArray;

import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetAddress;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetTimeStamp;
import javax.baja.bacnet.datatypes.BBacnetValueSource;
import javax.baja.bacnet.enums.BBacnetErrorClass;
import javax.baja.bacnet.enums.BBacnetErrorCode;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.asn.NReadPropertyResult;

/**
 * BBacnetBinaryWritableDescriptor exposes a ControlPoint as a
 * commandable binary point.  It is the superclass for Binary Output
 * and commandable Binary Value points.
 *
 * @author Craig Gemmill on 19 Feb 02
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType
@NiagaraProperty(
  name = "bacnetWritable",
  type = "String",
  defaultValue = "BBacnetPointDescriptor.lexNotWritable",
  flags = Flags.READONLY | Flags.HIDDEN
)
/*
 @since Niagara 4.15
 */
@NiagaraProperty(
  name = "valueSourceArray",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetValueSource.TYPE, 16)",
  flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT
)
/*
 @since Niagara 4.15
 */
@NiagaraProperty(
  name = "lastCommandTime",
  type = "BBacnetTimeStamp",
  defaultValue = "new BBacnetTimeStamp(new BBacnetDateTime())",
  flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT
)
/*
 @since Niagara 4.15
 */
@NiagaraProperty(
  name = "commandTimeArray",
  type = "BBacnetArray",
  defaultValue = "makeEmptyCommandTimeArray()",
  flags = Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT
)
abstract public class BBacnetBinaryWritableDescriptor
  extends BBacnetBinaryPointDescriptor
  implements BacnetWritableDescriptor
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.export.BBacnetBinaryWritableDescriptor(2014467452)1.0$ @*/
/* Generated Tue Oct 22 12:09:24 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "bacnetWritable"

  /**
   * Slot for the {@code bacnetWritable} property.
   * @see #getBacnetWritable
   * @see #setBacnetWritable
   */
  @Generated
  public static final Property bacnetWritable = newProperty(Flags.READONLY | Flags.HIDDEN, BBacnetPointDescriptor.lexNotWritable, null);

  /**
   * Get the {@code bacnetWritable} property.
   * @see #bacnetWritable
   */
  @Generated
  public String getBacnetWritable() { return getString(bacnetWritable); }

  /**
   * Set the {@code bacnetWritable} property.
   * @see #bacnetWritable
   */
  @Generated
  public void setBacnetWritable(String v) { setString(bacnetWritable, v, null); }

  //endregion Property "bacnetWritable"

  //region Property "valueSourceArray"

  /**
   * Slot for the {@code valueSourceArray} property.
   * @since Niagara 4.15
   * @see #getValueSourceArray
   * @see #setValueSourceArray
   */
  @Generated
  public static final Property valueSourceArray = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT, new BBacnetArray(BBacnetValueSource.TYPE, 16), null);

  /**
   * Get the {@code valueSourceArray} property.
   * @since Niagara 4.15
   * @see #valueSourceArray
   */
  @Generated
  public BBacnetArray getValueSourceArray() { return (BBacnetArray)get(valueSourceArray); }

  /**
   * Set the {@code valueSourceArray} property.
   * @since Niagara 4.15
   * @see #valueSourceArray
   */
  @Generated
  public void setValueSourceArray(BBacnetArray v) { set(valueSourceArray, v, null); }

  //endregion Property "valueSourceArray"

  //region Property "lastCommandTime"

  /**
   * Slot for the {@code lastCommandTime} property.
   * @since Niagara 4.15
   * @see #getLastCommandTime
   * @see #setLastCommandTime
   */
  @Generated
  public static final Property lastCommandTime = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT, new BBacnetTimeStamp(new BBacnetDateTime()), null);

  /**
   * Get the {@code lastCommandTime} property.
   * @since Niagara 4.15
   * @see #lastCommandTime
   */
  @Generated
  public BBacnetTimeStamp getLastCommandTime() { return (BBacnetTimeStamp)get(lastCommandTime); }

  /**
   * Set the {@code lastCommandTime} property.
   * @since Niagara 4.15
   * @see #lastCommandTime
   */
  @Generated
  public void setLastCommandTime(BBacnetTimeStamp v) { set(lastCommandTime, v, null); }

  //endregion Property "lastCommandTime"

  //region Property "commandTimeArray"

  /**
   * Slot for the {@code commandTimeArray} property.
   * @since Niagara 4.15
   * @see #getCommandTimeArray
   * @see #setCommandTimeArray
   */
  @Generated
  public static final Property commandTimeArray = newProperty(Flags.READONLY | Flags.DEFAULT_ON_CLONE | Flags.TRANSIENT, makeEmptyCommandTimeArray(), null);

  /**
   * Get the {@code commandTimeArray} property.
   * @since Niagara 4.15
   * @see #commandTimeArray
   */
  @Generated
  public BBacnetArray getCommandTimeArray() { return (BBacnetArray)get(commandTimeArray); }

  /**
   * Set the {@code commandTimeArray} property.
   * @since Niagara 4.15
   * @see #commandTimeArray
   */
  @Generated
  public void setCommandTimeArray(BBacnetArray v) { set(commandTimeArray, v, null); }

  //endregion Property "commandTimeArray"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetBinaryWritableDescriptor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////
  
  /*
   * Started.
   * 2005-07-25 CPG Keep the code in here, but commented.
   * This change clears the values from all of the BACnet inputs
   * on startup, so the values effectively do not persist, but
   * the slots themselves persist.
  public void started()
    throws Exception
  {
    super.started();
    String inSlotName = null;
    Property inSlot = null;
    BStatusBoolean bacval = new BStatusBoolean();
    bacval.setStatusNull(true);
    loadSlots();
    for (int pri=1; pri<=16; pri++)
    {
      inSlotName = "bacnetValueIn"+pri;
      inSlot = getProperty(inSlotName);
      if (inSlot != null) set(inSlot, bacval.newCopy(), null);
    }
  }
   */

  /**
   * BBacnetBinaryWritableDescriptor may only expose BBooleanWritable.
   *
   * @param pt the exposed point
   * @return true if the Niagara point type is legal for this point type.
   */
  @Override
  protected final boolean isPointTypeLegal(BControlPoint pt)
  {
    return pt instanceof BBooleanWritable;
  }

  /**
   * Is this export descriptor representing a BACnet object
   * with a Commandable Present_Value property (per the Clause 19
   * prioritization procedure)?<p>
   * Writable descriptors must override this to return true.
   *
   * @return true if commandable, otherwise false
   */
  @Override
  protected boolean isCommandable()
  {
    return true;
  }

  /**
   * Get the value of a property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @return a PropertyValue containing either the encoded value or the error.
   */
  @Override
  protected PropertyValue readProperty(int pId, int ndx)
  {
    BBooleanWritable pt = (BBooleanWritable)getPoint();
    if (pt == null)
    {
      return new NReadPropertyResult(pId, ndx, new NErrorType(BBacnetErrorClass.OBJECT,
                                                              BBacnetErrorCode.TARGET_NOT_CONFIGURED));
    }

    switch (pId)
    {
      case BBacnetPropertyIdentifier.PRIORITY_ARRAY:
        return readPriorityArray(ndx);

      case BBacnetPropertyIdentifier.RELINQUISH_DEFAULT:
        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnEnumerated(pt.getFallback().getValue()));
    }

    return super.readProperty(pId, ndx);
  }

  /**
   * Set the value of a property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  @Override
  protected ErrorType writeProperty(int pId,
                                    int ndx,
                                    byte[] val,
                                    int pri)
    throws BacnetException
  {
    BBooleanWritable pt = (BBooleanWritable)getPoint();
    if (pt == null)
    {
      return new NErrorType(BBacnetErrorClass.OBJECT,
                            BBacnetErrorCode.TARGET_NOT_CONFIGURED);
    }

    // Check for array index on non-array property.
    if (ndx >= 0)
    {
      if (!isArray(pId))
      {
        return new NErrorType(BBacnetErrorClass.PROPERTY,
                              BBacnetErrorCode.PROPERTY_IS_NOT_AN_ARRAY);
      }
    }

    try
    {
      switch (pId)
      {
        case BBacnetPropertyIdentifier.PRIORITY_ARRAY:
          return new NErrorType(BBacnetErrorClass.PROPERTY,
                                BBacnetErrorCode.WRITE_ACCESS_DENIED);

        case BBacnetPropertyIdentifier.RELINQUISH_DEFAULT:
          BStatusBoolean fb = pt.getFallback();
          fb.setBoolean(BStatusBoolean.value,
                        AsnUtil.fromOnlyBinaryPv(val),
                        BLocalBacnetDevice.getBacnetContext());
          fb.setStatusNull(false);
          return null;
      }
    }
    catch (OutOfRangeException e)
    {
      log.warning("OutOfRangeException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.VALUE_OUT_OF_RANGE);
    }
    catch (AsnException e)
    {
      log.warning("AsnException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.INVALID_DATA_TYPE);
    }
    catch (PermissionException e)
    {
      log.warning("PermissionException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.WRITE_ACCESS_DENIED);
    }

    return super.writeProperty(pId, ndx, val, pri);
  }

  /**
   * Set the value of a property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @param sourceAddress the address of the BACnet device that originally sent the write request.
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   * @since Niagara 4.15
   */
  @Override
  protected ErrorType writeProperty(int pId, int ndx, byte[] val, int pri, BBacnetAddress sourceAddress)
    throws BacnetException
  {
    BBooleanWritable pt = (BBooleanWritable)getPoint();
    if (pt == null)
    {
      return new NErrorType(BBacnetErrorClass.OBJECT,
                            BBacnetErrorCode.TARGET_NOT_CONFIGURED);
    }

    // Check for array index on non-array property.
    if (ndx >= 0)
    {
      if (!isArray(pId))
      {
        return new NErrorType(BBacnetErrorClass.PROPERTY,
                              BBacnetErrorCode.PROPERTY_IS_NOT_AN_ARRAY);
      }
    }

    try
    {
      switch (pId)
      {
        case BBacnetPropertyIdentifier.PRESENT_VALUE:
          return writePriorityArray(pri, val, sourceAddress);

        case BBacnetPropertyIdentifier.VALUE_SOURCE:
          return writeValueSource(pri, val, sourceAddress);

        case BBacnetPropertyIdentifier.CURRENT_COMMAND_PRIORITY:
        case BBacnetPropertyIdentifier.VALUE_SOURCE_ARRAY:
        case BBacnetPropertyIdentifier.LAST_COMMAND_TIME:
        case BBacnetPropertyIdentifier.COMMAND_TIME_ARRAY:
          return new NErrorType(property, writeAccessDenied);
      }
    }
    catch (OutOfRangeException e)
    {
      log.warning("OutOfRangeException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.VALUE_OUT_OF_RANGE);
    }
    catch (AsnException e)
    {
      log.warning("AsnException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.INVALID_DATA_TYPE);
    }
    catch (PermissionException e)
    {
      log.warning("PermissionException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.WRITE_ACCESS_DENIED);
    }

    return super.writeProperty(pId, ndx, val, pri, sourceAddress);
  }

  /**
   * Read the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @return a PropertyValue containing either the encoded value or the error.
   */
  @Override
  protected PropertyValue readOptionalProperty(int pId, int ndx)
  {
    BBooleanWritable pt = (BBooleanWritable)getPoint();
    switch (pId)
    {
      case BBacnetPropertyIdentifier.MINIMUM_OFF_TIME:
        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getMinInactiveTime().getMillis() / BRelTime.MILLIS_IN_SECOND));

      case BBacnetPropertyIdentifier.MINIMUM_ON_TIME:
        return new NReadPropertyResult(pId, ndx, AsnUtil.toAsnUnsigned(pt.getMinActiveTime().getMillis() / BRelTime.MILLIS_IN_SECOND));

      case BBacnetPropertyIdentifier.CURRENT_COMMAND_PRIORITY:
        return readCurrentCommandPriority();

      case BBacnetPropertyIdentifier.VALUE_SOURCE:
        return readValueSource(getValueSourceArray());

      case BBacnetPropertyIdentifier.VALUE_SOURCE_ARRAY:
        return readArray(pId, ndx, getValueSourceArray());

      case BBacnetPropertyIdentifier.LAST_COMMAND_TIME:
        return makeConstructedReadResult(BBacnetPropertyIdentifier.lastCommandTime, getLastCommandTime());

      case BBacnetPropertyIdentifier.COMMAND_TIME_ARRAY:
        return readArray(pId, ndx, getCommandTimeArray());
    }

    return super.readOptionalProperty(pId, ndx);
  }

  /**
   * Set the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  @Override
  protected ErrorType writeOptionalProperty(int pId,
                                            int ndx,
                                            byte[] val,
                                            int pri)
    throws BacnetException
  {
    try
    {
      BBooleanWritable pt = (BBooleanWritable)getPoint();
      switch (pId)
      {
        case BBacnetPropertyIdentifier.MINIMUM_OFF_TIME:
          pt.set(BBooleanWritable.minInactiveTime,
                 BRelTime.make(BRelTime.MILLIS_IN_SECOND * AsnUtil.fromAsnUnsignedInteger(val)),
                 BLocalBacnetDevice.getBacnetContext());
          return null;

        case BBacnetPropertyIdentifier.MINIMUM_ON_TIME:
          pt.set(BBooleanWritable.minActiveTime,
                 BRelTime.make(BRelTime.MILLIS_IN_SECOND * AsnUtil.fromAsnUnsignedInteger(val)),
                 BLocalBacnetDevice.getBacnetContext());
          return null;
      }

      return super.writeOptionalProperty(pId, ndx, val, pri);
    }
    catch (AsnException e)
    {
      log.warning("AsnException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.INVALID_DATA_TYPE);
    }
    catch (PermissionException e)
    {
      log.warning("PermissionException writing property " + pId + " in object " + getObjectId() + ": " + e);
      return new NErrorType(BBacnetErrorClass.PROPERTY,
                            BBacnetErrorCode.WRITE_ACCESS_DENIED);
    }
  }

////////////////////////////////////////////////////////////////
// Support
////////////////////////////////////////////////////////////////

  @Override
  protected void writeAsnPriorityValue(AsnOutput out, BValue value)
  {
    out.writeEnumerated(((BIBoolean) value).getBoolean() ? 1 : 0);
  }

  @Override
  protected BValue readAsnPriorityValue(AsnInput in, BControlPoint point)
    throws AsnException
  {
    int ordinal = in.readEnumerated();
    if (ordinal != 0 && ordinal != 1)
    {
      // Out-of-range
      return null;
    }
    return BBoolean.make(ordinal == 1);
  }

  @Override
  protected boolean isPriorityValueOutOfRange(BValue value, BControlPoint point)
  {
    return value == null;
  }

  private void resetBacnetWritable()
  {
    StringBuilder sb = new StringBuilder();
    Knob[] knobs = getKnobs();
    for (int i = 0; i < knobs.length; i++)
    {
      BObject tgt = knobs[i].getTargetOrd().get(this);
      BObject pt = getPoint();
      if (knobs[i].getTargetSlotName().startsWith("in") &&
          tgt == pt)
      {
        sb.append(knobs[i].getTargetSlotName()).append(',');
      }
    }
    setBacnetWritable((sb.length() > 0) ? sb.substring(0, sb.length() - 1) :
                                          lexNotWritable);
  }

  @Override
  public void knobAdded(Knob knob, Context cx)
  {
    resetBacnetWritable();
  }

  @Override
  public void knobRemoved(Knob knob, Context cx)
  {
    resetBacnetWritable();
  }

}
