/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import java.util.Vector;

import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BControlPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.NReadPropertyResult;

/**
 * BBacnetAnalogValuePrioritizedDescriptor exposes a ControlPoint as a writable (non-commandable) Bacnet
 * Analog Value Object.
 *
 * @author Craig Gemmill on 19 Feb 02
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType(
  agent = @AgentOn(
    types = "control:NumericWritable"
  )
)
/*
 objectId is the identifier by which this point is known
 to the Bacnet world.
 */
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_VALUE)",
  flags = Flags.DEFAULT_ON_CLONE,
  override = true
)
public class BBacnetAnalogValuePrioritizedDescriptor
  extends BBacnetAnalogWritableDescriptor
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.export.BBacnetAnalogValuePrioritizedDescriptor(3882925907)1.0$ @*/
/* Generated Thu Jun 02 14:30:02 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * objectId is the identifier by which this point is known
   * to the Bacnet world.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.DEFAULT_ON_CLONE, BBacnetObjectIdentifier.make(BBacnetObjectType.ANALOG_VALUE), null);

  //endregion Property "objectId"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetAnalogValuePrioritizedDescriptor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Get slot facets.
   *
   * @param s
   * @return the appropriate slot facets.
   */
  @Override
  public final BFacets getSlotFacets(Slot s)
  {
    if (s == objectId)
    {
      return BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.ANALOG_VALUE);
    }
    return super.getSlotFacets(s);
  }

  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  protected void addRequiredProps(Vector v)
  {
    v.add(BBacnetPropertyIdentifier.presentValue);
    v.add(BBacnetPropertyIdentifier.statusFlags);
    v.add(BBacnetPropertyIdentifier.eventState);
    v.add(BBacnetPropertyIdentifier.outOfService);
    v.add(BBacnetPropertyIdentifier.units);
  }

  /**
   * Subclass override method to add optional properties.
   * NOTE: You MUST call super.addOptionalProps(v) first!
   *
   * @param v Vector containing optional propertyIds.
   */
  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  protected void addOptionalProps(Vector v)
  {
    v.add(BBacnetPropertyIdentifier.description);
    v.add(BBacnetPropertyIdentifier.reliability);
    v.add(BBacnetPropertyIdentifier.priorityArray);
    v.add(BBacnetPropertyIdentifier.relinquishDefault);

    BControlPoint pt = getPoint();
    BNumber min = (BNumber)pt.getFacets().getFacet(BFacets.MIN);
    if (min != null)
    {
      v.add(BBacnetPropertyIdentifier.minPresValue);
    }
    BNumber max = (BNumber)pt.getFacets().getFacet(BFacets.MAX);
    if (max != null)
    {
      v.add(BBacnetPropertyIdentifier.maxPresValue);
    }
    BNumber prec = (BNumber)pt.getFacets().getFacet(BFacets.PRECISION);
    if (prec != null)
    {
      v.add(BBacnetPropertyIdentifier.resolution);
    }

    v.add(BBacnetPropertyIdentifier.covIncrement);
    v.add(BBacnetPropertyIdentifier.currentCommandPriority);
    v.add(BBacnetPropertyIdentifier.valueSource);
    v.add(BBacnetPropertyIdentifier.valueSourceArray);
    v.add(BBacnetPropertyIdentifier.lastCommandTime);
    v.add(BBacnetPropertyIdentifier.commandTimeArray);

    BAlarmSourceExt alarmExt = getAlarmExt();
    if (alarmExt != null)
    {
      v.add(BBacnetPropertyIdentifier.timeDelay);
      v.add(BBacnetPropertyIdentifier.notificationClass);
      v.add(BBacnetPropertyIdentifier.highLimit);
      v.add(BBacnetPropertyIdentifier.lowLimit);
      v.add(BBacnetPropertyIdentifier.deadband);
      v.add(BBacnetPropertyIdentifier.limitEnable);
      v.add(BBacnetPropertyIdentifier.eventEnable);
      v.add(BBacnetPropertyIdentifier.ackedTransitions);
      v.add(BBacnetPropertyIdentifier.notifyType);
      v.add(BBacnetPropertyIdentifier.eventTimeStamps);
      v.add(BBacnetPropertyIdentifier.eventMessageTexts);
      v.add(BBacnetPropertyIdentifier.eventMessageTextsConfig);
      v.add(BBacnetPropertyIdentifier.eventDetectionEnable);
      v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibitRef);
      v.add(BBacnetPropertyIdentifier.eventAlgorithmInhibit);
      v.add(BBacnetPropertyIdentifier.timeDelayNormal);

      if (alarmExt.getFaultAlgorithm() instanceof BOutOfRangeFaultAlgorithm)
      {
        v.add(BBacnetPropertyIdentifier.faultHighLimit);
        v.add(BBacnetPropertyIdentifier.faultLowLimit);
      }
    }
  }

  /**
   * Read the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @return a PropertyValue containing either the encoded value or the error.
   */
  @Override
  protected PropertyValue readOptionalProperty(int pId, int ndx)
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm) faultAlgorithm).getHighLimit()));
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm) faultAlgorithm).getLowLimit()));
        }
        break;
      }
    }
    return super.readOptionalProperty(pId, ndx);
  }

  /**
   * Set the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  @Override
  protected ErrorType writeOptionalProperty(int pId,
                                            int ndx,
                                            byte[] val,
                                            int pri)
    throws BacnetException
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.highLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.lowLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }
    }

    return super.writeOptionalProperty(pId, ndx, val, pri);
  }
}
