/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the Bacnet Timer Transition enumeration
 * defined in the Change Of Timer Event Algorithm.
 *
 * @author Tim Urenda on Oct. 26, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("none"),
    @Range("idleToRunning"),
    @Range("runningToIdle"),
    @Range("runningToRunning"),
    @Range("runningToExpired"),
    @Range("forcedToExpired"),
    @Range("expiredToIdle"),
    @Range("expiredToRunning")
  }
)
public final class BBacnetTimerTransition
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetTimerTransition(1927436812)1.0$ @*/
/* Generated Thu Oct 26 09:19:31 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for none. */
  @Generated
  public static final int NONE = 0;
  /** Ordinal value for idleToRunning. */
  @Generated
  public static final int IDLE_TO_RUNNING = 1;
  /** Ordinal value for runningToIdle. */
  @Generated
  public static final int RUNNING_TO_IDLE = 2;
  /** Ordinal value for runningToRunning. */
  @Generated
  public static final int RUNNING_TO_RUNNING = 3;
  /** Ordinal value for runningToExpired. */
  @Generated
  public static final int RUNNING_TO_EXPIRED = 4;
  /** Ordinal value for forcedToExpired. */
  @Generated
  public static final int FORCED_TO_EXPIRED = 5;
  /** Ordinal value for expiredToIdle. */
  @Generated
  public static final int EXPIRED_TO_IDLE = 6;
  /** Ordinal value for expiredToRunning. */
  @Generated
  public static final int EXPIRED_TO_RUNNING = 7;

  /** BBacnetTimerTransition constant for none. */
  @Generated
  public static final BBacnetTimerTransition none = new BBacnetTimerTransition(NONE);
  /** BBacnetTimerTransition constant for idleToRunning. */
  @Generated
  public static final BBacnetTimerTransition idleToRunning = new BBacnetTimerTransition(IDLE_TO_RUNNING);
  /** BBacnetTimerTransition constant for runningToIdle. */
  @Generated
  public static final BBacnetTimerTransition runningToIdle = new BBacnetTimerTransition(RUNNING_TO_IDLE);
  /** BBacnetTimerTransition constant for runningToRunning. */
  @Generated
  public static final BBacnetTimerTransition runningToRunning = new BBacnetTimerTransition(RUNNING_TO_RUNNING);
  /** BBacnetTimerTransition constant for runningToExpired. */
  @Generated
  public static final BBacnetTimerTransition runningToExpired = new BBacnetTimerTransition(RUNNING_TO_EXPIRED);
  /** BBacnetTimerTransition constant for forcedToExpired. */
  @Generated
  public static final BBacnetTimerTransition forcedToExpired = new BBacnetTimerTransition(FORCED_TO_EXPIRED);
  /** BBacnetTimerTransition constant for expiredToIdle. */
  @Generated
  public static final BBacnetTimerTransition expiredToIdle = new BBacnetTimerTransition(EXPIRED_TO_IDLE);
  /** BBacnetTimerTransition constant for expiredToRunning. */
  @Generated
  public static final BBacnetTimerTransition expiredToRunning = new BBacnetTimerTransition(EXPIRED_TO_RUNNING);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetTimerTransition make(int ordinal)
  {
    return (BBacnetTimerTransition)none.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetTimerTransition make(String tag)
  {
    return (BBacnetTimerTransition)none.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetTimerTransition(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetTimerTransition DEFAULT = none;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetTimerTransition.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  //region Static methods

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  //endregion
}
