/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the Bacnet Timer State enumeration
 * defined in the Change Of Timer Event Algorithm.
 *
 * @author Tim Urenda on Oct. 26, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("idle"),
    @Range("running"),
    @Range("expired")
  }
)
public final class BBacnetTimerState
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetTimerState(2494858319)1.0$ @*/
/* Generated Thu Oct 26 09:12:04 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for idle. */
  @Generated
  public static final int IDLE = 0;
  /** Ordinal value for running. */
  @Generated
  public static final int RUNNING = 1;
  /** Ordinal value for expired. */
  @Generated
  public static final int EXPIRED = 2;

  /** BBacnetTimerState constant for idle. */
  @Generated
  public static final BBacnetTimerState idle = new BBacnetTimerState(IDLE);
  /** BBacnetTimerState constant for running. */
  @Generated
  public static final BBacnetTimerState running = new BBacnetTimerState(RUNNING);
  /** BBacnetTimerState constant for expired. */
  @Generated
  public static final BBacnetTimerState expired = new BBacnetTimerState(EXPIRED);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetTimerState make(int ordinal)
  {
    return (BBacnetTimerState)idle.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetTimerState make(String tag)
  {
    return (BBacnetTimerState)idle.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetTimerState(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetTimerState DEFAULT = idle;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetTimerState.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  //region Static methods

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  //endregion
}
