/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author Bishal Debbarma on 17 November 2023
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("acknowledgeAlarm"),
    @Range("confirmedCovNotification"),
    @Range("confirmedEventNotification"),
    @Range("getAlarmSummary"),
    @Range("getEnrollmentSummary"),
    @Range("subscribeCov"),
    @Range("atomicReadFile"),
    @Range("atomicWriteFile"),
    @Range("addListElement"),
    @Range("removeListElement"),
    @Range("createObject"),
    @Range("deleteObject"),
    @Range("readProperty"),
    @Range("readPropertyConditional"),
    @Range("readPropertyMultiple"),
    @Range("writeProperty"),
    @Range("writePropertyMultiple"),
    @Range("deviceCommunicationControl"),
    @Range("confirmedPrivateTransfer"),
    @Range("confirmedTextMessage"),
    @Range("reinitializeDevice"),
    @Range("vtOpen"),
    @Range("vtClose"),
    @Range("vtData"),
    @Range("authenticate"),
    @Range("requestKey"),
    @Range("iAm"),
    @Range("iHave"),
    @Range("unconfirmedCovNotification"),
    @Range("unconfirmedEventNotification"),
    @Range("unconfirmedPrivateTransfer"),
    @Range("unconfirmedTextMessage"),
    @Range("timeSynchronization"),
    @Range("whoHas"),
    @Range("whoIs"),
    @Range("readRange"),
    @Range("utcTimeSynchronization"),
    @Range("lifeSafetyOperation"),
    @Range("subscribeCovProperty"),
    @Range("getEventInformation"),
    @Range("writeGroup"),
    @Range("subscribeCovPropertyMultiple"),
    @Range("confirmedCovNotificationMultiple"),
    @Range("unconfirmedCovNotificationMultiple")
  },
  defaultValue = "acknowledgeAlarm"
)
public final class BBacnetServicesSupported extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetServicesSupported(1766295406)1.0$ @*/
/* Generated Sun Oct 27 17:42:13 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for acknowledgeAlarm. */
  @Generated
  public static final int ACKNOWLEDGE_ALARM = 0;
  /** Ordinal value for confirmedCovNotification. */
  @Generated
  public static final int CONFIRMED_COV_NOTIFICATION = 1;
  /** Ordinal value for confirmedEventNotification. */
  @Generated
  public static final int CONFIRMED_EVENT_NOTIFICATION = 2;
  /** Ordinal value for getAlarmSummary. */
  @Generated
  public static final int GET_ALARM_SUMMARY = 3;
  /** Ordinal value for getEnrollmentSummary. */
  @Generated
  public static final int GET_ENROLLMENT_SUMMARY = 4;
  /** Ordinal value for subscribeCov. */
  @Generated
  public static final int SUBSCRIBE_COV = 5;
  /** Ordinal value for atomicReadFile. */
  @Generated
  public static final int ATOMIC_READ_FILE = 6;
  /** Ordinal value for atomicWriteFile. */
  @Generated
  public static final int ATOMIC_WRITE_FILE = 7;
  /** Ordinal value for addListElement. */
  @Generated
  public static final int ADD_LIST_ELEMENT = 8;
  /** Ordinal value for removeListElement. */
  @Generated
  public static final int REMOVE_LIST_ELEMENT = 9;
  /** Ordinal value for createObject. */
  @Generated
  public static final int CREATE_OBJECT = 10;
  /** Ordinal value for deleteObject. */
  @Generated
  public static final int DELETE_OBJECT = 11;
  /** Ordinal value for readProperty. */
  @Generated
  public static final int READ_PROPERTY = 12;
  /** Ordinal value for readPropertyConditional. */
  @Generated
  public static final int READ_PROPERTY_CONDITIONAL = 13;
  /** Ordinal value for readPropertyMultiple. */
  @Generated
  public static final int READ_PROPERTY_MULTIPLE = 14;
  /** Ordinal value for writeProperty. */
  @Generated
  public static final int WRITE_PROPERTY = 15;
  /** Ordinal value for writePropertyMultiple. */
  @Generated
  public static final int WRITE_PROPERTY_MULTIPLE = 16;
  /** Ordinal value for deviceCommunicationControl. */
  @Generated
  public static final int DEVICE_COMMUNICATION_CONTROL = 17;
  /** Ordinal value for confirmedPrivateTransfer. */
  @Generated
  public static final int CONFIRMED_PRIVATE_TRANSFER = 18;
  /** Ordinal value for confirmedTextMessage. */
  @Generated
  public static final int CONFIRMED_TEXT_MESSAGE = 19;
  /** Ordinal value for reinitializeDevice. */
  @Generated
  public static final int REINITIALIZE_DEVICE = 20;
  /** Ordinal value for vtOpen. */
  @Generated
  public static final int VT_OPEN = 21;
  /** Ordinal value for vtClose. */
  @Generated
  public static final int VT_CLOSE = 22;
  /** Ordinal value for vtData. */
  @Generated
  public static final int VT_DATA = 23;
  /** Ordinal value for authenticate. */
  @Generated
  public static final int AUTHENTICATE = 24;
  /** Ordinal value for requestKey. */
  @Generated
  public static final int REQUEST_KEY = 25;
  /** Ordinal value for iAm. */
  @Generated
  public static final int I_AM = 26;
  /** Ordinal value for iHave. */
  @Generated
  public static final int I_HAVE = 27;
  /** Ordinal value for unconfirmedCovNotification. */
  @Generated
  public static final int UNCONFIRMED_COV_NOTIFICATION = 28;
  /** Ordinal value for unconfirmedEventNotification. */
  @Generated
  public static final int UNCONFIRMED_EVENT_NOTIFICATION = 29;
  /** Ordinal value for unconfirmedPrivateTransfer. */
  @Generated
  public static final int UNCONFIRMED_PRIVATE_TRANSFER = 30;
  /** Ordinal value for unconfirmedTextMessage. */
  @Generated
  public static final int UNCONFIRMED_TEXT_MESSAGE = 31;
  /** Ordinal value for timeSynchronization. */
  @Generated
  public static final int TIME_SYNCHRONIZATION = 32;
  /** Ordinal value for whoHas. */
  @Generated
  public static final int WHO_HAS = 33;
  /** Ordinal value for whoIs. */
  @Generated
  public static final int WHO_IS = 34;
  /** Ordinal value for readRange. */
  @Generated
  public static final int READ_RANGE = 35;
  /** Ordinal value for utcTimeSynchronization. */
  @Generated
  public static final int UTC_TIME_SYNCHRONIZATION = 36;
  /** Ordinal value for lifeSafetyOperation. */
  @Generated
  public static final int LIFE_SAFETY_OPERATION = 37;
  /** Ordinal value for subscribeCovProperty. */
  @Generated
  public static final int SUBSCRIBE_COV_PROPERTY = 38;
  /** Ordinal value for getEventInformation. */
  @Generated
  public static final int GET_EVENT_INFORMATION = 39;
  /** Ordinal value for writeGroup. */
  @Generated
  public static final int WRITE_GROUP = 40;
  /** Ordinal value for subscribeCovPropertyMultiple. */
  @Generated
  public static final int SUBSCRIBE_COV_PROPERTY_MULTIPLE = 41;
  /** Ordinal value for confirmedCovNotificationMultiple. */
  @Generated
  public static final int CONFIRMED_COV_NOTIFICATION_MULTIPLE = 42;
  /** Ordinal value for unconfirmedCovNotificationMultiple. */
  @Generated
  public static final int UNCONFIRMED_COV_NOTIFICATION_MULTIPLE = 43;

  /** BBacnetServicesSupported constant for acknowledgeAlarm. */
  @Generated
  public static final BBacnetServicesSupported acknowledgeAlarm = new BBacnetServicesSupported(ACKNOWLEDGE_ALARM);
  /** BBacnetServicesSupported constant for confirmedCovNotification. */
  @Generated
  public static final BBacnetServicesSupported confirmedCovNotification = new BBacnetServicesSupported(CONFIRMED_COV_NOTIFICATION);
  /** BBacnetServicesSupported constant for confirmedEventNotification. */
  @Generated
  public static final BBacnetServicesSupported confirmedEventNotification = new BBacnetServicesSupported(CONFIRMED_EVENT_NOTIFICATION);
  /** BBacnetServicesSupported constant for getAlarmSummary. */
  @Generated
  public static final BBacnetServicesSupported getAlarmSummary = new BBacnetServicesSupported(GET_ALARM_SUMMARY);
  /** BBacnetServicesSupported constant for getEnrollmentSummary. */
  @Generated
  public static final BBacnetServicesSupported getEnrollmentSummary = new BBacnetServicesSupported(GET_ENROLLMENT_SUMMARY);
  /** BBacnetServicesSupported constant for subscribeCov. */
  @Generated
  public static final BBacnetServicesSupported subscribeCov = new BBacnetServicesSupported(SUBSCRIBE_COV);
  /** BBacnetServicesSupported constant for atomicReadFile. */
  @Generated
  public static final BBacnetServicesSupported atomicReadFile = new BBacnetServicesSupported(ATOMIC_READ_FILE);
  /** BBacnetServicesSupported constant for atomicWriteFile. */
  @Generated
  public static final BBacnetServicesSupported atomicWriteFile = new BBacnetServicesSupported(ATOMIC_WRITE_FILE);
  /** BBacnetServicesSupported constant for addListElement. */
  @Generated
  public static final BBacnetServicesSupported addListElement = new BBacnetServicesSupported(ADD_LIST_ELEMENT);
  /** BBacnetServicesSupported constant for removeListElement. */
  @Generated
  public static final BBacnetServicesSupported removeListElement = new BBacnetServicesSupported(REMOVE_LIST_ELEMENT);
  /** BBacnetServicesSupported constant for createObject. */
  @Generated
  public static final BBacnetServicesSupported createObject = new BBacnetServicesSupported(CREATE_OBJECT);
  /** BBacnetServicesSupported constant for deleteObject. */
  @Generated
  public static final BBacnetServicesSupported deleteObject = new BBacnetServicesSupported(DELETE_OBJECT);
  /** BBacnetServicesSupported constant for readProperty. */
  @Generated
  public static final BBacnetServicesSupported readProperty = new BBacnetServicesSupported(READ_PROPERTY);
  /** BBacnetServicesSupported constant for readPropertyConditional. */
  @Generated
  public static final BBacnetServicesSupported readPropertyConditional = new BBacnetServicesSupported(READ_PROPERTY_CONDITIONAL);
  /** BBacnetServicesSupported constant for readPropertyMultiple. */
  @Generated
  public static final BBacnetServicesSupported readPropertyMultiple = new BBacnetServicesSupported(READ_PROPERTY_MULTIPLE);
  /** BBacnetServicesSupported constant for writeProperty. */
  @Generated
  public static final BBacnetServicesSupported writeProperty = new BBacnetServicesSupported(WRITE_PROPERTY);
  /** BBacnetServicesSupported constant for writePropertyMultiple. */
  @Generated
  public static final BBacnetServicesSupported writePropertyMultiple = new BBacnetServicesSupported(WRITE_PROPERTY_MULTIPLE);
  /** BBacnetServicesSupported constant for deviceCommunicationControl. */
  @Generated
  public static final BBacnetServicesSupported deviceCommunicationControl = new BBacnetServicesSupported(DEVICE_COMMUNICATION_CONTROL);
  /** BBacnetServicesSupported constant for confirmedPrivateTransfer. */
  @Generated
  public static final BBacnetServicesSupported confirmedPrivateTransfer = new BBacnetServicesSupported(CONFIRMED_PRIVATE_TRANSFER);
  /** BBacnetServicesSupported constant for confirmedTextMessage. */
  @Generated
  public static final BBacnetServicesSupported confirmedTextMessage = new BBacnetServicesSupported(CONFIRMED_TEXT_MESSAGE);
  /** BBacnetServicesSupported constant for reinitializeDevice. */
  @Generated
  public static final BBacnetServicesSupported reinitializeDevice = new BBacnetServicesSupported(REINITIALIZE_DEVICE);
  /** BBacnetServicesSupported constant for vtOpen. */
  @Generated
  public static final BBacnetServicesSupported vtOpen = new BBacnetServicesSupported(VT_OPEN);
  /** BBacnetServicesSupported constant for vtClose. */
  @Generated
  public static final BBacnetServicesSupported vtClose = new BBacnetServicesSupported(VT_CLOSE);
  /** BBacnetServicesSupported constant for vtData. */
  @Generated
  public static final BBacnetServicesSupported vtData = new BBacnetServicesSupported(VT_DATA);
  /** BBacnetServicesSupported constant for authenticate. */
  @Generated
  public static final BBacnetServicesSupported authenticate = new BBacnetServicesSupported(AUTHENTICATE);
  /** BBacnetServicesSupported constant for requestKey. */
  @Generated
  public static final BBacnetServicesSupported requestKey = new BBacnetServicesSupported(REQUEST_KEY);
  /** BBacnetServicesSupported constant for iAm. */
  @Generated
  public static final BBacnetServicesSupported iAm = new BBacnetServicesSupported(I_AM);
  /** BBacnetServicesSupported constant for iHave. */
  @Generated
  public static final BBacnetServicesSupported iHave = new BBacnetServicesSupported(I_HAVE);
  /** BBacnetServicesSupported constant for unconfirmedCovNotification. */
  @Generated
  public static final BBacnetServicesSupported unconfirmedCovNotification = new BBacnetServicesSupported(UNCONFIRMED_COV_NOTIFICATION);
  /** BBacnetServicesSupported constant for unconfirmedEventNotification. */
  @Generated
  public static final BBacnetServicesSupported unconfirmedEventNotification = new BBacnetServicesSupported(UNCONFIRMED_EVENT_NOTIFICATION);
  /** BBacnetServicesSupported constant for unconfirmedPrivateTransfer. */
  @Generated
  public static final BBacnetServicesSupported unconfirmedPrivateTransfer = new BBacnetServicesSupported(UNCONFIRMED_PRIVATE_TRANSFER);
  /** BBacnetServicesSupported constant for unconfirmedTextMessage. */
  @Generated
  public static final BBacnetServicesSupported unconfirmedTextMessage = new BBacnetServicesSupported(UNCONFIRMED_TEXT_MESSAGE);
  /** BBacnetServicesSupported constant for timeSynchronization. */
  @Generated
  public static final BBacnetServicesSupported timeSynchronization = new BBacnetServicesSupported(TIME_SYNCHRONIZATION);
  /** BBacnetServicesSupported constant for whoHas. */
  @Generated
  public static final BBacnetServicesSupported whoHas = new BBacnetServicesSupported(WHO_HAS);
  /** BBacnetServicesSupported constant for whoIs. */
  @Generated
  public static final BBacnetServicesSupported whoIs = new BBacnetServicesSupported(WHO_IS);
  /** BBacnetServicesSupported constant for readRange. */
  @Generated
  public static final BBacnetServicesSupported readRange = new BBacnetServicesSupported(READ_RANGE);
  /** BBacnetServicesSupported constant for utcTimeSynchronization. */
  @Generated
  public static final BBacnetServicesSupported utcTimeSynchronization = new BBacnetServicesSupported(UTC_TIME_SYNCHRONIZATION);
  /** BBacnetServicesSupported constant for lifeSafetyOperation. */
  @Generated
  public static final BBacnetServicesSupported lifeSafetyOperation = new BBacnetServicesSupported(LIFE_SAFETY_OPERATION);
  /** BBacnetServicesSupported constant for subscribeCovProperty. */
  @Generated
  public static final BBacnetServicesSupported subscribeCovProperty = new BBacnetServicesSupported(SUBSCRIBE_COV_PROPERTY);
  /** BBacnetServicesSupported constant for getEventInformation. */
  @Generated
  public static final BBacnetServicesSupported getEventInformation = new BBacnetServicesSupported(GET_EVENT_INFORMATION);
  /** BBacnetServicesSupported constant for writeGroup. */
  @Generated
  public static final BBacnetServicesSupported writeGroup = new BBacnetServicesSupported(WRITE_GROUP);
  /** BBacnetServicesSupported constant for subscribeCovPropertyMultiple. */
  @Generated
  public static final BBacnetServicesSupported subscribeCovPropertyMultiple = new BBacnetServicesSupported(SUBSCRIBE_COV_PROPERTY_MULTIPLE);
  /** BBacnetServicesSupported constant for confirmedCovNotificationMultiple. */
  @Generated
  public static final BBacnetServicesSupported confirmedCovNotificationMultiple = new BBacnetServicesSupported(CONFIRMED_COV_NOTIFICATION_MULTIPLE);
  /** BBacnetServicesSupported constant for unconfirmedCovNotificationMultiple. */
  @Generated
  public static final BBacnetServicesSupported unconfirmedCovNotificationMultiple = new BBacnetServicesSupported(UNCONFIRMED_COV_NOTIFICATION_MULTIPLE);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetServicesSupported make(int ordinal)
  {
    return (BBacnetServicesSupported)acknowledgeAlarm.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetServicesSupported make(String tag)
  {
    return (BBacnetServicesSupported)acknowledgeAlarm.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetServicesSupported(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetServicesSupported DEFAULT = acknowledgeAlarm;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetServicesSupported.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
