/*
 * Copyright 2020, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Implementation of BACnetSCConnectionState.
 * See 12.56.Y16 SC_Hub_Function_Connection_Status
 * @author M Swainston on 6/5/2020
 * @since Niagara 4.11
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range(value = "notConnected", ordinal = 0),
    @Range(value = "connected", ordinal = 1),
    @Range(value = "disconnectedWithErrors", ordinal = 2),
    @Range(value = "failedToConnect", ordinal = 3)
  },
  defaultValue = "notConnected"
)
public final class BBacnetScConnectionState extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetScConnectionState(186001650)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  /** Ordinal value for notConnected. */
  @Generated
  public static final int NOT_CONNECTED = 0;
  /** Ordinal value for connected. */
  @Generated
  public static final int CONNECTED = 1;
  /** Ordinal value for disconnectedWithErrors. */
  @Generated
  public static final int DISCONNECTED_WITH_ERRORS = 2;
  /** Ordinal value for failedToConnect. */
  @Generated
  public static final int FAILED_TO_CONNECT = 3;

  /** BBacnetScConnectionState constant for notConnected. */
  @Generated
  public static final BBacnetScConnectionState notConnected = new BBacnetScConnectionState(NOT_CONNECTED);
  /** BBacnetScConnectionState constant for connected. */
  @Generated
  public static final BBacnetScConnectionState connected = new BBacnetScConnectionState(CONNECTED);
  /** BBacnetScConnectionState constant for disconnectedWithErrors. */
  @Generated
  public static final BBacnetScConnectionState disconnectedWithErrors = new BBacnetScConnectionState(DISCONNECTED_WITH_ERRORS);
  /** BBacnetScConnectionState constant for failedToConnect. */
  @Generated
  public static final BBacnetScConnectionState failedToConnect = new BBacnetScConnectionState(FAILED_TO_CONNECT);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetScConnectionState make(int ordinal)
  {
    return (BBacnetScConnectionState)notConnected.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetScConnectionState make(String tag)
  {
    return (BBacnetScConnectionState)notConnected.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetScConnectionState(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetScConnectionState DEFAULT = notConnected;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetScConnectionState.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
