/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetRouterStatus represents the status enumerated field in BACnetRouterEntry (represented by
 * BBacnetRoutingTableEntry in Niagara).
 *
 * @author Uday Rapuru on 05-May-2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("available"),
    @Range("busy"),
    @Range("disconnected")
  }
)
public final class BBacnetRouterStatus
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetRouterStatus(3374943877)1.0$ @*/
/* Generated Mon May 06 14:47:12 IST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for available. */
  @Generated
  public static final int AVAILABLE = 0;
  /** Ordinal value for busy. */
  @Generated
  public static final int BUSY = 1;
  /** Ordinal value for disconnected. */
  @Generated
  public static final int DISCONNECTED = 2;

  /** BBacnetRouterStatus constant for available. */
  @Generated
  public static final BBacnetRouterStatus available = new BBacnetRouterStatus(AVAILABLE);
  /** BBacnetRouterStatus constant for busy. */
  @Generated
  public static final BBacnetRouterStatus busy = new BBacnetRouterStatus(BUSY);
  /** BBacnetRouterStatus constant for disconnected. */
  @Generated
  public static final BBacnetRouterStatus disconnected = new BBacnetRouterStatus(DISCONNECTED);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetRouterStatus make(int ordinal)
  {
    return (BBacnetRouterStatus)available.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetRouterStatus make(String tag)
  {
    return (BBacnetRouterStatus)available.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetRouterStatus(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetRouterStatus DEFAULT = available;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetRouterStatus.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
