/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetProtocolLevel represents the BACnetProtocolLevel enumeration.
 *
 * @author Uday Rapuru on 26-Sep-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("physical"),
    @Range("protocol"),
    @Range("bacnetApplication"),
    @Range("nonBacnetApplication")
  }
)
public final class BBacnetProtocolLevel
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetProtocolLevel(4024612271)1.0$ @*/
/* Generated Tue Sep 26 10:27:47 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for physical. */
  @Generated
  public static final int PHYSICAL = 0;
  /** Ordinal value for protocol. */
  @Generated
  public static final int PROTOCOL = 1;
  /** Ordinal value for bacnetApplication. */
  @Generated
  public static final int BACNET_APPLICATION = 2;
  /** Ordinal value for nonBacnetApplication. */
  @Generated
  public static final int NON_BACNET_APPLICATION = 3;

  /** BBacnetProtocolLevel constant for physical. */
  @Generated
  public static final BBacnetProtocolLevel physical = new BBacnetProtocolLevel(PHYSICAL);
  /** BBacnetProtocolLevel constant for protocol. */
  @Generated
  public static final BBacnetProtocolLevel protocol = new BBacnetProtocolLevel(PROTOCOL);
  /** BBacnetProtocolLevel constant for bacnetApplication. */
  @Generated
  public static final BBacnetProtocolLevel bacnetApplication = new BBacnetProtocolLevel(BACNET_APPLICATION);
  /** BBacnetProtocolLevel constant for nonBacnetApplication. */
  @Generated
  public static final BBacnetProtocolLevel nonBacnetApplication = new BBacnetProtocolLevel(NON_BACNET_APPLICATION);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetProtocolLevel make(int ordinal)
  {
    return (BBacnetProtocolLevel)physical.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetProtocolLevel make(String tag)
  {
    return (BBacnetProtocolLevel)physical.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetProtocolLevel(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetProtocolLevel DEFAULT = physical;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetProtocolLevel.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public String toString(Context context)
  {
    if (BacnetConst.facetsContext.equals(context))
    {
      return getTag();
    }
    return getDisplayTag(context);
  }
}
