/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import java.util.Arrays;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetObjectType represents the BACnetObjectType
 * enumeration.
 * <p>
 * BBacnetObjectType is an "extensible" enumeration.
 * Values 0-127 are reserved for used by ASHRAE.
 * Values from 128-1023 (0x3FF)
 * can be used for proprietary extensions.
 * <p>
 * Note that for proprietary extensions, a given ordinal is not
 * globally mapped to the same enumeration.  Type X from vendor
 * A will be different than type X from vendor B.  Extensions are
 * also not guaranteed unique within a vendor's own products, so
 * type Y in device A from vendor A will in general be different
 * than type Y in device B from vendor A.
 *
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/19/01 4:35:59 PM$
 * @creation 21 Jul 00
 * @since Niagara 3 Bacnet 1.0
 */

@NiagaraType
@NiagaraEnum(
  range = {
    @Range("analogInput"),
    @Range("analogOutput"),
    @Range("analogValue"),
    @Range("binaryInput"),
    @Range("binaryOutput"),
    @Range("binaryValue"),
    @Range("calendar"),
    @Range("command"),
    @Range("device"),
    @Range("eventEnrollment"),
    @Range("file"),
    @Range("group"),
    @Range("loop"),
    @Range("multiStateInput"),
    @Range("multiStateOutput"),
    @Range("notificationClass"),
    @Range("program"),
    @Range("schedule"),
    @Range("averaging"),
    @Range("multiStateValue"),
    @Range("trendLog"),
    @Range("lifeSafetyPoint"),
    @Range("lifeSafetyZone"),
    @Range("accumulator"),
    @Range("pulseConverter"),
    @Range("eventLog"),
    @Range("globalGroup"),
    @Range("trendLogMultiple"),
    @Range("loadControl"),
    @Range("structuredView"),
    @Range("accessDoor"),
    @Range("unassigned31"),
    @Range("accessCredential"),
    @Range("accessPoint"),
    @Range("accessRights"),
    @Range("accessUser"),
    @Range("accessZone"),
    @Range("credentialDataInput"),
    @Range("networkSecurity"),
    @Range("bitstringValue"),
    @Range("characterStringValue"),
    @Range("datePatternValue"),
    @Range("dateValue"),
    @Range("dateTimePatternValue"),
    @Range("dateTimeValue"),
    @Range("integerValue"),
    @Range("largeAnalogValue"),
    @Range("octetStringValue"),
    @Range("positiveIntegerValue"),
    @Range("timePatternValue"),
    @Range("timeValue"),
    @Range("notificationForwarder"),
    @Range("alertEnrollment"),
    @Range("channel"),
    @Range("lightingOutput"),
    @Range("binaryLightingOutput"),
    @Range("networkPort"),
    @Range("elevatorGroup"),
    @Range("escalator"),
    @Range("lift")
  }
)
public final class BBacnetObjectType
  extends BFrozenEnum
  implements BacnetConst
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetObjectType(92922746)1.0$ @*/
/* Generated Fri Sep 27 13:01:41 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for analogInput. */
  @Generated
  public static final int ANALOG_INPUT = 0;
  /** Ordinal value for analogOutput. */
  @Generated
  public static final int ANALOG_OUTPUT = 1;
  /** Ordinal value for analogValue. */
  @Generated
  public static final int ANALOG_VALUE = 2;
  /** Ordinal value for binaryInput. */
  @Generated
  public static final int BINARY_INPUT = 3;
  /** Ordinal value for binaryOutput. */
  @Generated
  public static final int BINARY_OUTPUT = 4;
  /** Ordinal value for binaryValue. */
  @Generated
  public static final int BINARY_VALUE = 5;
  /** Ordinal value for calendar. */
  @Generated
  public static final int CALENDAR = 6;
  /** Ordinal value for command. */
  @Generated
  public static final int COMMAND = 7;
  /** Ordinal value for device. */
  @Generated
  public static final int DEVICE = 8;
  /** Ordinal value for eventEnrollment. */
  @Generated
  public static final int EVENT_ENROLLMENT = 9;
  /** Ordinal value for file. */
  @Generated
  public static final int FILE = 10;
  /** Ordinal value for group. */
  @Generated
  public static final int GROUP = 11;
  /** Ordinal value for loop. */
  @Generated
  public static final int LOOP = 12;
  /** Ordinal value for multiStateInput. */
  @Generated
  public static final int MULTI_STATE_INPUT = 13;
  /** Ordinal value for multiStateOutput. */
  @Generated
  public static final int MULTI_STATE_OUTPUT = 14;
  /** Ordinal value for notificationClass. */
  @Generated
  public static final int NOTIFICATION_CLASS = 15;
  /** Ordinal value for program. */
  @Generated
  public static final int PROGRAM = 16;
  /** Ordinal value for schedule. */
  @Generated
  public static final int SCHEDULE = 17;
  /** Ordinal value for averaging. */
  @Generated
  public static final int AVERAGING = 18;
  /** Ordinal value for multiStateValue. */
  @Generated
  public static final int MULTI_STATE_VALUE = 19;
  /** Ordinal value for trendLog. */
  @Generated
  public static final int TREND_LOG = 20;
  /** Ordinal value for lifeSafetyPoint. */
  @Generated
  public static final int LIFE_SAFETY_POINT = 21;
  /** Ordinal value for lifeSafetyZone. */
  @Generated
  public static final int LIFE_SAFETY_ZONE = 22;
  /** Ordinal value for accumulator. */
  @Generated
  public static final int ACCUMULATOR = 23;
  /** Ordinal value for pulseConverter. */
  @Generated
  public static final int PULSE_CONVERTER = 24;
  /** Ordinal value for eventLog. */
  @Generated
  public static final int EVENT_LOG = 25;
  /** Ordinal value for globalGroup. */
  @Generated
  public static final int GLOBAL_GROUP = 26;
  /** Ordinal value for trendLogMultiple. */
  @Generated
  public static final int TREND_LOG_MULTIPLE = 27;
  /** Ordinal value for loadControl. */
  @Generated
  public static final int LOAD_CONTROL = 28;
  /** Ordinal value for structuredView. */
  @Generated
  public static final int STRUCTURED_VIEW = 29;
  /** Ordinal value for accessDoor. */
  @Generated
  public static final int ACCESS_DOOR = 30;
  /** Ordinal value for unassigned31. */
  @Generated
  public static final int UNASSIGNED_31 = 31;
  /** Ordinal value for accessCredential. */
  @Generated
  public static final int ACCESS_CREDENTIAL = 32;
  /** Ordinal value for accessPoint. */
  @Generated
  public static final int ACCESS_POINT = 33;
  /** Ordinal value for accessRights. */
  @Generated
  public static final int ACCESS_RIGHTS = 34;
  /** Ordinal value for accessUser. */
  @Generated
  public static final int ACCESS_USER = 35;
  /** Ordinal value for accessZone. */
  @Generated
  public static final int ACCESS_ZONE = 36;
  /** Ordinal value for credentialDataInput. */
  @Generated
  public static final int CREDENTIAL_DATA_INPUT = 37;
  /** Ordinal value for networkSecurity. */
  @Generated
  public static final int NETWORK_SECURITY = 38;
  /** Ordinal value for bitstringValue. */
  @Generated
  public static final int BITSTRING_VALUE = 39;
  /** Ordinal value for characterStringValue. */
  @Generated
  public static final int CHARACTER_STRING_VALUE = 40;
  /** Ordinal value for datePatternValue. */
  @Generated
  public static final int DATE_PATTERN_VALUE = 41;
  /** Ordinal value for dateValue. */
  @Generated
  public static final int DATE_VALUE = 42;
  /** Ordinal value for dateTimePatternValue. */
  @Generated
  public static final int DATE_TIME_PATTERN_VALUE = 43;
  /** Ordinal value for dateTimeValue. */
  @Generated
  public static final int DATE_TIME_VALUE = 44;
  /** Ordinal value for integerValue. */
  @Generated
  public static final int INTEGER_VALUE = 45;
  /** Ordinal value for largeAnalogValue. */
  @Generated
  public static final int LARGE_ANALOG_VALUE = 46;
  /** Ordinal value for octetStringValue. */
  @Generated
  public static final int OCTET_STRING_VALUE = 47;
  /** Ordinal value for positiveIntegerValue. */
  @Generated
  public static final int POSITIVE_INTEGER_VALUE = 48;
  /** Ordinal value for timePatternValue. */
  @Generated
  public static final int TIME_PATTERN_VALUE = 49;
  /** Ordinal value for timeValue. */
  @Generated
  public static final int TIME_VALUE = 50;
  /** Ordinal value for notificationForwarder. */
  @Generated
  public static final int NOTIFICATION_FORWARDER = 51;
  /** Ordinal value for alertEnrollment. */
  @Generated
  public static final int ALERT_ENROLLMENT = 52;
  /** Ordinal value for channel. */
  @Generated
  public static final int CHANNEL = 53;
  /** Ordinal value for lightingOutput. */
  @Generated
  public static final int LIGHTING_OUTPUT = 54;
  /** Ordinal value for binaryLightingOutput. */
  @Generated
  public static final int BINARY_LIGHTING_OUTPUT = 55;
  /** Ordinal value for networkPort. */
  @Generated
  public static final int NETWORK_PORT = 56;
  /** Ordinal value for elevatorGroup. */
  @Generated
  public static final int ELEVATOR_GROUP = 57;
  /** Ordinal value for escalator. */
  @Generated
  public static final int ESCALATOR = 58;
  /** Ordinal value for lift. */
  @Generated
  public static final int LIFT = 59;

  /** BBacnetObjectType constant for analogInput. */
  @Generated
  public static final BBacnetObjectType analogInput = new BBacnetObjectType(ANALOG_INPUT);
  /** BBacnetObjectType constant for analogOutput. */
  @Generated
  public static final BBacnetObjectType analogOutput = new BBacnetObjectType(ANALOG_OUTPUT);
  /** BBacnetObjectType constant for analogValue. */
  @Generated
  public static final BBacnetObjectType analogValue = new BBacnetObjectType(ANALOG_VALUE);
  /** BBacnetObjectType constant for binaryInput. */
  @Generated
  public static final BBacnetObjectType binaryInput = new BBacnetObjectType(BINARY_INPUT);
  /** BBacnetObjectType constant for binaryOutput. */
  @Generated
  public static final BBacnetObjectType binaryOutput = new BBacnetObjectType(BINARY_OUTPUT);
  /** BBacnetObjectType constant for binaryValue. */
  @Generated
  public static final BBacnetObjectType binaryValue = new BBacnetObjectType(BINARY_VALUE);
  /** BBacnetObjectType constant for calendar. */
  @Generated
  public static final BBacnetObjectType calendar = new BBacnetObjectType(CALENDAR);
  /** BBacnetObjectType constant for command. */
  @Generated
  public static final BBacnetObjectType command = new BBacnetObjectType(COMMAND);
  /** BBacnetObjectType constant for device. */
  @Generated
  public static final BBacnetObjectType device = new BBacnetObjectType(DEVICE);
  /** BBacnetObjectType constant for eventEnrollment. */
  @Generated
  public static final BBacnetObjectType eventEnrollment = new BBacnetObjectType(EVENT_ENROLLMENT);
  /** BBacnetObjectType constant for file. */
  @Generated
  public static final BBacnetObjectType file = new BBacnetObjectType(FILE);
  /** BBacnetObjectType constant for group. */
  @Generated
  public static final BBacnetObjectType group = new BBacnetObjectType(GROUP);
  /** BBacnetObjectType constant for loop. */
  @Generated
  public static final BBacnetObjectType loop = new BBacnetObjectType(LOOP);
  /** BBacnetObjectType constant for multiStateInput. */
  @Generated
  public static final BBacnetObjectType multiStateInput = new BBacnetObjectType(MULTI_STATE_INPUT);
  /** BBacnetObjectType constant for multiStateOutput. */
  @Generated
  public static final BBacnetObjectType multiStateOutput = new BBacnetObjectType(MULTI_STATE_OUTPUT);
  /** BBacnetObjectType constant for notificationClass. */
  @Generated
  public static final BBacnetObjectType notificationClass = new BBacnetObjectType(NOTIFICATION_CLASS);
  /** BBacnetObjectType constant for program. */
  @Generated
  public static final BBacnetObjectType program = new BBacnetObjectType(PROGRAM);
  /** BBacnetObjectType constant for schedule. */
  @Generated
  public static final BBacnetObjectType schedule = new BBacnetObjectType(SCHEDULE);
  /** BBacnetObjectType constant for averaging. */
  @Generated
  public static final BBacnetObjectType averaging = new BBacnetObjectType(AVERAGING);
  /** BBacnetObjectType constant for multiStateValue. */
  @Generated
  public static final BBacnetObjectType multiStateValue = new BBacnetObjectType(MULTI_STATE_VALUE);
  /** BBacnetObjectType constant for trendLog. */
  @Generated
  public static final BBacnetObjectType trendLog = new BBacnetObjectType(TREND_LOG);
  /** BBacnetObjectType constant for lifeSafetyPoint. */
  @Generated
  public static final BBacnetObjectType lifeSafetyPoint = new BBacnetObjectType(LIFE_SAFETY_POINT);
  /** BBacnetObjectType constant for lifeSafetyZone. */
  @Generated
  public static final BBacnetObjectType lifeSafetyZone = new BBacnetObjectType(LIFE_SAFETY_ZONE);
  /** BBacnetObjectType constant for accumulator. */
  @Generated
  public static final BBacnetObjectType accumulator = new BBacnetObjectType(ACCUMULATOR);
  /** BBacnetObjectType constant for pulseConverter. */
  @Generated
  public static final BBacnetObjectType pulseConverter = new BBacnetObjectType(PULSE_CONVERTER);
  /** BBacnetObjectType constant for eventLog. */
  @Generated
  public static final BBacnetObjectType eventLog = new BBacnetObjectType(EVENT_LOG);
  /** BBacnetObjectType constant for globalGroup. */
  @Generated
  public static final BBacnetObjectType globalGroup = new BBacnetObjectType(GLOBAL_GROUP);
  /** BBacnetObjectType constant for trendLogMultiple. */
  @Generated
  public static final BBacnetObjectType trendLogMultiple = new BBacnetObjectType(TREND_LOG_MULTIPLE);
  /** BBacnetObjectType constant for loadControl. */
  @Generated
  public static final BBacnetObjectType loadControl = new BBacnetObjectType(LOAD_CONTROL);
  /** BBacnetObjectType constant for structuredView. */
  @Generated
  public static final BBacnetObjectType structuredView = new BBacnetObjectType(STRUCTURED_VIEW);
  /** BBacnetObjectType constant for accessDoor. */
  @Generated
  public static final BBacnetObjectType accessDoor = new BBacnetObjectType(ACCESS_DOOR);
  /** BBacnetObjectType constant for unassigned31. */
  @Generated
  public static final BBacnetObjectType unassigned31 = new BBacnetObjectType(UNASSIGNED_31);
  /** BBacnetObjectType constant for accessCredential. */
  @Generated
  public static final BBacnetObjectType accessCredential = new BBacnetObjectType(ACCESS_CREDENTIAL);
  /** BBacnetObjectType constant for accessPoint. */
  @Generated
  public static final BBacnetObjectType accessPoint = new BBacnetObjectType(ACCESS_POINT);
  /** BBacnetObjectType constant for accessRights. */
  @Generated
  public static final BBacnetObjectType accessRights = new BBacnetObjectType(ACCESS_RIGHTS);
  /** BBacnetObjectType constant for accessUser. */
  @Generated
  public static final BBacnetObjectType accessUser = new BBacnetObjectType(ACCESS_USER);
  /** BBacnetObjectType constant for accessZone. */
  @Generated
  public static final BBacnetObjectType accessZone = new BBacnetObjectType(ACCESS_ZONE);
  /** BBacnetObjectType constant for credentialDataInput. */
  @Generated
  public static final BBacnetObjectType credentialDataInput = new BBacnetObjectType(CREDENTIAL_DATA_INPUT);
  /** BBacnetObjectType constant for networkSecurity. */
  @Generated
  public static final BBacnetObjectType networkSecurity = new BBacnetObjectType(NETWORK_SECURITY);
  /** BBacnetObjectType constant for bitstringValue. */
  @Generated
  public static final BBacnetObjectType bitstringValue = new BBacnetObjectType(BITSTRING_VALUE);
  /** BBacnetObjectType constant for characterStringValue. */
  @Generated
  public static final BBacnetObjectType characterStringValue = new BBacnetObjectType(CHARACTER_STRING_VALUE);
  /** BBacnetObjectType constant for datePatternValue. */
  @Generated
  public static final BBacnetObjectType datePatternValue = new BBacnetObjectType(DATE_PATTERN_VALUE);
  /** BBacnetObjectType constant for dateValue. */
  @Generated
  public static final BBacnetObjectType dateValue = new BBacnetObjectType(DATE_VALUE);
  /** BBacnetObjectType constant for dateTimePatternValue. */
  @Generated
  public static final BBacnetObjectType dateTimePatternValue = new BBacnetObjectType(DATE_TIME_PATTERN_VALUE);
  /** BBacnetObjectType constant for dateTimeValue. */
  @Generated
  public static final BBacnetObjectType dateTimeValue = new BBacnetObjectType(DATE_TIME_VALUE);
  /** BBacnetObjectType constant for integerValue. */
  @Generated
  public static final BBacnetObjectType integerValue = new BBacnetObjectType(INTEGER_VALUE);
  /** BBacnetObjectType constant for largeAnalogValue. */
  @Generated
  public static final BBacnetObjectType largeAnalogValue = new BBacnetObjectType(LARGE_ANALOG_VALUE);
  /** BBacnetObjectType constant for octetStringValue. */
  @Generated
  public static final BBacnetObjectType octetStringValue = new BBacnetObjectType(OCTET_STRING_VALUE);
  /** BBacnetObjectType constant for positiveIntegerValue. */
  @Generated
  public static final BBacnetObjectType positiveIntegerValue = new BBacnetObjectType(POSITIVE_INTEGER_VALUE);
  /** BBacnetObjectType constant for timePatternValue. */
  @Generated
  public static final BBacnetObjectType timePatternValue = new BBacnetObjectType(TIME_PATTERN_VALUE);
  /** BBacnetObjectType constant for timeValue. */
  @Generated
  public static final BBacnetObjectType timeValue = new BBacnetObjectType(TIME_VALUE);
  /** BBacnetObjectType constant for notificationForwarder. */
  @Generated
  public static final BBacnetObjectType notificationForwarder = new BBacnetObjectType(NOTIFICATION_FORWARDER);
  /** BBacnetObjectType constant for alertEnrollment. */
  @Generated
  public static final BBacnetObjectType alertEnrollment = new BBacnetObjectType(ALERT_ENROLLMENT);
  /** BBacnetObjectType constant for channel. */
  @Generated
  public static final BBacnetObjectType channel = new BBacnetObjectType(CHANNEL);
  /** BBacnetObjectType constant for lightingOutput. */
  @Generated
  public static final BBacnetObjectType lightingOutput = new BBacnetObjectType(LIGHTING_OUTPUT);
  /** BBacnetObjectType constant for binaryLightingOutput. */
  @Generated
  public static final BBacnetObjectType binaryLightingOutput = new BBacnetObjectType(BINARY_LIGHTING_OUTPUT);
  /** BBacnetObjectType constant for networkPort. */
  @Generated
  public static final BBacnetObjectType networkPort = new BBacnetObjectType(NETWORK_PORT);
  /** BBacnetObjectType constant for elevatorGroup. */
  @Generated
  public static final BBacnetObjectType elevatorGroup = new BBacnetObjectType(ELEVATOR_GROUP);
  /** BBacnetObjectType constant for escalator. */
  @Generated
  public static final BBacnetObjectType escalator = new BBacnetObjectType(ESCALATOR);
  /** BBacnetObjectType constant for lift. */
  @Generated
  public static final BBacnetObjectType lift = new BBacnetObjectType(LIFT);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetObjectType make(int ordinal)
  {
    return (BBacnetObjectType)analogInput.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetObjectType make(String tag)
  {
    return (BBacnetObjectType)analogInput.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetObjectType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetObjectType DEFAULT = analogInput;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetObjectType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final int MAX_ASHRAE_ID = LIFT;
  public static final int MAX_RESERVED_ID = 127;
  public static final int MAX_ID = 1023;

  private static final String INVALID_OBJECT_TYPE = "INVALID";

////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @param id the integer enumeration value.
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    if (DEFAULT.getRange().isOrdinal(id))
    {
      return DEFAULT.getRange().getTag(id);
    }
    if (isAshrae(id))
    {
      return ASHRAE_PREFIX + id;
    }
    if (isProprietary(id))
    {
      return PROPRIETARY_PREFIX + id;
    }
    return INVALID_OBJECT_TYPE + ':' + id;
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag)
  {
    try
    {
      return DEFAULT.getRange().tagToOrdinal(tag);
    }
    catch (InvalidEnumException e)
    {
      if (tag.startsWith(ASHRAE_PREFIX))
      {
        return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
      }
      if (tag.startsWith(PROPRIETARY_PREFIX))
      {
        return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
      }
      if (tag.startsWith(INVALID_OBJECT_TYPE))
      {
        return -1;
      }
      throw e;
    }
  }

  /**
   * Is this a proprietary extension?
   *
   * @return true if this is a proprietary extension.
   */
  public static boolean isProprietary(int id)
  {
    return (id > MAX_RESERVED_ID) && (id <= MAX_ID);
  }

  /**
   * Is this an ASHRAE extension?
   *
   * @return true if this is an ASHRAE extension.
   */
  public static boolean isAshrae(int id)
  {
    return (id > MAX_ASHRAE_ID) && (id <= MAX_RESERVED_ID);
  }

  /**
   * Is this id valid for this enumeration?
   *
   * @return true if this id is within the allowed range.
   */
  public static boolean isValid(int id)
  {
    return id <= MAX_ID;
  }

  /**
   * Is this id part of the predefined (fixed) range?
   *
   * @return true if this id is in the fixed range.
   */
  public static boolean isFixed(int id)
  {
    return id <= MAX_ASHRAE_ID;
  }

  /**
   * Utility to determine if this is one of the object types
   * with status flags.
   *
   * @param ordinal object type
   * @return true if this object type has status flags.
   * @deprecated Since 3.5 - use {@code hasStatusFlags(int, BBacnetDevice)}
   */
  @Deprecated
  public static boolean hasStatusFlags(int ordinal)
  {
    return hasStatusFlags(ordinal, null);
  }

  /**
   * Utility to determine if this is one of the object types
   * with status flags.
   *
   * @param ordinal object type
   * @param device  the device in which the object resides
   * @return true if this object type has status flags.
   */
  public static boolean hasStatusFlags(int ordinal, BBacnetDevice device)
  {
    int pr = 0;
    if (device != null)
    {
      pr = device.getProtocolRevision();
    }

    return hasStatusFlags(ordinal, pr);
  }

  /**
   * Utility to determine if this is one of the object types
   * with status flags.
   *
   * @param ordinal object type
   * @param pr      of the device in which the object resides
   * @return true if this object type has status flags.
   */
  public static boolean hasStatusFlags(int ordinal, int pr)
  {
    if (ordinal > MAX_ASHRAE_ID)
    {
      return false;
    }

    switch (ordinal)
    {
      case ANALOG_INPUT:
      case ANALOG_OUTPUT:
      case ANALOG_VALUE:
      case BINARY_INPUT:
      case BINARY_OUTPUT:
      case BINARY_VALUE:
      case LOOP:
      case MULTI_STATE_INPUT:
      case MULTI_STATE_OUTPUT:
      case PROGRAM:
        return pr >= 0;

      case MULTI_STATE_VALUE:
        return pr >= 1;

      case LIFE_SAFETY_POINT:
      case LIFE_SAFETY_ZONE:
        return pr >= 2;

      case SCHEDULE:
      case ACCUMULATOR:
      case PULSE_CONVERTER:
        return pr >= 4;

      case LOAD_CONTROL:
      case ACCESS_DOOR:
        return pr >= 6;

      case TREND_LOG:
      case EVENT_LOG:
      case TREND_LOG_MULTIPLE:
        return pr >= 7;

      case ACCESS_CREDENTIAL:
        return pr >= 9;

      case BITSTRING_VALUE:
      case CHARACTER_STRING_VALUE:
      case DATE_PATTERN_VALUE:
      case DATE_VALUE:
      case DATE_TIME_PATTERN_VALUE:
      case DATE_TIME_VALUE:
      case INTEGER_VALUE:
      case LARGE_ANALOG_VALUE:
      case OCTET_STRING_VALUE:
      case POSITIVE_INTEGER_VALUE:
      case TIME_PATTERN_VALUE:
      case TIME_VALUE:
        return pr >= 10;

      case GLOBAL_GROUP:
        return pr >= 11;

      case EVENT_ENROLLMENT:
      case NOTIFICATION_FORWARDER:
        return pr >= 13;

      case CHANNEL:
      case LIGHTING_OUTPUT:
        return pr >= 14;

      case COMMAND:
      case DEVICE:
      case NOTIFICATION_CLASS:
      case BINARY_LIGHTING_OUTPUT:
        return pr >= 16;

      case UNASSIGNED_31:
      case NETWORK_PORT:
        return pr >= 17;

      case ESCALATOR:
      case LIFT:
        return pr >= 18;
    }

    return false;
  }

  /**
   * Utility to determine if this is one of the object types
   * that may support Cov reporting (not Cov-Property).
   *
   * @param ordinal object type
   * @return true if this object type may support Cov reporting.
   * @deprecated Since 3.5 - use {@code canSupportCov(int, BBacnetDevice)}
   */
  @Deprecated
  public static boolean canSupportCov(int ordinal)
  {
    return canSupportCov(ordinal, null);
  }

  /**
   * Utility to determine if this is one of the object types
   * that may support Cov reporting (not Cov-Property).
   *
   * @param ordinal object type
   * @return true if this object type may support Cov reporting.
   */
  public static boolean canSupportCov(int ordinal, BBacnetDevice device)
  {
    int pr = 0;
    if (device != null)
    {
      pr = device.getProtocolRevision();
    }

    return canSupportCov(ordinal, pr);
  }

  public static boolean canSupportCov(int ordinal, int pr)
  {
    if (ordinal > MAX_ASHRAE_ID)
    {
      return false;
    }

    switch (ordinal)
    {
      case ANALOG_INPUT:
      case ANALOG_OUTPUT:
      case ANALOG_VALUE:
      case BINARY_INPUT:
      case BINARY_OUTPUT:
      case BINARY_VALUE:
      case MULTI_STATE_INPUT:
      case MULTI_STATE_OUTPUT:
      case LOOP:
        return pr >= 0;

      case MULTI_STATE_VALUE:       // Add-135-1995b
        return pr >= 1;

      case LIFE_SAFETY_POINT:       // Add-135-1995c
      case LIFE_SAFETY_ZONE:
        return pr >= 2;

      case PULSE_CONVERTER:         // Add-135-2001c
        return pr >= 4;

      case LOAD_CONTROL:            // Add-135-2004e
      case ACCESS_DOOR:             // Add-135-2004f
        return pr >= 6;

      case ACCESS_POINT:            // Add-135-2008j
      case CREDENTIAL_DATA_INPUT:
        return pr >= 9;

      case LARGE_ANALOG_VALUE:      // Add-135-2008w
      case INTEGER_VALUE:
      case POSITIVE_INTEGER_VALUE:
      case OCTET_STRING_VALUE:
      case CHARACTER_STRING_VALUE:
      case TIME_VALUE:
      case DATE_TIME_VALUE:
      case DATE_VALUE:
      case TIME_PATTERN_VALUE:
      case DATE_PATTERN_VALUE:
      case DATE_TIME_PATTERN_VALUE:
        return pr >= 10;

      case LIGHTING_OUTPUT:         // Add-135-2010i
        return pr >= 14;

      case BINARY_LIGHTING_OUTPUT: // Add-135-2012az
        return pr >= 16;

      //case STAGING:              // Add-135-2016bd
      //  return pr >= 20;
    }

    return false;
  }

  /**
   * Build a long bit mask for the object ids whose ordinal
   * values are specified in the bits arguments.
   *
   * @param bits an array of integers whose bits should be set
   * @return the long mask representing the input ordinal values
   */
  public static long bitmask(int... bits)
  {
    long mask = 0;
    for (int i = 0; i < bits.length; i++)
    {
      mask |= 1L << bits[i];
    }
    return mask;
  }

////////////////////////////////////////////////////////////////
// Short tag
////////////////////////////////////////////////////////////////

  /**
   * Return a short form of the tag
   */
  public static String getShortTag(int objectType)
  {
    if (objectType < 0 || objectType >= shortTags.length)
    {
      return objectType + ":";
    }
    return shortTags[objectType];
  }

  private static final String[] shortTags = makeShortTags();
  private static String[] makeShortTags()
  {
    String[] shortTags = new String[MAX_ASHRAE_ID + 1];
    Arrays.fill(shortTags, "");
    shortTags[ANALOG_INPUT]            = "AI";
    shortTags[ANALOG_OUTPUT]           = "AO";
    shortTags[ANALOG_VALUE]            = "AV";
    shortTags[BINARY_INPUT]            = "BI";
    shortTags[BINARY_OUTPUT]           = "BO";
    shortTags[BINARY_VALUE]            = "BV";
    shortTags[CALENDAR]                = "CAL";
    shortTags[COMMAND]                 = "CMD";
    shortTags[DEVICE]                  = "DEV";
    shortTags[EVENT_ENROLLMENT]        = "EE";
    shortTags[FILE]                    = "FILE";
    shortTags[GROUP]                   = "GRP";
    shortTags[LOOP]                    = "LP";
    shortTags[MULTI_STATE_INPUT]       = "MSI";
    shortTags[MULTI_STATE_OUTPUT]      = "MSO";
    shortTags[NOTIFICATION_CLASS]      = "NC";
    shortTags[PROGRAM]                 = "PGM";
    shortTags[SCHEDULE]                = "SCH";
    shortTags[AVERAGING]               = "AVG";
    shortTags[MULTI_STATE_VALUE]       = "MSV";
    shortTags[TREND_LOG]               = "LOG";
    shortTags[LIFE_SAFETY_POINT]       = "LSP";
    shortTags[LIFE_SAFETY_ZONE]        = "LSZ";
    shortTags[ACCUMULATOR]             = "ACC";
    shortTags[PULSE_CONVERTER]         = "PC";
    shortTags[EVENT_LOG]               = "ELOG";
    shortTags[GLOBAL_GROUP]            = "GGRP";
    shortTags[TREND_LOG_MULTIPLE]      = "TLM";
    shortTags[LOAD_CONTROL]            = "LCO";
    shortTags[STRUCTURED_VIEW]         = "SVO";
    shortTags[ACCESS_DOOR]             = "DOOR";
    shortTags[UNASSIGNED_31]           = "TMR";
    shortTags[ACCESS_CREDENTIAL]       = "ACRD";
    shortTags[ACCESS_POINT]            = "APNT";
    shortTags[ACCESS_RIGHTS]           = "ARGT";
    shortTags[ACCESS_USER]             = "AUSR";
    shortTags[ACCESS_ZONE]             = "AZNE";
    shortTags[CREDENTIAL_DATA_INPUT]   = "CRDI";
    shortTags[NETWORK_SECURITY]        = "SEC";
    shortTags[BITSTRING_VALUE]         = "BSV";
    shortTags[CHARACTER_STRING_VALUE]  = "CSV";
    shortTags[DATE_PATTERN_VALUE]      = "DTP";
    shortTags[DATE_VALUE]              = "DTV";
    shortTags[DATE_TIME_PATTERN_VALUE] = "DTMP";
    shortTags[DATE_TIME_VALUE]         = "DTMV";
    shortTags[INTEGER_VALUE]           = "INT";
    shortTags[LARGE_ANALOG_VALUE]      = "LAV";
    shortTags[OCTET_STRING_VALUE]      = "OSV";
    shortTags[POSITIVE_INTEGER_VALUE]  = "PINT";
    shortTags[TIME_PATTERN_VALUE]      = "TMP";
    shortTags[TIME_VALUE]              = "TMV";
    shortTags[NOTIFICATION_FORWARDER]  = "NF";
    shortTags[ALERT_ENROLLMENT]        = "AE";
    shortTags[CHANNEL]                 = "CHA";
    shortTags[LIGHTING_OUTPUT]         = "LO";
    shortTags[BINARY_LIGHTING_OUTPUT]  = "BLO";
    shortTags[NETWORK_PORT]            = "NP";
    shortTags[ELEVATOR_GROUP]          = "EG";
    shortTags[ESCALATOR]               = "ESC";
    shortTags[LIFT]                    = "LIFT";
    return shortTags;
  }

/////////////////////////////////////////////////////////////////
//  Object ID Facets instances
/////////////////////////////////////////////////////////////////

  private static final BFacets[] objectIdFacets = new BFacets[MAX_ASHRAE_ID + 1];

  public static BFacets getObjectIdFacets(int objectType)
  {
    if (objectType < 0 || objectType >= objectIdFacets.length)
    {
      return null;
    }

    BFacets facets = objectIdFacets[objectType];
    if (facets == null)
    {
      facets = BFacets.makeEnum(BEnumRange.make(new int[] { objectType }, new String[] { tag(objectType) }));
      objectIdFacets[objectType] = facets;
    }
    return facets;
  }
}
