/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetNetworkType represents the BACnetNetworkType enumeration.
 * <p>
 * BBacnetNetworkType is an "extensible" enumeration.
 * Values 0-63 are reserved for use by ASHRAE.
 * Values from 64-255 can be used for proprietary extensions.
 * <p>
 * Note that for proprietary extensions, a given ordinal is not globally mapped to the same
 * enumeration. Type X from vendor A will be different from type X from vendor B. Extensions are
 * also not guaranteed unique within a vendor's own products, so type Y in device A from vendor A
 * will in general be different from type Y in device B from vendor A.
 *
 * @author Uday Rapuru on 12-Jul-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("ethernet"),
    @Range("arcnet"),
    @Range("mstp"),
    @Range("ptp"),
    @Range("lontalk"),
    @Range("ipv4"),
    @Range("zigbee"),
    @Range("virtual"),
    @Range("nonBacnet"),
    @Range("ipv6"),
    @Range("serial"),
    @Range("secureConnect")
  }
)
public final class BBacnetNetworkType
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetNetworkType(4004251525)1.0$ @*/
/* Generated Tue Feb 20 14:23:16 CST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for ethernet. */
  @Generated
  public static final int ETHERNET = 0;
  /** Ordinal value for arcnet. */
  @Generated
  public static final int ARCNET = 1;
  /** Ordinal value for mstp. */
  @Generated
  public static final int MSTP = 2;
  /** Ordinal value for ptp. */
  @Generated
  public static final int PTP = 3;
  /** Ordinal value for lontalk. */
  @Generated
  public static final int LONTALK = 4;
  /** Ordinal value for ipv4. */
  @Generated
  public static final int IPV_4 = 5;
  /** Ordinal value for zigbee. */
  @Generated
  public static final int ZIGBEE = 6;
  /** Ordinal value for virtual. */
  @Generated
  public static final int VIRTUAL = 7;
  /** Ordinal value for nonBacnet. */
  @Generated
  public static final int NON_BACNET = 8;
  /** Ordinal value for ipv6. */
  @Generated
  public static final int IPV_6 = 9;
  /** Ordinal value for serial. */
  @Generated
  public static final int SERIAL = 10;
  /** Ordinal value for secureConnect. */
  @Generated
  public static final int SECURE_CONNECT = 11;

  /** BBacnetNetworkType constant for ethernet. */
  @Generated
  public static final BBacnetNetworkType ethernet = new BBacnetNetworkType(ETHERNET);
  /** BBacnetNetworkType constant for arcnet. */
  @Generated
  public static final BBacnetNetworkType arcnet = new BBacnetNetworkType(ARCNET);
  /** BBacnetNetworkType constant for mstp. */
  @Generated
  public static final BBacnetNetworkType mstp = new BBacnetNetworkType(MSTP);
  /** BBacnetNetworkType constant for ptp. */
  @Generated
  public static final BBacnetNetworkType ptp = new BBacnetNetworkType(PTP);
  /** BBacnetNetworkType constant for lontalk. */
  @Generated
  public static final BBacnetNetworkType lontalk = new BBacnetNetworkType(LONTALK);
  /** BBacnetNetworkType constant for ipv4. */
  @Generated
  public static final BBacnetNetworkType ipv4 = new BBacnetNetworkType(IPV_4);
  /** BBacnetNetworkType constant for zigbee. */
  @Generated
  public static final BBacnetNetworkType zigbee = new BBacnetNetworkType(ZIGBEE);
  /** BBacnetNetworkType constant for virtual. */
  @Generated
  public static final BBacnetNetworkType virtual = new BBacnetNetworkType(VIRTUAL);
  /** BBacnetNetworkType constant for nonBacnet. */
  @Generated
  public static final BBacnetNetworkType nonBacnet = new BBacnetNetworkType(NON_BACNET);
  /** BBacnetNetworkType constant for ipv6. */
  @Generated
  public static final BBacnetNetworkType ipv6 = new BBacnetNetworkType(IPV_6);
  /** BBacnetNetworkType constant for serial. */
  @Generated
  public static final BBacnetNetworkType serial = new BBacnetNetworkType(SERIAL);
  /** BBacnetNetworkType constant for secureConnect. */
  @Generated
  public static final BBacnetNetworkType secureConnect = new BBacnetNetworkType(SECURE_CONNECT);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetNetworkType make(int ordinal)
  {
    return (BBacnetNetworkType)ethernet.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetNetworkType make(String tag)
  {
    return (BBacnetNetworkType)ethernet.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetNetworkType(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetNetworkType DEFAULT = ethernet;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNetworkType.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static final int MAX_ASHRAE_ID = SECURE_CONNECT;
  public static final int MAX_RESERVED_ID = 63;
  public static final int MAX_ID = 255;

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    if (DEFAULT.getRange().isOrdinal(id))
    {
      return DEFAULT.getRange().getTag(id);
    }
    if (isAshrae(id))
    {
      return BacnetConst.ASHRAE_PREFIX + id;
    }
    if (isProprietary(id))
    {
      return BacnetConst.PROPRIETARY_PREFIX + id;
    }
    throw new InvalidEnumException(id);
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag)
  {
    try
    {
      return DEFAULT.getRange().tagToOrdinal(tag);
    }
    catch (InvalidEnumException e)
    {
      if (tag.startsWith(BacnetConst.ASHRAE_PREFIX))
      {
        return Integer.parseInt(tag.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
      }
      if (tag.startsWith(BacnetConst.PROPRIETARY_PREFIX))
      {
        return Integer.parseInt(tag.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
      }
      throw e;
    }
  }

  /**
   * Is this a proprietary extension?
   *
   * @return true if this is a proprietary extension.
   */
  public static boolean isProprietary(int id)
  {
    return id > MAX_RESERVED_ID && id <= MAX_ID;
  }

  /**
   * Is this an ASHRAE extension?
   *
   * @return true if this is an ASHRAE extension.
   */
  public static boolean isAshrae(int id)
  {
    return id > MAX_ASHRAE_ID && id <= MAX_RESERVED_ID;
  }

  /**
   * Is this id valid for this enumeration?
   *
   * @return true if this id is within the allowed range.
   */
  public static boolean isValid(int id)
  {
    return id <= MAX_ID;
  }

  /**
   * Is this id part of the predefined (fixed) range?
   *
   * @return true if this id is in the fixed range.
   */
  public static boolean isFixed(int id)
  {
    return id <= MAX_ASHRAE_ID;
  }

  /**
   * @return String representation of this BEnum.
   */
  @Override
  public String toString(Context context)
  {
    if (BacnetConst.facetsContext.equals(context))
    {
      return getTag();
    }
    return getDisplayTag(context);
  }
}
