/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetNetworkType represents the BACnetNetworkType enumeration.
 * <p>
 * BBacnetNetworkType is an "extensible" enumeration.
 * Values 0-127 are reserved for use by ASHRAE.
 * Values from 128-255 can be used for proprietary extensions.
 * <p>
 * Note that for proprietary extensions, a given ordinal is not globally mapped to the same
 * enumeration. Type X from vendor A will be different from type X from vendor B. Extensions are
 * also not guaranteed unique within a vendor's own products, so type Y in device A from vendor A
 * will in general be different from type Y in device B from vendor A.
 *
 * @author Uday Rapuru on 14-Feb-2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("idle"),
    @Range("discardChanges"),
    @Range("renewFdRegistration"),
    @Range("restartSlaveDiscovery"),
    @Range("renewDhcp"),
    @Range("restartAutonegotiation"),
    @Range("disconnect"),
    @Range("restartPort"),
    @Range("generateCsrFile"),
    @Range("validateChanges")
  }
)
public final class BBacnetNetworkPortCommand
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetNetworkPortCommand(3509322119)1.0$ @*/
/* Generated Sun Feb 18 13:58:50 CST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for idle. */
  @Generated
  public static final int IDLE = 0;
  /** Ordinal value for discardChanges. */
  @Generated
  public static final int DISCARD_CHANGES = 1;
  /** Ordinal value for renewFdRegistration. */
  @Generated
  public static final int RENEW_FD_REGISTRATION = 2;
  /** Ordinal value for restartSlaveDiscovery. */
  @Generated
  public static final int RESTART_SLAVE_DISCOVERY = 3;
  /** Ordinal value for renewDhcp. */
  @Generated
  public static final int RENEW_DHCP = 4;
  /** Ordinal value for restartAutonegotiation. */
  @Generated
  public static final int RESTART_AUTONEGOTIATION = 5;
  /** Ordinal value for disconnect. */
  @Generated
  public static final int DISCONNECT = 6;
  /** Ordinal value for restartPort. */
  @Generated
  public static final int RESTART_PORT = 7;
  /** Ordinal value for generateCsrFile. */
  @Generated
  public static final int GENERATE_CSR_FILE = 8;
  /** Ordinal value for validateChanges. */
  @Generated
  public static final int VALIDATE_CHANGES = 9;

  /** BBacnetNetworkPortCommand constant for idle. */
  @Generated
  public static final BBacnetNetworkPortCommand idle = new BBacnetNetworkPortCommand(IDLE);
  /** BBacnetNetworkPortCommand constant for discardChanges. */
  @Generated
  public static final BBacnetNetworkPortCommand discardChanges = new BBacnetNetworkPortCommand(DISCARD_CHANGES);
  /** BBacnetNetworkPortCommand constant for renewFdRegistration. */
  @Generated
  public static final BBacnetNetworkPortCommand renewFdRegistration = new BBacnetNetworkPortCommand(RENEW_FD_REGISTRATION);
  /** BBacnetNetworkPortCommand constant for restartSlaveDiscovery. */
  @Generated
  public static final BBacnetNetworkPortCommand restartSlaveDiscovery = new BBacnetNetworkPortCommand(RESTART_SLAVE_DISCOVERY);
  /** BBacnetNetworkPortCommand constant for renewDhcp. */
  @Generated
  public static final BBacnetNetworkPortCommand renewDhcp = new BBacnetNetworkPortCommand(RENEW_DHCP);
  /** BBacnetNetworkPortCommand constant for restartAutonegotiation. */
  @Generated
  public static final BBacnetNetworkPortCommand restartAutonegotiation = new BBacnetNetworkPortCommand(RESTART_AUTONEGOTIATION);
  /** BBacnetNetworkPortCommand constant for disconnect. */
  @Generated
  public static final BBacnetNetworkPortCommand disconnect = new BBacnetNetworkPortCommand(DISCONNECT);
  /** BBacnetNetworkPortCommand constant for restartPort. */
  @Generated
  public static final BBacnetNetworkPortCommand restartPort = new BBacnetNetworkPortCommand(RESTART_PORT);
  /** BBacnetNetworkPortCommand constant for generateCsrFile. */
  @Generated
  public static final BBacnetNetworkPortCommand generateCsrFile = new BBacnetNetworkPortCommand(GENERATE_CSR_FILE);
  /** BBacnetNetworkPortCommand constant for validateChanges. */
  @Generated
  public static final BBacnetNetworkPortCommand validateChanges = new BBacnetNetworkPortCommand(VALIDATE_CHANGES);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetNetworkPortCommand make(int ordinal)
  {
    return (BBacnetNetworkPortCommand)idle.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetNetworkPortCommand make(String tag)
  {
    return (BBacnetNetworkPortCommand)idle.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetNetworkPortCommand(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetNetworkPortCommand DEFAULT = idle;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNetworkPortCommand.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  private static final int MAX_FIXED_ID = VALIDATE_CHANGES;
  private static final int MAX_RESERVED_ID = 127;
  private static final int MAX_ID = 255;

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    if (DEFAULT.getRange().isOrdinal(id))
    {
      return DEFAULT.getRange().getTag(id);
    }
    if (isAshrae(id))
    {
      return BacnetConst.ASHRAE_PREFIX + id;
    }
    if (isProprietary(id))
    {
      return BacnetConst.PROPRIETARY_PREFIX + id;
    }
    throw new InvalidEnumException(id);
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag)
  {
    try
    {
      return DEFAULT.getRange().tagToOrdinal(tag);
    }
    catch (InvalidEnumException e)
    {
      if (tag.startsWith(BacnetConst.ASHRAE_PREFIX))
      {
        return Integer.parseInt(tag.substring(BacnetConst.ASHRAE_PREFIX_LENGTH));
      }
      if (tag.startsWith(BacnetConst.PROPRIETARY_PREFIX))
      {
        return Integer.parseInt(tag.substring(BacnetConst.PROPRIETARY_PREFIX_LENGTH));
      }
      throw e;
    }
  }

  /**
   * Is this a proprietary extension?
   *
   * @return true if this is a proprietary extension.
   */
  public static boolean isProprietary(int id)
  {
    return id > MAX_RESERVED_ID && id <= MAX_ID;
  }

  /**
   * Is this an ASHRAE extension?
   *
   * @return true if this is an ASHRAE extension.
   */
  public static boolean isAshrae(int id)
  {
    return id > MAX_FIXED_ID && id <= MAX_RESERVED_ID;
  }

  /**
   * Is this id valid for this enumeration?
   *
   * @return true if this id is within the allowed range.
   */
  public static boolean isValid(int id)
  {
    return id <= MAX_ID;
  }

  /**
   * Is this id part of the predefined (fixed) range?
   *
   * @return true if this id is in the fixed range.
   */
  public static boolean isFixed(int id)
  {
    return id <= MAX_FIXED_ID;
  }

  /**
   * @return String representation of this BEnum.
   */
  @Override
  public String toString(Context context)
  {
    if (BacnetConst.facetsContext.equals(context))
    {
      return getTag();
    }
    return getDisplayTag(context);
  }
}
