/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetNetworkNumberQuality represents the BACnetNetworkNumberQuality enumeration.
 *
 * @author Uday Rapuru on 12-Jul-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("unknown"),
    @Range("learned"),
    @Range("learnedConfigured"),
    @Range("configured")
  }
)
public final class BBacnetNetworkNumberQuality
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetNetworkNumberQuality(3013620445)1.0$ @*/
/* Generated Wed Jul 12 15:42:30 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for unknown. */
  @Generated
  public static final int UNKNOWN = 0;
  /** Ordinal value for learned. */
  @Generated
  public static final int LEARNED = 1;
  /** Ordinal value for learnedConfigured. */
  @Generated
  public static final int LEARNED_CONFIGURED = 2;
  /** Ordinal value for configured. */
  @Generated
  public static final int CONFIGURED = 3;

  /** BBacnetNetworkNumberQuality constant for unknown. */
  @Generated
  public static final BBacnetNetworkNumberQuality unknown = new BBacnetNetworkNumberQuality(UNKNOWN);
  /** BBacnetNetworkNumberQuality constant for learned. */
  @Generated
  public static final BBacnetNetworkNumberQuality learned = new BBacnetNetworkNumberQuality(LEARNED);
  /** BBacnetNetworkNumberQuality constant for learnedConfigured. */
  @Generated
  public static final BBacnetNetworkNumberQuality learnedConfigured = new BBacnetNetworkNumberQuality(LEARNED_CONFIGURED);
  /** BBacnetNetworkNumberQuality constant for configured. */
  @Generated
  public static final BBacnetNetworkNumberQuality configured = new BBacnetNetworkNumberQuality(CONFIGURED);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetNetworkNumberQuality make(int ordinal)
  {
    return (BBacnetNetworkNumberQuality)unknown.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetNetworkNumberQuality make(String tag)
  {
    return (BBacnetNetworkNumberQuality)unknown.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetNetworkNumberQuality(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetNetworkNumberQuality DEFAULT = unknown;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetNetworkNumberQuality.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * @return String representation of this BEnum.
   */
  @Override
  public String toString(Context context)
  {
    if (BacnetConst.facetsContext.equals(context))
    {
      return getTag();
    }
    return getDisplayTag(context);
  }
}
