/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.bacnet.BacnetConst;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetIpMode represents the BACnetIPMode enumeration.
 *
 * @author Uday Rapuru on 5-oct-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("normal"),
    @Range("foreign"),
    @Range("bbmd")
  }
)
public final class BBacnetIpMode
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.enums.BBacnetIpMode(3349804756)1.0$ @*/
/* Generated Fri Oct 13 10:26:30 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for normal. */
  @Generated
  public static final int NORMAL = 0;
  /** Ordinal value for foreign. */
  @Generated
  public static final int FOREIGN = 1;
  /** Ordinal value for bbmd. */
  @Generated
  public static final int BBMD = 2;

  /** BBacnetIpMode constant for normal. */
  @Generated
  public static final BBacnetIpMode normal = new BBacnetIpMode(NORMAL);
  /** BBacnetIpMode constant for foreign. */
  @Generated
  public static final BBacnetIpMode foreign = new BBacnetIpMode(FOREIGN);
  /** BBacnetIpMode constant for bbmd. */
  @Generated
  public static final BBacnetIpMode bbmd = new BBacnetIpMode(BBMD);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetIpMode make(int ordinal)
  {
    return (BBacnetIpMode)normal.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetIpMode make(String tag)
  {
    return (BBacnetIpMode)normal.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetIpMode(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetIpMode DEFAULT = normal;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetIpMode.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * @return String representation of this BEnum.
   */
  @Override
  public String toString(Context context)
  {
    if (BacnetConst.facetsContext.equals(context))
    {
      return getTag();
    }
    return getDisplayTag(context);
  }
}
