/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.Arrays;
import java.util.Objects;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetVMACEntry contains Virtual mac address and native mac address.
 *
 * @author Uday Rapuru on 18-Mar-2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "virtualMacAddress",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "nativeMacAddress",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
public final class BBacnetVmacEntry
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetVmacEntry(3032202442)1.0$ @*/
/* Generated Wed Mar 20 18:16:19 IST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "virtualMacAddress"

  /**
   * Slot for the {@code virtualMacAddress} property.
   * @see #getVirtualMacAddress
   * @see #setVirtualMacAddress
   */
  @Generated
  public static final Property virtualMacAddress = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code virtualMacAddress} property.
   * @see #virtualMacAddress
   */
  @Generated
  public BBacnetOctetString getVirtualMacAddress() { return (BBacnetOctetString)get(virtualMacAddress); }

  /**
   * Set the {@code virtualMacAddress} property.
   * @see #virtualMacAddress
   */
  @Generated
  public void setVirtualMacAddress(BBacnetOctetString v) { set(virtualMacAddress, v, null); }

  //endregion Property "virtualMacAddress"

  //region Property "nativeMacAddress"

  /**
   * Slot for the {@code nativeMacAddress} property.
   * @see #getNativeMacAddress
   * @see #setNativeMacAddress
   */
  @Generated
  public static final Property nativeMacAddress = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code nativeMacAddress} property.
   * @see #nativeMacAddress
   */
  @Generated
  public BBacnetOctetString getNativeMacAddress() { return (BBacnetOctetString)get(nativeMacAddress); }

  /**
   * Set the {@code nativeMacAddress} property.
   * @see #nativeMacAddress
   */
  @Generated
  public void setNativeMacAddress(BBacnetOctetString v) { set(nativeMacAddress, v, null); }

  //endregion Property "nativeMacAddress"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetVmacEntry.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default constructor.
   */
  public BBacnetVmacEntry()
  {
  }

  /**
   * Constructor.
   *
   * @param virtualMac is an octetString with a maximum length of 6 octets.
   * @param nativeMac  is an octetString.
   */
  public BBacnetVmacEntry(byte[] virtualMac, byte[] nativeMac)
  {
    Objects.requireNonNull(virtualMac, "virtualMac must not be null");
    Objects.requireNonNull(nativeMac, "nativeMac must not be null");
    if (virtualMac.length > MAX_VMAC_ADDRESS_SIZE)
    {
      throw new IllegalArgumentException("virtualMac cannot be greater than length 6: " + Arrays.toString(virtualMac));
    }

    setVirtualMacAddress(BBacnetOctetString.make(virtualMac));
    setNativeMacAddress(BBacnetOctetString.make(nativeMac));
  }

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    BBacnetOctetString virtualMacAddress = getVirtualMacAddress();
    if (virtualMacAddress.getBytes() == null ||
        virtualMacAddress.length() > MAX_VMAC_ADDRESS_SIZE)
    {
      throw new IllegalStateException("Invalid virtualMacAddress: " + Arrays.toString(virtualMacAddress.getBytes()));
    }
    BBacnetOctetString nativeMacAddress = getNativeMacAddress();
    if (nativeMacAddress.getBytes() == null)
    {
      throw new IllegalStateException("Invalid nativeMacAddress: " + Arrays.toString(nativeMacAddress.getBytes()));
    }

    out.writeOctetString(0, virtualMacAddress);
    out.writeOctetString(1, nativeMacAddress);
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetOctetString virtualMacAddress = in.readBacnetOctetString(0);
    if (virtualMacAddress.length() > MAX_VMAC_ADDRESS_SIZE)
    {
      throw new OutOfRangeException("virtualMacAddress maximum length is 6: " + virtualMacAddress.length());
    }
    BBacnetOctetString nativeMacAddress = in.readBacnetOctetString(1);

    set(BBacnetVmacEntry.virtualMacAddress, virtualMacAddress, noWrite);
    set(BBacnetVmacEntry.nativeMacAddress, nativeMacAddress, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    return "VMAC: " + getVirtualMacAddress().toString(context) +
      ", Native: " + getNativeMacAddress().toString(context);
  }

  private static final int MAX_VMAC_ADDRESS_SIZE = 6;
}
