/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.datatypes;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Choice values for the BACnetValueChoice.
 *
 * @author Tim Urenda on Jan 4, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("none"),
    @Range("object"),
    @Range("address")
  }
)
public final class BBacnetValueSourceChoice
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetValueSourceChoice(204808108)1.0$ @*/
/* Generated Thu Jan 04 16:09:01 EST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for none. */
  @Generated
  public static final int NONE = 0;
  /** Ordinal value for object. */
  @Generated
  public static final int OBJECT = 1;
  /** Ordinal value for address. */
  @Generated
  public static final int ADDRESS = 2;

  /** BBacnetValueSourceChoice constant for none. */
  @Generated
  public static final BBacnetValueSourceChoice none = new BBacnetValueSourceChoice(NONE);
  /** BBacnetValueSourceChoice constant for object. */
  @Generated
  public static final BBacnetValueSourceChoice object = new BBacnetValueSourceChoice(OBJECT);
  /** BBacnetValueSourceChoice constant for address. */
  @Generated
  public static final BBacnetValueSourceChoice address = new BBacnetValueSourceChoice(ADDRESS);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetValueSourceChoice make(int ordinal)
  {
    return (BBacnetValueSourceChoice)none.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetValueSourceChoice make(String tag)
  {
    return (BBacnetValueSourceChoice)none.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetValueSourceChoice(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetValueSourceChoice DEFAULT = none;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetValueSourceChoice.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
