/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents a BACnetValueSource data type.
 *
 * @author Tim Urenda on Jan 2, 2024
 * @since Niagara 4.15
 */

/*
BACnetValueSource ::= CHOICE {
  none [0] NULL,
  object [1] BACnetDeviceObjectReference,
  address [2] BACnetAddress
}
 */
@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "BBacnetValueSourceChoice",
  defaultValue = "BBacnetValueSourceChoice.none"
)
@NiagaraProperty(
  name = "object",
  type = "BBacnetDeviceObjectReference",
  defaultValue = "new BBacnetDeviceObjectReference()"
)
@NiagaraProperty(
  name = "address",
  type = "BBacnetAddress",
  defaultValue = "BBacnetAddress.DEFAULT"
)
public class BBacnetValueSource
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetValueSource(3618217762)1.0$ @*/
/* Generated Tue Feb 13 13:49:55 CST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, BBacnetValueSourceChoice.none, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public BBacnetValueSourceChoice getChoice() { return (BBacnetValueSourceChoice)get(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(BBacnetValueSourceChoice v) { set(choice, v, null); }

  //endregion Property "choice"

  //region Property "object"

  /**
   * Slot for the {@code object} property.
   * @see #getObject
   * @see #setObject
   */
  @Generated
  public static final Property object = newProperty(0, new BBacnetDeviceObjectReference(), null);

  /**
   * Get the {@code object} property.
   * @see #object
   */
  @Generated
  public BBacnetDeviceObjectReference getObject() { return (BBacnetDeviceObjectReference)get(object); }

  /**
   * Set the {@code object} property.
   * @see #object
   */
  @Generated
  public void setObject(BBacnetDeviceObjectReference v) { set(object, v, null); }

  //endregion Property "object"

  //region Property "address"

  /**
   * Slot for the {@code address} property.
   * @see #getAddress
   * @see #setAddress
   */
  @Generated
  public static final Property address = newProperty(0, BBacnetAddress.DEFAULT, null);

  /**
   * Get the {@code address} property.
   * @see #address
   */
  @Generated
  public BBacnetAddress getAddress() { return (BBacnetAddress)get(address); }

  /**
   * Set the {@code address} property.
   * @see #address
   */
  @Generated
  public void setAddress(BBacnetAddress v) { set(address, v, null); }

  //endregion Property "address"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetValueSource.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetValueSource()
  {
    setChoice(BBacnetValueSourceChoice.none);
  }

  public BBacnetValueSource(BBacnetDeviceObjectReference object)
  {
    setObject((BBacnetDeviceObjectReference)object.newCopy(true));
    setChoice(BBacnetValueSourceChoice.object);
  }

  public BBacnetValueSource(BBacnetAddress address)
  {
    setAddress((BBacnetAddress)address.newCopy(true));
    setChoice(BBacnetValueSourceChoice.address);
  }

  public BBacnetValueSource(BBacnetDeviceObjectReference object, BBacnetAddress address)
  {
    setObject((BBacnetDeviceObjectReference)object.newCopy(true));
    setAddress((BBacnetAddress)address.newCopy(true));
    setChoice(BBacnetValueSourceChoice.object);
  }

  /**
   * To String.
   */
  @Override
  public String toString(Context cx)
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetValueSourceChoice.NONE:
        return "None";
      case BBacnetValueSourceChoice.OBJECT:
        return "Object: " + getObject().toString(cx);
      case BBacnetValueSourceChoice.ADDRESS:
        return "Address: " + getAddress().toString(cx);
      default:
        return "BBacnetValueSource: ???";
    }
  }

  /**
   * Get the value source, returned as a BValue.
   *
   * @return the slot value for the current value of choice.
   */
  public BValue getValueSource()
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetValueSourceChoice.NONE:
        return BBacnetNull.DEFAULT;
      case BBacnetValueSourceChoice.OBJECT:
        return getObject();
      case BBacnetValueSourceChoice.ADDRESS:
        return getAddress();
      default:
        throw new IllegalStateException("Invalid choice value: " + getChoice());
    }
  }

  /**
   * Convenience for setValueSource(valueSource, null).
   */
  public void setValueSource(BValue valueSource)
  {
    setValueSource(valueSource, null);
  }

  /**
   * Updates the choice property and sets the object or address properties based on type of the
   * valueSource argument.
   */
  public void setValueSource(BValue valueSource, Context cx)
  {
    if (valueSource == null)
    {
      set(choice, BBacnetValueSourceChoice.none, cx);
      return;
    }

    Type type = valueSource.getType();
    if (type == BBacnetNull.TYPE)
    {
      set(choice, BBacnetValueSourceChoice.none, cx);
    }
    else if (type == BBacnetDeviceObjectReference.TYPE)
    {
      set(choice, BBacnetValueSourceChoice.object, cx);
      set(object, valueSource.newCopy(), cx);
    }
    else if (type == BBacnetAddress.TYPE)
    {
      set(choice, BBacnetValueSourceChoice.address, cx);
      set(address, valueSource.newCopy(), cx);
    }
    else
    {
      throw new IllegalArgumentException("Invalid type for BBacnetValueSource value: " + type);
    }
  }

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetValueSourceChoice.NONE:
        out.writeNull(BBacnetValueSourceChoice.NONE);
        break;
      case BBacnetValueSourceChoice.OBJECT:
        out.writeOpeningTag(BBacnetValueSourceChoice.OBJECT);
        getObject().writeAsn(out);
        out.writeClosingTag(BBacnetValueSourceChoice.OBJECT);
        break;
      case BBacnetValueSourceChoice.ADDRESS:
        out.writeOpeningTag(BBacnetValueSourceChoice.ADDRESS);
        getAddress().writeAsn(out);
        out.writeClosingTag(BBacnetValueSourceChoice.ADDRESS);
        break;
      default:
        throw new IllegalStateException("Invalid choice value: " + getChoice());
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BIBacnetDataType value = null;
    int tag = in.peekTag();
    switch (tag)
    {
      case BBacnetValueSourceChoice.NONE:
        in.readNull(BBacnetValueSourceChoice.NONE);
        break;
      case BBacnetValueSourceChoice.OBJECT:
        in.skipOpeningTag(tag);
        value = new BBacnetDeviceObjectReference();
        value.readAsn(in);
        in.skipClosingTag(tag);
        break;
      case BBacnetValueSourceChoice.ADDRESS:
        in.skipOpeningTag(tag);
        value = new BBacnetAddress();
        value.readAsn(in);
        in.skipClosingTag(tag);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
    setValueSource((BValue) value, noWrite);
  }
}
