/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Choice values for the BACnetTimerStateChangeValue choice.
 *
 * @author Eric Anderson on 03 Nov 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("nullValue"),
    @Range("booleanValue"),
    @Range("unsigned"),
    @Range("integer"),
    @Range("real"),
    @Range("doubleValue"),
    @Range("octetString"),
    @Range("characterString"),
    @Range("bitString"),
    @Range("enumerated"),
    @Range("date"),
    @Range("time"),
    @Range("objectIdentifier"),
    @Range("noValue"),
    @Range("constructedValue"),
    @Range("dateTime"),
    @Range("lightingCommand")
  }
)
public final class BBacnetTimerStateChangeValueChoice
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice(1086430741)1.0$ @*/
/* Generated Fri Nov 03 12:39:01 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  /** Ordinal value for nullValue. */
  @Generated
  public static final int NULL_VALUE = 0;
  /** Ordinal value for booleanValue. */
  @Generated
  public static final int BOOLEAN_VALUE = 1;
  /** Ordinal value for unsigned. */
  @Generated
  public static final int UNSIGNED = 2;
  /** Ordinal value for integer. */
  @Generated
  public static final int INTEGER = 3;
  /** Ordinal value for real. */
  @Generated
  public static final int REAL = 4;
  /** Ordinal value for doubleValue. */
  @Generated
  public static final int DOUBLE_VALUE = 5;
  /** Ordinal value for octetString. */
  @Generated
  public static final int OCTET_STRING = 6;
  /** Ordinal value for characterString. */
  @Generated
  public static final int CHARACTER_STRING = 7;
  /** Ordinal value for bitString. */
  @Generated
  public static final int BIT_STRING = 8;
  /** Ordinal value for enumerated. */
  @Generated
  public static final int ENUMERATED = 9;
  /** Ordinal value for date. */
  @Generated
  public static final int DATE = 10;
  /** Ordinal value for time. */
  @Generated
  public static final int TIME = 11;
  /** Ordinal value for objectIdentifier. */
  @Generated
  public static final int OBJECT_IDENTIFIER = 12;
  /** Ordinal value for noValue. */
  @Generated
  public static final int NO_VALUE = 13;
  /** Ordinal value for constructedValue. */
  @Generated
  public static final int CONSTRUCTED_VALUE = 14;
  /** Ordinal value for dateTime. */
  @Generated
  public static final int DATE_TIME = 15;
  /** Ordinal value for lightingCommand. */
  @Generated
  public static final int LIGHTING_COMMAND = 16;

  /** BBacnetTimerStateChangeValueChoice constant for nullValue. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice nullValue = new BBacnetTimerStateChangeValueChoice(NULL_VALUE);
  /** BBacnetTimerStateChangeValueChoice constant for booleanValue. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice booleanValue = new BBacnetTimerStateChangeValueChoice(BOOLEAN_VALUE);
  /** BBacnetTimerStateChangeValueChoice constant for unsigned. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice unsigned = new BBacnetTimerStateChangeValueChoice(UNSIGNED);
  /** BBacnetTimerStateChangeValueChoice constant for integer. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice integer = new BBacnetTimerStateChangeValueChoice(INTEGER);
  /** BBacnetTimerStateChangeValueChoice constant for real. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice real = new BBacnetTimerStateChangeValueChoice(REAL);
  /** BBacnetTimerStateChangeValueChoice constant for doubleValue. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice doubleValue = new BBacnetTimerStateChangeValueChoice(DOUBLE_VALUE);
  /** BBacnetTimerStateChangeValueChoice constant for octetString. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice octetString = new BBacnetTimerStateChangeValueChoice(OCTET_STRING);
  /** BBacnetTimerStateChangeValueChoice constant for characterString. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice characterString = new BBacnetTimerStateChangeValueChoice(CHARACTER_STRING);
  /** BBacnetTimerStateChangeValueChoice constant for bitString. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice bitString = new BBacnetTimerStateChangeValueChoice(BIT_STRING);
  /** BBacnetTimerStateChangeValueChoice constant for enumerated. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice enumerated = new BBacnetTimerStateChangeValueChoice(ENUMERATED);
  /** BBacnetTimerStateChangeValueChoice constant for date. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice date = new BBacnetTimerStateChangeValueChoice(DATE);
  /** BBacnetTimerStateChangeValueChoice constant for time. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice time = new BBacnetTimerStateChangeValueChoice(TIME);
  /** BBacnetTimerStateChangeValueChoice constant for objectIdentifier. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice objectIdentifier = new BBacnetTimerStateChangeValueChoice(OBJECT_IDENTIFIER);
  /** BBacnetTimerStateChangeValueChoice constant for noValue. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice noValue = new BBacnetTimerStateChangeValueChoice(NO_VALUE);
  /** BBacnetTimerStateChangeValueChoice constant for constructedValue. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice constructedValue = new BBacnetTimerStateChangeValueChoice(CONSTRUCTED_VALUE);
  /** BBacnetTimerStateChangeValueChoice constant for dateTime. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice dateTime = new BBacnetTimerStateChangeValueChoice(DATE_TIME);
  /** BBacnetTimerStateChangeValueChoice constant for lightingCommand. */
  @Generated
  public static final BBacnetTimerStateChangeValueChoice lightingCommand = new BBacnetTimerStateChangeValueChoice(LIGHTING_COMMAND);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetTimerStateChangeValueChoice make(int ordinal)
  {
    return (BBacnetTimerStateChangeValueChoice)nullValue.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetTimerStateChangeValueChoice make(String tag)
  {
    return (BBacnetTimerStateChangeValueChoice)nullValue.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetTimerStateChangeValueChoice(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetTimerStateChangeValueChoice DEFAULT = nullValue;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetTimerStateChangeValueChoice.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
