/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.bitString;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.booleanValue;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.characterString;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.constructedValue;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.date;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.dateTime;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.doubleValue;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.enumerated;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.integer;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.lightingCommand;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.noValue;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.nullValue;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.objectIdentifier;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.octetString;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.real;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.time;
import static javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValueChoice.unsigned;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnUtil;

/**
 * Represents a BACnetTimerStateChangeValue choice.
 *
 * @author Tim Urenda on Oct. 26, 2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "BBacnetTimerStateChangeValueChoice",
  defaultValue = "nullValue"
)
@NiagaraProperty(
  name = "value",
  type = "BValue",
  defaultValue = "BBacnetNull.DEFAULT"
)
@NiagaraProperty(
  name = "constructedValueType",
  type = "BTypeSpec",
  defaultValue = "BTypeSpec.NULL"
)
public final class BBacnetTimerStateChangeValue
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetTimerStateChangeValue(4194441161)1.0$ @*/
/* Generated Fri Nov 03 14:34:47 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, nullValue, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public BBacnetTimerStateChangeValueChoice getChoice() { return (BBacnetTimerStateChangeValueChoice)get(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(BBacnetTimerStateChangeValueChoice v) { set(choice, v, null); }

  //endregion Property "choice"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BValue getValue() { return get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BValue v) { set(value, v, null); }

  //endregion Property "value"

  //region Property "constructedValueType"

  /**
   * Slot for the {@code constructedValueType} property.
   * @see #getConstructedValueType
   * @see #setConstructedValueType
   */
  @Generated
  public static final Property constructedValueType = newProperty(0, BTypeSpec.NULL, null);

  /**
   * Get the {@code constructedValueType} property.
   * @see #constructedValueType
   */
  @Generated
  public BTypeSpec getConstructedValueType() { return (BTypeSpec)get(constructedValueType); }

  /**
   * Set the {@code constructedValueType} property.
   * @see #constructedValueType
   */
  @Generated
  public void setConstructedValueType(BTypeSpec v) { set(constructedValueType, v, null); }

  //endregion Property "constructedValueType"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetTimerStateChangeValue.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public static BBacnetTimerStateChangeValue make(BValue value)
  {
    BBacnetTimerStateChangeValue result = new BBacnetTimerStateChangeValue();
    result.updateChoice(value, null);
    result.setValue(value != null ? value : BBacnetNull.DEFAULT);
    if (result.getChoice().equals(constructedValue) && value instanceof BIBacnetDataType)
    {
      result.setConstructedValueType(value.getType().getTypeSpec());
    }
    return result;
  }

  //region BIBacnetDataType

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetTimerStateChangeValueChoice.NULL_VALUE:
        out.writeNull();
        break;
      case BBacnetTimerStateChangeValueChoice.BOOLEAN_VALUE:
        out.writeBoolean((BBoolean)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.UNSIGNED:
        out.writeUnsigned((BBacnetUnsigned)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.INTEGER:
        out.writeSignedInteger((BInteger)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.REAL:
        //noinspection OverlyStrongTypeCast
        out.writeReal((BFloat)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.DOUBLE_VALUE:
        //noinspection OverlyStrongTypeCast
        out.writeDouble((BDouble)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.OCTET_STRING:
        out.writeOctetString((BBacnetOctetString)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.CHARACTER_STRING:
        out.writeCharacterString((BString)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.BIT_STRING:
        out.writeBitString((BBacnetBitString)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.ENUMERATED:
        out.writeEnumerated((BEnum)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.DATE:
        out.writeDate((BBacnetDate)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.TIME:
        out.writeTime((BBacnetTime)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.OBJECT_IDENTIFIER:
        out.writeObjectIdentifier((BBacnetObjectIdentifier)getValue());
        break;
      case BBacnetTimerStateChangeValueChoice.NO_VALUE:
        out.writeOpeningTag(NO_VALUE_TAG);
        out.writeNull();
        out.writeClosingTag(NO_VALUE_TAG);
        break;
      case BBacnetTimerStateChangeValueChoice.CONSTRUCTED_VALUE:
        out.writeEncodedValue(CONSTRUCTED_VALUE_TAG, AsnUtil.toAsn(BacnetConst.ASN_CONSTRUCTED_DATA, getValue()));
        break;
      case BBacnetTimerStateChangeValueChoice.DATE_TIME:
        out.writeOpeningTag(DATE_TIME_TAG);
        BBacnetDateTime dateTime = new BBacnetDateTime((BAbsTime)getValue());
        dateTime.writeAsn(out);
        out.writeClosingTag(DATE_TIME_TAG);
        break;
      case BBacnetTimerStateChangeValueChoice.LIGHTING_COMMAND:
        out.writeOpeningTag(LIGHTING_COMMAND_TAG);
        BBacnetLightingCommand lightingCommand = (BBacnetLightingCommand)getValue();
        lightingCommand.writeAsn(out);
        out.writeClosingTag(LIGHTING_COMMAND_TAG);
        break;
      default:
        throw new IllegalStateException("Invalid choice value: " + getChoice().getOrdinal());
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BValue value;
    int tag = in.peekTag();
    if (in.isApplicationTag(tag))
    {
      switch (tag)
      {
        case ASN_NULL:
          value = in.readNull();
          break;
        case ASN_BOOLEAN:
          value = BBoolean.make(in.readBoolean());
          break;
        case ASN_UNSIGNED:
          value = in.readUnsigned();
          break;
        case ASN_INTEGER:
          value = in.readSigned();
          break;
        case ASN_REAL:
          value = in.readFloat();
          break;
        case ASN_DOUBLE:
          value = BDouble.make(in.readDouble());
          break;
        case ASN_OCTET_STRING:
          value = in.readBacnetOctetString();
          break;
        case ASN_CHARACTER_STRING:
          value = BString.make(in.readCharacterString());
          break;
        case ASN_BIT_STRING:
          value = in.readBitString();
          break;
        case ASN_ENUMERATED:
          value = BDynamicEnum.make(in.readEnumerated());
          break;
        case ASN_DATE:
          value = in.readDate();
          break;
        case ASN_TIME:
          value = in.readTime();
          break;
        case ASN_OBJECT_IDENTIFIER:
          value = in.readObjectIdentifier();
          break;
        default:
          throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
      }
    }
    else if (in.isOpeningTag(tag))
    {
      switch (tag)
      {
        case NO_VALUE_TAG:
          in.skipTag();
          in.readNull();
          in.skipClosingTag(tag);
          set(choice, noValue, noWrite);
          set(BBacnetTimerStateChangeValue.value, BBacnetNull.DEFAULT, noWrite);
          return;
        case CONSTRUCTED_VALUE_TAG:
          BValue constructed = makeConstructedInstance();
          if (constructed != null)
          {
            in.skipTag();
            ((BIBacnetDataType)constructed).readAsn(in);
            in.skipClosingTag(tag);
            value = constructed;
          }
          else
          {
            byte[] bytes = in.readEncodedValue(CONSTRUCTED_VALUE_TAG);
            value = AsnUtil.asnToValue(bytes);
          }
          break;
        case DATE_TIME_TAG:
          BBacnetDateTime dateTimeValue = new BBacnetDateTime();
          in.skipTag();
          dateTimeValue.readAsn(in);
          in.skipClosingTag(tag);
          value = dateTimeValue.toBAbsTime();
          break;
        case LIGHTING_COMMAND_TAG:
          value = new BBacnetLightingCommand();
          in.skipTag();
          ((BIBacnetDataType)value).readAsn(in);
          in.skipClosingTag(tag);
          break;
        default:
          throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
      }
    }
    else
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    updateChoice(value, noWrite);
    set(BBacnetTimerStateChangeValue.value, value, noWrite);
  }

  private BValue makeConstructedInstance()
  {
    BTypeSpec constructedValueType = getConstructedValueType();
    if (constructedValueType.isNull())
    {
      return null;
    }

    try
    {
      BObject object = constructedValueType.getInstance();
      if (object instanceof BIBacnetDataType)
      {
        // All relevant BIBacnetDataTypes should also be BValues
        //noinspection CastConflictsWithInstanceof
        return (BValue)object;
      }
      else
      {
        if (logger.isLoggable(Level.FINE))
        {
          logger.fine("BBacnetTimerStateChangeValue: Type is not a BIBacnetDataType: " + constructedValueType);
        }
        return null;
      }
    }
    catch (Exception e)
    {
      if (logger.isLoggable(Level.FINE))
      {
        logger.log(
          Level.FINE,
          "BBacnetTimerStateChangeValue: Could not create instance of type " + constructedValueType,
          e);
      }
      return null;
    }
  }

  //endregion

  //region BComponent

  /**
   * Property changed.
   *
   * @param property the property that was changed.
   * @param context the context for the property change.
   */
  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    if (!isMounted() || !isRunning())
    {
      return;
    }

    if (property.equals(value))
    {
      try
      {
        updateChoice(getValue(), context);
      }
      catch (Exception e)
      {
        logger.log(
          Level.WARNING,
          "BBacnetTimerStateChangeValue value property changed to unsupported type: " + getValue().getType(),
          logger.isLoggable(Level.FINE) ? e : null);
      }
    }
    else if (property.equals(choice))
    {
      switch (getChoice().getOrdinal())
      {
        case BBacnetTimerStateChangeValueChoice.NULL_VALUE:
          set(value, BBacnetNull.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.BOOLEAN_VALUE:
          set(value, BBoolean.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.UNSIGNED:
          set(value, BBacnetUnsigned.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.INTEGER:
          set(value, BInteger.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.REAL:
          set(value, BFloat.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.DOUBLE_VALUE:
          set(value, BDouble.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.OCTET_STRING:
          set(value, BBacnetOctetString.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.CHARACTER_STRING:
          set(value, BString.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.BIT_STRING:
          set(value, BBacnetBitString.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.ENUMERATED:
          set(value, BDynamicEnum.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.DATE:
          set(value, BBacnetDate.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.TIME:
          set(value, BBacnetTime.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.OBJECT_IDENTIFIER:
          set(value, BBacnetObjectIdentifier.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.NO_VALUE:
          set(value, BBacnetNull.DEFAULT, context);
          break;
        case BBacnetTimerStateChangeValueChoice.CONSTRUCTED_VALUE:
          BValue constructed = makeConstructedInstance();
          set(value, constructed != null ? constructed : new BComponent(), context);
          break;
        case BBacnetTimerStateChangeValueChoice.DATE_TIME:
          set(value, new BBacnetDateTime().toBAbsTime(), context);
          break;
        case BBacnetTimerStateChangeValueChoice.LIGHTING_COMMAND:
          set(value, new BBacnetLightingCommand(), context);
          break;
        default:
          logger.warning("Unknown timer state change choice: " + getChoice());
      }
    }
    else if (property.equals(constructedValueType))
    {
      if (getChoice().equals(constructedValue))
      {
        BValue constructed = makeConstructedInstance();
        set(value, constructed != null ? constructed : new BComponent(), context);
      }
    }
  }

  //endregion

  //region Utility

  private void updateChoice(BValue value, Context context)
  {
    if (value == null)
    {
      set(choice, noValue, context);
      return;
    }

    Type type = value.getType();
    if (type == BBacnetNull.TYPE)
    {
      set(choice, nullValue, context);
    }
    else if (type == BBoolean.TYPE)
    {
      set(choice, booleanValue, context);
    }
    else if (type == BBacnetUnsigned.TYPE)
    {
      set(choice, unsigned, context);
    }
    else if (type == BInteger.TYPE)
    {
      set(choice, integer, context);
    }
    else if (type == BFloat.TYPE)
    {
      set(choice, real, context);
    }
    else if (type == BDouble.TYPE)
    {
      set(choice, doubleValue, context);
    }
    else if (type == BBacnetOctetString.TYPE)
    {
      set(choice, octetString, context);
    }
    else if (type == BString.TYPE)
    {
      set(choice, characterString, context);
    }
    else if (type == BBacnetBitString.TYPE)
    {
      set(choice, bitString, context);
    }
    else if (type.is(BEnum.TYPE))
    {
      set(choice, enumerated, context);
    }
    else if (type == BBacnetDate.TYPE)
    {
      set(choice, date, context);
    }
    else if (type == BBacnetTime.TYPE)
    {
      set(choice, time, context);
    }
    else if (type == BBacnetObjectIdentifier.TYPE)
    {
      set(choice, objectIdentifier, context);
    }
    else if (type == BAbsTime.TYPE)
    {
      set(choice, dateTime, context);
    }
    else if (type == BBacnetLightingCommand.TYPE)
    {
      set(choice, lightingCommand, context);
    }
    else if (type.is(BIBacnetDataType.TYPE) || type == BComponent.TYPE)
    {
      set(choice, constructedValue, context);
    }
    else
    {
      throw new IllegalArgumentException("Invalid type for BBacnetTimerStateChange value: " + type);
    }
  }

  //endregion

  //region Constants

  private static final int NO_VALUE_TAG = 0;
  private static final int CONSTRUCTED_VALUE_TAG = 1;
  private static final int DATE_TIME_TAG = 2;
  private static final int LIGHTING_COMMAND_TAG = 3;

  private static final Logger logger = Logger.getLogger("bacnet.datatypes");

  //endregion
}
