/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetSCHubFunctionConnection data type.
 *
 * @author Sandipan Aich on 7-Jun-2024
 * @since Niagara 4.15
 */
@NiagaraType
/*
 Current state of the hub connection
 */
@NiagaraProperty(
  name = "connectionState",
  type = "BBacnetScConnectionState",
  defaultValue = "BBacnetScConnectionState.notConnected"
)
/*
 Local date and time when the connection was established.
 */
@NiagaraProperty(
  name = "connectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
/*
 Local date and time when the connection successfully disconnected or disconnected with errors. If
 the connection has never disconnected, this field shall contain an unspecified datetime.
 */
@NiagaraProperty(
  name = "disconnectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "peerAddress",
  type = "BBacnetHostNPort",
  defaultValue = "new BBacnetHostNPort()"
)
@NiagaraProperty(
  name = "peerVmac",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0 })"
)
@NiagaraProperty(
  name = "peerUuid",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 })"
)
@NiagaraProperty(
  name = "error",
  type = "BErrorType",
  defaultValue = "new BErrorType(-1, -1)"
)
@NiagaraProperty(
  name = "errorDetails",
  type = "String",
  defaultValue = ""
)
public class BBacnetScHubFunctionConnection
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetScHubFunctionConnection(159152108)1.0$ @*/
/* Generated Mon Jun 17 23:39:54 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "connectionState"

  /**
   * Slot for the {@code connectionState} property.
   * Current state of the hub connection
   * @see #getConnectionState
   * @see #setConnectionState
   */
  @Generated
  public static final Property connectionState = newProperty(0, BBacnetScConnectionState.notConnected, null);

  /**
   * Get the {@code connectionState} property.
   * Current state of the hub connection
   * @see #connectionState
   */
  @Generated
  public BBacnetScConnectionState getConnectionState() { return (BBacnetScConnectionState)get(connectionState); }

  /**
   * Set the {@code connectionState} property.
   * Current state of the hub connection
   * @see #connectionState
   */
  @Generated
  public void setConnectionState(BBacnetScConnectionState v) { set(connectionState, v, null); }

  //endregion Property "connectionState"

  //region Property "connectTimestamp"

  /**
   * Slot for the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #getConnectTimestamp
   * @see #setConnectTimestamp
   */
  @Generated
  public static final Property connectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #connectTimestamp
   */
  @Generated
  public BBacnetDateTime getConnectTimestamp() { return (BBacnetDateTime)get(connectTimestamp); }

  /**
   * Set the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #connectTimestamp
   */
  @Generated
  public void setConnectTimestamp(BBacnetDateTime v) { set(connectTimestamp, v, null); }

  //endregion Property "connectTimestamp"

  //region Property "disconnectTimestamp"

  /**
   * Slot for the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #getDisconnectTimestamp
   * @see #setDisconnectTimestamp
   */
  @Generated
  public static final Property disconnectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public BBacnetDateTime getDisconnectTimestamp() { return (BBacnetDateTime)get(disconnectTimestamp); }

  /**
   * Set the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public void setDisconnectTimestamp(BBacnetDateTime v) { set(disconnectTimestamp, v, null); }

  //endregion Property "disconnectTimestamp"

  //region Property "peerAddress"

  /**
   * Slot for the {@code peerAddress} property.
   * @see #getPeerAddress
   * @see #setPeerAddress
   */
  @Generated
  public static final Property peerAddress = newProperty(0, new BBacnetHostNPort(), null);

  /**
   * Get the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public BBacnetHostNPort getPeerAddress() { return (BBacnetHostNPort)get(peerAddress); }

  /**
   * Set the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public void setPeerAddress(BBacnetHostNPort v) { set(peerAddress, v, null); }

  //endregion Property "peerAddress"

  //region Property "peerVmac"

  /**
   * Slot for the {@code peerVmac} property.
   * @see #getPeerVmac
   * @see #setPeerVmac
   */
  @Generated
  public static final Property peerVmac = newProperty(0, BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0 }), null);

  /**
   * Get the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public BBacnetOctetString getPeerVmac() { return (BBacnetOctetString)get(peerVmac); }

  /**
   * Set the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public void setPeerVmac(BBacnetOctetString v) { set(peerVmac, v, null); }

  //endregion Property "peerVmac"

  //region Property "peerUuid"

  /**
   * Slot for the {@code peerUuid} property.
   * @see #getPeerUuid
   * @see #setPeerUuid
   */
  @Generated
  public static final Property peerUuid = newProperty(0, BBacnetOctetString.make(new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }), null);

  /**
   * Get the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public BBacnetOctetString getPeerUuid() { return (BBacnetOctetString)get(peerUuid); }

  /**
   * Set the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public void setPeerUuid(BBacnetOctetString v) { set(peerUuid, v, null); }

  //endregion Property "peerUuid"

  //region Property "error"

  /**
   * Slot for the {@code error} property.
   * @see #getError
   * @see #setError
   */
  @Generated
  public static final Property error = newProperty(0, new BErrorType(-1, -1), null);

  /**
   * Get the {@code error} property.
   * @see #error
   */
  @Generated
  public BErrorType getError() { return (BErrorType)get(error); }

  /**
   * Set the {@code error} property.
   * @see #error
   */
  @Generated
  public void setError(BErrorType v) { set(error, v, null); }

  //endregion Property "error"

  //region Property "errorDetails"

  /**
   * Slot for the {@code errorDetails} property.
   * @see #getErrorDetails
   * @see #setErrorDetails
   */
  @Generated
  public static final Property errorDetails = newProperty(0, "", null);

  /**
   * Get the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public String getErrorDetails() { return getString(errorDetails); }

  /**
   * Set the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public void setErrorDetails(String v) { setString(errorDetails, v, null); }

  //endregion Property "errorDetails"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetScHubFunctionConnection.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetScConnectionState connectionState = BBacnetScConnectionState.make(in.readEnumerated(0));

    in.skipOpeningTag(1);
    BBacnetDateTime connectTimestamp = new BBacnetDateTime();
    connectTimestamp.readAsn(in);
    in.skipClosingTag(1);

    in.skipOpeningTag(2);
    BBacnetDateTime disconnectTimestamp = new BBacnetDateTime();
    disconnectTimestamp.readAsn(in);
    in.skipClosingTag(2);

    in.skipOpeningTag(3);
    BBacnetHostNPort peerAddress = new BBacnetHostNPort();
    peerAddress.readAsn(in);
    in.skipClosingTag(3);

    BBacnetOctetString peerVmac = in.readBacnetOctetString(4);
    if (peerVmac.length() != 6)
    {
      throw new OutOfRangeException("BACnetScHubFunctionConnection.peerVmac must be length 6; actual: " + peerVmac.length());
    }

    BBacnetOctetString peerUuid = in.readBacnetOctetString(5);
    if (peerUuid.length() != 16)
    {
      throw new OutOfRangeException("BACnetScHubFunctionConnection.peerUuid must be length 16; actual: " + peerUuid.length());
    }

    BErrorType error = new BErrorType();
    in.peekTag();
    if (in.isOpeningTag(6))
    {
      in.skipTag();
      error.readAsn(in);
      in.skipClosingTag(6);
    }

    String errorDetails = "";
    in.peekTag();
    if (in.isContextTag(7))
    {
      errorDetails = in.readCharacterString(7);
    }

    set(BBacnetScHubFunctionConnection.connectionState, connectionState, noWrite);
    set(BBacnetScHubFunctionConnection.connectTimestamp, connectTimestamp, noWrite);
    set(BBacnetScHubFunctionConnection.disconnectTimestamp, disconnectTimestamp, noWrite);
    set(BBacnetScHubFunctionConnection.peerAddress, peerAddress, noWrite);
    set(BBacnetScHubFunctionConnection.peerVmac, peerVmac, noWrite);
    set(BBacnetScHubFunctionConnection.peerUuid, peerUuid, noWrite);
    set(BBacnetScHubFunctionConnection.error, error, noWrite);
    setString(BBacnetScHubFunctionConnection.errorDetails, errorDetails, noWrite);
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeEnumerated(0, getConnectionState());

    out.writeOpeningTag(1);
    getConnectTimestamp().writeAsn(out);
    out.writeClosingTag(1);

    out.writeOpeningTag(2);
    getDisconnectTimestamp().writeAsn(out);
    out.writeClosingTag(2);

    out.writeOpeningTag(3);
    getPeerAddress().writeAsn(out);
    out.writeClosingTag(3);

    BBacnetOctetString peerVmac = getPeerVmac();
    if (peerVmac.isNull() || peerVmac.length() != 6)
    {
      throw new IllegalArgumentException("BACnetScHubFunctionConnection.peerVmac must be length 6" +
        "; actual: " + (peerVmac.isNull() ? -1 : peerVmac.length()));
    }
    out.writeOctetString(4, peerVmac);

    BBacnetOctetString peerUuid = getPeerUuid();
    if (peerUuid.isNull() || peerUuid.length() != 16)
    {
      throw new IllegalArgumentException("BACnetScHubFunctionConnection.peerUuid must be length 16" +
        "; actual: " + (peerUuid.isNull() ? -1 : peerUuid.length()));
    }
    out.writeOctetString(5, peerUuid);

    BErrorType error = getError();
    if (!error.isDefault())
    {
      out.writeOpeningTag(6);
      error.writeAsn(out);
      out.writeClosingTag(6);
    }

    String errorDetails = getErrorDetails();
    if (!errorDetails.isEmpty())
    {
      out.writeCharacterString(7, errorDetails);
    }
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder builder = new StringBuilder(getConnectionState().toString(context))
      .append(" [")
      .append(ByteArrayUtil.toHexString(getPeerVmac().getAddr()).toUpperCase())
      .append(']');
    BErrorType error = getError();
    if (!error.isDefault())
    {
      builder.append(' ').append(error.toString(context));
    }
    return builder.toString();
  }
}
