/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetSCHubConnection data type.
 *
 * @author Sandipan Aich on 21-Jun-2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "connectionState",
  type = "BBacnetScConnectionState",
  defaultValue = "BBacnetScConnectionState.notConnected"
)
/*
 Local date and time when the connection was established.
 */
@NiagaraProperty(
  name = "connectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
/*
 Local date and time when the connection successfully disconnected or disconnected with errors. If
 the connection has never disconnected, this field shall contain an unspecified datetime.
 */
@NiagaraProperty(
  name = "disconnectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "error",
  type = "BErrorType",
  defaultValue = "new BErrorType(-1, -1)"
)
@NiagaraProperty(
  name = "errorDetails",
  type = "String",
  defaultValue = ""
)
public class BBacnetScHubConnection
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetScHubConnection(1612782535)1.0$ @*/
/* Generated Fri Jun 21 08:23:11 EDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "connectionState"

  /**
   * Slot for the {@code connectionState} property.
   * @see #getConnectionState
   * @see #setConnectionState
   */
  @Generated
  public static final Property connectionState = newProperty(0, BBacnetScConnectionState.notConnected, null);

  /**
   * Get the {@code connectionState} property.
   * @see #connectionState
   */
  @Generated
  public BBacnetScConnectionState getConnectionState() { return (BBacnetScConnectionState)get(connectionState); }

  /**
   * Set the {@code connectionState} property.
   * @see #connectionState
   */
  @Generated
  public void setConnectionState(BBacnetScConnectionState v) { set(connectionState, v, null); }

  //endregion Property "connectionState"

  //region Property "connectTimestamp"

  /**
   * Slot for the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #getConnectTimestamp
   * @see #setConnectTimestamp
   */
  @Generated
  public static final Property connectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #connectTimestamp
   */
  @Generated
  public BBacnetDateTime getConnectTimestamp() { return (BBacnetDateTime)get(connectTimestamp); }

  /**
   * Set the {@code connectTimestamp} property.
   * Local date and time when the connection was established.
   * @see #connectTimestamp
   */
  @Generated
  public void setConnectTimestamp(BBacnetDateTime v) { set(connectTimestamp, v, null); }

  //endregion Property "connectTimestamp"

  //region Property "disconnectTimestamp"

  /**
   * Slot for the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #getDisconnectTimestamp
   * @see #setDisconnectTimestamp
   */
  @Generated
  public static final Property disconnectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public BBacnetDateTime getDisconnectTimestamp() { return (BBacnetDateTime)get(disconnectTimestamp); }

  /**
   * Set the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public void setDisconnectTimestamp(BBacnetDateTime v) { set(disconnectTimestamp, v, null); }

  //endregion Property "disconnectTimestamp"

  //region Property "error"

  /**
   * Slot for the {@code error} property.
   * @see #getError
   * @see #setError
   */
  @Generated
  public static final Property error = newProperty(0, new BErrorType(-1, -1), null);

  /**
   * Get the {@code error} property.
   * @see #error
   */
  @Generated
  public BErrorType getError() { return (BErrorType)get(error); }

  /**
   * Set the {@code error} property.
   * @see #error
   */
  @Generated
  public void setError(BErrorType v) { set(error, v, null); }

  //endregion Property "error"

  //region Property "errorDetails"

  /**
   * Slot for the {@code errorDetails} property.
   * @see #getErrorDetails
   * @see #setErrorDetails
   */
  @Generated
  public static final Property errorDetails = newProperty(0, "", null);

  /**
   * Get the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public String getErrorDetails() { return getString(errorDetails); }

  /**
   * Set the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public void setErrorDetails(String v) { setString(errorDetails, v, null); }

  //endregion Property "errorDetails"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetScHubConnection.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetScConnectionState connectionState = BBacnetScConnectionState.make(in.readEnumerated(0));

    in.skipOpeningTag(1);
    BBacnetDateTime connectTimestamp = new BBacnetDateTime();
    connectTimestamp.readAsn(in);
    in.skipClosingTag(1);

    in.skipOpeningTag(2);
    BBacnetDateTime disconnectTimestamp = new BBacnetDateTime();
    disconnectTimestamp.readAsn(in);
    in.skipClosingTag(2);

    BErrorType error = new BErrorType();
    in.peekTag();
    if (in.isOpeningTag(3))
    {
      in.skipTag();
      error.readAsn(in);
      in.skipClosingTag(3);
    }

    String errorDetails = "";
    in.peekTag();
    if (in.isContextTag(4))
    {
      errorDetails = in.readCharacterString(4);
    }

    set(BBacnetScHubConnection.connectionState, connectionState, noWrite);
    set(BBacnetScHubConnection.connectTimestamp, connectTimestamp, noWrite);
    set(BBacnetScHubConnection.disconnectTimestamp, disconnectTimestamp, noWrite);
    set(BBacnetScHubConnection.error, error, noWrite);
    setString(BBacnetScHubConnection.errorDetails, errorDetails, noWrite);
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeEnumerated(0, getConnectionState());

    out.writeOpeningTag(1);
    getConnectTimestamp().writeAsn(out);
    out.writeClosingTag(1);

    out.writeOpeningTag(2);
    getDisconnectTimestamp().writeAsn(out);
    out.writeClosingTag(2);

    BErrorType error = getError();
    if (!error.isDefault())
    {
      out.writeOpeningTag(3);
      error.writeAsn(out);
      out.writeClosingTag(3);
    }

    String errorDetails = getErrorDetails();
    if (!errorDetails.isEmpty())
    {
      out.writeCharacterString(4, errorDetails);
    }
  }

  @Override
  public String toString(Context context)
  {
    return getConnectionState().toString(context);
  }
}
