/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetSCFailedConnectionRequest data type.
 *
 * @author Sandipan Aich on 7-Jun-2024
 * @since Niagara 4.15
 */
@NiagaraType
/*
 Local date and time of the connection request
 */
@NiagaraProperty(
  name = "timestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "peerAddress",
  type = "BBacnetHostNPort",
  defaultValue = "new BBacnetHostNPort()"
)
@NiagaraProperty(
  name = "peerVmac",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "peerUuid",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
/*
 Most recent error for the connection
 */
@NiagaraProperty(
  name = "error",
  type = "BErrorType",
  defaultValue = "new BErrorType(-1, -1)"
)
/*
 Details on the most recent error
 */
@NiagaraProperty(
  name = "errorDetails",
  type = "String",
  defaultValue = ""
)
public class BBacnetScFailedConnectionRequest
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetScFailedConnectionRequest(4016209576)1.0$ @*/
/* Generated Wed Jun 12 12:46:45 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "timestamp"

  /**
   * Slot for the {@code timestamp} property.
   * Local date and time of the connection request
   * @see #getTimestamp
   * @see #setTimestamp
   */
  @Generated
  public static final Property timestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code timestamp} property.
   * Local date and time of the connection request
   * @see #timestamp
   */
  @Generated
  public BBacnetDateTime getTimestamp() { return (BBacnetDateTime)get(timestamp); }

  /**
   * Set the {@code timestamp} property.
   * Local date and time of the connection request
   * @see #timestamp
   */
  @Generated
  public void setTimestamp(BBacnetDateTime v) { set(timestamp, v, null); }

  //endregion Property "timestamp"

  //region Property "peerAddress"

  /**
   * Slot for the {@code peerAddress} property.
   * @see #getPeerAddress
   * @see #setPeerAddress
   */
  @Generated
  public static final Property peerAddress = newProperty(0, new BBacnetHostNPort(), null);

  /**
   * Get the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public BBacnetHostNPort getPeerAddress() { return (BBacnetHostNPort)get(peerAddress); }

  /**
   * Set the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public void setPeerAddress(BBacnetHostNPort v) { set(peerAddress, v, null); }

  //endregion Property "peerAddress"

  //region Property "peerVmac"

  /**
   * Slot for the {@code peerVmac} property.
   * @see #getPeerVmac
   * @see #setPeerVmac
   */
  @Generated
  public static final Property peerVmac = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public BBacnetOctetString getPeerVmac() { return (BBacnetOctetString)get(peerVmac); }

  /**
   * Set the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public void setPeerVmac(BBacnetOctetString v) { set(peerVmac, v, null); }

  //endregion Property "peerVmac"

  //region Property "peerUuid"

  /**
   * Slot for the {@code peerUuid} property.
   * @see #getPeerUuid
   * @see #setPeerUuid
   */
  @Generated
  public static final Property peerUuid = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public BBacnetOctetString getPeerUuid() { return (BBacnetOctetString)get(peerUuid); }

  /**
   * Set the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public void setPeerUuid(BBacnetOctetString v) { set(peerUuid, v, null); }

  //endregion Property "peerUuid"

  //region Property "error"

  /**
   * Slot for the {@code error} property.
   * Most recent error for the connection
   * @see #getError
   * @see #setError
   */
  @Generated
  public static final Property error = newProperty(0, new BErrorType(-1, -1), null);

  /**
   * Get the {@code error} property.
   * Most recent error for the connection
   * @see #error
   */
  @Generated
  public BErrorType getError() { return (BErrorType)get(error); }

  /**
   * Set the {@code error} property.
   * Most recent error for the connection
   * @see #error
   */
  @Generated
  public void setError(BErrorType v) { set(error, v, null); }

  //endregion Property "error"

  //region Property "errorDetails"

  /**
   * Slot for the {@code errorDetails} property.
   * Details on the most recent error
   * @see #getErrorDetails
   * @see #setErrorDetails
   */
  @Generated
  public static final Property errorDetails = newProperty(0, "", null);

  /**
   * Get the {@code errorDetails} property.
   * Details on the most recent error
   * @see #errorDetails
   */
  @Generated
  public String getErrorDetails() { return getString(errorDetails); }

  /**
   * Set the {@code errorDetails} property.
   * Details on the most recent error
   * @see #errorDetails
   */
  @Generated
  public void setErrorDetails(String v) { setString(errorDetails, v, null); }

  //endregion Property "errorDetails"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetScFailedConnectionRequest.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetDateTime timestamp = new BBacnetDateTime();
    timestamp.readAsn(in);
    in.skipClosingTag(0);

    in.skipOpeningTag(1);
    BBacnetHostNPort peerAddress = new BBacnetHostNPort();
    peerAddress.readAsn(in);
    in.skipClosingTag(1);

    BBacnetOctetString peerVmac = BBacnetOctetString.DEFAULT;
    in.peekTag();
    if (in.isContextTag(2))
    {
      peerVmac = in.readBacnetOctetString(2);
      if (peerVmac.length() != 6)
      {
        throw new OutOfRangeException("BACnetScFailedConnectionRequest.peerVmac must be length 6; actual: " + peerVmac.length());
      }
    }

    BBacnetOctetString peerUuid = BBacnetOctetString.DEFAULT;
    in.peekTag();
    if (in.isContextTag(3))
    {
      peerUuid = in.readBacnetOctetString(3);
      if (peerUuid.length() != 16)
      {
        throw new OutOfRangeException("BACnetScFailedConnectionRequest.peerUuid must be length 16; actual: " + peerUuid.length());
      }
    }

    in.skipOpeningTag(4);
    BErrorType error = new BErrorType();
    error.readAsn(in);
    in.skipClosingTag(4);

    String errorDetails = "";
    in.peekTag();
    if (in.isContextTag(5))
    {
      errorDetails = in.readCharacterString(5);
    }

    set(BBacnetScFailedConnectionRequest.timestamp, timestamp, noWrite);
    set(BBacnetScFailedConnectionRequest.peerAddress, peerAddress, noWrite);
    set(BBacnetScFailedConnectionRequest.peerVmac, peerVmac, noWrite);
    set(BBacnetScFailedConnectionRequest.peerUuid, peerUuid, noWrite);
    set(BBacnetScFailedConnectionRequest.error, error, noWrite);
    setString(BBacnetScFailedConnectionRequest.errorDetails, errorDetails, noWrite);
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getTimestamp().writeAsn(out);
    out.writeClosingTag(0);

    out.writeOpeningTag(1);
    getPeerAddress().writeAsn(out);
    out.writeClosingTag(1);

    BBacnetOctetString peerVmac = getPeerVmac();
    if (!peerVmac.isNull())
    {
      if (peerVmac.length() != 6)
      {
        throw new IllegalArgumentException("BACnetScFailedConnectionRequest.peerVmac length must be 6; actual: " + peerVmac.length());
      }
      out.writeOctetString(2, peerVmac);
    }

    BBacnetOctetString peerUuid = getPeerUuid();
    if (!peerUuid.isNull())
    {
      if (peerUuid.length() != 16)
      {
        throw new IllegalArgumentException("BACnetScFailedConnectionRequest.peerUuid length must be 16; actual: " + peerUuid.length());
      }
      out.writeOctetString(3, peerUuid);
    }

    out.writeOpeningTag(4);
    getError().writeAsn(out);
    out.writeClosingTag(4);

    String errorDetails = getErrorDetails();
    if (!errorDetails.isEmpty())
    {
      out.writeCharacterString(5, errorDetails);
    }
  }

  @Override
  public String toString(Context context)
  {
    return getPeerAddress().toString(context) + ' ' + getError().toString(context);
  }
}
