/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetScConnectionState;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetSCDirectConnection data type.
 *
 * @author Sandipan Aich on 7-Jun-2024
 * @since Niagara 4.15
 */
@NiagaraType
/*
 For initiated direct connections, this field shall contain the WebSocket URI that was used for
 initiating the connection. For accepted direct connections, this field shall be an empty string.
 */
@NiagaraProperty(
  name = "uri",
  type = "String",
  defaultValue = ""
)
/*
 Current state of the direct connection
 */
@NiagaraProperty(
  name = "connectionState",
  type = "BBacnetScConnectionState",
  defaultValue = "BBacnetScConnectionState.notConnected"
)
/*
 Local date and time when the connection was established, or the connection attempt failed. If the
 connection has never been established, this field shall contain an unspecified datetime.
 */
@NiagaraProperty(
  name = "connectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
/*
 Local date and time when the connection successfully disconnected or disconnected with errors. If
 the connection has never disconnected, this field shall contain an unspecified datetime.
 */
@NiagaraProperty(
  name = "disconnectTimestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "peerAddress",
  type = "BBacnetHostNPort",
  defaultValue = "new BBacnetHostNPort()"
)
@NiagaraProperty(
  name = "peerVmac",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "peerUuid",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "error",
  type = "BErrorType",
  defaultValue = "new BErrorType(-1, -1)"
)
@NiagaraProperty(
  name = "errorDetails",
  type = "String",
  defaultValue = ""
)
public class BBacnetScDirectConnection
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetScDirectConnection(3616764499)1.0$ @*/
/* Generated Fri Jun 07 12:49:12 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "uri"

  /**
   * Slot for the {@code uri} property.
   * For initiated direct connections, this field shall contain the WebSocket URI that was used for
   * initiating the connection. For accepted direct connections, this field shall be an empty string.
   * @see #getUri
   * @see #setUri
   */
  @Generated
  public static final Property uri = newProperty(0, "", null);

  /**
   * Get the {@code uri} property.
   * For initiated direct connections, this field shall contain the WebSocket URI that was used for
   * initiating the connection. For accepted direct connections, this field shall be an empty string.
   * @see #uri
   */
  @Generated
  public String getUri() { return getString(uri); }

  /**
   * Set the {@code uri} property.
   * For initiated direct connections, this field shall contain the WebSocket URI that was used for
   * initiating the connection. For accepted direct connections, this field shall be an empty string.
   * @see #uri
   */
  @Generated
  public void setUri(String v) { setString(uri, v, null); }

  //endregion Property "uri"

  //region Property "connectionState"

  /**
   * Slot for the {@code connectionState} property.
   * Current state of the direct connection
   * @see #getConnectionState
   * @see #setConnectionState
   */
  @Generated
  public static final Property connectionState = newProperty(0, BBacnetScConnectionState.notConnected, null);

  /**
   * Get the {@code connectionState} property.
   * Current state of the direct connection
   * @see #connectionState
   */
  @Generated
  public BBacnetScConnectionState getConnectionState() { return (BBacnetScConnectionState)get(connectionState); }

  /**
   * Set the {@code connectionState} property.
   * Current state of the direct connection
   * @see #connectionState
   */
  @Generated
  public void setConnectionState(BBacnetScConnectionState v) { set(connectionState, v, null); }

  //endregion Property "connectionState"

  //region Property "connectTimestamp"

  /**
   * Slot for the {@code connectTimestamp} property.
   * Local date and time when the connection was established, or the connection attempt failed. If the
   * connection has never been established, this field shall contain an unspecified datetime.
   * @see #getConnectTimestamp
   * @see #setConnectTimestamp
   */
  @Generated
  public static final Property connectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code connectTimestamp} property.
   * Local date and time when the connection was established, or the connection attempt failed. If the
   * connection has never been established, this field shall contain an unspecified datetime.
   * @see #connectTimestamp
   */
  @Generated
  public BBacnetDateTime getConnectTimestamp() { return (BBacnetDateTime)get(connectTimestamp); }

  /**
   * Set the {@code connectTimestamp} property.
   * Local date and time when the connection was established, or the connection attempt failed. If the
   * connection has never been established, this field shall contain an unspecified datetime.
   * @see #connectTimestamp
   */
  @Generated
  public void setConnectTimestamp(BBacnetDateTime v) { set(connectTimestamp, v, null); }

  //endregion Property "connectTimestamp"

  //region Property "disconnectTimestamp"

  /**
   * Slot for the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #getDisconnectTimestamp
   * @see #setDisconnectTimestamp
   */
  @Generated
  public static final Property disconnectTimestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public BBacnetDateTime getDisconnectTimestamp() { return (BBacnetDateTime)get(disconnectTimestamp); }

  /**
   * Set the {@code disconnectTimestamp} property.
   * Local date and time when the connection successfully disconnected or disconnected with errors. If
   * the connection has never disconnected, this field shall contain an unspecified datetime.
   * @see #disconnectTimestamp
   */
  @Generated
  public void setDisconnectTimestamp(BBacnetDateTime v) { set(disconnectTimestamp, v, null); }

  //endregion Property "disconnectTimestamp"

  //region Property "peerAddress"

  /**
   * Slot for the {@code peerAddress} property.
   * @see #getPeerAddress
   * @see #setPeerAddress
   */
  @Generated
  public static final Property peerAddress = newProperty(0, new BBacnetHostNPort(), null);

  /**
   * Get the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public BBacnetHostNPort getPeerAddress() { return (BBacnetHostNPort)get(peerAddress); }

  /**
   * Set the {@code peerAddress} property.
   * @see #peerAddress
   */
  @Generated
  public void setPeerAddress(BBacnetHostNPort v) { set(peerAddress, v, null); }

  //endregion Property "peerAddress"

  //region Property "peerVmac"

  /**
   * Slot for the {@code peerVmac} property.
   * @see #getPeerVmac
   * @see #setPeerVmac
   */
  @Generated
  public static final Property peerVmac = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public BBacnetOctetString getPeerVmac() { return (BBacnetOctetString)get(peerVmac); }

  /**
   * Set the {@code peerVmac} property.
   * @see #peerVmac
   */
  @Generated
  public void setPeerVmac(BBacnetOctetString v) { set(peerVmac, v, null); }

  //endregion Property "peerVmac"

  //region Property "peerUuid"

  /**
   * Slot for the {@code peerUuid} property.
   * @see #getPeerUuid
   * @see #setPeerUuid
   */
  @Generated
  public static final Property peerUuid = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public BBacnetOctetString getPeerUuid() { return (BBacnetOctetString)get(peerUuid); }

  /**
   * Set the {@code peerUuid} property.
   * @see #peerUuid
   */
  @Generated
  public void setPeerUuid(BBacnetOctetString v) { set(peerUuid, v, null); }

  //endregion Property "peerUuid"

  //region Property "error"

  /**
   * Slot for the {@code error} property.
   * @see #getError
   * @see #setError
   */
  @Generated
  public static final Property error = newProperty(0, new BErrorType(-1, -1), null);

  /**
   * Get the {@code error} property.
   * @see #error
   */
  @Generated
  public BErrorType getError() { return (BErrorType)get(error); }

  /**
   * Set the {@code error} property.
   * @see #error
   */
  @Generated
  public void setError(BErrorType v) { set(error, v, null); }

  //endregion Property "error"

  //region Property "errorDetails"

  /**
   * Slot for the {@code errorDetails} property.
   * @see #getErrorDetails
   * @see #setErrorDetails
   */
  @Generated
  public static final Property errorDetails = newProperty(0, "", null);

  /**
   * Get the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public String getErrorDetails() { return getString(errorDetails); }

  /**
   * Set the {@code errorDetails} property.
   * @see #errorDetails
   */
  @Generated
  public void setErrorDetails(String v) { setString(errorDetails, v, null); }

  //endregion Property "errorDetails"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetScDirectConnection.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    String uri = in.readCharacterString(0);
    BBacnetScConnectionState connectionState = BBacnetScConnectionState.make(in.readEnumerated(1));

    in.skipOpeningTag(2);
    BBacnetDateTime connectTimestamp = new BBacnetDateTime();
    connectTimestamp.readAsn(in);
    in.skipClosingTag(2);

    in.skipOpeningTag(3);
    BBacnetDateTime disconnectTimestamp = new BBacnetDateTime();
    disconnectTimestamp.readAsn(in);
    in.skipClosingTag(3);

    BBacnetHostNPort peerAddress = new BBacnetHostNPort();
    in.peekTag();
    if (in.isOpeningTag(4))
    {
      in.skipTag();
      peerAddress.readAsn(in);
      in.skipClosingTag(4);
    }

    BBacnetOctetString peerVmac = BBacnetOctetString.DEFAULT;
    in.peekTag();
    if (in.isContextTag(5))
    {
      peerVmac = in.readBacnetOctetString(5);
      if (peerVmac.length() != 6)
      {
        throw new OutOfRangeException("BACnetScDirectConnection.peerVmac must be length 6; actual: " + peerVmac.length());
      }
    }

    BBacnetOctetString peerUuid = BBacnetOctetString.DEFAULT;
    in.peekTag();
    if (in.isContextTag(6))
    {
      peerUuid = in.readBacnetOctetString(6);
      if (peerUuid.length() != 16)
      {
        throw new OutOfRangeException("BACnetScDirectConnection.peerUuid must be length 16; actual: " + peerUuid.length());
      }
    }

    BErrorType error = new BErrorType();
    in.peekTag();
    if (in.isOpeningTag(7))
    {
      in.skipTag();
      error.readAsn(in);
      in.skipClosingTag(7);
    }

    String errorDetails = "";
    in.peekTag();
    if (in.isContextTag(8))
    {
      errorDetails = in.readCharacterString(8);
    }

    setString(BBacnetScDirectConnection.uri, uri, noWrite);
    set(BBacnetScDirectConnection.connectionState, connectionState, noWrite);
    set(BBacnetScDirectConnection.connectTimestamp, connectTimestamp, noWrite);
    set(BBacnetScDirectConnection.disconnectTimestamp, disconnectTimestamp, noWrite);
    set(BBacnetScDirectConnection.peerAddress, peerAddress, noWrite);
    set(BBacnetScDirectConnection.peerVmac, peerVmac, noWrite);
    set(BBacnetScDirectConnection.peerUuid, peerUuid, noWrite);
    set(BBacnetScDirectConnection.error, error, noWrite);
    setString(BBacnetScDirectConnection.errorDetails, errorDetails, noWrite);
  }

  public void writeAsn(AsnOutput out)
  {
    out.writeCharacterString(0, getUri());
    out.writeEnumerated(1, getConnectionState());

    out.writeOpeningTag(2);
    getConnectTimestamp().writeAsn(out);
    out.writeClosingTag(2);

    out.writeOpeningTag(3);
    getDisconnectTimestamp().writeAsn(out);
    out.writeClosingTag(3);

    BBacnetHostNPort peerAddress = getPeerAddress();
    if (!peerAddress.getHostAddress().getChoice().equals(BBacnetHostAddressChoice.none))
    {
      out.writeOpeningTag(4);
      peerAddress.writeAsn(out);
      out.writeClosingTag(4);
    }

    BBacnetOctetString peerVmac = getPeerVmac();
    if (!peerVmac.isNull())
    {
      if (peerVmac.length() != 6)
      {
        throw new IllegalArgumentException("BACnetScDirectConnection.peerVmac must be length 6; actual: " + peerVmac.length());
      }
      out.writeOctetString(5, peerVmac);
    }

    BBacnetOctetString peerUuid = getPeerUuid();
    if (!peerUuid.isNull())
    {
      if (peerUuid.length() != 16)
      {
        throw new IllegalArgumentException("BACnetScDirectConnection.peerUuid must be length 16; actual: " + peerUuid.length());
      }
      out.writeOctetString(6, peerUuid);
    }

    BErrorType error = getError();
    if (!error.isDefault())
    {
      out.writeOpeningTag(7);
      error.writeAsn(out);
      out.writeClosingTag(7);
    }

    String errorDetails = getErrorDetails();
    if (!errorDetails.isEmpty())
    {
      out.writeCharacterString(8, errorDetails);
    }
  }

  @Override
  public String toString(Context context)
  {
    StringBuilder builder = new StringBuilder(getConnectionState().toString(context));

    BBacnetOctetString peerVmac = getPeerVmac();
    if (!peerVmac.isNull())
    {
      builder
        .append(" [")
        .append(ByteArrayUtil.toHexString(getPeerVmac().getAddr()).toUpperCase())
        .append(']');
    }

    String uri = getUri();
    if (!uri.isEmpty())
    {
      builder.append(' ').append(uri);
    }
    return builder.toString();
  }
}
