/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.enums.BBacnetRouterStatus;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetRoutingTableEntry represents the BACnetRouterEntry sequence. Niagara already had a
 * BBacnetRouterEntry class so this class's name could not match the datatype name.
 *
 * @author Uday Rapuru on 05-May-2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "networkNumber",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "macAddress",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.EMPTY"
)
@NiagaraProperty(
  name = "status",
  type = "BBacnetRouterStatus",
  defaultValue = "BBacnetRouterStatus.available"
)
@NiagaraProperty(
  name = "performanceIndex",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.make(-1)"
)
public final class BBacnetRoutingTableEntry
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetRoutingTableEntry(1255610556)1.0$ @*/
/* Generated Tue May 07 14:00:15 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "networkNumber"

  /**
   * Slot for the {@code networkNumber} property.
   * @see #getNetworkNumber
   * @see #setNetworkNumber
   */
  @Generated
  public static final Property networkNumber = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code networkNumber} property.
   * @see #networkNumber
   */
  @Generated
  public BBacnetUnsigned getNetworkNumber() { return (BBacnetUnsigned)get(networkNumber); }

  /**
   * Set the {@code networkNumber} property.
   * @see #networkNumber
   */
  @Generated
  public void setNetworkNumber(BBacnetUnsigned v) { set(networkNumber, v, null); }

  //endregion Property "networkNumber"

  //region Property "macAddress"

  /**
   * Slot for the {@code macAddress} property.
   * @see #getMacAddress
   * @see #setMacAddress
   */
  @Generated
  public static final Property macAddress = newProperty(0, BBacnetOctetString.EMPTY, null);

  /**
   * Get the {@code macAddress} property.
   * @see #macAddress
   */
  @Generated
  public BBacnetOctetString getMacAddress() { return (BBacnetOctetString)get(macAddress); }

  /**
   * Set the {@code macAddress} property.
   * @see #macAddress
   */
  @Generated
  public void setMacAddress(BBacnetOctetString v) { set(macAddress, v, null); }

  //endregion Property "macAddress"

  //region Property "status"

  /**
   * Slot for the {@code status} property.
   * @see #getStatus
   * @see #setStatus
   */
  @Generated
  public static final Property status = newProperty(0, BBacnetRouterStatus.available, null);

  /**
   * Get the {@code status} property.
   * @see #status
   */
  @Generated
  public BBacnetRouterStatus getStatus() { return (BBacnetRouterStatus)get(status); }

  /**
   * Set the {@code status} property.
   * @see #status
   */
  @Generated
  public void setStatus(BBacnetRouterStatus v) { set(status, v, null); }

  //endregion Property "status"

  //region Property "performanceIndex"

  /**
   * Slot for the {@code performanceIndex} property.
   * @see #getPerformanceIndex
   * @see #setPerformanceIndex
   */
  @Generated
  public static final Property performanceIndex = newProperty(0, BBacnetUnsigned.make(-1), null);

  /**
   * Get the {@code performanceIndex} property.
   * @see #performanceIndex
   */
  @Generated
  public BBacnetUnsigned getPerformanceIndex() { return (BBacnetUnsigned)get(performanceIndex); }

  /**
   * Set the {@code performanceIndex} property.
   * @see #performanceIndex
   */
  @Generated
  public void setPerformanceIndex(BBacnetUnsigned v) { set(performanceIndex, v, null); }

  //endregion Property "performanceIndex"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetRoutingTableEntry.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetRoutingTableEntry()
  {
  }

  public void writeAsn(AsnOutput out)
  {
    int networkNumber = getNetworkNumber().getInt();
    if (networkNumber < 0 || networkNumber > BBacnetUnsigned.MAX_UNSIGNED16_VALUE)
    {
      throw new IllegalArgumentException("BACnetRouterEntry.NetworkNumber must be [0-65535]: " + networkNumber);
    }

    out.writeUnsignedInteger(0, networkNumber);
    out.writeOctetString(1, getMacAddress());
    out.writeEnumerated(2, getStatus());

    int performanceIndex = getPerformanceIndex().getInt();
    if (performanceIndex >= 0)
    {
      if (performanceIndex > BBacnetUnsigned.MAX_UNSIGNED8_VALUE)
      {
        throw new IllegalArgumentException("BACnetRouterEntry.PerformanceIndex must be [0-255]: " + performanceIndex);
      }

      out.writeUnsignedInteger(3, performanceIndex);
    }
  }

  public void readAsn(AsnInput in)
    throws AsnException
  {
    int networkNumber = in.readUnsignedInt(0);
    if (networkNumber > BBacnetUnsigned.MAX_UNSIGNED16_VALUE)
    {
      throw new OutOfRangeException("BACnetRouterEntry.NetworkNumber must be [0-65535]: " + networkNumber);
    }

    BBacnetOctetString macAddress = in.readBacnetOctetString(1);
    BBacnetRouterStatus status = BBacnetRouterStatus.make(in.readEnumerated(2));

    in.peekTag();
    int performanceIndex = in.isValueTag(3) ? in.readUnsignedInt(3) : -1;
    if (performanceIndex > BBacnetUnsigned.MAX_UNSIGNED8_VALUE)
    {
      throw new OutOfRangeException("BACnetRouterEntry.PerformanceIndex must be [0-255]: " + performanceIndex);
    }

    set(BBacnetRoutingTableEntry.networkNumber, BBacnetUnsigned.make(networkNumber), noWrite);
    set(BBacnetRoutingTableEntry.macAddress, macAddress, noWrite);
    set(BBacnetRoutingTableEntry.status, status, noWrite);
    set(BBacnetRoutingTableEntry.performanceIndex, BBacnetUnsigned.make(performanceIndex), noWrite);
  }

  public String toString(Context cx)
  {
    StringBuilder builder = new StringBuilder()
      .append("network: ").append(getNetworkNumber())
      .append(" mac: ").append(getMacAddress())
      .append(" status: ").append(getStatus());
    int performanceIndex = getPerformanceIndex().getInt();
    if (performanceIndex >= 0)
    {
      builder.append(" performance: ").append(performanceIndex);
    }
    return builder.toString();
  }
}
