/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.HashMap;
import java.util.Map;

import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyOperation;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetMaintenance;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetProtocolLevel;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.enums.BBacnetSilencedState;
import javax.baja.bacnet.enums.BBacnetTimerState;
import javax.baja.bacnet.enums.BBacnetTimerTransition;
import javax.baja.bacnet.enums.BBacnetWriteStatus;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.enums.access.BBacnetAccessZoneOccupancyState;
import javax.baja.bacnet.enums.access.BBacnetAuthenticationStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorAlarmState;
import javax.baja.bacnet.enums.access.BBacnetDoorSecuredStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.access.BBacnetLockStatus;
import javax.baja.bacnet.enums.elevator.BBacnetEscalatorFault;
import javax.baja.bacnet.enums.elevator.BBacnetEscalatorMode;
import javax.baja.bacnet.enums.elevator.BBacnetEscalatorOperationDirection;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDirection;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDoorCommand;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarDriveStatus;
import javax.baja.bacnet.enums.elevator.BBacnetLiftCarMode;
import javax.baja.bacnet.enums.elevator.BBacnetLiftFault;
import javax.baja.bacnet.enums.elevator.BBacnetLiftGroupMode;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.enums.lighting.BBacnetLightingInProgress;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.enums.lighting.BBacnetLightingTransition;
import javax.baja.bacnet.enums.security.BBacnetSecurityLevel;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BBacnetPropertyStates represents the BACnetPropertyStates
 * choice.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 23 Apr 04
 * @since Niagara 3 Bacnet 1.0
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "0",
  flags = Flags.HIDDEN
)
public final class BBacnetPropertyStates
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetPropertyStates(246626917)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(Flags.HIDDEN, 0, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetPropertyStates.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Create a BOOLEAN type BACnetPropertyStates instance
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeBoolean(boolean value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(BOOLEAN_VALUE_TAG);
    propertyStates.add(slotNames[BOOLEAN_VALUE_TAG], BBoolean.make(value));
    return propertyStates;
  }

  /**
   * Create a BacnetBinaryPV type BACnetPropertyStates instance
   *
   * @since Niagara 4.10u3
   * @since Niagara 4.12
   */
  public static BBacnetPropertyStates makeBinaryPv(boolean value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(BINARY_VALUE_TAG);
    propertyStates.add(slotNames[BINARY_VALUE_TAG], BBacnetBinaryPv.make(value));
    return propertyStates;
  }

  /**
   * Create an Unsigned type BACnetPropertyStates instance
   *
   * @since Niagara 4.10u3
   * @since Niagara 4.12
   */
  public static BBacnetPropertyStates makeUnsigned(long value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(UNSIGNED_VALUE_TAG);
    propertyStates.add(slotNames[UNSIGNED_VALUE_TAG], BBacnetUnsigned.make(value));
    return propertyStates;
  }

  /**
   * Create a Signed type BACnetPropertyStates instance
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeInteger(int value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(INTEGER_VALUE_TAG);
    propertyStates.add(slotNames[INTEGER_VALUE_TAG], BInteger.make(value));
    return propertyStates;
  }

  /**
   * Create an enum type BACnetPropertyStates instance. The choice is based on the typeSpec, the
   * corresponding enum value is retrieved based on the ordinal, and that value is added with the
   * appropriate slot name.
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeEnum(BTypeSpec typeSpec, int ordinal)
  {
    Integer choice = choices.get(typeSpec);
    if (choice == null)
    {
      throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec);
    }

    BValue value;
    try
    {
      value = makeEnumValue(choice, ordinal);
    }
    catch (OutOfRangeException e)
    {
      throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec, e);
    }

    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(choice);
    propertyStates.add(slotNames[choice], value);
    return propertyStates;
  }

  /**
   * Create an enum type BACnetPropertyStates instance.
   *
   * @since Niagara 4.14u2
   */
  public static BBacnetPropertyStates makeEnum(BEnum enumValue)
  {
    return makeEnum(enumValue.getType().getTypeSpec(), enumValue.getOrdinal());
  }

////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;
    BComplex parent = getParent();
    if (parent != null)
      parent.asComponent().changed(getPropertyInParent(), cx);
    // vfixx: throw changed w/ GCC context?
  }

  /**
   * Callback when the component enters the subscribed state.
   */
  public void subscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childSubscribed(this);
  }

  /**
   * Callback when the component leaves the subscribed state.
   */
  public void unsubscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childUnsubscribed(this);
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getAppliedCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this))
      return getParent().asComponent().getAppliedCategoryMask();
    return super.getAppliedCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getCategoryMask();
    return super.getCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BPermissions getPermissions(Context cx)
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getPermissions(cx);
    return super.getPermissions(cx);
  }

  public String toString(Context cx)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getTag());
    int choice = getChoice();
    if (choice < 0 || choice == MAX_ASHRAE_CHOICE)
    {
      return sb.toString();
    }

    if (choice <= MAX_DEFINED_CHOICE)
    {
      sb.append(get(slotNames[choice]));
    }
    else if (choice < MAX_ASHRAE_CHOICE)
    {
      sb.append(get(slotNames[ASHRAE_CHOICE_INDEX]));
    }
    else if (choice <= MAX_TAG)
    {
      sb.append(get(slotNames[PROPRIETARY_CHOICE_INDEX]));
    }
    else
    {
      sb.append(get(slotNames[ASHRAE_CHOICE_INDEX]));
    }
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   * Since protocol revision 16, choice values greater than 254 are multiplied by 100,000 and added
   * to the enum value; the result is encoded using context tag 63.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice();
    if (choice < 0)
    {
      throw new IllegalStateException("Invalid BACnetPropertyStates choice: " + getChoice());
    }
    if (choice == MAX_ASHRAE_CHOICE)
    {
      throw new IllegalStateException("Choice value 63 reserved to extend support for tag number greater than 254");
    }
    if (choice <= MAX_DEFINED_CHOICE)
    {
      switch (choice)
      {
        case BOOLEAN_VALUE_TAG:
          out.writeBoolean(BOOLEAN_VALUE_TAG, (BBoolean) get(slotNames[choice]));
          break;
        case UNSIGNED_VALUE_TAG:
          out.writeUnsigned(UNSIGNED_VALUE_TAG, (BBacnetUnsigned) get(slotNames[choice]));
          break;
        case BINARY_VALUE_TAG:
        case EVENT_TYPE_TAG:
        case POLARITY_TAG:
        case PROGRAM_CHANGE_TAG:
        case PROGRAM_STATE_TAG:
        case REASON_FOR_HALT_TAG:
        case RELIABILITY_TAG:
        case STATE_TAG:
        case SYSTEM_STATUS_TAG:
        case UNITS_TAG:
        case LIFE_SAFETY_MODE_TAG:
        case LIFE_SAFETY_STATE_TAG:
        case RESTART_REASON_TAG:
        case DOOR_ALARM_TAG:
        case ACTION_TAG:
        case DOOR_SECURED_STATUS_TAG:
        case DOOR_STATUS_TAG:
        case DOOR_VALUE_TAG:
        case FILE_ACCESS_METHOD_TAG:
        case LOCK_STATUS_TAG:
        case LIFE_SAFETY_OPERATION_TAG:
        case MAINTENANCE_TAG:
        case NODE_TYPE_TAG:
        case NOTIFY_TYPE_TAG:
        case SECURITY_LEVEL_TAG:
        case SHED_STATE_TAG:
        case SILENCED_STATE_TAG:
        case RESERVED29_TAG:
        case ACCESS_EVENT_TAG:
        case ZONE_OCCUPANCY_TAG:
        case ACCESS_CREDENTIAL_DISABLE_REASON_TAG:
        case ACCESS_CREDENTIAL_DISABLE_TAG:
        case AUTHENTICATION_STATUS_TAG:
        case BACKUP_STATE_TAG:
        case WRITE_STATUS_TAG:
        case LIGHTING_IN_PROGRESS_TAG:
        case LIGHTING_OPERATION_TAG:
        case LIGHTING_TRANSITION_TAG:
        case BINARY_LIGHTING_VALUE:
        case TIMER_STATE_TAG:
        case TIMER_TRANSITION_TAG:
        case ESCALATOR_OPERATION_DIRECTION_TAG:
        case ESCALATOR_FAULT_TAG:
        case ESCALATOR_MODE_TAG:
        case LIFT_CAR_DIRECTION_TAG:
        case LIFT_CAR_DOOR_COMMAND_TAG:
        case LIFT_CAR_DRIVE_STATUS_TAG:
        case LIFT_CAR_MODE_TAG:
        case LIFT_GROUP_MODE_TAG:
        case LIFT_FAULT_TAG:
        case PROTOCOL_LEVEL_TAG:
          out.writeEnumerated(choice, (BEnum) get(slotNames[choice]));
          break;
        case INTEGER_VALUE_TAG:
          out.writeSignedInteger(choice, (BInteger) get(slotNames[choice]));
          break;
      }
    }
    else if (choice < MAX_ASHRAE_CHOICE)
    {
      // TODO enum ?
      out.writeUnsigned(choice, (BBacnetUnsigned) get(slotNames[ASHRAE_CHOICE_INDEX]));
    }
    else if (choice <= MAX_TAG)
    {
      out.writeUnsigned(choice, (BBacnetUnsigned) get(slotNames[PROPRIETARY_CHOICE_INDEX]));
    }
    else
    {
      if (choice > MAX_CHOICE)
      {
        throw new IllegalStateException("BACnetPropertyStates choice " + choice + " is too large to be encoded by ASN; choice should be less than " + MAX_CHOICE);
      }
      // TODO enum ?
      long value = ((BBacnetUnsigned) get(slotNames[ASHRAE_CHOICE_INDEX])).getLong();
      long extendedValue = choice * 100_000L + value;
      out.writeUnsigned(MAX_ASHRAE_CHOICE, BBacnetUnsigned.make(extendedValue));
    }
  }

  /**
   * Read the value from the Asn input stream.
   * Since protocol revision 16, provides support for decoding encoded choice values greater than
   * 254.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (tag < 0 || tag > MAX_TAG)
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    int choice = tag;
    String slotName;
    BValue value;
    if (tag <= MAX_DEFINED_CHOICE)
    {
      slotName = slotNames[tag];
      switch (tag)
      {
        case BOOLEAN_VALUE_TAG:
          value = BBoolean.make(in.readBoolean(BOOLEAN_VALUE_TAG));
          break;
        case UNSIGNED_VALUE_TAG:
          value = in.readUnsigned(UNSIGNED_VALUE_TAG);
          break;
        case INTEGER_VALUE_TAG:
          value = in.readSigned(INTEGER_VALUE_TAG);
          break;
        default:
          value = makeEnumValue(tag, in.readEnumerated(tag));
          break;
      }
    }
    else if (tag < MAX_ASHRAE_CHOICE)
    {
      slotName = slotNames[ASHRAE_CHOICE_INDEX];
      value = in.readUnsigned(tag);
    }
    else if (tag == MAX_ASHRAE_CHOICE)
    {
      long extendedValue = in.readUnsignedInteger(MAX_ASHRAE_CHOICE);
      if (extendedValue < 25_500_000L)
      {
        throw new OutOfRangeException("Extended choice values must be at least 255; value: " + extendedValue);
      }

      long extendedChoice = extendedValue / 100_000L;
      if (extendedChoice > MAX_CHOICE)
      {
        throw new OutOfRangeException("Extended choice value greater than 42949 are not supported: " + extendedChoice);
      }

      choice = (int)extendedChoice;
      slotName = slotNames[ASHRAE_CHOICE_INDEX];
      // TODO BEnum ?
      value = BBacnetUnsigned.make(extendedValue - extendedChoice * 100_000L);
    }
    else
    {
      slotName = slotNames[PROPRIETARY_CHOICE_INDEX];
      value = in.readUnsigned(tag);
    }

    removeAll(noWrite);
    setInt(BBacnetPropertyStates.choice, choice, noWrite);
    add(slotName, value, noWrite);
  }

  /**
   * Return either the BFrozenEnum instance that corresponds to the ordinal or a BDynamicEnum if
   * the enum is extensible.
   */
  private static BValue makeEnumValue(int tag, int ordinal)
    throws OutOfRangeException
  {
    switch (tag)
    {
      case BINARY_VALUE_TAG:
        return BBacnetBinaryPv.make(ordinal);
      case EVENT_TYPE_TAG:
        return makeDynamicEnum(ordinal, BBacnetEventType.DEFAULT);
      case POLARITY_TAG:
        return BBacnetPolarity.make(ordinal);
      case PROGRAM_CHANGE_TAG:
        return BBacnetProgramRequest.make(ordinal);
      case PROGRAM_STATE_TAG:
        return BBacnetProgramState.make(ordinal);
      case REASON_FOR_HALT_TAG:
        return makeDynamicEnum(ordinal, BBacnetProgramError.DEFAULT);
      case RELIABILITY_TAG:
        return makeDynamicEnum(ordinal, BBacnetReliability.DEFAULT);
      case STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetEventState.DEFAULT);
      case SYSTEM_STATUS_TAG:
        return makeDynamicEnum(ordinal, BBacnetDeviceStatus.DEFAULT);
      case UNITS_TAG:
        return makeDynamicEnum(ordinal, BBacnetEngineeringUnits.DEFAULT);
      case LIFE_SAFETY_MODE_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyMode.DEFAULT);
      case LIFE_SAFETY_STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyState.DEFAULT);
      case RESTART_REASON_TAG:
        return makeDynamicEnum(ordinal, BBacnetRestartReason.DEFAULT);
      case DOOR_ALARM_TAG:
        return makeDynamicEnum(ordinal, BBacnetDoorAlarmState.DEFAULT);
      case ACTION_TAG:
        return BBacnetAction.make(ordinal);
      case DOOR_SECURED_STATUS_TAG:
        return BBacnetDoorSecuredStatus.make(ordinal);
      case DOOR_STATUS_TAG:
        return makeDynamicEnum(ordinal, BBacnetDoorStatus.DEFAULT);
      case DOOR_VALUE_TAG:
        return BBacnetDoorValue.make(ordinal);
      case FILE_ACCESS_METHOD_TAG:
        return BBacnetFileAccessMethod.make(ordinal);
      case LOCK_STATUS_TAG:
        return BBacnetLockStatus.make(ordinal);
      case LIFE_SAFETY_OPERATION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyOperation.DEFAULT);
      case MAINTENANCE_TAG:
        return makeDynamicEnum(ordinal, BBacnetMaintenance.DEFAULT);
      case NODE_TYPE_TAG:
        return BBacnetNodeType.make(ordinal);
      case NOTIFY_TYPE_TAG:
        return BBacnetNotifyType.make(ordinal);
      case SECURITY_LEVEL_TAG: // (26) Removed
        return makeDynamicEnum(ordinal, BBacnetSecurityLevel.DEFAULT);
      case SHED_STATE_TAG:
        return BBacnetShedState.make(ordinal);
      case SILENCED_STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetSilencedState.DEFAULT);
      // (29) Reserved
      case ACCESS_EVENT_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessEvent.DEFAULT);
      case ZONE_OCCUPANCY_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessZoneOccupancyState.DEFAULT);
      case ACCESS_CREDENTIAL_DISABLE_REASON_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessCredentialDisableReason.DEFAULT);
      case ACCESS_CREDENTIAL_DISABLE_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessCredentialDisable.DEFAULT);
      case AUTHENTICATION_STATUS_TAG:
        return BBacnetAuthenticationStatus.make(ordinal);
      case BACKUP_STATE_TAG:
        return BBacnetBackupState.make(ordinal);
      case WRITE_STATUS_TAG:
        return BBacnetWriteStatus.make(ordinal);
      case LIGHTING_IN_PROGRESS_TAG:
        return BBacnetLightingInProgress.make(ordinal);
      case LIGHTING_OPERATION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLightingOperation.DEFAULT);
      case LIGHTING_TRANSITION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLightingTransition.DEFAULT);
      case BINARY_LIGHTING_VALUE:
        return makeDynamicEnum(ordinal, BBacnetBinaryLightingPv.DEFAULT);
      case TIMER_STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetTimerState.DEFAULT);
      case TIMER_TRANSITION_TAG:
        return makeDynamicEnum(ordinal, BBacnetTimerTransition.DEFAULT);
      case ESCALATOR_OPERATION_DIRECTION_TAG:
        return makeDynamicEnum(ordinal, BBacnetEscalatorOperationDirection.DEFAULT);
      case ESCALATOR_FAULT_TAG:
        return makeDynamicEnum(ordinal, BBacnetEscalatorFault.DEFAULT);
      case ESCALATOR_MODE_TAG:
        return makeDynamicEnum(ordinal, BBacnetEscalatorMode.DEFAULT);
      case LIFT_CAR_DIRECTION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLiftCarDirection.DEFAULT);
      case LIFT_CAR_DOOR_COMMAND_TAG:
        return BBacnetLiftCarDoorCommand.make(ordinal);
      case LIFT_CAR_DRIVE_STATUS_TAG:
        return makeDynamicEnum(ordinal, BBacnetLiftCarDriveStatus.DEFAULT);
      case LIFT_CAR_MODE_TAG:
        return makeDynamicEnum(ordinal, BBacnetLiftCarMode.DEFAULT);
      case LIFT_GROUP_MODE_TAG:
        return BBacnetLiftGroupMode.make(ordinal);
      case LIFT_FAULT_TAG:
        return makeDynamicEnum(ordinal, BBacnetLiftFault.DEFAULT);
      case PROTOCOL_LEVEL_TAG:
        return BBacnetProtocolLevel.make(ordinal);
      default:
        throw new OutOfRangeException("Enum choice value not supported: " + tag);
    }
  }

  private static BDynamicEnum makeDynamicEnum(int ordinal, BFrozenEnum enumDefault)
  {
    return BDynamicEnum.make(ordinal, enumDefault.getRange());
  }

////////////////////////////////////////////////////////////////
// Support
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetPropertyStates", 2);
    out.prop("virtual", BacnetVirtualUtil.isVirtual(this));
    out.endProps();
  }


/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  private static final int MAX_TAG = 254;

  public static final int BOOLEAN_VALUE_TAG = 0;
  public static final int BINARY_VALUE_TAG = 1;
  public static final int EVENT_TYPE_TAG = 2;
  public static final int POLARITY_TAG = 3;
  public static final int PROGRAM_CHANGE_TAG = 4;
  public static final int PROGRAM_STATE_TAG = 5;
  public static final int REASON_FOR_HALT_TAG = 6;
  public static final int RELIABILITY_TAG = 7;
  public static final int STATE_TAG = 8;
  public static final int SYSTEM_STATUS_TAG = 9;
  public static final int UNITS_TAG = 10;
  public static final int UNSIGNED_VALUE_TAG = 11;
  public static final int LIFE_SAFETY_MODE_TAG = 12;
  public static final int LIFE_SAFETY_STATE_TAG = 13;
  public static final int RESTART_REASON_TAG = 14;
  public static final int DOOR_ALARM_TAG = 15;
  public static final int ACTION_TAG = 16;
  public static final int DOOR_SECURED_STATUS_TAG = 17;
  public static final int DOOR_STATUS_TAG = 18;
  public static final int DOOR_VALUE_TAG = 19;
  public static final int FILE_ACCESS_METHOD_TAG = 20;
  public static final int LOCK_STATUS_TAG = 21;
  public static final int LIFE_SAFETY_OPERATION_TAG = 22;
  public static final int MAINTENANCE_TAG = 23;
  public static final int NODE_TYPE_TAG = 24;
  public static final int NOTIFY_TYPE_TAG = 25;
  public static final int SECURITY_LEVEL_TAG = 26;
  public static final int SHED_STATE_TAG = 27;
  public static final int SILENCED_STATE_TAG = 28;
  public static final int RESERVED29_TAG = 29;
  public static final int ACCESS_EVENT_TAG = 30;
  public static final int ZONE_OCCUPANCY_TAG = 31;
  public static final int ACCESS_CREDENTIAL_DISABLE_REASON_TAG = 32;
  public static final int ACCESS_CREDENTIAL_DISABLE_TAG = 33;
  public static final int AUTHENTICATION_STATUS_TAG = 34;

  // from Addendum 135-2008n, for Backup & Restore
  public static final int BACKUP_STATE_TAG = 36;
  public static final int WRITE_STATUS_TAG = 37;
  public static final int LIGHTING_IN_PROGRESS_TAG = 38;
  public static final int LIGHTING_OPERATION_TAG = 39;
  public static final int LIGHTING_TRANSITION_TAG = 40;

  // From Addendum 135-2012aw, Extend the CHANGE-OF-STATE Event Algorithm for All Discrete Types
  public static final int INTEGER_VALUE_TAG = 41;

  // From Addendum 135-2012az, Add Binary Lighting Output Object Type
  public static final int BINARY_LIGHTING_VALUE = 42;

  // From Addendum 135-2012ay, Add a Timer Object Type
  public static final int TIMER_STATE_TAG = 43;
  public static final int TIMER_TRANSITION_TAG = 44;

  // From Addendum 135-2012aq, Add Escalator and Lift Object Types
  public static final int ESCALATOR_OPERATION_DIRECTION_TAG = 49;
  public static final int ESCALATOR_FAULT_TAG = 50;
  public static final int ESCALATOR_MODE_TAG = 51;
  public static final int LIFT_CAR_DIRECTION_TAG = 52;
  public static final int LIFT_CAR_DOOR_COMMAND_TAG = 53;
  public static final int LIFT_CAR_DRIVE_STATUS_TAG = 54;
  public static final int LIFT_CAR_MODE_TAG = 55;
  public static final int LIFT_GROUP_MODE_TAG = 56;
  public static final int LIFT_FAULT_TAG = 57;

  // From Addendum 135-2012bf, Add Protocol Level
  public static final int PROTOCOL_LEVEL_TAG = 58;

  private static final int MAX_DEFINED_CHOICE = PROTOCOL_LEVEL_TAG;
  private static final int MAX_ASHRAE_CHOICE = 63;

  // For choices greater than 42,949, too big for AsnConversion.
  private static final int MAX_CHOICE = 42_949;

  private static final Map<BTypeSpec, Integer> choices = makeChoicesMap();
  private static Map<BTypeSpec, Integer> makeChoicesMap()
  {
    Map<BTypeSpec, Integer> choices = new HashMap<>();
    choices.put(BBacnetBinaryPv.TYPE.getTypeSpec(), BINARY_VALUE_TAG);
    choices.put(BBacnetEventType.TYPE.getTypeSpec(), EVENT_TYPE_TAG);
    choices.put(BBacnetPolarity.TYPE.getTypeSpec(), POLARITY_TAG);
    choices.put(BBacnetProgramRequest.TYPE.getTypeSpec(), PROGRAM_CHANGE_TAG);
    choices.put(BBacnetProgramState.TYPE.getTypeSpec(), PROGRAM_STATE_TAG);
    choices.put(BBacnetProgramError.TYPE.getTypeSpec(), REASON_FOR_HALT_TAG);
    choices.put(BBacnetReliability.TYPE.getTypeSpec(), RELIABILITY_TAG);
    choices.put(BBacnetEventState.TYPE.getTypeSpec(), STATE_TAG);
    choices.put(BBacnetDeviceStatus.TYPE.getTypeSpec(), SYSTEM_STATUS_TAG);
    choices.put(BBacnetEngineeringUnits.TYPE.getTypeSpec(), UNITS_TAG);
    choices.put(BBacnetLifeSafetyMode.TYPE.getTypeSpec(), LIFE_SAFETY_MODE_TAG);
    choices.put(BBacnetLifeSafetyState.TYPE.getTypeSpec(), LIFE_SAFETY_STATE_TAG);
    choices.put(BBacnetRestartReason.TYPE.getTypeSpec(), RESTART_REASON_TAG);
    choices.put(BBacnetDoorAlarmState.TYPE.getTypeSpec(), DOOR_ALARM_TAG);
    choices.put(BBacnetAction.TYPE.getTypeSpec(), ACTION_TAG);
    choices.put(BBacnetDoorSecuredStatus.TYPE.getTypeSpec(), DOOR_SECURED_STATUS_TAG);
    choices.put(BBacnetDoorStatus.TYPE.getTypeSpec(), DOOR_STATUS_TAG);
    choices.put(BBacnetDoorValue.TYPE.getTypeSpec(), DOOR_VALUE_TAG);
    choices.put(BBacnetFileAccessMethod.TYPE.getTypeSpec(), FILE_ACCESS_METHOD_TAG);
    choices.put(BBacnetLockStatus.TYPE.getTypeSpec(), LOCK_STATUS_TAG);
    choices.put(BBacnetLifeSafetyOperation.TYPE.getTypeSpec(), LIFE_SAFETY_OPERATION_TAG);
    choices.put(BBacnetMaintenance.TYPE.getTypeSpec(), MAINTENANCE_TAG);
    choices.put(BBacnetNodeType.TYPE.getTypeSpec(), NODE_TYPE_TAG);
    choices.put(BBacnetNotifyType.TYPE.getTypeSpec(), NOTIFY_TYPE_TAG);
    choices.put(BBacnetSecurityLevel.TYPE.getTypeSpec(), SECURITY_LEVEL_TAG);
    choices.put(BBacnetShedState.TYPE.getTypeSpec(), SHED_STATE_TAG);
    choices.put(BBacnetSilencedState.TYPE.getTypeSpec(), SILENCED_STATE_TAG);
    choices.put(BBacnetAccessEvent.TYPE.getTypeSpec(), ACCESS_EVENT_TAG);
    choices.put(BBacnetAccessZoneOccupancyState.TYPE.getTypeSpec(), ZONE_OCCUPANCY_TAG);
    choices.put(BBacnetAccessCredentialDisableReason.TYPE.getTypeSpec(), ACCESS_CREDENTIAL_DISABLE_REASON_TAG);
    choices.put(BBacnetAccessCredentialDisable.TYPE.getTypeSpec(), ACCESS_CREDENTIAL_DISABLE_TAG);
    choices.put(BBacnetAuthenticationStatus.TYPE.getTypeSpec(), AUTHENTICATION_STATUS_TAG);
    choices.put(BBacnetBackupState.TYPE.getTypeSpec(), BACKUP_STATE_TAG);
    choices.put(BBacnetWriteStatus.TYPE.getTypeSpec(), WRITE_STATUS_TAG);
    choices.put(BBacnetLightingInProgress.TYPE.getTypeSpec(), LIGHTING_IN_PROGRESS_TAG);
    choices.put(BBacnetLightingOperation.TYPE.getTypeSpec(), LIGHTING_OPERATION_TAG);
    choices.put(BBacnetLightingTransition.TYPE.getTypeSpec(), LIGHTING_TRANSITION_TAG);
    choices.put(BBacnetBinaryLightingPv.TYPE.getTypeSpec(), BINARY_LIGHTING_VALUE);
    choices.put(BBacnetTimerState.TYPE.getTypeSpec(), TIMER_STATE_TAG);
    choices.put(BBacnetTimerTransition.TYPE.getTypeSpec(), TIMER_TRANSITION_TAG);
    choices.put(BBacnetEscalatorOperationDirection.TYPE.getTypeSpec(), ESCALATOR_OPERATION_DIRECTION_TAG);
    choices.put(BBacnetEscalatorFault.TYPE.getTypeSpec(), ESCALATOR_FAULT_TAG);
    choices.put(BBacnetEscalatorMode.TYPE.getTypeSpec(), ESCALATOR_MODE_TAG);
    choices.put(BBacnetLiftCarDirection.TYPE.getTypeSpec(), LIFT_CAR_DIRECTION_TAG);
    choices.put(BBacnetLiftCarDoorCommand.TYPE.getTypeSpec(), LIFT_CAR_DOOR_COMMAND_TAG);
    choices.put(BBacnetLiftCarDriveStatus.TYPE.getTypeSpec(), LIFT_CAR_DRIVE_STATUS_TAG);
    choices.put(BBacnetLiftCarMode.TYPE.getTypeSpec(), LIFT_CAR_MODE_TAG);
    choices.put(BBacnetLiftGroupMode.TYPE.getTypeSpec(), LIFT_GROUP_MODE_TAG);
    choices.put(BBacnetLiftFault.TYPE.getTypeSpec(), LIFT_FAULT_TAG);
    choices.put(BBacnetProtocolLevel.TYPE.getTypeSpec(), PROTOCOL_LEVEL_TAG);
    return choices;
  }

  private static final Lexicon lex = Lexicon.make("bacnet");

  private static final String[] tags = {
/* 0 */   lex.getText("BacnetPropertyStates.booleanValue"),
/* 1 */   lex.getText("BacnetPropertyStates.binaryValue"),
/* 2 */   lex.getText("BacnetPropertyStates.eventType"),
/* 3 */   lex.getText("BacnetPropertyStates.polarity"),
/* 4 */   lex.getText("BacnetPropertyStates.programChange"),
/* 5 */   lex.getText("BacnetPropertyStates.programState"),
/* 6 */   lex.getText("BacnetPropertyStates.reasonForHalt"),
/* 7 */   lex.getText("BacnetPropertyStates.reliability"),
/* 8 */   lex.getText("BacnetPropertyStates.state"),
/* 9 */   lex.getText("BacnetPropertyStates.systemStatus"),
/* 10 */  lex.getText("BacnetPropertyStates.units"),
/* 11 */  lex.getText("BacnetPropertyStates.unsignedValue"),
/* 12 */  lex.getText("BacnetPropertyStates.lifeSafetyMode"),
/* 13 */  lex.getText("BacnetPropertyStates.lifeSafetyState"),
/* 14 */  lex.getText("BacnetPropertyStates.restartReason"),
/* 15 */  lex.getText("BacnetPropertyStates.doorAlarmState"),
/* 16 */  lex.getText("BacnetPropertyStates.action"),
/* 17 */  lex.getText("BacnetPropertyStates.doorSecuredStatus"),
/* 18 */  lex.getText("BacnetPropertyStates.doorStatus"),
/* 19 */  lex.getText("BacnetPropertyStates.doorValue"),
/* 20 */  lex.getText("BacnetPropertyStates.fileAccessMethod"),
/* 21 */  lex.getText("BacnetPropertyStates.lockStatus"),
/* 22 */  lex.getText("BacnetPropertyStates.lifeSafetyOperation"),
/* 23 */  lex.getText("BacnetPropertyStates.maintenance"),
/* 24 */  lex.getText("BacnetPropertyStates.nodeType"),
/* 25 */  lex.getText("BacnetPropertyStates.notifyType"),
/* 26 */  lex.getText("BacnetPropertyStates.securityLevel"),
/* 27 */  lex.getText("BacnetPropertyStates.shedState"),
/* 28 */  lex.getText("BacnetPropertyStates.silencedState"),
/* 29 */  lex.getText("BacnetPropertyStates.reserved29"),
/* 30 */  lex.getText("BacnetPropertyStates.accessEvent"),
/* 31 */  lex.getText("BacnetPropertyStates.zoneOccupancyState"),
/* 32 */  lex.getText("BacnetPropertyStates.accessCredentialDisableReason"),
/* 33 */  lex.getText("BacnetPropertyStates.accessCredentialDisable"),
/* 34 */  lex.getText("BacnetPropertyStates.authenticationStatus"),
/* 35 */  lex.getText("BacnetPropertyStates.reserved35"),
/* 36 */  lex.getText("BacnetPropertyStates.backupState"),
/* 37 */  lex.getText("BacnetPropertyStates.writeStatus"),
/* 38 */  lex.getText("BacnetPropertyStates.lightingInProgress"),
/* 39 */  lex.getText("BacnetPropertyStates.lightingOperation"),
/* 40 */  lex.getText("BacnetPropertyStates.lightingTransition"),
/* 41 */  lex.getText("BacnetPropertyStates.integerValue"),
/* 42 */  lex.getText("BacnetPropertyStates.binaryLightingValue"),
/* 43 */  lex.getText("BacnetPropertyStates.timerState"),
/* 44 */  lex.getText("BacnetPropertyStates.timerTransition"),
//---------------------------------------------------------------------
/* 45 */  lex.getText("BacnetPropertyStates.ashrae"),
/* 46 */  lex.getText("BacnetPropertyStates.proprietary"),
/* 47 */  lex.getText("BacnetPropertyStates.invalid"),
/* 48 */  lex.getText("BacnetPropertyStates.invalid"),
/* 49 */  lex.getText("BacnetPropertyStates.escalatorOperationDirection"),
/* 50 */  lex.getText("BacnetPropertyStates.escalatorFault"),
/* 51 */  lex.getText("BacnetPropertyStates.escalatorMode"),
/* 52 */  lex.getText("BacnetPropertyStates.liftCarDirection"),
/* 53 */  lex.getText("BacnetPropertyStates.liftCarDoorCommand"),
/* 54 */  lex.getText("BacnetPropertyStates.liftCarDriveStatus"),
/* 55 */  lex.getText("BacnetPropertyStates.liftCarMode"),
/* 56 */  lex.getText("BacnetPropertyStates.liftGroupMode"),
/* 57 */  lex.getText("BacnetPropertyStates.liftFault"),
/* 58 */  lex.getText("BacnetPropertyStates.protocolLevel"),
  };

  private static final int ASHRAE_CHOICE_INDEX = 45;
  private static final int PROPRIETARY_CHOICE_INDEX = 46;
  private static final int INVALID_CHOICE_INDEX = 47;

  public static final String BOOLEAN_VALUE_SLOT_NAME = "booleanValue";
  public static final String BINARY_VALUE_SLOT_NAME = "binaryValue";
  public static final String UNSIGNED_VALUE_SLOT_NAME = "unsignedValue";

  private static final String[] slotNames = {
    /* 0 */   BOOLEAN_VALUE_SLOT_NAME,
    /* 1 */   BINARY_VALUE_SLOT_NAME,
    /* 2 */   "eventType",
    /* 3 */   "polarity",
    /* 4 */   "programChange",
    /* 5 */   "programState",
    /* 6 */   "reasonForHalt",
    /* 7 */   "reliability",
    /* 8 */   "state",
    /* 9 */   "systemStatus",
    /* 10 */  "units",
    /* 11 */  UNSIGNED_VALUE_SLOT_NAME,
    /* 12 */  "lifeSafetyMode",
    /* 13 */  "lifeSafetyState",
    /* 14 */  "restartReason",
    /* 15 */  "doorAlarmState",
    /* 16 */  "action",
    /* 17 */  "doorSecuredStatus",
    /* 18 */  "doorStatus",
    /* 19 */  "doorValue",
    /* 20 */  "fileAccessMethod",
    /* 21 */  "lockStatus",
    /* 22 */  "lifeSafetyOperation",
    /* 23 */  "maintenance",
    /* 24 */  "nodeType",
    /* 25 */  "notifyType",
    /* 26 */  "securityLevel",
    /* 27 */  "shedState",
    /* 28 */  "silencedState",
    /* 29 */  "reserved29",
    /* 30 */  "accessEvent",
    /* 31 */  "zoneOccupancyState",
    /* 32 */  "accessCredentialDisableReason",
    /* 33 */  "accessCredentialDisable",
    /* 34 */  "authenticationStatus",
    /* 35 */  "reserved35",
    /* 36 */  "backupState",
    /* 37 */  "writeStatus",
    /* 38 */  "lightingInProgress",
    /* 39 */  "lightingOperation",
    /* 40 */  "lightingTransition",
    /* 41 */  "integerValue",
    /* 42 */  "binaryLightingValue",
    /* 43 */  "timerState",
    /* 44 */  "timerTransition",
    //---------------------------------------------------------------------
    /* 45 */  "ashrae",
    /* 46 */  "proprietary",
    /* 47 */  "invalid",
    /* 48 */  "invalid",
    /* 49 */  "escalatorOperationDirection",
    /* 50 */  "escalatorFault",
    /* 51 */  "escalatorMode",
    /* 52 */  "liftCarDirection",
    /* 53 */  "liftCarDoorCommand",
    /* 54 */  "liftCarDriveStatus",
    /* 55 */  "liftCarMode",
    /* 56 */  "liftGroupMode",
    /* 57 */  "liftFault",
    /* 58 */  "protocolLevel",
  };

  private String getTag()
  {
    int ch = getChoice();
    if (ch < 0 || ch == MAX_ASHRAE_CHOICE)
    {
      return tags[INVALID_CHOICE_INDEX];
    }
    else if (ch <= MAX_DEFINED_CHOICE)
    {
      return tags[ch];
    }
    else if (ch < MAX_ASHRAE_CHOICE)
    {
      return tags[ASHRAE_CHOICE_INDEX];
    }
    else if (ch <= MAX_TAG)
    {
      return tags[PROPRIETARY_CHOICE_INDEX];
    }
    else
    {
      return tags[ASHRAE_CHOICE_INDEX];
    }
  }

  /**
   * Return the value of this object based on the choice value. Returns null if the choice is not
   * defined.
   *
   * @since Niagara 4.10u5
   * @since Niagara 4.12u2
   * @since Niagara 4.13
   */
  public BValue getValue()
  {
    int ch = getChoice();
    if (ch < 0 || ch == MAX_ASHRAE_CHOICE)
    {
      return null;
    }
    else if (ch <= MAX_DEFINED_CHOICE)
    {
      return get(slotNames[ch]);
    }
    else if (ch < MAX_ASHRAE_CHOICE)
    {
      return get(slotNames[ASHRAE_CHOICE_INDEX]);
    }
    else if (ch <= MAX_TAG)
    {
      return get(slotNames[PROPRIETARY_CHOICE_INDEX]);
    }
    else
    {
      return get(slotNames[ASHRAE_CHOICE_INDEX]);
    }
  }
}
