/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetOptionalDoorValue choice, which may be null or contain a BACnetDoorValue.
 *
 * @author Uday Rapuru on 03-Apr-2025
 * @since Niagara 4.15U1
 * @since Niagara 4.14U2
 */
@NiagaraType
@NiagaraProperty(
  name = "isNull",
  type = "boolean",
  defaultValue = "true"
)
@NiagaraProperty(
  name = "value",
  type = "BBacnetDoorValue",
  defaultValue = "BBacnetDoorValue.DEFAULT"
)
public final class BBacnetOptionalDoorValue
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetOptionalDoorValue(1044193707)1.0$ @*/
/* Generated Thu Apr 03 13:49:30 IST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "isNull"

  /**
   * Slot for the {@code isNull} property.
   * @see #getIsNull
   * @see #setIsNull
   */
  @Generated
  public static final Property isNull = newProperty(0, true, null);

  /**
   * Get the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public boolean getIsNull() { return getBoolean(isNull); }

  /**
   * Set the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public void setIsNull(boolean v) { setBoolean(isNull, v, null); }

  //endregion Property "isNull"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetDoorValue.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BBacnetDoorValue getValue() { return (BBacnetDoorValue)get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BBacnetDoorValue v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetOptionalDoorValue.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default (NULL) constructor
   */
  public BBacnetOptionalDoorValue()
  {
  }

  /**
   * DoorValue constructor.
   */
  public BBacnetOptionalDoorValue(BBacnetDoorValue value)
  {
    setIsNull(false);
    setValue(value);
  }

  /**
   * @return true if choice is null
   */
  @Override
  public boolean isNull()
  {
    return getIsNull();
  }

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    if (getIsNull())
    {
      out.writeNull();
    }
    else
    {
      out.writeEnumerated(getValue());
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case BacnetConst.ASN_NULL:
        in.readNull();
        setBoolean(isNull, true, noWrite);
        break;
      case BacnetConst.ASN_ENUMERATED:
        int ordinal = in.readEnumerated();
        BBacnetDoorValue doorValue;
        try
        {
          doorValue = BBacnetDoorValue.make(ordinal);
        }
        catch (InvalidEnumException e)
        {
          throw new OutOfRangeException("BACnetOptionalDoorValue decoded enumerated value not valid: " + ordinal);
        }
        setBoolean(isNull, false, noWrite);
        set(value, doorValue, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  /**
   * To String.
   */
  @Override
  public String toString(Context context)
  {
    return getIsNull() ? "null" : getValue().toString(context);
  }
}
