/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * @author Eric Anderson on 12 Jan 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraEnum(
  range = {
    @Range("none"),
    @Range("ipAddress"),
    @Range("name")
  }
)
public final class BBacnetHostAddressChoice
  extends BFrozenEnum
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetHostAddressChoice(2075856638)1.0$ @*/
/* Generated Fri Jan 12 13:54:21 CST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  /** Ordinal value for none. */
  @Generated
  public static final int NONE = 0;
  /** Ordinal value for ipAddress. */
  @Generated
  public static final int IP_ADDRESS = 1;
  /** Ordinal value for name. */
  @Generated
  public static final int NAME = 2;

  /** BBacnetHostAddressChoice constant for none. */
  @Generated
  public static final BBacnetHostAddressChoice none = new BBacnetHostAddressChoice(NONE);
  /** BBacnetHostAddressChoice constant for ipAddress. */
  @Generated
  public static final BBacnetHostAddressChoice ipAddress = new BBacnetHostAddressChoice(IP_ADDRESS);
  /** BBacnetHostAddressChoice constant for name. */
  @Generated
  public static final BBacnetHostAddressChoice name = new BBacnetHostAddressChoice(NAME);

  /** Factory method with ordinal. */
  @Generated
  public static BBacnetHostAddressChoice make(int ordinal)
  {
    return (BBacnetHostAddressChoice)none.getRange().get(ordinal, false);
  }

  /** Factory method with tag. */
  @Generated
  public static BBacnetHostAddressChoice make(String tag)
  {
    return (BBacnetHostAddressChoice)none.getRange().get(tag);
  }

  /** Private constructor. */
  @Generated
  private BBacnetHostAddressChoice(int ordinal)
  {
    super(ordinal);
  }

  @Generated
  public static final BBacnetHostAddressChoice DEFAULT = none;

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetHostAddressChoice.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
