/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetHostAddress choice: none, IP address, or host name.
 *
 * @author Uday Rapuru on 10-Oct-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "BBacnetHostAddressChoice",
  defaultValue = "BBacnetHostAddressChoice.none"
)
@NiagaraProperty(
  name = "ipAddress",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "hostName",
  type = "String",
  defaultValue = ""
)
public class BBacnetHostAddress
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetHostAddress(4262381403)1.0$ @*/
/* Generated Fri Jan 12 13:55:02 CST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, BBacnetHostAddressChoice.none, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public BBacnetHostAddressChoice getChoice() { return (BBacnetHostAddressChoice)get(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(BBacnetHostAddressChoice v) { set(choice, v, null); }

  //endregion Property "choice"

  //region Property "ipAddress"

  /**
   * Slot for the {@code ipAddress} property.
   * @see #getIpAddress
   * @see #setIpAddress
   */
  @Generated
  public static final Property ipAddress = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code ipAddress} property.
   * @see #ipAddress
   */
  @Generated
  public BBacnetOctetString getIpAddress() { return (BBacnetOctetString)get(ipAddress); }

  /**
   * Set the {@code ipAddress} property.
   * @see #ipAddress
   */
  @Generated
  public void setIpAddress(BBacnetOctetString v) { set(ipAddress, v, null); }

  //endregion Property "ipAddress"

  //region Property "hostName"

  /**
   * Slot for the {@code hostName} property.
   * @see #getHostName
   * @see #setHostName
   */
  @Generated
  public static final Property hostName = newProperty(0, "", null);

  /**
   * Get the {@code hostName} property.
   * @see #hostName
   */
  @Generated
  public String getHostName() { return getString(hostName); }

  /**
   * Set the {@code hostName} property.
   * @see #hostName
   */
  @Generated
  public void setHostName(String v) { setString(hostName, v, null); }

  //endregion Property "hostName"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetHostAddress.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Factory method to create a BBacnetHostAddress with neither an IP address nor a host name.
   */
  public static BBacnetHostAddress makeNone()
  {
    BBacnetHostAddress hostAddress = new BBacnetHostAddress();
    hostAddress.setChoice(BBacnetHostAddressChoice.none);
    return hostAddress;
  }

  /**
   * Factory method to create a BBacnetHostAddress with an IP address.
   */
  public static BBacnetHostAddress makeWithIpAddress(BBacnetOctetString ipAddress)
  {
    BBacnetHostAddress hostAddress = new BBacnetHostAddress();
    hostAddress.setChoice(BBacnetHostAddressChoice.ipAddress);
    hostAddress.setIpAddress(ipAddress);
    return hostAddress;
  }

  /**
   * Factory method to create a BBacnetHostAddress with IP address bytes.
   */
  public static BBacnetHostAddress makeWithIpAddress(byte[] ipAddressBytes)
  {
    return makeWithIpAddress(BBacnetOctetString.make(ipAddressBytes));
  }

  /**
   * Factory method to create a BBacnetHostAddress with an internet host name.
   */
  public static BBacnetHostAddress makeWithHostName(String hostName)
  {
    BBacnetHostAddress hostAddress = new BBacnetHostAddress();
    hostAddress.setChoice(BBacnetHostAddressChoice.name);
    hostAddress.setHostName(hostName);
    return hostAddress;
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice().getOrdinal();
    switch (choice)
    {
      case BBacnetHostAddressChoice.NONE:
        out.writeNull(BBacnetHostAddressChoice.NONE);
        break;

      case BBacnetHostAddressChoice.IP_ADDRESS:
        byte[] bytes = getIpAddress().getBytes();
        if (bytes == null || (bytes.length != 4 && bytes.length != 16))
        {
          throw new IllegalStateException("Invalid BACnetHostAddress IpAddress length: " + (bytes != null ? bytes.length : "null"));
        }
        out.writeOctetString(BBacnetHostAddressChoice.IP_ADDRESS, bytes);
        break;

      case BBacnetHostAddressChoice.NAME:
        out.writeCharacterString(BBacnetHostAddressChoice.NAME, getHostName());
        break;

      default:
        throw new IllegalStateException("Invalid BBacnetHostAddress choice: " + choice);
    }
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int choice = in.peekTag();
    BBacnetOctetString ipAddress = BBacnetOctetString.DEFAULT;
    String hostName = "";
    switch (choice)
    {
      case BBacnetHostAddressChoice.NONE:
        in.readNull(BBacnetHostAddressChoice.NONE);
        break;
      case BBacnetHostAddressChoice.IP_ADDRESS:
        ipAddress = in.readBacnetOctetString(BBacnetHostAddressChoice.IP_ADDRESS);
        if (ipAddress.length() != 4 && ipAddress.length() != 16)
        {
          throw new OutOfRangeException("Invalid BACnetHostAddress IpAddress length: " + ipAddress.length());
        }
        break;
      case BBacnetHostAddressChoice.NAME:
        hostName = in.readCharacterString(BBacnetHostAddressChoice.NAME);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + choice);
    }

    set(BBacnetHostAddress.choice, BBacnetHostAddressChoice.make(choice), noWrite);
    set(BBacnetHostAddress.ipAddress, ipAddress, noWrite);
    setString(BBacnetHostAddress.hostName, hostName, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetHostAddressChoice.NONE:
        return "none";
      case BBacnetHostAddressChoice.IP_ADDRESS:
        BBacnetOctetString ipAddress = getIpAddress();
        if (!ipAddress.isNull() && ipAddress.length() == 4)
        {
          return BBacnetAddress.bytesToString(BBacnetAddress.MAC_TYPE_IP, ipAddress.getBytes());
        }
        else
        {
          return getIpAddress().toString(context);
        }
      case BBacnetHostAddressChoice.NAME:
        return getHostName();
      default:
        return "BACnetHostAddress choice unknown";
    }
  }
}
