/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

/**
 * Represents the BACnetFDTEntry sequence, which contains a bacnetIpAddress, timeToLive (seconds),
 * and remainingTimeToLive (seconds).
 *
 * @author Uday Rapuru on 10-Oct-2023
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "bacnetIpAddress",
  type = "BBacnetOctetString",
  defaultValue = "BBacnetOctetString.DEFAULT"
)
@NiagaraProperty(
  name = "timeToLive",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("BFacets.makeInt(BUnit.getUnit(\"second\"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE)")
)
@NiagaraProperty(
  name = "remainingTimeToLive",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("BFacets.makeInt(BUnit.getUnit(\"second\"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE)")
)
public final class BBacnetFdtEntry
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetFdtEntry(2780062133)1.0$ @*/
/* Generated Tue May 28 16:59:20 IST 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "bacnetIpAddress"

  /**
   * Slot for the {@code bacnetIpAddress} property.
   * @see #getBacnetIpAddress
   * @see #setBacnetIpAddress
   */
  @Generated
  public static final Property bacnetIpAddress = newProperty(0, BBacnetOctetString.DEFAULT, null);

  /**
   * Get the {@code bacnetIpAddress} property.
   * @see #bacnetIpAddress
   */
  @Generated
  public BBacnetOctetString getBacnetIpAddress() { return (BBacnetOctetString)get(bacnetIpAddress); }

  /**
   * Set the {@code bacnetIpAddress} property.
   * @see #bacnetIpAddress
   */
  @Generated
  public void setBacnetIpAddress(BBacnetOctetString v) { set(bacnetIpAddress, v, null); }

  //endregion Property "bacnetIpAddress"

  //region Property "timeToLive"

  /**
   * Slot for the {@code timeToLive} property.
   * @see #getTimeToLive
   * @see #setTimeToLive
   */
  @Generated
  public static final Property timeToLive = newProperty(0, BBacnetUnsigned.DEFAULT, BFacets.makeInt(BUnit.getUnit("second"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE));

  /**
   * Get the {@code timeToLive} property.
   * @see #timeToLive
   */
  @Generated
  public BBacnetUnsigned getTimeToLive() { return (BBacnetUnsigned)get(timeToLive); }

  /**
   * Set the {@code timeToLive} property.
   * @see #timeToLive
   */
  @Generated
  public void setTimeToLive(BBacnetUnsigned v) { set(timeToLive, v, null); }

  //endregion Property "timeToLive"

  //region Property "remainingTimeToLive"

  /**
   * Slot for the {@code remainingTimeToLive} property.
   * @see #getRemainingTimeToLive
   * @see #setRemainingTimeToLive
   */
  @Generated
  public static final Property remainingTimeToLive = newProperty(0, BBacnetUnsigned.DEFAULT, BFacets.makeInt(BUnit.getUnit("second"), (int)BBacnetUnsigned.MIN_UNSIGNED_VALUE, (int)BBacnetUnsigned.MAX_UNSIGNED16_VALUE));

  /**
   * Get the {@code remainingTimeToLive} property.
   * @see #remainingTimeToLive
   */
  @Generated
  public BBacnetUnsigned getRemainingTimeToLive() { return (BBacnetUnsigned)get(remainingTimeToLive); }

  /**
   * Set the {@code remainingTimeToLive} property.
   * @see #remainingTimeToLive
   */
  @Generated
  public void setRemainingTimeToLive(BBacnetUnsigned v) { set(remainingTimeToLive, v, null); }

  //endregion Property "remainingTimeToLive"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetFdtEntry.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetOctetString bacnetIpAddress = BBacnetOctetString.make(in.readOctetString(0));
    int timeToLive = in.readUnsignedInt(1);
    int remainingTimeToLive = in.readUnsignedInt(2);

    set(BBacnetFdtEntry.bacnetIpAddress, bacnetIpAddress, noWrite);
    set(BBacnetFdtEntry.timeToLive, BBacnetUnsigned.make(timeToLive), noWrite);
    set(BBacnetFdtEntry.remainingTimeToLive, BBacnetUnsigned.make(remainingTimeToLive), noWrite);
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    long timeToLive = getTimeToLive().getLong();
    if (timeToLive < 0 || timeToLive > BBacnetUnsigned.MAX_UNSIGNED16_VALUE)
    {
      throw new IllegalStateException("BACnetFDTEntry TimeToLive must be 0-65535: " + timeToLive);
    }

    long remainingTimeToLive = getRemainingTimeToLive().getLong();
    if (remainingTimeToLive < 0 || remainingTimeToLive > BBacnetUnsigned.MAX_UNSIGNED16_VALUE)
    {
      throw new IllegalStateException("BACnetFDTEntry RemainingTimeToLive must be 0-65535: " + remainingTimeToLive);
    }

    out.writeOctetString(0, getBacnetIpAddress());
    out.writeUnsignedInteger(1, timeToLive);
    out.writeUnsignedInteger(2, remainingTimeToLive);
  }

  @Override
  public String toString(Context context)
  {
    return "BBacnetFdtEntry" +
      ": bacnetIpAddress=" + getBacnetIpAddress().toString(context) +
      "; timeToLive=" + getTimeToLive() +
      "; remainingTimeToLive=" + getRemainingTimeToLive();
  }
}
