/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.EventNotificationParameters;
import com.tridium.bacnet.datatypes.BBacnetEventNotification;
import com.tridium.bacnet.datatypes.BTrendEvent;

/**
 * BBacnetEventLogRecord represents the BACnetEventLogRecord sequence.
 *
 * @author Bishal Debbarma
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "timestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "logDatum",
  type = "BValue",
  defaultValue = "BBacnetNull.DEFAULT"
)
public final class BBacnetEventLogRecord
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetEventLogRecord(2191919024)1.0$ @*/
/* Generated Mon May 22 13:43:59 CDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "timestamp"

  /**
   * Slot for the {@code timestamp} property.
   * @see #getTimestamp
   * @see #setTimestamp
   */
  @Generated
  public static final Property timestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public BBacnetDateTime getTimestamp() { return (BBacnetDateTime)get(timestamp); }

  /**
   * Set the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public void setTimestamp(BBacnetDateTime v) { set(timestamp, v, null); }

  //endregion Property "timestamp"

  //region Property "logDatum"

  /**
   * Slot for the {@code logDatum} property.
   * @see #getLogDatum
   * @see #setLogDatum
   */
  @Generated
  public static final Property logDatum = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code logDatum} property.
   * @see #logDatum
   */
  @Generated
  public BValue getLogDatum() { return get(logDatum); }

  /**
   * Set the {@code logDatum} property.
   * @see #logDatum
   */
  @Generated
  public void setLogDatum(BValue v) { set(logDatum, v, null); }

  //endregion Property "logDatum"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetEventLogRecord.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Write the value to the Asn output stream.
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getTimestamp().writeAsn(out);
    out.writeClosingTag(0);
    out.writeOpeningTag(1);
    writeLogDatum((AsnOutputStream)out);
    out.writeClosingTag(1);
  }

  private void writeLogDatum(AsnOutputStream out)
  {
    BValue logDatum = getLogDatum();
    if (logDatum instanceof BBacnetEventNotification)
    {
      out.writeOpeningTag(NOTIFICATION_TAG);
      BBacnetEventNotification eventNotification = (BBacnetEventNotification)logDatum;
      EventNotificationParameters eventParams = eventNotification.getEventNotificationParameters();
      eventParams.writeEncoded(out);
      out.writeClosingTag(NOTIFICATION_TAG);
      return;
    }

    if (logDatum instanceof BTrendEvent)
    {
      BTrendEvent event = (BTrendEvent)logDatum;
      if (event.isLogStatus())
      {
        out.writeBitString(LOG_STATUS_TAG, BTrendEvent.getLogStatus(event.getLong()));
        return;
      }
      else if (event.isTimeChange())
      {
        out.writeReal(TIME_CHANGE_TAG, BTrendEvent.getTimeChange(event.getLong()));
        return;
      }
    }

    throw new IllegalStateException("BBacnetEventLogRecord: Invalid log-datum choice type: " + logDatum.getType());
  }

  /**
   * Read the value from the Asn input stream.
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetDate date = in.readDate();
    BBacnetTime time = in.readTime();
    in.skipClosingTag(0);

    in.skipOpeningTag(1);
    int logDatumChoice = in.peekTag();
    BValue logDatum;
    switch (logDatumChoice)
    {
      case LOG_STATUS_TAG:
        logDatum = BTrendEvent.makeLogStatus(in.readBitString(LOG_STATUS_TAG));
        break;
      case NOTIFICATION_TAG:
        in.skipOpeningTag(NOTIFICATION_TAG);
        EventNotificationParameters eventParams = new EventNotificationParameters();
        eventParams.readEncoded((AsnInputStream)in);
        logDatum = new BBacnetEventNotification(eventParams);
        in.skipClosingTag(NOTIFICATION_TAG);
        break;
      case TIME_CHANGE_TAG:
        logDatum = BTrendEvent.makeTimeChange((long)in.readReal(TIME_CHANGE_TAG));
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + logDatumChoice);
    }
    in.skipClosingTag(1);

    BBacnetDateTime timestamp = getTimestamp();
    timestamp.set(BBacnetDateTime.date, date, noWrite);
    timestamp.set(BBacnetDateTime.time, time, noWrite);
    set(BBacnetEventLogRecord.logDatum, logDatum, noWrite);
  }

  /**
   * To String.
   */
  @Override
  public String toString(Context context)
  {
    return getTimestamp().toString(context) + '_' + getLogDatum().toString(context);
  }

  private static final int LOG_STATUS_TAG    = 0;
  private static final int NOTIFICATION_TAG  = 1;
  private static final int TIME_CHANGE_TAG   = 2;
}
