/*
 * Copyright 2024 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents an entry in the list of COV subscription specifications sequence of sequences in a
 * BACnetCOVMultipleSubscription sequence.
 *
 * @author Tim Urenda on Oct 18, 2024
 * @since Niagara 4.15
 */
@NiagaraType
@NiagaraProperty(
  name = "monitoredObjectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.DEFAULT"
)
public class BBacnetCovMultipleSubscriptionSpecification
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetCovMultipleSubscriptionSpecification(801621441)1.0$ @*/
/* Generated Sun Oct 27 17:09:48 CDT 2024 by Slot-o-Matic (c) Tridium, Inc. 2012-2024 */

  //region Property "monitoredObjectId"

  /**
   * Slot for the {@code monitoredObjectId} property.
   * @see #getMonitoredObjectId
   * @see #setMonitoredObjectId
   */
  @Generated
  public static final Property monitoredObjectId = newProperty(0, BBacnetObjectIdentifier.DEFAULT, null);

  /**
   * Get the {@code monitoredObjectId} property.
   * @see #monitoredObjectId
   */
  @Generated
  public BBacnetObjectIdentifier getMonitoredObjectId() { return (BBacnetObjectIdentifier)get(monitoredObjectId); }

  /**
   * Set the {@code monitoredObjectId} property.
   * @see #monitoredObjectId
   */
  @Generated
  public void setMonitoredObjectId(BBacnetObjectIdentifier v) { set(monitoredObjectId, v, null); }

  //endregion Property "monitoredObjectId"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetCovMultipleSubscriptionSpecification.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeObjectIdentifier(0, getMonitoredObjectId());
    out.writeOpeningTag(1);
    for (BBacnetCovMultipleSubscriptionCovReference entry : getChildren(BBacnetCovMultipleSubscriptionCovReference.class))
    {
      entry.writeAsn(out);
    }
    out.writeClosingTag(1);
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetObjectIdentifier monitoredObjectId = in.readObjectIdentifier(0);

    List<BBacnetCovMultipleSubscriptionCovReference> covReferences = new ArrayList<>();
    in.skipOpeningTag(1);
    in.peekTag();
    while (!in.isClosingTag(1))
    {
      BBacnetCovMultipleSubscriptionCovReference entry = new BBacnetCovMultipleSubscriptionCovReference();
      entry.readAsn(in);
      covReferences.add(entry);
      in.peekTag();
    }
    in.skipClosingTag(1);

    set(BBacnetCovMultipleSubscriptionSpecification.monitoredObjectId, monitoredObjectId, noWrite);

    removeAll(noWrite);
    for (int i = 0; i < covReferences.size(); i++)
    {
      add("entry" + (i + 1), covReferences.get(i), noWrite);
    }
  }

  @Override
  public String toString(Context context)
  {
    return getMonitoredObjectId().toString(context);
  }
}
